/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.emusys.kc85.AbstractKC85Module;

public class M033
extends AbstractKC85Module {
    private static byte[] rom = null;
    private int begAddr = 0;
    private int segMask = 0;

    public M033(int n, EmuThread emuThread) {
        super(n);
        if (rom == null) {
            rom = EmuUtil.readResource(emuThread.getScreenFrm(), "/rom/kc85/m033.bin");
        }
    }

    @Override
    public int getBegAddr() {
        return this.begAddr;
    }

    @Override
    public String getModuleName() {
        return "M033";
    }

    @Override
    public int getSegmentNum() {
        return this.segMask >> 13 & 1;
    }

    @Override
    public int getTypeByte() {
        return 1;
    }

    @Override
    public int readMemByte(int n) {
        int n2;
        int n3 = -1;
        if (this.enabled && n >= this.begAddr && n < this.begAddr + 8192 && rom != null && (n2 = n - this.begAddr | this.segMask) < rom.length) {
            n3 = rom[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(n);
        this.begAddr = n << 8 & 0xC000;
        this.segMask = (n & 0x10) != 0 ? 8192 : 0;
    }
}

