/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kc85;

import java.util.Arrays;
import jkcemu.emusys.kc85.AbstractKC85Module;

public class M035
extends AbstractKC85Module {
    private int segMask = 0;
    private boolean readWrite = false;
    private byte[] ram = new byte[0x100000];

    public M035(int n) {
        super(n);
    }

    @Override
    public void clearRAM() {
        Arrays.fill(this.ram, (byte)0);
    }

    @Override
    public int getBegAddr() {
        return 32768;
    }

    @Override
    public String getModuleName() {
        return "M035";
    }

    @Override
    public Boolean getReadWrite() {
        return this.readWrite;
    }

    @Override
    public int getSegmentNum() {
        return this.segMask >> 14 & 0x3F;
    }

    @Override
    public int getTypeByte() {
        return 123;
    }

    @Override
    public int readMemByte(int n) {
        int n2;
        int n3 = -1;
        if (this.enabled && n >= 32768 && n < 49152 && (n2 = n - 32768 | this.segMask) >= 0 && n2 < this.ram.length) {
            n3 = this.ram[n2] & 0xFF;
        }
        return n3;
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(n);
        this.segMask = n << 12 & 0xFC000;
        this.readWrite = (n & 2) != 0;
    }

    @Override
    public int writeMemByte(int n, int n2) {
        int n3;
        int n4 = 0;
        if (this.enabled && n >= 32768 && n < 49152 && (n3 = n - 32768 | this.segMask) >= 0 && n3 < this.ram.length) {
            if (this.readWrite) {
                this.ram[n3] = (byte)n2;
                n4 = 2;
            } else {
                n4 = 1;
            }
        }
        return n4;
    }
}

