/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.kccompact;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.KCcompact;

public class KCcompactKeyboardFld
extends AbstractKeyboardFld<KCcompact> {
    private static final int TEXT_FONT_SIZE = 10;
    private static final int LETTER_FONT_SIZE = 14;
    private static final int DIGIT_FONT_SIZE = 12;
    private static final int LED_SIZE = 8;
    private static final int KEY_SIZE = 40;
    private static final int KEY_HALF_SIZE = 20;
    private static final int MEDIUM_KEY_SIZE = 50;
    private static final int LARGE_KEY_SIZE = 60;
    private static final int SPACE_KEY_SIZE = 320;
    private static final int MARGIN = 20;
    private Image imgKey40x40 = this.getImage("/images/keyboard/key40x40.png");
    private Image imgKey50x40 = this.getImage("/images/keyboard/key50x40.png");
    private Image imgKey60x40 = this.getImage("/images/keyboard/key60x40.png");
    private Image imgKey320x40 = this.getImage("/images/keyboard/key320x40.png");
    private Image imgLeft = this.getImage("/images/keyboard/left.png");
    private Image imgRight = this.getImage("/images/keyboard/right.png");
    private Image imgUp = this.getImage("/images/keyboard/up.png");
    private Image imgDown = this.getImage("/images/keyboard/down.png");
    private Image imgPoint = this.getImage("/images/keyboard/point.png");
    private Font fontText = new Font("SansSerif", 0, 10);
    private Font fontLetter = new Font("SansSerif", 0, 14);
    private Font fontDigit = new Font("SansSerif", 0, 12);
    private int[] kbMatrix = new int[10];
    private int curIdx = 0;
    private int curX = 20;
    private int curY = 20;
    private int xRow1Left;
    private int xRow1Right;
    private int xRow3Right;

    public KCcompactKeyboardFld(KCcompact kCcompact) {
        super(kCcompact, 69, true);
        this.addKey("F0", null, 1, 128, "F5");
        this.curX += 20;
        this.xRow1Left = this.curX;
        this.addKey("ESC", null, 8, 4, "Esc");
        this.addKey("1", "!", 8, 1);
        this.addKey("2", "\"", 8, 2);
        this.addKey("3", "#", 7, 2);
        this.addKey("4", "$", 7, 1);
        this.addKey("5", "%", 6, 2);
        this.addKey("6", "&", 6, 1);
        this.addKey("7", "'", 5, 2);
        this.addKey("8", "(", 5, 1);
        this.addKey("9", ")", 4, 2);
        this.addKey("0", "_", 4, 1);
        this.addKey("-", "=", 3, 2);
        this.addKey("^", "\u00a3", 9, 1);
        this.addKey("CLR", null, 2, 1, "Entf");
        this.xRow1Right = this.curX - 1;
        this.curX += 30;
        int n = this.curX + 30;
        this.addLargeKey("DEL", 9, 128, "Backspace");
        this.curX = 20;
        this.curY += 40;
        this.addKey("F1", null, 1, 32, "F1");
        this.curX += 40;
        this.addKey("TAB", null, 8, 16, "Tabulator");
        this.addKey("Q", 8, 8);
        this.addKey("W", 7, 8);
        this.addKey("E", 7, 4);
        this.addKey("R", 6, 4);
        this.addKey("T", 6, 8);
        this.addKey("Y", 5, 8);
        this.addKey("U", 5, 4);
        this.addKey("I", 4, 8);
        this.addKey("O", 4, 4);
        this.addKey("P", 3, 8);
        this.addKey("@", "|", 3, 4);
        this.addKey("[", "{", 2, 2);
        this.curX = n - 20;
        this.addKey(this.imgUp, 0, 1, null);
        this.curX = 20;
        this.curY += 40;
        this.addKey("F2", null, 1, 64, "F2");
        this.curX += 40;
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 50, 40, "CAPS\nLOCK", null, null, null, null, 8, 64, false, null);
        this.curX += 50;
        this.addKey("A", 8, 32);
        this.addKey("S", 7, 16);
        this.addKey("D", 7, 32);
        this.addKey("F", 6, 32);
        this.addKey("G", 6, 16);
        this.addKey("H", 5, 16);
        this.addKey("J", 5, 32);
        this.addKey("K", 4, 32);
        this.addKey("L", 4, 16);
        this.addKey(":", "*", 3, 32);
        this.addKey(";", "+", 3, 16);
        this.addKey("]", "}", 2, 8);
        this.xRow3Right = this.curX - 1;
        this.curX = n - 40;
        this.addKey(this.imgLeft, 1, 1, null);
        this.addKey(this.imgRight, 0, 2, null);
        int n2 = this.curX + 20;
        this.curX = 20;
        this.curY += 40;
        this.addKey("F3", null, 0, 32, "F3");
        this.curX += 20;
        this.addKey(this.imgPoint, 0, 8, "F7");
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 50, 40, "SHIFT", null, null, null, null, 2, 32, true, null);
        this.keys[this.curIdx++] = keyData;
        this.curX += 50;
        this.addKey("Z", 8, 128);
        this.addKey("X", 7, 128);
        this.addKey("C", 7, 64);
        this.addKey("V", 6, 128);
        this.addKey("B", 6, 64);
        this.addKey("N", 5, 64);
        this.addKey("M", 4, 64);
        this.addKey(",", "<", 4, 128);
        this.addKey(".", ">", 3, 128);
        this.addKey("/", "?", 3, 64);
        AbstractKeyboardFld.KeyData keyData2 = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 40, "SHIFT", null, null, null, null, 2, 32, true, null);
        this.keys[this.curIdx++] = keyData2;
        this.curX = n - 20;
        this.addKey(this.imgDown, 0, 4, null);
        this.curX = 20;
        this.curY += 40;
        this.addKey("F4", null, 2, 16, "F4");
        this.curX += 50;
        this.addKey("ENTER", null, 0, 64, "F6");
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, "CTRL", null, null, null, null, 2, 128, true, null);
        this.curX += 40;
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 320, 40, null, null, null, null, null, 5, 128, false, null);
        this.curX += 320;
        this.addKey("COPY", null, 1, 2, "F8");
        this.addKey("\\", "`", 2, 64);
        this.curX = n - 30;
        this.addLargeKey("RETURN", 2, 4, "Enter");
        int n3 = this.curY + 40 + 20;
        this.setPreferredSize(new Dimension(n2, n3));
        this.setShiftKeys(keyData, keyData2);
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof KCcompact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((KCcompact)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setPaintMode();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            if (this.isKeySelected(keyData)) {
                graphics.setColor(Color.gray);
                graphics.fillRect(keyData.x, keyData.y, keyData.w, keyData.h);
            }
            switch (keyData.w) {
                case 40: {
                    if (this.imgKey40x40 == null) break;
                    graphics.drawImage(this.imgKey40x40, keyData.x, keyData.y, this);
                    break;
                }
                case 50: {
                    if (this.imgKey50x40 == null) break;
                    graphics.drawImage(this.imgKey50x40, keyData.x, keyData.y, this);
                    break;
                }
                case 60: {
                    if (this.imgKey60x40 == null) break;
                    graphics.drawImage(this.imgKey60x40, keyData.x, keyData.y, this);
                    break;
                }
                case 320: {
                    if (this.imgKey320x40 == null) break;
                    graphics.drawImage(this.imgKey320x40, keyData.x, keyData.y, this);
                }
            }
            if (keyData.image != null) {
                graphics.drawImage(keyData.image, keyData.x + (keyData.w - keyData.image.getWidth(this)) / 2, keyData.y + (keyData.h - keyData.image.getHeight(this)) / 2, this);
                continue;
            }
            graphics.setColor(Color.black);
            if (keyData.text1 == null) continue;
            if (keyData.text2 != null) {
                graphics.setFont(this.fontDigit);
                if (keyData.text2 != null) {
                    graphics.drawString(keyData.text2, keyData.x + 8, keyData.y + 5 + 12);
                }
                graphics.drawString(keyData.text1, keyData.x + 22, keyData.y + 40 - 10);
                continue;
            }
            if (keyData.text1.length() == 1) {
                graphics.setFont(this.fontLetter);
                graphics.drawString(keyData.text1, keyData.x + 8, keyData.y + 6 + 14);
                continue;
            }
            graphics.setFont(this.fontText);
            this.drawMultiLineString(graphics, keyData.x, keyData.y, keyData.w, keyData.h, keyData.text1, 10);
        }
        graphics.setColor(Color.gray);
        graphics.drawLine(this.xRow1Left, 60, this.xRow1Left, 140);
        int n = this.xRow1Left + 6;
        int n2 = 76;
        graphics.setColor(Color.gray);
        graphics.fillOval(n, n2, 8, 8);
        graphics.fillOval(n, n2 + 40, 8, 8);
        n2 = 100;
        graphics.setColor(Color.gray);
        graphics.drawLine(this.xRow1Right, 60, this.xRow1Right, n2);
        graphics.drawLine(this.xRow1Right, n2, this.xRow3Right, n2);
        graphics.setColor(Color.red);
        n = this.xRow1Right - 20 + 6;
        n2 = 76;
        graphics.fillOval(n, n2, 8, 8);
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof KCcompact)) {
            throw new IllegalArgumentException("EmuSys != KCcompact");
        }
        this.emuSys = (KCcompact)emuSys;
    }

    private void addKey(Image image, int n, int n2, String string) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, null, null, null, null, image, n, n2, false, string);
        this.curX += 40;
    }

    private void addKey(String string, String string2, int n, int n2, String string3) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 40, 40, string, string2, null, null, null, n, n2, false, string3);
        this.curX += 40;
    }

    private void addKey(String string, String string2, int n, int n2) {
        this.addKey(string, string2, n, n2, null);
    }

    private void addKey(String string, int n, int n2) {
        this.addKey(string, null, n, n2);
    }

    private void addLargeKey(String string, int n, int n2, String string2) {
        this.keys[this.curIdx++] = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 40, string, null, null, null, null, n, n2, false, string2);
        this.curX += 60;
    }
}

