/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.poly880;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import jkcemu.base.AbstractKeyboardFld;
import jkcemu.base.EmuSys;
import jkcemu.emusys.Poly880;

public class Poly880KeyboardFld
extends AbstractKeyboardFld<Poly880> {
    private static final int MARGIN = 10;
    private static final int KEY_SIZE = 60;
    private static final String[] notEmulatedMsg = new String[]{"Der Poly-Computer 880 bietet einen", "Schrittbetrieb auf Maschinenzyklusebene.", "Dieser wird von JKCEMU aber nicht emuliert.", "Aus diesem Grund haben die Tasten", "M/CYCL und CYCL keine Wirkung."};
    private Color colorBg;
    private Font fontFct;
    private Font fontHex;
    private Font fontReg;
    private Font fontInfo;
    private Image imgKeyRed;
    private Image imgKeyGreen;
    private Image imgKeyOrange;
    private Image imgKeyWhite;
    private Image imgKeySelected;
    private AbstractKeyboardFld.KeyData resetKey;
    private AbstractKeyboardFld.KeyData cyclKey;
    private AbstractKeyboardFld.KeyData mCyclKey;
    private AbstractKeyboardFld.KeyData monKey;
    private int[] kbMatrix = new int[8];
    private int curIdx = 0;
    private int curX = 10;
    private int curY = 10;

    public Poly880KeyboardFld(Poly880 poly880) {
        super(poly880, 27, true);
        this.colorBg = new Color(20, 20, 20);
        this.fontInfo = new Font("SansSerif", 0, 18);
        this.fontFct = new Font("SansSerif", 0, 16);
        this.fontHex = new Font("SansSerif", 1, 24);
        this.fontReg = new Font("SansSerif", 0, 12);
        this.imgKeyRed = this.getImage("/images/keyboard/poly880/key_red.png");
        this.imgKeyGreen = this.getImage("/images/keyboard/poly880/key_green.png");
        this.imgKeyOrange = this.getImage("/images/keyboard/poly880/key_orange.png");
        this.imgKeyWhite = this.getImage("/images/keyboard/poly880/key_white.png");
        this.imgKeySelected = this.getImage("/images/keyboard/poly880/key_selected.png");
        this.addHexKey("C", "PC", 4, 128);
        this.addHexKey("D", null, 5, 128);
        this.addHexKey("E", null, 7, 128);
        this.addHexKey("F", null, 6, 128);
        this.curX += 30;
        this.addWhiteKey("GO", 0, 16, "G");
        this.addWhiteKey("MEM", 7, 16, "M");
        this.curX += 30;
        this.resetKey = this.addKey(this.imgKeyRed, "RES", null, null, -1, -1, "Esc");
        this.curX = 10;
        this.curY += 60;
        this.addHexKey("8", "IE", 4, 32);
        this.addHexKey("9", "IX", 5, 32);
        this.addHexKey("A", "IY", 7, 32);
        this.addHexKey("B", "SP", 6, 32);
        this.curX += 30;
        this.addWhiteKey("STEP", 6, 16, "S");
        this.addWhiteKey("REG", 4, 16, "R");
        this.curX += 30;
        this.monKey = this.addKey(this.imgKeyOrange, "MON", null, null, -1, -1, "F2");
        this.curX = 10;
        this.curY += 60;
        this.addHexKey("4", "AF'/MI", 0, 128);
        this.addHexKey("5", "BC'/MO", 3, 128);
        this.addHexKey("6", "DE'", 1, 128);
        this.addHexKey("7", "HL'", 2, 128);
        this.curX += 30;
        this.addWhiteKey("FCT", 5, 16, "F1");
        this.addWhiteKey("BACK", 3, 16, "- oder Backspace");
        this.curX += 30;
        this.mCyclKey = this.addKey(this.imgKeyGreen, "M\nCYCL", null, null, -1, -1, null);
        this.curX = 10;
        this.curY += 60;
        this.addHexKey("0", "AF/PI", 0, 32);
        this.addHexKey("1", "BC/PO", 3, 32);
        this.addHexKey("2", "DE/ME", 1, 32);
        this.addHexKey("3", "HL/FL", 2, 32);
        this.curX += 60;
        this.addKey(this.imgKeyRed, "EXEC", null, null, 2, 16, "X oder Enter");
        this.curX += 60;
        this.cyclKey = this.addKey(this.imgKeyGreen, "CYCL", null, null, -1, -1, null);
        this.setPreferredSize(new Dimension(500, 260));
    }

    @Override
    public boolean accepts(EmuSys emuSys) {
        return emuSys instanceof Poly880;
    }

    @Override
    public String getKeyboardName() {
        return "Poly-Computer Tastatur";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void keySelectionChanged() {
        Arrays.fill(this.kbMatrix, 0);
        List list = this.selectedKeys;
        synchronized (list) {
            for (AbstractKeyboardFld.KeyData keyData : this.selectedKeys) {
                if (keyData.col < 0 || keyData.col >= this.kbMatrix.length) continue;
                int n = keyData.col;
                this.kbMatrix[n] = this.kbMatrix[n] | keyData.value;
            }
        }
        ((Poly880)this.emuSys).updKeyboardMatrix(this.kbMatrix);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this) {
            if (Poly880KeyboardFld.hits(this.resetKey, mouseEvent)) {
                this.fireWarmResetAfterDelay();
            } else if (Poly880KeyboardFld.hits(this.monKey, mouseEvent)) {
                ((Poly880)this.emuSys).fireMonKey();
            }
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        boolean bl = false;
        graphics.setColor(this.colorBg);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (AbstractKeyboardFld.KeyData keyData : this.keys) {
            FontMetrics fontMetrics;
            String[] stringArray = null;
            if (this.isKeySelected(keyData)) {
                if (keyData == this.mCyclKey || keyData == this.cyclKey) {
                    bl = true;
                    stringArray = keyData.image;
                } else {
                    stringArray = this.imgKeySelected;
                }
            } else {
                stringArray = keyData.image;
            }
            if (stringArray != null) {
                graphics.drawImage((Image)stringArray, keyData.x, keyData.y, this);
            }
            graphics.setColor(Color.black);
            if (keyData.text1 != null) {
                graphics.setFont(this.fontFct);
                fontMetrics = graphics.getFontMetrics();
                if (fontMetrics != null) {
                    int n = keyData.text1.indexOf(10);
                    if (n >= 0) {
                        String string = keyData.text1.substring(0, n);
                        graphics.drawString(string, keyData.x + (keyData.w - fontMetrics.stringWidth(string)) / 2, keyData.y + keyData.w / 2 - 4);
                        string = keyData.text1.substring(n + 1);
                        graphics.drawString(string, keyData.x + (keyData.w - fontMetrics.stringWidth(string)) / 2, keyData.y + keyData.w / 2 + this.fontFct.getSize());
                    } else {
                        int n2 = this.fontFct.getSize();
                        graphics.drawString(keyData.text1, keyData.x + (keyData.w - fontMetrics.stringWidth(keyData.text1)) / 2, keyData.y + n2 - 2 + (60 - n2) / 2);
                    }
                }
            }
            if (keyData.text2 != null) {
                graphics.setFont(this.fontHex);
                fontMetrics = graphics.getFontMetrics();
                if (fontMetrics != null) {
                    graphics.drawString(keyData.text2, keyData.x + (keyData.w - fontMetrics.stringWidth(keyData.text2)) / 2, keyData.y + 8 + this.fontHex.getSize());
                }
            }
            if (keyData.text3 == null) continue;
            graphics.setFont(this.fontReg);
            graphics.drawString(keyData.text3, keyData.x + 8, keyData.y + 60 - 8);
        }
        if (bl) {
            graphics.setFont(this.fontInfo);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (fontMetrics != null) {
                int n = this.fontInfo.getSize() + 1;
                int n3 = notEmulatedMsg.length * n;
                int n4 = 0;
                for (String string : notEmulatedMsg) {
                    int n5 = fontMetrics.stringWidth(string);
                    if (n5 <= n4) continue;
                    n4 = n5;
                }
                int n6 = (this.getWidth() - (n4 += 20)) / 2;
                int n7 = (this.getHeight() - (n3 += 20)) / 2;
                graphics.setColor(Color.yellow);
                graphics.fillRect(n6, n7, n4, n3);
                graphics.setColor(Color.black);
                n6 += 10;
                n7 += 8;
                n7 += n;
                for (String string : notEmulatedMsg) {
                    graphics.drawString(string, n6, n7);
                    n7 += n;
                }
            }
        }
    }

    @Override
    public void setEmuSys(EmuSys emuSys) {
        if (!(emuSys instanceof Poly880)) {
            throw new IllegalArgumentException("EmuSys != Poly880");
        }
        this.emuSys = (Poly880)emuSys;
    }

    private AbstractKeyboardFld.KeyData addKey(Image image, String string, String string2, String string3, int n, int n2, String string4) {
        AbstractKeyboardFld.KeyData keyData = new AbstractKeyboardFld.KeyData(this.curX, this.curY, 60, 60, string, string2, string3, null, image, n, n2, false, string4);
        this.keys[this.curIdx++] = keyData;
        this.curX += 60;
        return keyData;
    }

    private void addHexKey(String string, String string2, int n, int n2) {
        this.addKey(this.imgKeyOrange, null, string, string2, n, n2, null);
    }

    private void addWhiteKey(String string, int n, int n2, String string2) {
        this.addKey(this.imgKeyWhite, string, null, null, n, n2, string2);
    }

    private void addWhiteKey(String string, int n, int n2) {
        this.addKey(this.imgKeyWhite, string, null, null, n, n2, null);
    }
}

