/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.emusys.z1013;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.AutoInputSettingsFld;
import jkcemu.base.AutoLoadSettingsFld;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.RAMFloppiesSettingsFld;
import jkcemu.base.RAMFloppy;
import jkcemu.base.ROMFileSettingsFld;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserCancelException;
import jkcemu.base.UserInputException;
import jkcemu.disk.GIDESettingsFld;

public class Z1013SettingsFld
extends AbstractSettingsFld {
    private JTabbedPane tabbedPane;
    private JRadioButton btnZ1013_01;
    private JRadioButton btnZ1013_12;
    private JRadioButton btnZ1013_16;
    private JRadioButton btnZ1013_64;
    private JRadioButton btnMon202;
    private JRadioButton btnMonA2;
    private JRadioButton btnMonRB_K7659;
    private JRadioButton btnMonRB_S6009;
    private JRadioButton btnMonINCOM_K7669;
    private JRadioButton btnMonJM_1992;
    private JRadioButton btnBL4_K7659;
    private JRadioButton btnPortNone;
    private JRadioButton btnPortJoyJuTe_6_87;
    private JRadioButton btnPortJoyPractic_4_87;
    private JRadioButton btnPortJoyPractic_1_88;
    private JRadioButton btnPortCentr7Practic_2_89;
    private JRadioButton btnPortCentr8FA_10_90;
    private JCheckBox btnModBasic;
    private JCheckBox btnModMegaROM;
    private JCheckBox btnFloppyDisk;
    private JCheckBox btnRTC;
    private JCheckBox btnKCNet;
    private JCheckBox btnVDIP;
    private JCheckBox btnGraphCCJ;
    private JCheckBox btnGraphic;
    private JCheckBox btnCatchPrintCalls;
    private JCheckBox btnCatchJoyCalls;
    private JCheckBox btnPasteFast;
    private ROMFileSettingsFld fldAltOS;
    private ROMFileSettingsFld fldAltFont;
    private ROMFileSettingsFld fldAltGCCJFont;
    private ROMFileSettingsFld fldAltBasic;
    private ROMFileSettingsFld fldMegaROM;
    private JPanel tabModel;
    private JPanel tabMon;
    private JPanel tabUserPort;
    private RAMFloppiesSettingsFld tabRF;
    private GIDESettingsFld tabGIDE;
    private JPanel tabModROM;
    private JPanel tabExt;
    private JPanel tabEtc;
    private AutoLoadSettingsFld tabAutoLoad;
    private AutoInputSettingsFld tabAutoInput;

    public Z1013SettingsFld(SettingsFrm settingsFrm, String string) {
        super(settingsFrm, string);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, "Center");
        this.tabModel = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Modell", this.tabModel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnZ1013_01 = new JRadioButton("Z1013.01 (1 MHz, 16 KByte RAM)", false);
        this.btnZ1013_01.addActionListener(this);
        buttonGroup.add(this.btnZ1013_01);
        this.tabModel.add((Component)this.btnZ1013_01, gridBagConstraints);
        this.btnZ1013_12 = new JRadioButton("Z1013.12 (2 MHz, 1 KByte RAM)", false);
        this.btnZ1013_12.addActionListener(this);
        buttonGroup.add(this.btnZ1013_12);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnZ1013_12, gridBagConstraints);
        this.btnZ1013_16 = new JRadioButton("Z1013.16 (2 MHz, 16 KByte RAM)", false);
        this.btnZ1013_16.addActionListener(this);
        buttonGroup.add(this.btnZ1013_16);
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnZ1013_16, gridBagConstraints);
        this.btnZ1013_64 = new JRadioButton("Z1013.64 (2 MHz, 64 KByte RAM)", false);
        this.btnZ1013_64.addActionListener(this);
        buttonGroup.add(this.btnZ1013_64);
        ++gridBagConstraints.gridy;
        this.tabModel.add((Component)this.btnZ1013_64, gridBagConstraints);
        this.tabMon = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Monitorprogramm / Tastatur", this.tabMon);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnMon202 = new JRadioButton("Monitorprogramm 2.02 / Folienflachtastatur", true);
        this.btnMon202.addActionListener(this);
        buttonGroup2.add(this.btnMon202);
        this.tabMon.add((Component)this.btnMon202, gridBagConstraints2);
        this.btnMonA2 = new JRadioButton("Monitorprogramm A.2 / Alphatastatur", false);
        this.btnMonA2.addActionListener(this);
        buttonGroup2.add(this.btnMonA2);
        gridBagConstraints2.insets.top = 0;
        ++gridBagConstraints2.gridy;
        this.tabMon.add((Component)this.btnMonA2, gridBagConstraints2);
        this.btnMonRB_K7659 = new JRadioButton("Brosig-Monitorprogramm 2.028 / Tastatur K7659", false);
        this.btnMonRB_K7659.addActionListener(this);
        buttonGroup2.add(this.btnMonRB_K7659);
        ++gridBagConstraints2.gridy;
        this.tabMon.add((Component)this.btnMonRB_K7659, gridBagConstraints2);
        this.btnMonRB_S6009 = new JRadioButton("Brosig-Monitorprogramm 2.028 / Tastatur S6009", false);
        this.btnMonRB_S6009.addActionListener(this);
        buttonGroup2.add(this.btnMonRB_S6009);
        ++gridBagConstraints2.gridy;
        this.tabMon.add((Component)this.btnMonRB_S6009, gridBagConstraints2);
        this.btnMonINCOM_K7669 = new JRadioButton("INCOM-Monitorprogramm 2.2 / Tastatur K7669", false);
        this.btnMonINCOM_K7669.addActionListener(this);
        buttonGroup2.add(this.btnMonINCOM_K7669);
        ++gridBagConstraints2.gridy;
        this.tabMon.add((Component)this.btnMonINCOM_K7669, gridBagConstraints2);
        this.btnMonJM_1992 = new JRadioButton("M\u00fcller-Monitorprogramm 1992 / Folienflachtastatur", false);
        this.btnMonJM_1992.addActionListener(this);
        buttonGroup2.add(this.btnMonJM_1992);
        ++gridBagConstraints2.gridy;
        this.tabMon.add((Component)this.btnMonJM_1992, gridBagConstraints2);
        this.btnBL4_K7659 = new JRadioButton("Boot Lader 4 / Tastatur K7659 (Boot-Diskette einlegen!)", false);
        this.btnBL4_K7659.addActionListener(this);
        buttonGroup2.add(this.btnBL4_K7659);
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        this.tabMon.add((Component)this.btnBL4_K7659, gridBagConstraints2);
        this.tabUserPort = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Anwendertor", this.tabUserPort);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.tabUserPort.add((Component)new JLabel("Am Anwendertor (User Port) emulierte Hardware:"), gridBagConstraints3);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.btnPortNone = new JRadioButton("Keine angeschlossene Hardware emulieren", true);
        this.btnPortNone.addActionListener(this);
        buttonGroup3.add(this.btnPortNone);
        gridBagConstraints3.insets.left = 50;
        gridBagConstraints3.insets.top = 0;
        gridBagConstraints3.insets.bottom = 0;
        ++gridBagConstraints3.gridy;
        this.tabUserPort.add((Component)this.btnPortNone, gridBagConstraints3);
        this.btnPortJoyJuTe_6_87 = new JRadioButton("1 Spielhebel nach JU+TE 06/1987", false);
        this.btnPortJoyJuTe_6_87.addActionListener(this);
        buttonGroup3.add(this.btnPortJoyJuTe_6_87);
        ++gridBagConstraints3.gridy;
        this.tabUserPort.add((Component)this.btnPortJoyJuTe_6_87, gridBagConstraints3);
        this.btnPortJoyPractic_4_87 = new JRadioButton("2 Spielhebel nach practic 04/1987", false);
        this.btnPortJoyPractic_4_87.addActionListener(this);
        buttonGroup3.add(this.btnPortJoyPractic_4_87);
        ++gridBagConstraints3.gridy;
        this.tabUserPort.add((Component)this.btnPortJoyPractic_4_87, gridBagConstraints3);
        this.btnPortJoyPractic_1_88 = new JRadioButton("2 Spielhebel nach practic 01/1988", false);
        this.btnPortJoyPractic_1_88.addActionListener(this);
        buttonGroup3.add(this.btnPortJoyPractic_1_88);
        ++gridBagConstraints3.gridy;
        this.tabUserPort.add((Component)this.btnPortJoyPractic_1_88, gridBagConstraints3);
        this.btnPortCentr7Practic_2_89 = new JRadioButton("Drucker an 7-Bit-Centronics-Anschluss nach practic 02/1989", false);
        this.btnPortCentr7Practic_2_89.addActionListener(this);
        buttonGroup3.add(this.btnPortCentr7Practic_2_89);
        ++gridBagConstraints3.gridy;
        this.tabUserPort.add((Component)this.btnPortCentr7Practic_2_89, gridBagConstraints3);
        this.btnPortCentr8FA_10_90 = new JRadioButton("Drucker an 8-Bit-Centronics-Anschluss nach FA 10/1990", false);
        this.btnPortCentr8FA_10_90.addActionListener(this);
        buttonGroup3.add(this.btnPortCentr8FA_10_90);
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        this.tabUserPort.add((Component)this.btnPortCentr8FA_10_90, gridBagConstraints3);
        this.tabRF = new RAMFloppiesSettingsFld(settingsFrm, string, "RAM-Floppy nach MP 3/88 (256 KByte) an E/A-Adressen 98h-9Fh", RAMFloppy.RFType.MP_3_1988, "RAM-Floppy nach MP 3/88 (256 KByte) an E/A-Adressen 58h-5Fh", RAMFloppy.RFType.MP_3_1988);
        this.tabbedPane.addTab("RAM-Floppies", this.tabRF);
        this.tabModROM = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("ROM-Module", this.tabModROM);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.btnModBasic = new JCheckBox("KC-BASIC-Modul (C000h-EBFFh)");
        ++gridBagConstraints4.gridy;
        this.tabModROM.add((Component)this.btnModBasic, gridBagConstraints4);
        this.fldAltBasic = new ROMFileSettingsFld(settingsFrm, string + "rom_basic.", "Alternativer Inhalt des KC-BASIC-Moduls:");
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets.left = 50;
        gridBagConstraints4.insets.top = 0;
        ++gridBagConstraints4.gridy;
        this.tabModROM.add((Component)this.fldAltBasic, gridBagConstraints4);
        this.btnModMegaROM = new JCheckBox("Mega-ROM-Modul (256 x C000h-E7FFh)");
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.insets.top = 5;
        gridBagConstraints4.insets.left = 5;
        ++gridBagConstraints4.gridy;
        this.tabModROM.add((Component)this.btnModMegaROM, gridBagConstraints4);
        this.fldMegaROM = new ROMFileSettingsFld(settingsFrm, string + "rom_mega.", "Inhalt des Mega-ROM-Moduls:");
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets.top = 0;
        gridBagConstraints4.insets.left = 50;
        ++gridBagConstraints4.gridy;
        this.tabModROM.add((Component)this.fldMegaROM, gridBagConstraints4);
        this.updROMModFieldsEnabled();
        this.btnModBasic.addActionListener(this);
        this.btnModMegaROM.addActionListener(this);
        this.tabGIDE = new GIDESettingsFld(settingsFrm, string);
        this.tabbedPane.addTab("GIDE", this.tabGIDE);
        this.tabExt = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Erweiterungen", this.tabExt);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
        this.btnFloppyDisk = new JCheckBox("Floppy-Disk-Modul", false);
        this.btnFloppyDisk.addActionListener(this);
        this.tabExt.add((Component)this.btnFloppyDisk, gridBagConstraints5);
        this.btnKCNet = new JCheckBox("KCNet-kompatible Netzwerkkarte", false);
        gridBagConstraints5.insets.top = 0;
        ++gridBagConstraints5.gridy;
        this.btnKCNet.addActionListener(this);
        this.tabExt.add((Component)this.btnKCNet, gridBagConstraints5);
        this.btnVDIP = new JCheckBox("USB-Anschluss (Vinculum VDIP Modul)", false);
        this.btnVDIP.addActionListener(this);
        ++gridBagConstraints5.gridy;
        this.tabExt.add((Component)this.btnVDIP, gridBagConstraints5);
        this.btnRTC = new JCheckBox("Echtzeituhr", false);
        this.btnRTC.addActionListener(this);
        ++gridBagConstraints5.gridy;
        this.tabExt.add((Component)this.btnRTC, gridBagConstraints5);
        this.btnGraphic = new JCheckBox("Vollgrafikerweiterung nach KRT 11 und FA 7/91", false);
        this.btnGraphic.addActionListener(this);
        ++gridBagConstraints5.gridy;
        this.tabExt.add((Component)this.btnGraphic, gridBagConstraints5);
        this.btnGraphCCJ = new JCheckBox("Grafikkarte des CC Jena (80x25 Zeichen)", false);
        this.btnGraphCCJ.addActionListener(this);
        gridBagConstraints5.insets.bottom = 5;
        ++gridBagConstraints5.gridy;
        this.tabExt.add((Component)this.btnGraphCCJ, gridBagConstraints5);
        this.fldAltGCCJFont = new ROMFileSettingsFld(settingsFrm, this.propPrefix + "graphic_ccj.font.file", "Alternativer Zeichensatz:");
        gridBagConstraints5.insets.left = 50;
        ++gridBagConstraints5.gridy;
        this.tabExt.add((Component)this.fldAltGCCJFont, gridBagConstraints5);
        this.updAltGCCJFontFieldsEnabled();
        this.tabEtc = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Sonstiges", this.tabEtc);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.btnCatchPrintCalls = new JCheckBox("Sprungverteileraufrufe f\u00fcr Druckerausgaben abfangen", true);
        this.btnCatchPrintCalls.addActionListener(this);
        this.tabEtc.add((Component)this.btnCatchPrintCalls, gridBagConstraints6);
        this.btnCatchJoyCalls = new JCheckBox("Sprungverteileraufrufe f\u00fcr Joystick-Abfragen abfangen", true);
        this.btnCatchJoyCalls.addActionListener(this);
        gridBagConstraints6.insets.top = 0;
        ++gridBagConstraints6.gridy;
        this.tabEtc.add((Component)this.btnCatchJoyCalls, gridBagConstraints6);
        this.btnPasteFast = new JCheckBox("Einf\u00fcgen von Text durch Abfangen des Systemaufrufs", true);
        this.btnPasteFast.addActionListener(this);
        gridBagConstraints6.insets.bottom = 5;
        ++gridBagConstraints6.gridy;
        this.tabEtc.add((Component)this.btnPasteFast, gridBagConstraints6);
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.insets.top = 10;
        gridBagConstraints6.insets.bottom = 10;
        ++gridBagConstraints6.gridy;
        this.tabEtc.add((Component)new JSeparator(), gridBagConstraints6);
        this.fldAltOS = new ROMFileSettingsFld(settingsFrm, string + "os.", "Alternatives Monitorprogramm (F000h-FFFFh):");
        gridBagConstraints6.insets.top = 5;
        gridBagConstraints6.insets.bottom = 5;
        ++gridBagConstraints6.gridy;
        this.tabEtc.add((Component)this.fldAltOS, gridBagConstraints6);
        this.fldAltFont = new ROMFileSettingsFld(settingsFrm, string + "font.", "Alternativer Zeichensatz:");
        ++gridBagConstraints6.gridy;
        this.tabEtc.add((Component)this.fldAltFont, gridBagConstraints6);
        this.tabAutoLoad = new AutoLoadSettingsFld(settingsFrm, string, 500, true);
        this.tabbedPane.addTab("AutoLoad", this.tabAutoLoad);
        this.tabAutoInput = new AutoInputSettingsFld(settingsFrm, string, true, 4, 500);
        this.tabbedPane.addTab("AutoInput", this.tabAutoInput);
    }

    public String getModelSysName() {
        String string = "Z1013.64";
        if (this.btnZ1013_01.isSelected()) {
            string = "Z1013.01";
        } else if (this.btnZ1013_12.isSelected()) {
            string = "Z1013.12";
        } else if (this.btnZ1013_16.isSelected()) {
            string = "Z1013.16";
        }
        return string;
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserCancelException, UserInputException {
        JPanel jPanel = null;
        String string = null;
        try {
            jPanel = this.tabModel;
            string = "2.02";
            if (this.btnMonA2.isSelected()) {
                string = "A.2";
            } else if (this.btnMonRB_K7659.isSelected()) {
                string = "RB_K7659";
            } else if (this.btnMonRB_S6009.isSelected()) {
                string = "RB_S6009";
            } else if (this.btnMonINCOM_K7669.isSelected()) {
                string = "INCOM_K7669";
            } else if (this.btnMonJM_1992.isSelected()) {
                string = "JM_1992";
            } else if (this.btnBL4_K7659.isSelected()) {
                string = "BL4_K7659";
            }
            EmuUtil.setProperty(properties, "jkcemu.z1013.monitor", string);
            jPanel = this.tabUserPort;
            string = "none";
            if (this.btnPortJoyJuTe_6_87.isSelected()) {
                string = "joystick:jute0687";
            } else if (this.btnPortJoyPractic_4_87.isSelected()) {
                string = "joystick:practic0487";
            } else if (this.btnPortJoyPractic_1_88.isSelected()) {
                string = "joystick:practic0188";
            } else if (this.btnPortCentr7Practic_2_89.isSelected()) {
                string = "centronics7:practic0289";
            } else if (this.btnPortCentr8FA_10_90.isSelected()) {
                string = "centronics8:fa1090";
            }
            EmuUtil.setProperty(properties, this.propPrefix + "userport", string);
            jPanel = this.tabRF;
            this.tabRF.applyInput(properties, bl);
            jPanel = this.tabModROM;
            EmuUtil.setProperty(properties, this.propPrefix + "rom_basic.enabled", this.btnModBasic.isSelected());
            this.fldAltBasic.applyInput(properties, bl);
            boolean bl2 = this.btnModMegaROM.isSelected();
            if (bl2 && this.fldMegaROM.getFile() == null) {
                throw new UserInputException("Datei f\u00fcr Mega-ROM-Modul nicht ausgew\u00e4hlt");
            }
            EmuUtil.setProperty(properties, this.propPrefix + "rom_mega.enabled", bl2);
            this.fldMegaROM.applyInput(properties, bl);
            jPanel = this.tabGIDE;
            this.tabGIDE.applyInput(properties, bl);
            jPanel = this.tabExt;
            EmuUtil.setProperty(properties, this.propPrefix + "fdc.enabled", this.btnFloppyDisk.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "rtc.enabled", this.btnRTC.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "kcnet.enabled", this.btnKCNet.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "vdip.enabled", this.btnVDIP.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "graphic.enabled", this.btnGraphic.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "graphic_ccj.enabled", this.btnGraphCCJ.isSelected());
            this.fldAltGCCJFont.applyInput(properties, bl);
            jPanel = this.tabEtc;
            EmuUtil.setProperty(properties, this.propPrefix + "catch_print_calls", this.btnCatchPrintCalls.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "catch_joystick_calls", this.btnCatchJoyCalls.isSelected());
            EmuUtil.setProperty(properties, this.propPrefix + "paste.fast", this.btnPasteFast.isSelected());
            this.fldAltOS.applyInput(properties, bl);
            this.fldAltFont.applyInput(properties, bl);
            jPanel = this.tabAutoLoad;
            this.tabAutoLoad.applyInput(properties, bl);
            jPanel = this.tabAutoInput;
            this.tabAutoInput.applyInput(properties, bl);
            if (bl && this.btnMonA2.isSelected() && this.btnModBasic.isSelected() && this.fldAltBasic.getFile() == null && !BaseDlg.showYesNoWarningDlg(this, "Das im ROM-Modul enthaltene KC-BASIC l\u00e4uft nicht mit dem Monitorprogramm A.2 zusammen.\nSie sollten deshalb entweder ein anderes Monitorprogramm ausw\u00e4hlen oder f\u00fcr das ROM-Modul\neinen alternativen, an das Monitorprogramm angepassten Inhalt einbinden.\n\nM\u00f6chten Sie trotzdem die Einstellungen \u00fcbernehmen?", "Konflikt")) {
                throw new UserCancelException();
            }
        }
        catch (UserInputException userInputException) {
            if (jPanel != null) {
                this.tabbedPane.setSelectedComponent(jPanel);
            }
            throw userInputException;
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        this.settingsFrm.setWaitCursor(true);
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnModBasic) {
                bl = true;
                if (this.btnModBasic.isSelected() && this.btnModMegaROM.isSelected()) {
                    this.btnModMegaROM.setSelected(false);
                }
                this.updROMModFieldsEnabled();
                this.fireDataChanged();
            } else if (object == this.btnModMegaROM) {
                bl = true;
                if (this.btnModBasic.isSelected() && this.btnModMegaROM.isSelected()) {
                    this.btnModBasic.setSelected(false);
                }
                this.updROMModFieldsEnabled();
                this.fireDataChanged();
            } else if (object == this.btnGraphCCJ) {
                bl = true;
                this.updAltGCCJFontFieldsEnabled();
                this.fireDataChanged();
            } else if (object instanceof AbstractButton) {
                bl = true;
                this.fireDataChanged();
            }
        }
        if (!bl) {
            bl = this.tabGIDE.doAction(eventObject);
        }
        if (!bl) {
            bl = this.tabAutoLoad.doAction(eventObject);
        }
        if (!bl) {
            bl = this.tabAutoInput.doAction(eventObject);
        }
        this.settingsFrm.setWaitCursor(false);
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.fldAltOS.lookAndFeelChanged();
        this.fldAltFont.lookAndFeelChanged();
        this.fldAltGCCJFont.lookAndFeelChanged();
        this.fldAltBasic.lookAndFeelChanged();
        this.fldMegaROM.lookAndFeelChanged();
        this.tabGIDE.lookAndFeelChanged();
        this.tabAutoLoad.lookAndFeelChanged();
        this.tabAutoInput.lookAndFeelChanged();
    }

    @Override
    public void updFields(Properties properties) {
        switch (EmuUtil.getProperty(properties, "jkcemu.system")) {
            case "Z1013.01": {
                this.btnZ1013_01.setSelected(true);
                break;
            }
            case "Z1013.12": {
                this.btnZ1013_12.setSelected(true);
                break;
            }
            case "Z1013.16": {
                this.btnZ1013_16.setSelected(true);
                break;
            }
            default: {
                this.btnZ1013_64.setSelected(true);
            }
        }
        String string = EmuUtil.getProperty(properties, "jkcemu.z1013.monitor");
        if (string.equals("A.2")) {
            this.btnMonA2.setSelected(true);
        } else if (string.equals("RB_K7659")) {
            this.btnMonRB_K7659.setSelected(true);
        } else if (string.equals("RB_S6009")) {
            this.btnMonRB_S6009.setSelected(true);
        } else if (string.equals("INCOM_K7669")) {
            this.btnMonINCOM_K7669.setSelected(true);
        } else if (string.equals("JM_1992")) {
            this.btnMonJM_1992.setSelected(true);
        } else if (string.equals("BL4_K7659")) {
            this.btnBL4_K7659.setSelected(true);
        } else {
            this.btnMon202.setSelected(true);
        }
        String string2 = EmuUtil.getProperty(properties, this.propPrefix + "userport");
        if (string2.equals("joystick:jute0687")) {
            this.btnPortJoyJuTe_6_87.setSelected(true);
        } else if (string2.equals("joystick:practic0487")) {
            this.btnPortJoyPractic_4_87.setSelected(true);
        } else if (string2.equals("joystick:practic0188")) {
            this.btnPortJoyPractic_1_88.setSelected(true);
        } else if (string2.equals("centronics7:practic0289")) {
            this.btnPortCentr7Practic_2_89.setSelected(true);
        } else if (string2.equals("centronics8:fa1090")) {
            this.btnPortCentr8FA_10_90.setSelected(true);
        } else {
            this.btnPortNone.setSelected(true);
        }
        this.tabRF.updFields(properties);
        this.tabGIDE.updFields(properties);
        this.btnModBasic.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom_basic.enabled", false));
        this.btnModMegaROM.setSelected(!this.btnModBasic.isSelected() && EmuUtil.getBooleanProperty(properties, this.propPrefix + "rom_mega.enabled", false));
        this.updROMModFieldsEnabled();
        this.fldAltBasic.updFields(properties);
        this.fldMegaROM.updFields(properties);
        this.btnFloppyDisk.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "fdc.enabled", false));
        this.btnRTC.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "rtc.enabled", false));
        this.btnKCNet.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "kcnet.enabled", false));
        this.btnVDIP.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "vdip.enabled", false));
        this.btnGraphic.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "graphic.enabled", false));
        this.btnGraphCCJ.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "graphic_ccj.enabled", false));
        this.updAltGCCJFontFieldsEnabled();
        this.fldAltGCCJFont.updFields(properties);
        this.btnCatchPrintCalls.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "catch_print_calls", true));
        this.btnCatchJoyCalls.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "catch_joystick_calls", true));
        this.btnPasteFast.setSelected(EmuUtil.getBooleanProperty(properties, this.propPrefix + "paste.fast", true));
        this.fldAltOS.updFields(properties);
        this.fldAltFont.updFields(properties);
        this.tabAutoLoad.updFields(properties);
        this.tabAutoInput.updFields(properties);
    }

    private void updAltGCCJFontFieldsEnabled() {
        this.fldAltGCCJFont.setEnabled(this.btnGraphCCJ.isSelected());
    }

    private void updROMModFieldsEnabled() {
        this.fldAltBasic.setEnabled(this.btnModBasic.isSelected());
        this.fldMegaROM.setEnabled(this.btnModMegaROM.isSelected());
    }
}

