/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import jkcemu.etc.CRC16;

public class CksCalculator {
    private static final String CKS_ADD8 = "Summe der Bytes";
    private static final String CKS_ADD16LE = "Summe der 16-Bit-Worte (Little Endian)";
    private static final String CKS_ADD16BE = "Summe der 16-Bit-Worte (Big Endian)";
    private static final String CKS_ADLER32 = "Adler-32";
    private static final String CKS_CRC16CCITT = "CRC-CCITT (CRC-16 HDLC)";
    private static final String CKS_CRC32 = "CRC-32";
    private static String[] algorithms = new String[]{"Summe der Bytes", "Summe der 16-Bit-Worte (Little Endian)", "Summe der 16-Bit-Worte (Big Endian)", "CRC-CCITT (CRC-16 HDLC)", "CRC-32", "Adler-32", "MD2", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"};
    private String algorithm;
    private String value;
    private Checksum checksum;
    private MessageDigest digest;

    public CksCalculator(String string) throws NoSuchAlgorithmException {
        this.algorithm = string;
        this.value = null;
        this.checksum = null;
        this.digest = null;
        if (string.equals(CKS_ADD8)) {
            this.checksum = new Add8();
        } else if (string.equals(CKS_ADD16LE)) {
            this.checksum = new Add16LE();
        } else if (string.equals(CKS_ADD16BE)) {
            this.checksum = new Add16BE();
        } else if (string.equals(CKS_ADLER32)) {
            this.checksum = new Adler32();
        } else if (string.equals(CKS_CRC16CCITT)) {
            this.checksum = CRC16.createCRC16CCITT();
        } else if (string.equals(CKS_CRC32)) {
            this.checksum = new CRC32();
        } else {
            this.digest = MessageDigest.getInstance(string);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static String[] getAvailableAlgorithms() {
        return algorithms;
    }

    public String getValue() {
        if (this.value == null) {
            byte[] byArray;
            if (this.checksum != null) {
                this.value = this.checksum instanceof CRC16 ? String.format("%04X", this.checksum.getValue()) : String.format("%08X", this.checksum.getValue());
            } else if (this.digest != null && (byArray = this.digest.digest()) != null) {
                StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuilder.append(String.format("%02X", byArray[i] & 0xFF));
                }
                this.value = stringBuilder.toString();
            }
        }
        return this.value;
    }

    public void reset() {
        this.value = null;
        if (this.checksum != null) {
            this.checksum.reset();
        } else if (this.digest != null) {
            this.digest.reset();
        }
    }

    public void update(int n) {
        if (this.checksum != null) {
            this.checksum.update(n);
        } else if (this.digest != null) {
            this.digest.update((byte)n);
        }
    }

    public static class Add16LE
    implements Checksum {
        private int cks;
        private int buf;

        public Add16LE() {
            this.reset();
        }

        @Override
        public long getValue() {
            int n = this.cks;
            if (this.buf >= 0) {
                n += this.buf;
            }
            return (long)n & 0xFFFFL;
        }

        @Override
        public void reset() {
            this.cks = 0;
            this.buf = -1;
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            while (n2 > 0) {
                this.update(byArray[n++]);
                --n2;
            }
        }

        @Override
        public void update(int n) {
            if (this.buf >= 0) {
                this.cks += n << 8 & 0xFF00 | this.buf;
                this.cks &= 0xFFFF;
                this.buf = -1;
            } else {
                this.buf = n & 0xFF;
            }
        }
    }

    public static class Add16BE
    implements Checksum {
        private int cks;
        private int buf;

        public Add16BE() {
            this.reset();
        }

        @Override
        public long getValue() {
            int n = this.cks;
            if (this.buf >= 0) {
                n += this.buf << 8 & 0xFF00;
            }
            return (long)n & 0xFFFFL;
        }

        @Override
        public void reset() {
            this.cks = 0;
            this.buf = -1;
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            while (n2 > 0) {
                this.update(byArray[n++]);
                --n2;
            }
        }

        @Override
        public void update(int n) {
            n &= 0xFF;
            if (this.buf >= 0) {
                this.cks += this.buf << 8 & 0xFF00 | n;
                this.cks &= 0xFFFF;
                this.buf = -1;
            } else {
                this.buf = n;
            }
        }
    }

    public static class Add8
    implements Checksum {
        private int cks;

        public Add8() {
            this.reset();
        }

        @Override
        public long getValue() {
            return (long)this.cks & 0xFFFFL;
        }

        @Override
        public void reset() {
            this.cks = 0;
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            while (n2 > 0) {
                this.update(byArray[n++]);
                --n2;
            }
        }

        @Override
        public void update(int n) {
            this.cks = this.cks + (n & 0xFF) & 0xFFFF;
        }
    }
}

