/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

public class PPI8255 {
    public static final int PORT_A = 0;
    public static final int PORT_B = 1;
    public static final int PORT_C = 2;
    private static final int ACK_A_MASK = 64;
    private static final int ACK_B_MASK = 4;
    private static final int IBF_A_MASK = 32;
    private static final int IBF_B_MASK = 2;
    private static final int INTR_A_MASK = 8;
    private static final int INTR_B_MASK = 1;
    private static final int OBF_A_MASK = 128;
    private static final int OBF_B_MASK = 2;
    private static final int STB_A_MASK = 16;
    private static final int STB_B_MASK = 4;
    private static final int INTE_A_IN_MASK = 16;
    private static final int INTE_B_IN_MASK = 4;
    private static final int INTE_A_OUT_MASK = 64;
    private static final int INTE_B_OUT_MASK = 4;
    private Callback callback;
    private int modeA;
    private int valueA;
    private int valueB;
    private int valueC;
    private boolean modeB1;
    private boolean dirAin;
    private boolean dirBin;
    private boolean dirCHin;
    private boolean dirCLin;

    public PPI8255(Callback callback) {
        this.callback = callback;
        this.reset();
    }

    public int fetchOutValueA(boolean bl) {
        if (bl) {
            this.valueC &= 0xFFFFFFBF;
            this.setBitsC(128, true);
        }
        return this.valueA;
    }

    public int fetchOutValueB(boolean bl) {
        if (bl) {
            this.valueC &= 0xFFFFFFFB;
            this.setBitsC(2, true);
        }
        return this.valueB;
    }

    public int fetchOutValueC() {
        return this.valueC;
    }

    public int read(int n, int n2) {
        int n3 = n2;
        switch (n & 3) {
            case 0: {
                if (this.modeA == 0 && this.dirAin) {
                    if (this.callback == null) break;
                    n3 = this.callback.ppiReadPort(this, 0);
                    break;
                }
                if ((this.modeA != 1 || !this.dirAin) && this.modeA != 2) break;
                n3 = this.valueA;
                this.valueC &= 0xFFFFFFF7;
                break;
            }
            case 1: {
                if (!this.dirBin) break;
                if (this.modeB1) {
                    n3 = this.valueB;
                    this.valueC &= 0xFFFFFFFE;
                    break;
                }
                if (this.callback == null) break;
                n3 = this.callback.ppiReadPort(this, 1);
                break;
            }
            case 2: {
                n3 = this.valueC;
                if (this.modeA != 0 || this.modeB1) break;
                int n4 = n3;
                if (this.callback != null) {
                    n4 = this.callback.ppiReadPort(this, 2);
                }
                if (this.dirCLin) {
                    n3 = n3 & 0xF0 | n4 & 0xF;
                }
                if (!this.dirCHin) break;
                n3 = n4 & 0xF0 | n3 & 0xF;
            }
        }
        return n3 & 0xFF;
    }

    public synchronized void reset() {
        this.modeA = 0;
        this.valueA = 255;
        this.valueB = 255;
        this.valueC = 255;
        this.modeB1 = false;
        this.dirAin = true;
        this.dirBin = true;
        this.dirCHin = true;
        this.dirCLin = true;
    }

    public void setStrobedInValueA(int n) {
        if (this.dirAin && this.modeA == 1 || this.modeA == 2) {
            this.valueA = n & 0xFF;
            int n2 = 48;
            if ((this.valueC & 0x10) != 0) {
                n2 |= 8;
            }
            this.setBitsC(n2, true);
        }
    }

    public void setStrobedInValueB(int n) {
        if (this.dirBin && this.modeB1) {
            this.valueB = n & 0xFF;
            int n2 = 6;
            if ((this.valueC & 4) != 0) {
                n2 |= 1;
            }
            this.setBitsC(n2, true);
        }
    }

    public void write(int n, int n2) {
        n2 &= 0xFF;
        switch (n & 3) {
            case 0: {
                if (this.dirAin) break;
                if (this.modeA == 0) {
                    if (n2 == this.valueA) break;
                    this.valueA = n2;
                    if (this.callback == null) break;
                    this.callback.ppiWritePort(this, 0, n2, false);
                    break;
                }
                if (this.modeA != 1 && this.modeA != 2) break;
                this.valueA = n2;
                if (this.callback != null) {
                    this.callback.ppiWritePort(this, 0, n2, true);
                }
                this.valueC &= 0xFFFFFFF7;
                this.setBitsC(128, false);
                break;
            }
            case 1: {
                if (this.dirBin) break;
                if (this.modeB1) {
                    this.valueB = n2;
                    if (this.callback != null) {
                        this.callback.ppiWritePort(this, 1, n2, true);
                    }
                    this.valueC &= 0xFFFFFFFE;
                    this.setBitsC(2, false);
                    break;
                }
                if (n2 == this.valueB) break;
                this.valueB = n2;
                if (this.callback == null) break;
                this.callback.ppiWritePort(this, 1, n2, false);
                break;
            }
            case 2: {
                if (this.dirCLin && this.dirCHin || this.modeA == 1 || this.modeB1) break;
                if (this.dirCLin) {
                    n2 = n2 & 0xF0 | this.valueC & 0xF;
                }
                if (this.dirCHin) {
                    n2 = this.valueC & 0xF0 | n2 & 0xF;
                }
                if (this.modeA > 1) {
                    n2 = this.valueC & 0xF8 | n2 & 7;
                }
                if (n2 == this.valueC) break;
                this.valueC = n2;
                if (this.callback == null) break;
                this.callback.ppiWritePort(this, 2, n2, false);
                break;
            }
            case 3: {
                if ((n2 & 0x80) != 0) {
                    this.modeA = n2 >> 5 & 3;
                    this.dirAin = (n2 & 0x10) != 0;
                    this.modeB1 = (n2 & 4) != 0;
                    this.dirBin = (n2 & 2) != 0;
                    this.dirCHin = (n2 & 8) != 0;
                    this.dirCLin = (n2 & 1) != 0;
                    break;
                }
                if (this.modeA == 1 || this.modeB1) break;
                int n3 = n2 >> 1 & 7;
                if (this.modeA != 0 && n3 > 2 || (this.dirCLin || n3 >= 4) && (this.dirCHin || n3 < 4)) break;
                int n4 = 1 << n3;
                this.setBitsC(1 << n3, (n2 & 1) != 0);
            }
        }
    }

    private void setBitsC(int n, boolean bl) {
        if (bl) {
            if ((this.valueC & n) != n) {
                this.valueC |= n;
                if (this.callback != null) {
                    this.callback.ppiWritePort(this, 2, this.valueC, false);
                }
            }
        } else if ((this.valueC & n) != 0) {
            this.valueC &= ~n;
            if (this.callback != null) {
                this.callback.ppiWritePort(this, 2, this.valueC, false);
            }
        }
    }

    public static interface Callback {
        public int ppiReadPort(PPI8255 var1, int var2);

        public void ppiWritePort(PPI8255 var1, int var2, int var3, boolean var4);
    }
}

