/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Properties;
import jkcemu.base.EmuUtil;
import jkcemu.base.UserInputException;
import jkcemu.etc.PlotterFrm;

public class Plotter {
    public static final String PROP_PAPER_COLOR = "jkcemu.plotter.paper.color";
    public static final String PROP_PEN_COLOR = "jkcemu.plotter.pen.color";
    public static final String PROP_PEN_THICKNESS = "jkcemu.plotter.pen.thickness";
    public static final int DEFAULT_PEN_THICKNESS = 3;
    private Color colorPaper;
    private Color colorPen;
    private IndexColorModel colorModel;
    private BufferedImage image = null;
    private PlotterFrm plotterFrm = null;
    private int width = this.width;
    private int height = this.height;
    private int curX = 0;
    private int curY = 0;
    private int paperRGB = -1;
    private int penRGB = -16777216;
    private int penThickness = 3;
    private boolean penState = false;
    private boolean clean = true;

    public Plotter() {
        this.colorPaper = new Color(this.paperRGB);
        this.colorPen = new Color(this.penRGB);
        this.createColorModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applySettings(Properties properties) {
        block16: {
            String string = EmuUtil.getProperty(properties, PROP_PAPER_COLOR);
            if (!string.isEmpty()) {
                try {
                    this.setPaperColor(new Color((int)Long.parseLong(string, 16)));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (UserInputException userInputException) {
                    // empty catch block
                }
            }
            if (!(string = EmuUtil.getProperty(properties, PROP_PEN_COLOR)).isEmpty()) {
                try {
                    this.setPenColor(new Color((int)Long.parseLong(string, 16)));
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (UserInputException userInputException) {
                    // empty catch block
                }
            }
            if (!(string = EmuUtil.getProperty(properties, PROP_PEN_THICKNESS)).isEmpty()) {
                try {
                    int n = Integer.parseInt(string);
                    if (n < 1 || n > 5) break block16;
                    Plotter plotter = this;
                    synchronized (plotter) {
                        if (n != this.penThickness) {
                            this.penThickness = n;
                            if (this.plotterFrm != null) {
                                this.plotterFrm.setPenThickness(this.penThickness);
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void die() {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
            this.clean = true;
        }
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public Color getPaperColor() {
        return this.colorPaper;
    }

    public Color getPenColor() {
        return this.colorPen;
    }

    public boolean isClean() {
        return this.clean;
    }

    public synchronized void movePen(int n, int n2) {
        if (n != 0 || n2 != 0) {
            int n3 = this.curX + n;
            if (n3 >= this.width) {
                n3 = this.width - 1;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            this.curX = n3;
            int n4 = this.curY + n2;
            if (n4 >= this.height) {
                n4 = this.height - 1;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            this.curY = n4;
            if (this.penState && this.image != null && this.curX < this.image.getWidth() && this.curY < this.image.getHeight()) {
                if (n != n2 && (Math.abs(n) > 1 || Math.abs(n2) > 1)) {
                    Graphics2D graphics2D = this.image.createGraphics();
                    int n5 = this.penThickness;
                    if (n5 > 1) {
                        graphics2D.drawRect(this.curX - n, this.curY - n2, n + n5 - 1, n2 + n5 - 1);
                    } else {
                        graphics2D.drawLine(this.curX - n, this.curY - n2, this.curX, this.curY);
                    }
                    graphics2D.dispose();
                } else {
                    this.paintPixel();
                }
                this.clean = false;
                if (this.plotterFrm != null) {
                    this.plotterFrm.setDirty();
                }
            }
        }
    }

    public synchronized void newPage() {
        if (this.image != null && this.image.getColorModel() != this.colorModel) {
            this.createBufferedImage();
        }
        this.clearPage();
    }

    public synchronized void setPageSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        if (this.image != null) {
            if (n != this.image.getWidth() || n2 != this.image.getHeight()) {
                this.createBufferedImage();
            }
        } else {
            this.createBufferedImage();
        }
    }

    public synchronized void setPaperColor(Color color) throws UserInputException {
        if (color.getRGB() != this.paperRGB) {
            this.colorPaper = color;
            this.createColorModel();
            if (this.isClean()) {
                this.createBufferedImage();
            } else {
                throw new UserInputException("Die neue Papierfarbe wird erst auf der n\u00e4chsten Seite wirksam.");
            }
        }
    }

    public synchronized void setPenColor(Color color) throws UserInputException {
        if (color.getRGB() != this.penRGB) {
            this.colorPen = color;
            this.createColorModel();
            if (this.isClean()) {
                this.createBufferedImage();
            } else {
                throw new UserInputException("Die neue Stiftfarbe wird erst auf der n\u00e4chsten Seite wirksam.");
            }
        }
    }

    public synchronized void setPenState(boolean bl) {
        if (bl != this.penState) {
            this.penState = bl;
            if (bl && this.paintPixel()) {
                this.clean = false;
                if (this.plotterFrm != null) {
                    this.plotterFrm.setDirty();
                }
            }
        }
    }

    public void setPenThickness(int n) {
        this.penThickness = n;
    }

    public synchronized void setPlotterFrm(PlotterFrm plotterFrm) {
        this.plotterFrm = plotterFrm;
        if (this.plotterFrm != null) {
            this.plotterFrm.setPenThickness(this.penThickness);
        }
    }

    public synchronized void reset() {
        this.curX = 0;
        this.curY = 0;
        this.penState = false;
    }

    private void clearPage() {
        if (this.image != null) {
            Graphics2D graphics2D = this.image.createGraphics();
            graphics2D.setColor(this.colorPaper);
            graphics2D.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
            graphics2D.dispose();
            this.clean = true;
            if (this.plotterFrm != null) {
                this.plotterFrm.setDirty();
            }
        }
    }

    private void createBufferedImage() {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        if (this.width > 0 && this.height > 0) {
            this.paperRGB = this.colorPaper.getRGB();
            this.penRGB = this.colorPen.getRGB();
            this.image = new BufferedImage(this.width, this.height, 13, this.colorModel);
            this.clearPage();
        }
    }

    private void createColorModel() {
        byte[] byArray = new byte[]{(byte)this.colorPaper.getRed(), (byte)this.colorPen.getRed()};
        byte[] byArray2 = new byte[]{(byte)this.colorPaper.getGreen(), (byte)this.colorPen.getGreen()};
        byte[] byArray3 = new byte[]{(byte)this.colorPaper.getBlue(), (byte)this.colorPen.getBlue()};
        if (this.colorPaper.getAlpha() > 0) {
            byte[] byArray4 = new byte[]{(byte)this.colorPaper.getAlpha(), -1};
            this.colorModel = new IndexColorModel(1, 2, byArray, byArray2, byArray3, byArray4);
        } else {
            this.colorModel = new IndexColorModel(1, 2, byArray, byArray2, byArray3);
        }
    }

    private boolean paintPixel() {
        boolean bl = false;
        BufferedImage bufferedImage = this.image;
        if (bufferedImage != null) {
            int n = this.curX;
            int n2 = this.curY;
            if (n >= 0 && n < this.image.getWidth() && n2 >= 0 && n2 < this.image.getHeight()) {
                int n3 = this.penThickness;
                if (n3 > 1) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            this.image.setRGB(n + i, n2 + j, this.penRGB);
                        }
                    }
                } else {
                    this.image.setRGB(n, n2, this.penRGB);
                }
                bl = true;
            }
        }
        return bl;
    }
}

