/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.Timer;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.HelpFrm;
import jkcemu.base.UserInputException;
import jkcemu.etc.Plotter;
import jkcemu.image.AbstractImageFrm;
import jkcemu.print.PrintUtil;

public class PlotterFrm
extends AbstractImageFrm {
    private static final String ACTION_CLOSE = "close";
    private static final String ACTION_COLOR_PAPER = "color.paper";
    private static final String ACTION_COLOR_PEN = "color.pen";
    private static final String ACTION_HELP = "help";
    private static final String HELP_PAGE = "/help/plotter.htm";
    private static final String PROP_CONFIRM_NEWPAGE = "confirm.newpage";
    private static PlotterFrm instance = null;
    private Plotter plotter;
    private Image image;
    private File file;
    private Timer refreshTimer;
    private volatile boolean dirty;
    private JMenuItem mnuNewPage;
    private JMenuItem mnuPrint;
    private JMenuItem mnuSaveAs;
    private JMenuItem mnuCopy;
    private JRadioButtonMenuItem mnuPenThk1;
    private JRadioButtonMenuItem mnuPenThk2;
    private JRadioButtonMenuItem mnuPenThk3;
    private JRadioButtonMenuItem mnuPenThk4;
    private JRadioButtonMenuItem mnuPenThk5;
    private JCheckBoxMenuItem mnuConfirmNewPage;
    private JButton btnNewPage;
    private JButton btnPrint;
    private JButton btnSaveAs;
    private JButton btnRotateLeft;
    private JButton btnRotateRight;

    public static void close() {
        if (instance != null) {
            instance.doClose();
        }
    }

    public static void lazySetPlotter(Plotter plotter) {
        if (instance != null) {
            if (PlotterFrm.instance.plotter != null) {
                PlotterFrm.instance.plotter.setPlotterFrm(null);
            }
            PlotterFrm.instance.plotter = plotter;
            if (PlotterFrm.instance.plotter != null) {
                PlotterFrm.instance.plotter.setPlotterFrm(instance);
            }
        }
    }

    public static void open(Plotter plotter) {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new PlotterFrm(plotter);
        }
        instance.toFront();
        instance.setVisible(true);
    }

    public void setDirty() {
        this.dirty = true;
    }

    public void setPenThickness(int n) {
        switch (n) {
            case 2: {
                this.mnuPenThk2.setSelected(true);
                break;
            }
            case 3: {
                this.mnuPenThk3.setSelected(true);
                break;
            }
            case 4: {
                this.mnuPenThk4.setSelected(true);
                break;
            }
            case 5: {
                this.mnuPenThk5.setSelected(true);
                break;
            }
            default: {
                this.mnuPenThk1.setSelected(true);
            }
        }
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        this.mnuConfirmNewPage.setSelected(EmuUtil.getBooleanProperty(properties, this.getSettingsPrefix() + PROP_CONFIRM_NEWPAGE, true));
        return super.applySettings(properties, bl);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() == this) {
            this.refreshTimer.stop();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() == this) {
            this.refreshTimer.start();
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            String string;
            Object object = eventObject.getSource();
            if (object != null) {
                if (object == this.btnRotateLeft) {
                    bl = true;
                    this.doRotateLeft();
                } else if (object == this.btnRotateRight) {
                    bl = true;
                    this.doRotateRight();
                }
                if (object == this.mnuNewPage || object == this.btnNewPage) {
                    bl = true;
                    this.doNewPage();
                } else if (object == this.mnuPrint || object == this.btnPrint) {
                    bl = true;
                    if (this.getImage() != null) {
                        PrintUtil.doPrint(this, this.imgFld, "Plotter");
                    }
                } else if (object == this.mnuSaveAs || object == this.btnSaveAs) {
                    bl = true;
                    this.doSaveAs();
                } else if (object == this.mnuCopy) {
                    bl = true;
                    this.doCopy();
                } else if (object == this.mnuPenThk1 || object == this.mnuPenThk2 || object == this.mnuPenThk3 || object == this.mnuPenThk4 || object == this.mnuPenThk5) {
                    bl = true;
                    if (this.plotter != null) {
                        int n = 1;
                        if (this.mnuPenThk2.isSelected()) {
                            n = 2;
                        } else if (this.mnuPenThk3.isSelected()) {
                            n = 3;
                        } else if (this.mnuPenThk4.isSelected()) {
                            n = 4;
                        } else if (this.mnuPenThk5.isSelected()) {
                            n = 5;
                        }
                        this.plotter.setPenThickness(n);
                        Main.setProperty("jkcemu.plotter.pen.thickness", Integer.toString(n));
                    }
                } else if (object == this.mnuConfirmNewPage) {
                    bl = true;
                    Main.setProperty(this.getSettingsPrefix() + PROP_CONFIRM_NEWPAGE, Boolean.toString(this.mnuConfirmNewPage.isSelected()));
                }
            }
            if (!bl && eventObject instanceof ActionEvent && (string = ((ActionEvent)eventObject).getActionCommand()) != null) {
                if (string.equals(ACTION_CLOSE)) {
                    bl = true;
                    this.doClose();
                } else if (string.equals(ACTION_COLOR_PEN)) {
                    bl = true;
                    this.doColorPen();
                } else if (string.equals(ACTION_COLOR_PAPER)) {
                    bl = true;
                    this.doColorPaper();
                } else if (string.equals(ACTION_HELP)) {
                    bl = true;
                    HelpFrm.open(HELP_PAGE);
                }
            }
        }
        if (!bl) {
            bl = super.doAction(eventObject);
        }
        return bl;
    }

    @Override
    public BufferedImage getImage() {
        return this.plotter.getBufferedImage();
    }

    private PlotterFrm(Plotter plotter) {
        this.plotter = plotter;
        this.dirty = false;
        this.image = null;
        this.file = null;
        this.setTitle("JKCEMU Plotter");
        Main.updIcon(this);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        this.mnuNewPage = this.createJMenuItem("Neue Seite");
        jMenu.add(this.mnuNewPage);
        this.mnuPrint = this.createJMenuItem("Drucken...");
        jMenu.add(this.mnuPrint);
        jMenu.addSeparator();
        this.mnuSaveAs = this.createJMenuItem("Speichern unter...");
        jMenu.add(this.mnuSaveAs);
        jMenu.addSeparator();
        jMenu.add(this.createJMenuItem("Schlie\u00dfen", ACTION_CLOSE));
        JMenu jMenu2 = new JMenu("Bearbeiten");
        jMenu2.setMnemonic(66);
        jMenuBar.add(jMenu2);
        this.mnuCopy = this.createJMenuItem("Kopieren");
        jMenu2.add(this.mnuCopy);
        JMenu jMenu3 = new JMenu("Einstellungen");
        jMenu2.setMnemonic(69);
        jMenuBar.add(jMenu3);
        JMenu jMenu4 = new JMenu("Stiftbreite");
        jMenu3.add(jMenu4);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mnuPenThk1 = new JRadioButtonMenuItem("1 Pixel");
        this.mnuPenThk1.addActionListener(this);
        buttonGroup.add(this.mnuPenThk1);
        jMenu4.add(this.mnuPenThk1);
        this.mnuPenThk2 = new JRadioButtonMenuItem("2 Pixel");
        this.mnuPenThk2.addActionListener(this);
        buttonGroup.add(this.mnuPenThk2);
        jMenu4.add(this.mnuPenThk2);
        this.mnuPenThk3 = new JRadioButtonMenuItem("3 Pixel");
        this.mnuPenThk3.addActionListener(this);
        buttonGroup.add(this.mnuPenThk3);
        jMenu4.add(this.mnuPenThk3);
        this.mnuPenThk4 = new JRadioButtonMenuItem("4 Pixel");
        this.mnuPenThk4.addActionListener(this);
        buttonGroup.add(this.mnuPenThk4);
        jMenu4.add(this.mnuPenThk4);
        this.mnuPenThk5 = new JRadioButtonMenuItem("5 Pixel");
        this.mnuPenThk5.addActionListener(this);
        buttonGroup.add(this.mnuPenThk5);
        jMenu4.add(this.mnuPenThk5);
        jMenu3.add(this.createJMenuItem("Stiftfarbe...", ACTION_COLOR_PEN));
        jMenu3.add(this.createJMenuItem("Papierfarbe...", ACTION_COLOR_PAPER));
        jMenu3.addSeparator();
        this.mnuConfirmNewPage = new JCheckBoxMenuItem("Best\u00e4tigung f\u00fcr neue Seite", true);
        this.mnuConfirmNewPage.addActionListener(this);
        jMenu3.add(this.mnuConfirmNewPage);
        JMenu jMenu5 = new JMenu("?");
        jMenuBar.add(jMenu5);
        jMenu5.add(this.createJMenuItem("Hilfe...", ACTION_HELP));
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.add((Component)jPanel, "North");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOrientation(0);
        jToolBar.setRollover(true);
        jPanel.add(jToolBar);
        this.btnNewPage = this.createImageButton("/images/file/new.png", "Neue Seite");
        jToolBar.add(this.btnNewPage);
        jToolBar.addSeparator();
        this.btnSaveAs = this.createImageButton("/images/file/save_as.png", "Speichern unter");
        jToolBar.add(this.btnSaveAs);
        this.btnPrint = this.createImageButton("/images/file/print.png", "Drucken");
        jToolBar.add(this.btnPrint);
        jToolBar.addSeparator();
        this.btnRotateLeft = this.createImageButton("/images/edit/rotate_left.png", "Nach links drehen");
        jToolBar.add(this.btnRotateLeft);
        this.btnRotateRight = this.createImageButton("/images/edit/rotate_right.png", "Nach rechts drehen");
        jToolBar.add(this.btnRotateRight);
        jToolBar.addSeparator();
        jToolBar.add(this.createScaleComboBox(25, 25, 33, 50, 75, 100));
        this.doScaleView();
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setScreenCentered();
        }
        this.setResizable(true);
        if (this.plotter != null) {
            this.plotter.setPlotterFrm(this);
        } else {
            this.setPenThickness(3);
        }
        this.updActionBtns();
        this.refreshTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlotterFrm.this.repaintImage();
            }
        });
    }

    private void doColorPaper() {
        Color color;
        Plotter plotter = this.plotter;
        if (plotter != null && (color = JColorChooser.showDialog(this, "Auswahl Papierfarbe", this.plotter.getPaperColor())) != null) {
            try {
                plotter.setPaperColor(color);
            }
            catch (UserInputException userInputException) {
                BaseDlg.showInfoDlg(this, userInputException.getMessage());
            }
            Main.setProperty("jkcemu.plotter.paper.color", String.format("%08X", color.getRGB()));
        }
    }

    private void doColorPen() {
        Color color;
        Plotter plotter = this.plotter;
        if (plotter != null && (color = JColorChooser.showDialog(this, "Auswahl Stiftfarbe", this.plotter.getPenColor())) != null) {
            try {
                plotter.setPenColor(color);
            }
            catch (UserInputException userInputException) {
                BaseDlg.showInfoDlg(this, userInputException.getMessage());
            }
            Main.setProperty("jkcemu.plotter.pen.color", String.format("%08X", color.getRGB()));
        }
    }

    private void doNewPage() {
        Plotter plotter = this.plotter;
        if (plotter != null) {
            if (this.mnuConfirmNewPage.isSelected()) {
                if (BaseDlg.showYesNoDlg(this, "Neue Seite?")) {
                    plotter.newPage();
                }
            } else {
                plotter.newPage();
            }
        }
    }

    private void doSaveAs() {
        File file = this.saveAs(this.file);
        if (file != null) {
            this.file = file;
        }
    }

    private boolean isClean() {
        Plotter plotter = this.plotter;
        return plotter != null ? plotter.isClean() : true;
    }

    private void repaintImage() {
        this.dirty = false;
        this.updActionBtns();
        this.repaint();
    }

    private void updActionBtns() {
        boolean bl = false;
        Plotter plotter = this.plotter;
        if (plotter != null) {
            bl = !plotter.isClean();
        }
        this.mnuSaveAs.setEnabled(bl);
        this.mnuPrint.setEnabled(bl);
        this.mnuCopy.setEnabled(bl);
        this.btnSaveAs.setEnabled(bl);
        this.btnPrint.setEnabled(bl);
        this.btnRotateLeft.setEnabled(bl);
        this.btnRotateRight.setEnabled(bl);
    }
}

