/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import jkcemu.Main;
import jkcemu.base.BaseFrm;
import jkcemu.base.DirSelectDlg;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;
import jkcemu.base.HelpFrm;
import jkcemu.base.ScreenFrm;

public class USBInterfaceFrm
extends BaseFrm
implements DropTargetListener {
    private static final String ACTION_CLOSE = "close";
    private static final String ACTION_HELP = "help";
    private static final String HELP_PAGE = "/help/usb.htm";
    private static USBInterfaceFrm instance = null;
    private ScreenFrm screenFrm;
    private FileNameFld dirFld;
    private JButton btnDirSelect;
    private JButton btnDirRemove;
    private JCheckBox btnReadOnly;
    private JCheckBox btnForceLowerCase;
    private JCheckBox btnForceCurTimestamp;

    public static void close() {
        if (instance != null) {
            instance.doClose();
        }
    }

    public static void open(ScreenFrm screenFrm) {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new USBInterfaceFrm(screenFrm);
        }
        instance.toFront();
        instance.setVisible(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        File file = EmuUtil.fileDrop(this, dropTargetDropEvent);
        if (file != null) {
            this.setDirFile(file);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!EmuUtil.isFileDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        this.updFields();
        return super.applySettings(properties, bl);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            String string;
            Object object = eventObject.getSource();
            if (object == this.btnDirSelect) {
                bl = true;
                this.doDirSelect();
            } else if (object == this.btnDirRemove) {
                bl = true;
                this.setDirFile(null);
            } else if (object == this.btnReadOnly) {
                bl = true;
                this.setReadOnly(this.btnReadOnly.isSelected());
            } else if (object == this.btnForceLowerCase) {
                bl = true;
                this.setForceLowerCase(this.btnForceLowerCase.isSelected());
            } else if (object == this.btnForceCurTimestamp) {
                bl = true;
                this.setForceCurrentTimestamp(this.btnForceCurTimestamp.isSelected());
            }
            if (!bl && eventObject instanceof ActionEvent && (string = ((ActionEvent)eventObject).getActionCommand()) != null) {
                if (string.equals(ACTION_CLOSE)) {
                    bl = true;
                    this.doClose();
                } else if (string.equals(ACTION_HELP)) {
                    bl = true;
                    HelpFrm.open(HELP_PAGE);
                }
            }
        }
        return bl;
    }

    private USBInterfaceFrm(ScreenFrm screenFrm) {
        this.screenFrm = screenFrm;
        this.setTitle("JKCEMU USB-Anschluss");
        Main.updIcon(this);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenu.add(this.createJMenuItem("Schlie\u00dfen", ACTION_CLOSE));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("?");
        jMenu2.add(this.createJMenuItem("Hilfe...", ACTION_HELP));
        jMenuBar.add(jMenu2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("Verzeichnis des emulierten USB-Speichersticks:"), gridBagConstraints);
        this.dirFld = new FileNameFld();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)this.dirFld, gridBagConstraints);
        this.btnDirSelect = this.createImageButton("/images/file/open.png", "Verzeichnis ausw\u00e4hlen");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnDirSelect, gridBagConstraints);
        this.btnDirRemove = this.createImageButton("/images/file/delete.png", "Verzeichnis entfernen");
        ++gridBagConstraints.gridx;
        this.add((Component)this.btnDirRemove, gridBagConstraints);
        this.btnReadOnly = new JCheckBox("Schreibschutz (Nur-Lese-Modus)", true);
        this.btnReadOnly.addActionListener(this);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnReadOnly, gridBagConstraints);
        this.btnForceLowerCase = new JCheckBox("Dateinamen klein schreiben");
        this.btnForceLowerCase.setEnabled(false);
        this.btnForceLowerCase.addActionListener(this);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnForceLowerCase, gridBagConstraints);
        this.btnForceCurTimestamp = new JCheckBox("Immer aktueller Zeitstempel bei Schreibzugriffen");
        this.btnForceCurTimestamp.setEnabled(false);
        this.btnForceCurTimestamp.addActionListener(this);
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnForceCurTimestamp, gridBagConstraints);
        this.setLocationByPlatform(true);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
        }
        this.setResizable(true);
        new DropTarget(this.dirFld, this).setActive(true);
        this.updFields();
    }

    private void doDirSelect() {
        File file;
        File file2 = this.dirFld.getFile();
        if (file2 == null) {
            file2 = Main.getLastDirFile("usb");
        }
        if (file2 != null && !file2.isDirectory()) {
            file2 = file2.getParentFile();
        }
        if ((file = DirSelectDlg.selectDirectory(this, file2)) != null) {
            this.setDirFile(file);
        }
    }

    private void setDirFile(File file) {
        EmuSys emuSys = this.screenFrm.getEmuSys();
        if (emuSys != null) {
            if (file != null) {
                if (file.isDirectory()) {
                    this.dirFld.setFile(file);
                    emuSys.setUSBMemStickDirectory(file);
                    this.btnDirRemove.setEnabled(true);
                    Main.setProperty("jkcemu.usb.memstick.directory", file.getPath());
                    Main.setLastFile(file, "usb");
                    this.setReadOnly(this.btnReadOnly.isSelected());
                    this.setForceLowerCase(this.btnForceLowerCase.isSelected());
                }
            } else {
                this.dirFld.setFile(null);
                emuSys.setUSBMemStickDirectory(null);
                this.btnDirRemove.setEnabled(false);
                Main.setProperty("jkcemu.usb.memstick.directory", "");
                Main.setLastFile(file, "usb");
            }
        }
    }

    private void setForceCurrentTimestamp(boolean bl) {
        EmuSys emuSys = this.screenFrm.getEmuSys();
        if (emuSys != null) {
            emuSys.setUSBMemStickForceCurrentTimestamp(bl);
            Main.setProperty("jkcemu.usb.memstick.force_current_timestamp", Boolean.toString(bl));
        }
    }

    private void setForceLowerCase(boolean bl) {
        EmuSys emuSys = this.screenFrm.getEmuSys();
        if (emuSys != null) {
            emuSys.setUSBMemStickForceLowerCaseFileNames(bl);
            Main.setProperty("jkcemu.usb.memstick.force_lowercase_filenames", Boolean.toString(bl));
        }
    }

    private void setReadOnly(boolean bl) {
        EmuSys emuSys = this.screenFrm.getEmuSys();
        if (emuSys != null) {
            emuSys.setUSBMemStickReadOnly(bl);
            Main.setProperty("jkcemu.usb.memstick.readonly", Boolean.toString(bl));
        }
        this.btnForceCurTimestamp.setEnabled(!bl);
        this.btnForceLowerCase.setEnabled(!bl);
    }

    private void updFields() {
        File file = null;
        EmuSys emuSys = this.screenFrm.getEmuSys();
        if (emuSys != null) {
            boolean bl = emuSys.getUSBMemStickReadOnly();
            this.btnReadOnly.setSelected(bl);
            this.btnForceCurTimestamp.setSelected(emuSys.getUSBMemStickForceCurrentTimestamp());
            this.btnForceCurTimestamp.setEnabled(!bl);
            this.btnForceLowerCase.setSelected(emuSys.getUSBMemStickForceLowerCaseFileNames());
            this.btnForceLowerCase.setEnabled(!bl);
            file = emuSys.getUSBMemStickDirectory();
        }
        this.dirFld.setFile(file);
        this.btnDirRemove.setEnabled(file != null);
    }
}

