/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.etc;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Properties;
import jkcemu.Main;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileTimesView;
import jkcemu.base.FileTimesViewFactory;
import jkcemu.etc.ByteQueue;
import z80emu.Z80InterruptSource;
import z80emu.Z80PIO;
import z80emu.Z80PIOPortListener;

public class VDIP
implements Runnable,
Z80InterruptSource,
Z80PIOPortListener {
    public static final String PROP_USB_DIR = "jkcemu.usb.memstick.directory";
    public static final String PROP_USB_FORCE_CURRENT_TIMESTAMP = "jkcemu.usb.memstick.force_current_timestamp";
    public static final String PROP_USB_FORCE_LOWERCASE_FILENAMES = "jkcemu.usb.memstick.force_lowercase_filenames";
    public static final String PROP_USB_READONLY = "jkcemu.usb.memstick.readonly";
    private static final int DEFAULT_DATETIME_VALUE = 831782912;
    private FileTimesViewFactory fileTimesViewFactory;
    private String title;
    private int debugLevel;
    private int bitMode;
    private boolean rootDirChanged;
    private boolean binaryMode;
    private boolean extendedMode;
    private boolean forceCurTimestamp;
    private boolean forceLowerCase;
    private boolean readOnly;
    private boolean readState;
    private boolean resetState;
    private boolean writeState;
    private boolean writeEnabled;
    private volatile boolean fileWrite;
    private volatile File file;
    private volatile Long fileMillis;
    private volatile RandomAccessFile raf;
    private volatile ByteQueue ioOut;
    private volatile IOCmd ioCmd;
    private volatile File ioFile;
    private volatile Long ioFileMillis;
    private volatile String ioFileName;
    private volatile long ioCount;
    private volatile boolean ioTaskEnabled;
    private volatile Thread ioTaskThread;
    private Long freeDiskSpace;
    private volatile File curDir;
    private volatile File rootDir;
    private File newRootDir;
    private Object lockObj;
    private Calendar calendar;
    private byte[] cmdLineBytes;
    private int cmdLineLen;
    private int cmdArgPos;
    private ByteQueue resultQueue;
    private Z80PIO pio;

    public VDIP(FileTimesViewFactory fileTimesViewFactory, String string) {
        this.fileTimesViewFactory = fileTimesViewFactory;
        this.title = string;
        this.debugLevel = 0;
        this.binaryMode = true;
        this.extendedMode = true;
        this.forceCurTimestamp = true;
        this.forceLowerCase = false;
        this.readOnly = false;
        this.readState = false;
        this.resetState = false;
        this.writeState = false;
        this.writeEnabled = false;
        this.fileWrite = false;
        this.file = null;
        this.fileMillis = null;
        this.raf = null;
        this.freeDiskSpace = null;
        this.curDir = null;
        this.rootDir = null;
        this.rootDirChanged = false;
        this.lockObj = new Object();
        this.calendar = Calendar.getInstance();
        this.cmdLineBytes = new byte[256];
        this.cmdLineLen = 0;
        this.cmdArgPos = 0;
        this.resultQueue = new ByteQueue(1024);
        this.pio = new Z80PIO(string);
        this.ioOut = null;
        this.ioCmd = IOCmd.NONE;
        this.ioFile = null;
        this.ioFileMillis = null;
        this.ioFileName = null;
        this.ioCount = 0L;
        this.ioTaskEnabled = true;
        this.ioTaskThread = new Thread((Runnable)this, "JKCEMU VDIP");
        this.ioTaskThread.start();
        this.pio.addPIOPortListener((Z80PIOPortListener)this, Z80PIO.PortInfo.B);
        String string2 = System.getProperty("jkcemu.debug.usb");
        if (string2 != null) {
            try {
                this.debugLevel = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void applySettings(Properties properties) {
        String string = EmuUtil.getProperty(properties, PROP_USB_DIR);
        this.setMemStickDirectory(string.isEmpty() ? null : new File(string));
        this.setMemStickForceCurrentTimestamp(EmuUtil.getBooleanProperty(properties, PROP_USB_FORCE_CURRENT_TIMESTAMP, true));
        this.setMemStickForceLowerCaseFileNames(EmuUtil.getBooleanProperty(properties, PROP_USB_FORCE_LOWERCASE_FILENAMES, false));
        this.setMemStickReadOnly(EmuUtil.getBooleanProperty(properties, PROP_USB_READONLY, true));
    }

    public void die() {
        this.pio.removePIOPortListener((Z80PIOPortListener)this, Z80PIO.PortInfo.B);
        this.ioCmd = IOCmd.NONE;
        this.ioTaskEnabled = false;
        this.ioTaskThread.interrupt();
        this.fireRunIOTask();
        this.closeFile();
    }

    public File getMemStickDirectory() {
        return this.rootDir;
    }

    public boolean getMemStickForceCurrentTimestamp() {
        return this.forceCurTimestamp;
    }

    public boolean getMemStickForceLowerCaseFileNames() {
        return this.forceLowerCase;
    }

    public boolean getMemStickReadOnly() {
        return this.readOnly;
    }

    public int read(int n) {
        int n2 = -1;
        switch (n & 3) {
            case 0: {
                n2 = this.pio.readDataA();
                if (this.debugLevel <= 1) break;
                System.out.printf("VDIP: read PIO Port A: %02X\n", n2);
                break;
            }
            case 1: {
                n2 = this.pio.readDataB();
                if (this.debugLevel <= 3) break;
                System.out.printf("VDIP: read PIO Port B: %02X\n", n2);
                break;
            }
            case 2: {
                n2 = this.pio.readControlA();
                if (this.debugLevel <= 2) break;
                System.out.printf("VDIP: read PIO Ctrl A: %02X\n", n2);
                break;
            }
            case 3: {
                n2 = this.pio.readControlB();
                if (this.debugLevel <= 2) break;
                System.out.printf("VDIP: read PIO Ctrl B: %02X\n", n2);
            }
        }
        return n2;
    }

    public synchronized void setMemStickDirectory(File file) {
        if (file != null && !file.isDirectory()) {
            file = null;
        }
        this.newRootDir = file;
        this.rootDirChanged = true;
        this.fireRunIOTask();
    }

    public void setMemStickForceCurrentTimestamp(boolean bl) {
        this.forceCurTimestamp = bl;
    }

    public void setMemStickForceLowerCaseFileNames(boolean bl) {
        this.forceLowerCase = bl;
    }

    public void setMemStickReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void write(int var1_1, int var2_2) {
        switch (var1_1 & 3) {
            case 0: {
                if (this.debugLevel > 1) {
                    System.out.printf("VDIP: write PIO Port A: %02X\n", new Object[]{var2_2});
                }
                this.pio.writeDataA(var2_2);
                break;
            }
            case 1: {
                if (this.debugLevel > 2) {
                    System.out.printf("VDIP: write PIO Port B: %02X\n", new Object[]{var2_2});
                }
                this.pio.writeDataB(var2_2);
                var3_3 = this.pio.fetchOutValuePortB(false);
                var4_4 = (var3_3 & 4) == 0;
                var5_5 = (var3_3 & 8) != 0;
                v0 = var6_6 = (var3_3 & 64) == 0;
                if (var6_6 != this.resetState) {
                    this.readState = var4_4;
                    this.writeState = var5_5;
                    this.resetState = var6_6;
                    if (!var6_6) break;
                    if (this.debugLevel > 0) {
                        System.out.println("VDIP soft reset");
                    }
                    this.resetVDIP();
                    break;
                }
                if (var4_4 != this.readState) {
                    this.readState = var4_4;
                    if (var4_4) {
                        var7_7 = this.resultQueue;
                        synchronized (var7_7) {
                            var8_9 = this.resultQueue.poll();
                            this.pio.putInValuePortA(var8_9 >= 0 ? var8_9 : 0, false);
                        }
                    }
                    var7_7 = this.resultQueue;
                    synchronized (var7_7) {
                        if (this.resultQueue.isEmpty()) {
                            this.pio.putInValuePortB(1, 1);
                            this.setWriteEnabled(true);
                        } else {
                            this.pio.putInValuePortB(0, 1);
                            this.pio.strobePortB();
                        }
                    }
                }
                if (var5_5 == this.writeState) break;
                this.writeState = var5_5;
                if (!var5_5) ** GOTO lbl77
                if (!this.writeEnabled) break;
                this.setWriteEnabled(false);
                var7_8 = this.pio.fetchOutValuePortA(false);
                var8_10 = this.ioOut;
                if (var8_10 != null) {
                    var8_10.add((byte)var7_8);
                    break;
                }
                var9_12 = false;
                if (var7_8 != 13) ** GOTO lbl72
                try {
                    this.doCmdExecute();
                    this.cmdLineLen = 0;
                    var9_12 = true;
                }
                catch (IncompleteCmdException var10_14) {
                    if (this.debugLevel <= 0) ** GOTO lbl72
                    System.out.print("    Command line incomplete -> wait for more bytes");
                }
lbl72:
                // 4 sources

                if (var9_12) break;
                if (this.cmdLineLen < this.cmdLineBytes.length) {
                    this.cmdLineBytes[this.cmdLineLen++] = (byte)var7_8;
                }
                this.setWriteEnabled(true);
                break;
lbl77:
                // 1 sources

                this.pio.strobePortA();
                break;
            }
            case 2: {
                if (this.debugLevel > 2) {
                    System.out.printf("VDIP: write PIO Ctrl A: %02X\n", new Object[]{var2_2});
                }
                this.pio.writeControlA(var2_2);
                break;
            }
            case 3: {
                if (this.debugLevel > 2) {
                    System.out.printf("VDIP: write PIO Ctrl B: %02X\n", new Object[]{var2_2});
                }
                this.pio.writeControlB(var2_2);
            }
        }
    }

    @Override
    public void appendInterruptStatusHTMLTo(StringBuilder stringBuilder) {
        this.pio.appendInterruptStatusHTMLTo(stringBuilder);
    }

    @Override
    public synchronized int interruptAccept() {
        return this.pio.interruptAccept();
    }

    @Override
    public synchronized void interruptFinish() {
        if (this.pio.isInterruptAccepted()) {
            this.pio.interruptFinish();
        }
    }

    @Override
    public boolean isInterruptAccepted() {
        return this.pio.isInterruptAccepted();
    }

    @Override
    public boolean isInterruptRequested() {
        return this.pio.isInterruptRequested();
    }

    @Override
    public void reset(boolean bl) {
        if (this.debugLevel > 0) {
            System.out.printf("VDIP reset: power_on=%b\n", bl);
        }
        this.pio.reset(bl);
        this.readState = false;
        this.writeState = false;
        this.resetVDIP();
    }

    @Override
    public void z80PIOPortStatusChanged(Z80PIO z80PIO, Z80PIO.PortInfo portInfo, Z80PIO.Status status) {
        if (z80PIO == this.pio && portInfo == Z80PIO.PortInfo.B && status == Z80PIO.Status.INTERRUPT_ENABLED && !this.resultQueue.isEmpty()) {
            this.pio.strobePortB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.ioTaskEnabled) {
                Thread thread = this.ioTaskThread;
                synchronized (thread) {
                    try {
                        this.ioTaskThread.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {
                        // empty catch block
                    }
                }
                if (!this.ioTaskEnabled) continue;
                boolean bl = true;
                boolean bl2 = false;
                File file = null;
                Object object = this;
                synchronized (object) {
                    bl2 = this.rootDirChanged;
                    file = this.newRootDir;
                    this.rootDirChanged = false;
                    this.newRootDir = null;
                }
                if (bl2) {
                    object = this.lockObj;
                    synchronized (object) {
                        this.closeFile();
                        if (this.rootDir != null) {
                            this.putDiskRemoved();
                        }
                        this.freeDiskSpace = null;
                        this.rootDir = file;
                        this.curDir = file;
                        if (this.rootDir != null) {
                            this.putDiskDetected();
                        }
                    }
                }
                try {
                    switch (this.ioCmd) {
                        case NONE: {
                            bl = false;
                            break;
                        }
                        case CLOSE_FILE: {
                            this.execCloseFileIO();
                            break;
                        }
                        case DELETE_DIR: {
                            this.execDeleteDirIO();
                            break;
                        }
                        case DELETE_FILE: {
                            this.execDeleteFileIO();
                            break;
                        }
                        case DIR: {
                            this.execDirIO();
                            break;
                        }
                        case MAKE_DIR: {
                            this.execMakeDirIO();
                            break;
                        }
                        case OPEN_FILE_FOR_READ: {
                            this.execOpenFileForReadIO();
                            break;
                        }
                        case OPEN_FILE_FOR_WRITE: {
                            this.execOpenFileForWriteIO();
                            break;
                        }
                        case READ_FILE: {
                            this.execReadFileIO();
                            break;
                        }
                        case READ_FROM_FILE: {
                            this.execReadFromFileIO();
                            break;
                        }
                        case SECTOR_WRITE: {
                            this.execSectorWriteIO();
                            break;
                        }
                        case SEND_DATA_FAILED: {
                            this.execSendDataFailed();
                            break;
                        }
                        case SET_BAUD_RATE: {
                            Thread.sleep(50L);
                            break;
                        }
                        case WRITE_TO_FILE: {
                            this.execWriteToFileIO();
                            break;
                        }
                        default: {
                            this.throwCommandFailed();
                            break;
                        }
                    }
                }
                catch (VdipException vdipException) {
                    this.putError(vdipException.vdipErr);
                    bl = false;
                }
                this.doCmdFinish(bl);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.title;
    }

    private void checkDisk() throws VdipException {
        if (this.rootDir == null) {
            this.throwNoDisk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFile() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.raf != null) {
                EmuUtil.closeSilent(this.raf);
                this.updLastModified();
                this.fileWrite = false;
                this.file = null;
                this.fileMillis = null;
                this.raf = null;
            }
        }
    }

    private void closeReadOnlyFile() {
        if (!this.fileWrite) {
            this.closeFile();
        }
    }

    private void doCmdExecute() throws IncompleteCmdException {
        int n;
        if (this.debugLevel > 0) {
            System.out.print("  Command: ");
            int n2 = 0;
            if (this.extendedMode) {
                while (n2 < this.cmdLineLen && (n = this.cmdLineBytes[n2++] & 0xFF) != 32) {
                    if (n > 32 && n < 127) {
                        System.out.print((char)n);
                        continue;
                    }
                    System.out.printf("\\u%04X", n);
                }
            } else if (n2 < this.cmdLineLen) {
                System.out.printf("0x%02X", this.cmdLineBytes[n2++] & 0xFF);
            }
            if (this.binaryMode) {
                while (n2 < this.cmdLineLen) {
                    System.out.printf(" 0x%02X", this.cmdLineBytes[n2++] & 0xFF);
                }
            } else {
                while (n2 < this.cmdLineLen) {
                    System.out.print((char)(this.cmdLineBytes[n2++] & 0xFF));
                }
            }
            System.out.println();
        }
        String string = "";
        n = -1;
        int n3 = 0;
        this.cmdArgPos = -1;
        if (this.extendedMode) {
            int n4;
            StringBuilder stringBuilder = new StringBuilder();
            while (n3 < this.cmdLineLen && (n4 = this.cmdLineBytes[n3++] & 0xFF) != 32) {
                stringBuilder.append((char)n4);
            }
            string = stringBuilder.toString();
            if (n3 < this.cmdLineLen) {
                this.cmdArgPos = n3;
            }
        } else if (n3 < this.cmdLineLen) {
            n = this.cmdLineBytes[n3++] & 0xFF;
            if (n3 < this.cmdLineLen) {
                if (this.cmdLineBytes[n3] == 32 && n3 + 1 < this.cmdLineLen) {
                    this.cmdArgPos = n3 + 1;
                } else {
                    n = -1;
                }
            }
        }
        try {
            if (this.cmdLineLen == 0) {
                this.checkDisk();
                this.doCmdFinish(true);
            } else if (n == 1 || string.equals("DIR")) {
                this.execDir();
            } else if (n == 2 || string.equals("CD")) {
                this.execChangeDir();
            } else if (n == 3 || string.equals("SD")) {
                this.execSectorDump();
            } else if (n == 4 || string.equals("RD")) {
                this.execReadFile();
            } else if (n == 5 || string.equals("DLD")) {
                this.execDeleteDir();
            } else if (n == 6 || string.equals("MKD")) {
                this.execMakeDir();
            } else if (n == 7 || string.equals("DLF")) {
                this.execDeleteFile();
            } else if (n == 8 || string.equals("WRF")) {
                this.execWriteToFile();
            } else if (n == 9 || string.equals("OPW")) {
                this.execOpenFileForWrite();
            } else if (n == 10 || string.equals("CLF")) {
                this.execCloseFile();
            } else if (n == 11 || string.equals("RDF")) {
                this.execReadFromFile();
            } else if (n == 12 || string.equals("REN")) {
                this.execRename();
            } else if (n == 14 || string.equals("OPR")) {
                this.execOpenFileForRead();
            } else if (n == 15 || string.equals("IDD")) {
                this.execIdentifyDiskDrive(false);
            } else if (n == 18 || string.equals("FS")) {
                this.execFreeSpace(false);
            } else if (n == 19 || string.equals("FWV")) {
                this.putString("\rMAIN 03.69VDAPF\rRPRG 1.00R\r");
                this.doCmdFinish(true);
            } else if (n == 20 || string.equals("SBD")) {
                this.putPrompt();
                this.startIOTask(IOCmd.SET_BAUD_RATE);
            } else if (n == 21 || string.equals("SUD")) {
                this.execSuspendDisk();
            } else if (n == 22 || string.equals("WKD")) {
                this.doCmdFinish(true);
            } else if (n == 23 || string.equals("SUM")) {
                this.doCmdFinish(true);
            } else if (n == 24 || string.equals("FBD")) {
                this.doCmdFinish(true);
            } else if (n == 25 || string.equals("FMC")) {
                this.doCmdFinish(true);
            } else if (n == 26 || string.equals("FSD")) {
                this.doCmdFinish(true);
            } else if (n == 27 || string.equals("FFC")) {
                this.doCmdFinish(true);
            } else if (n == 28 || string.equals("FGM")) {
                this.execGetNullBytes(2);
            } else if (n == 34 || string.equals("FSL")) {
                this.doCmdFinish(true);
            } else if (n == 35 || string.equals("FSB")) {
                this.execSetBitMode();
            } else if (n == 36 || string.equals("FGB")) {
                this.execGetBitMode();
            } else if (n == 40 || string.equals("SEK")) {
                this.execSeek();
            } else if (n == 41 || string.equals("IOR")) {
                this.execGetNullBytes(1);
            } else if (n == 42 || string.equals("IOW")) {
                this.doCmdFinish(true);
            } else if (n == 43 || string.equals("QP1")) {
                this.execQueryPort(1);
            } else if (n == 44 || string.equals("QP2")) {
                this.execQueryPort(2);
            } else if (n == 45 || string.equals("DSN")) {
                this.execDiskSerialNumber();
            } else if (n == 46 || string.equals("DVL")) {
                this.execDiskVolumeLabel();
            } else if (n == 47 || string.equals("DIRT")) {
                this.execDirT();
            } else if (n == 129 || string.equals("PGS")) {
                this.execGetNullBytes(1);
            } else if (n == 130 || string.equals("PSR")) {
                this.doCmdFinish(true);
            } else if (n == 131 || string.equals("DSD")) {
                this.execDeviceSendData();
            } else if (n == 132 || string.equals("DRD")) {
                this.execDeviceReadData();
            } else if (n == 133 || string.equals("QD")) {
                this.execQueryDevice();
            } else if (n == 134 || string.equals("SC")) {
                this.execCheckDeviceNum();
            } else if (n == 135 || string.equals("SF")) {
                this.execCheckDeviceNum();
            } else if (n == 144 || string.equals("IPA")) {
                this.binaryMode = false;
                this.doCmdFinish(true);
            } else if (n == 145 || string.equals("IPH")) {
                this.binaryMode = true;
                this.doCmdFinish(true);
            } else if (n == 146 || string.equals("SW")) {
                this.startIOTask(IOCmd.SECTOR_WRITE);
            } else if (n == 147 || string.equals("FSE")) {
                this.execFreeSpace(true);
            } else if (n == 148 || string.equals("IDDE")) {
                this.execIdentifyDiskDrive(true);
            } else {
                if (n == 149 || string.equals("FWU")) {
                    throw new VdipException(VdipErr.NO_UPGRADE);
                }
                if (n == 154 || string.equals("SSU")) {
                    this.execDeviceSendSetupData();
                } else if (n == 69 || string.equals("E")) {
                    this.putString("E\r");
                    this.doCmdFinish(false);
                } else if (n == 101 || string.equals("e")) {
                    this.putString("e\r");
                    this.doCmdFinish(false);
                } else if (this.cmdLineLen == 1 && this.cmdLineBytes[0] == 16 || this.cmdLineLen > 1 && this.cmdLineBytes[0] == 16 && this.cmdLineBytes[1] == 32 || this.cmdLineLen == 3 && this.cmdLineBytes[0] == 83 && this.cmdLineBytes[1] == 67 && this.cmdLineBytes[2] == 83 || this.cmdLineLen > 3 && this.cmdLineBytes[0] == 83 && this.cmdLineBytes[1] == 67 && this.cmdLineBytes[2] == 83 && this.cmdLineBytes[2] == 32) {
                    this.extendedMode = false;
                    this.doCmdFinish(true);
                } else if (this.cmdLineLen == 1 && this.cmdLineBytes[0] == 17 || this.cmdLineLen > 1 && this.cmdLineBytes[0] == 17 && this.cmdLineBytes[1] == 32 || this.cmdLineLen == 3 && this.cmdLineBytes[0] == 69 && this.cmdLineBytes[1] == 67 && this.cmdLineBytes[2] == 83 || this.cmdLineLen > 3 && this.cmdLineBytes[0] == 69 && this.cmdLineBytes[1] == 67 && this.cmdLineBytes[2] == 83 && this.cmdLineBytes[2] == 32) {
                    this.extendedMode = true;
                    this.doCmdFinish(true);
                } else {
                    this.throwBadCommand();
                }
            }
        }
        catch (VdipException vdipException) {
            this.putError(vdipException.vdipErr);
            this.doCmdFinish(false);
        }
    }

    private void doCmdFinish(boolean bl) {
        if (bl) {
            this.putPrompt();
        }
        this.ioCmd = IOCmd.NONE;
        this.setWriteEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execChangeDir() throws VdipException {
        String string = null;
        if (this.cmdArgPos >= 0) {
            int n;
            while (this.cmdArgPos < this.cmdLineLen && this.cmdLineBytes[this.cmdArgPos] == 32) {
                ++this.cmdArgPos;
            }
            if (this.cmdArgPos + 1 == this.cmdLineLen && ((n = this.cmdLineBytes[this.cmdArgPos] & 0xFF) == 47 || n == 92)) {
                string = "\\";
            }
        }
        if (string == null) {
            string = this.nextArgFileName(true);
        }
        Object object = this.lockObj;
        synchronized (object) {
            File file = this.curDir;
            File file2 = this.rootDir;
            if (file == null || file2 == null) {
                this.throwNoDisk();
            }
            if (this.raf != null) {
                this.throwFileOpen();
            }
            boolean bl = false;
            if (string != null && string.equals("\\")) {
                this.curDir = file2;
                bl = true;
            }
            if (!bl) {
                File file3 = this.findFile(string);
                if (file3 == null) {
                    this.throwCommandFailed();
                }
                if (!file.isDirectory()) {
                    this.throwInvalid();
                }
                this.curDir = file3;
            }
        }
        this.doCmdFinish(true);
    }

    private void execCheckDeviceNum() throws IncompleteCmdException, VdipException {
        long l = this.nextArgByte();
        if (l < 0L || l > 15L) {
            this.throwCommandFailed();
        }
        this.doCmdFinish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execCloseFile() throws VdipException {
        Object object = this.lockObj;
        synchronized (object) {
            this.checkDisk();
            if (this.raf != null) {
                this.startIOTask(IOCmd.CLOSE_FILE);
            } else {
                this.doCmdFinish(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execCloseFileIO() throws VdipException {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.raf != null) {
                if (!this.readOnly && this.fileWrite) {
                    try {
                        long l;
                        long l2 = this.raf.length();
                        if (l2 > 0L && (l = this.raf.getFilePointer()) >= 0L && l < l2 && l != l2) {
                            this.raf.setLength(l);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    this.raf.close();
                    this.updLastModified();
                    this.raf = null;
                    this.file = null;
                    this.fileMillis = null;
                    this.fileWrite = false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execDeleteDir() throws VdipException {
        String string = this.nextArgFileName(false);
        Object object = this.lockObj;
        synchronized (object) {
            File file;
            this.checkDisk();
            if (this.raf != null) {
                this.throwFileOpen();
            }
            if ((file = this.findFile(string)) != null) {
                if (this.readOnly) {
                    this.throwCommandFailed();
                }
                if (file.isDirectory()) {
                    this.startIOTask(IOCmd.DELETE_DIR, file);
                } else {
                    this.throwInvalid();
                }
            } else {
                this.throwCommandFailed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execDeleteDirIO() throws VdipException {
        Object object = this.lockObj;
        synchronized (object) {
            String[] stringArray;
            this.closeReadOnlyFile();
            File file = this.ioFile;
            if (file == null) {
                this.throwCommandFailed();
            }
            if (this.readOnly || !file.isDirectory()) {
                this.throwCommandFailed();
            }
            if ((stringArray = file.list()) != null) {
                for (String string : stringArray) {
                    if (string == null || string.equals(".") || string.equals("..")) continue;
                    throw new VdipException(VdipErr.DIR_NOT_EMPTY);
                }
            }
            if (!file.delete()) {
                this.throwCommandFailed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execDeleteFile() throws VdipException {
        String string = this.nextArgFileName(false);
        Object object = this.lockObj;
        synchronized (object) {
            File file;
            this.checkDisk();
            if (this.raf != null) {
                this.throwFileOpen();
            }
            if ((file = this.findFile(string)) != null) {
                if (this.readOnly || !file.canWrite()) {
                    this.throwReadOnly();
                }
                if (file.isFile()) {
                    this.startIOTask(IOCmd.DELETE_FILE, file);
                } else {
                    this.throwInvalid();
                }
            } else {
                this.throwCommandFailed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execDeleteFileIO() throws VdipException {
        Object object = this.lockObj;
        synchronized (object) {
            this.closeReadOnlyFile();
            File file = this.ioFile;
            if (file == null) {
                this.throwCommandFailed();
            }
            if (!file.isFile()) {
                this.throwCommandFailed();
            }
            if (this.readOnly || !file.canWrite()) {
                this.throwReadOnly();
            }
            if (!file.delete()) {
                this.throwCommandFailed();
            }
        }
    }

    private void execDeviceReadData() throws VdipException {
        this.putNumber(0L, 1);
        this.putResultByte(13);
        this.throwCommandFailed();
    }

    private void execDeviceSendData() throws IncompleteCmdException, VdipException {
        long l = this.nextArgByte();
        if (l > 0L) {
            this.startIOTask(IOCmd.SEND_DATA_FAILED, l);
        } else {
            this.throwCommandFailed();
        }
    }

    private void execDeviceSendSetupData() throws IncompleteCmdException, VdipException {
        long l = this.nextArgQWord();
        long l2 = l << 8 & 0xFF00L | l >> 8 & 0xFFL;
        if (l2 > 0L) {
            this.startIOTask(IOCmd.SEND_DATA_FAILED, l2);
        } else {
            this.throwCommandFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execDir() throws VdipException {
        String string = null;
        if (this.cmdArgPos >= 2 && this.cmdArgPos < this.cmdLineLen && (string = this.nextArgFileName(true)) == null) {
            this.putResultByte(13);
            this.throwCommandFailed();
        }
        Object object = this.lockObj;
        synchronized (object) {
            this.checkDisk();
            File file = null;
            if (string != null && (file = this.findFile(string)) == null) {
                this.putResultByte(13);
                this.throwCommandFailed();
            }
            this.startIOTask(IOCmd.DIR, file, string, null, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execDirIO() throws VdipException {
        Object object = this.lockObj;
        synchronized (object) {
            this.putResultByte(13);
            this.closeReadOnlyFile();
            File file = this.ioFile;
            if (file != null) {
                if (this.ioFileName == null) {
                    this.ioFileName = file.getName();
                }
                this.putString(this.ioFileName);
                if (file.isFile()) {
                    long l = file.length();
                    if (l > 0xFFFFFFFFL) {
                        l = 0xFFFFFFFFL;
                    }
                    this.putResultByte(32);
                    this.putNumber(l, 4);
                }
                this.putResultByte(13);
            } else {
                File[] fileArray;
                File file2 = this.curDir;
                File file3 = this.rootDir;
                if (file3 == null || file2 == null) {
                    this.throwCommandFailed();
                }
                if ((fileArray = file2.listFiles()) != null) {
                    if (!file2.equals(file3)) {
                        this.putString(". DIR\r");
                        this.putString(".. DIR\r");
                    }
                    for (File file4 : fileArray) {
                        String string = file4.getName();
                        if (string == null || !VDIP.isValidFileName(string) || string.equals(".") || string.equals("..")) continue;
                        string = string.toUpperCase();
                        if (file4.isFile()) {
                            this.putString(string);
                            this.putResultByte(13);
                            continue;
                        }
                        if (!file4.isDirectory()) continue;
                        this.putString(string);
                        this.putString(" DIR\r");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execDirT() throws VdipException {
        String string = this.nextArgFileName(true);
        Object object = this.lockObj;
        synchronized (object) {
            this.putResultByte(13);
            this.checkDisk();
            File file = this.findFile(string);
            if (file == null) {
                this.throwCommandFailed();
            }
            long l = 831782912L;
            long l2 = 831782912L;
            long l3 = 831782912L;
            FileTimesView fileTimesView = this.fileTimesViewFactory.getFileTimesView(file);
            if (fileTimesView != null) {
                Long l4 = fileTimesView.getLastModifiedMillis();
                if (l4 != null) {
                    l2 = l3 = this.getDateTimeByMillis(l4);
                }
                if ((l4 = fileTimesView.getCreationMillis()) != null) {
                    l = this.getDateTimeByMillis(l4);
                }
                if ((l4 = fileTimesView.getLastAccessMillis()) != null) {
                    l2 = this.getDateTimeByMillis(l4);
                }
            }
            this.putString(string);
            this.putResultByte(32);
            this.putNumber(l, 4);
            this.putNumber(l2 >> 16, 2);
            this.putNumber(l3, 4);
            this.putResultByte(13);
        }
        this.doCmdFinish(true);
    }

    private void execDiskSerialNumber() throws VdipException {
        File file = this.rootDir;
        if (file == null) {
            this.throwNoDisk();
        }
        this.putNumber(file.hashCode(), 4);
        this.putResultByte(13);
        this.doCmdFinish(true);
    }

    private void execDiskVolumeLabel() throws VdipException {
        this.checkDisk();
        this.putString("NO NAME    \r");
        this.doCmdFinish(true);
    }

    private void execFreeSpace(boolean bl) throws VdipException {
        long l = 0L;
        boolean bl2 = false;
        File file = this.curDir;
        if (file == null) {
            file = this.rootDir;
        }
        if (file == null) {
            this.throwNoDisk();
        }
        while (file != null) {
            long l2 = file.getFreeSpace();
            long l3 = file.getUsableSpace();
            if (l2 >= 0L) {
                l = l3 >= 0L ? Math.min(l2, l3) : l2;
            } else if (l3 >= 0L) {
                l = l3;
            }
            if (l > 0L || file.getTotalSpace() > 0L) {
                bl2 = true;
                break;
            }
            file = file.getParentFile();
        }
        if (!bl2) {
            this.throwCommandFailed();
        }
        this.freeDiskSpace = l;
        if (bl) {
            if (l > 0xFFFFFFFFFFFFL) {
                l = 0xFFFFFFFFFFFFL;
            }
            this.putNumber(l, 6);
        } else {
            if (l > 0xFFFFFFFFL) {
                l = 0xFFFFFFFFL;
            }
            this.putNumber(l, 4);
        }
        this.putResultByte(13);
        this.doCmdFinish(true);
    }

    private void execGetBitMode() {
        this.putNumber(this.bitMode, 1);
        this.putResultByte(13);
        this.doCmdFinish(true);
    }

    private void execGetNullBytes(int n) {
        for (int i = 0; i < n; ++i) {
            this.putNumber(0L, 1);
        }
        this.putResultByte(13);
        this.doCmdFinish(true);
    }

    private void execIdentifyDiskDrive(boolean bl) throws VdipException {
        long l = 0L;
        File file = this.curDir;
        if (file == null) {
            file = this.rootDir;
        }
        if (file == null) {
            this.throwNoDisk();
        }
        while (file != null && (l = file.getTotalSpace()) <= 0L) {
            file = file.getParentFile();
        }
        this.putString("\rUSB VID = $05DC\rUSB PID = $A560\rVendor Id = JKCEMU  \rProduct Id = Virtual Disk    \rRevision Level = 1\rI/F = SCSI\rFAT32\rBytes/Sector = $0200\rBytes/Cluster = $001000\rCapacity = $");
        if (bl) {
            if (l > 0xFFFFFFFFFFFFL) {
                l = 0xFFFFFFFFFFFFL;
            }
            this.putString(String.format("%02X%02X", l >> 40 & 0xFFL, l >> 32 & 0xFFL));
        } else if (l > 0xFFFFFFFFL) {
            l = 0xFFFFFFFFL;
        }
        this.putString(String.format("%02X%02X%02X%02X", l >> 24 & 0xFFL, l >> 16 & 0xFFL, l >> 8 & 0xFFL, l & 0xFFL));
        this.putString(" Bytes\rFree Space = $");
        Long l2 = this.freeDiskSpace;
        if (l2 != null) {
            long l3 = l2;
            if (l3 < 0L) {
                l3 = 0L;
            }
            if (l3 > l) {
                l3 = l;
            }
            if (bl) {
                this.putString(String.format("%02X%02X", l3 >> 40 & 0xFFL, l3 >> 32 & 0xFFL));
            }
            this.putString(String.format("%02X%02X%02X%02X", l3 >> 24 & 0xFFL, l3 >> 16 & 0xFFL, l3 >> 8 & 0xFFL, l3 & 0xFFL));
        }
        this.putString(" Bytes\r\r");
        this.doCmdFinish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execMakeDir() throws IncompleteCmdException, VdipException {
        String string = this.nextArgFileName(false);
        Long l = this.nextOptArgDatetimeInMillis();
        Object object = this.lockObj;
        synchronized (object) {
            this.checkDisk();
            if (this.raf != null) {
                this.throwFileOpen();
            }
            File file = this.curDir;
            if (this.readOnly || file == null) {
                this.throwCommandFailed();
            }
            if (this.forceLowerCase) {
                string = string.toLowerCase();
            }
            this.startIOTask(IOCmd.MAKE_DIR, new File(file, string), null, l, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execMakeDirIO() throws VdipException {
        Object object = this.lockObj;
        synchronized (object) {
            this.closeReadOnlyFile();
            File file = this.ioFile;
            if (this.readOnly || file == null) {
                this.throwCommandFailed();
            }
            if (file.mkdir()) {
                Long l;
                if (!this.forceCurTimestamp && (l = this.ioFileMillis) != null) {
                    file.setLastModified(l);
                }
            } else {
                this.throwCommandFailed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execOpenFileForRead() throws IncompleteCmdException, VdipException {
        String string = this.nextArgFileName(false);
        if (this.cmdArgPos >= 2 && this.cmdArgPos < this.cmdLineLen) {
            try {
                long l = this.nextArgNumber(4);
            }
            catch (VdipException vdipException) {
                // empty catch block
            }
        }
        Object object = this.lockObj;
        synchronized (object) {
            File file;
            this.checkDisk();
            if (this.raf != null && this.fileWrite) {
                this.throwFileOpen();
            }
            if ((file = this.findFile(string)) != null) {
                if (file.isFile()) {
                    this.startIOTask(IOCmd.OPEN_FILE_FOR_READ, file, string, null, 0L);
                } else {
                    this.throwInvalid();
                }
            } else {
                this.throwCommandFailed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execOpenFileForReadIO() throws VdipException {
        Object object = this.lockObj;
        synchronized (object) {
            this.closeReadOnlyFile();
            File file = this.ioFile;
            if (file != null) {
                try {
                    this.raf = new RandomAccessFile(file, "r");
                    this.fileWrite = false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.raf == null) {
                this.throwCommandFailed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execOpenFileForWrite() throws IncompleteCmdException, VdipException {
        String string = this.nextArgFileName(false);
        Long l = this.nextOptArgDatetimeInMillis();
        Object object = this.lockObj;
        synchronized (object) {
            File file;
            this.checkDisk();
            if (this.raf != null && this.fileWrite) {
                this.throwFileOpen();
            }
            if ((file = this.curDir) != null) {
                File file2 = new File(file, string);
                if (!file2.exists() && this.forceLowerCase) {
                    file2 = new File(file, string.toLowerCase());
                }
                if (this.readOnly || file2.exists() && !file2.canWrite()) {
                    this.throwReadOnly();
                }
                this.startIOTask(IOCmd.OPEN_FILE_FOR_WRITE, file2, string, l, 0L);
            } else {
                this.throwNoDisk();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execOpenFileForWriteIO() throws VdipException {
        Object object = this.lockObj;
        synchronized (object) {
            this.closeReadOnlyFile();
            File file = this.ioFile;
            if (file != null) {
                if (this.readOnly || file.exists() && !file.canWrite()) {
                    this.throwReadOnly();
                }
                RandomAccessFile randomAccessFile = null;
                try {
                    randomAccessFile = new RandomAccessFile(file, "rw");
                    randomAccessFile.seek(randomAccessFile.length());
                    this.raf = randomAccessFile;
                    this.file = file;
                    this.fileMillis = this.ioFileMillis;
                    this.fileWrite = true;
                }
                catch (IOException iOException) {
                    EmuUtil.closeSilent(randomAccessFile);
                }
            }
            if (this.raf == null) {
                this.throwCommandFailed();
            }
        }
    }

    private void execQueryDevice() throws IncompleteCmdException, VdipException {
        long l = this.nextArgByte();
        if (l < 0L || l > 15L) {
            this.throwCommandFailed();
        }
        if (l == 0L && this.rootDir != null) {
            this.putNumber(1L, 1);
            this.putNumber(0L, 1);
            this.putNumber(0L, 1);
            this.putNumber(0L, 1);
            this.putNumber(0L, 1);
            this.putNumber(0L, 1);
            this.putNumber(0L, 1);
            this.putNumber(32L, 1);
            this.putNumber(0L, 1);
            this.putNumber(2L, 1);
            this.putNumber(0L, 1);
            this.putNumber(8L, 1);
            this.putNumber(6L, 1);
            this.putNumber(80L, 1);
            this.putNumber(2284L, 2);
            this.putNumber(8L, 2);
            this.putNumber(256L, 2);
            this.putNumber(1L, 1);
            for (int i = 0; i < 11; ++i) {
                this.putNumber(0L, 1);
            }
        } else {
            for (int i = 0; i < 32; ++i) {
                this.putNumber(0L, 1);
            }
        }
        this.putResultByte(13);
        this.doCmdFinish(true);
    }

    private void execQueryPort(int n) {
        this.putNumber(n == 2 && this.rootDir != null ? 32L : 0L, 1);
        this.putNumber(0L, 1);
        this.putResultByte(13);
        this.doCmdFinish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execReadFile() throws VdipException {
        String string = this.nextArgFileName(false);
        Object object = this.lockObj;
        synchronized (object) {
            File file;
            this.checkDisk();
            if (this.raf != null) {
                this.throwFileOpen();
            }
            if ((file = this.findFile(string)) != null) {
                if (file.isFile()) {
                    this.startIOTask(IOCmd.READ_FILE, file);
                } else {
                    this.throwInvalid();
                }
            } else {
                this.throwCommandFailed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execReadFileIO() throws VdipException {
        Object object = this.lockObj;
        synchronized (object) {
            this.closeReadOnlyFile();
            File file = this.ioFile;
            if (file == null) {
                this.throwCommandFailed();
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                int n = ((InputStream)fileInputStream).read();
                while (n >= 0) {
                    this.writeResultByte(n);
                    n = ((InputStream)fileInputStream).read();
                }
            }
            catch (Exception exception) {
                try {
                    this.throwCommandFailed();
                }
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(fileInputStream);
                    throw throwable;
                }
                EmuUtil.closeSilent(fileInputStream);
            }
            EmuUtil.closeSilent(fileInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execReadFromFile() throws IncompleteCmdException, VdipException {
        long l = this.nextArgDWord();
        Object object = this.lockObj;
        synchronized (object) {
            this.checkDisk();
            this.startIOTask(IOCmd.READ_FROM_FILE, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execReadFromFileIO() throws VdipException {
        boolean bl = false;
        Object object = this.lockObj;
        synchronized (object) {
            long l;
            try {
                for (l = this.ioCount; !bl && l > 0L; --l) {
                    int n = -1;
                    try {
                        n = this.raf.read();
                    }
                    catch (EOFException eOFException) {
                        n = -1;
                    }
                    if (n < 0) {
                        bl = true;
                        break;
                    }
                    this.writeResultByte(n);
                }
            }
            catch (Exception exception) {
                bl = true;
            }
            while (l > 0L) {
                this.putResultByte(0);
                --l;
            }
        }
        if (bl) {
            this.throwCommandFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execRename() throws VdipException {
        String string = this.nextArgFileName(false);
        String string2 = this.nextArgFileName(false);
        Object object = this.lockObj;
        synchronized (object) {
            this.checkDisk();
            if (this.raf != null && this.fileWrite) {
                this.throwFileOpen();
            }
            if (this.readOnly) {
                this.throwCommandFailed();
            }
            File file = this.curDir;
            File file2 = this.findFile(string);
            File file3 = this.findFile(string2);
            if (file == null || file2 == null || file3 != null) {
                this.throwCommandFailed();
            }
            if (this.forceLowerCase) {
                string2 = string2.toLowerCase();
            }
            if (!file2.renameTo(new File(file, string2))) {
                this.throwCommandFailed();
            }
        }
        this.doCmdFinish(true);
    }

    private void execSectorDump() {
        for (int i = 0; i < 512; ++i) {
            this.putResultByte(0);
        }
        this.doCmdFinish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execSectorWriteIO() {
        Object object = this.lockObj;
        synchronized (object) {
            try {
                int n;
                this.ioOut = new ByteQueue(n);
                this.setWriteEnabled(true);
                for (n = 512; n > 0; --n) {
                    this.ioOut.read();
                    this.setWriteEnabled(true);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.ioOut = null;
            }
        }
        this.doCmdFinish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execSeek() throws IncompleteCmdException, VdipException {
        long l = this.nextArgDWord();
        Object object = this.lockObj;
        synchronized (object) {
            this.checkDisk();
            if (this.raf == null) {
                this.throwInvalid();
            }
            try {
                if (l < 0L || l > this.raf.length()) {
                    this.throwCommandFailed();
                }
                this.raf.seek(l);
            }
            catch (Exception exception) {
                this.throwCommandFailed();
            }
        }
        this.doCmdFinish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execSendDataFailed() throws InterruptedException, VdipException {
        Object object = this.lockObj;
        synchronized (object) {
            try {
                long l;
                if (l > 0L) {
                    this.ioOut = new ByteQueue(1);
                    this.setWriteEnabled(true);
                    for (l = this.ioCount; l > 0L; --l) {
                        this.ioOut.read();
                        this.setWriteEnabled(true);
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.ioOut = null;
            }
        }
        this.throwCommandFailed();
    }

    private void execSetBitMode() throws IncompleteCmdException {
        try {
            this.bitMode = (int)this.nextArgNumber(2);
        }
        catch (VdipException vdipException) {
            // empty catch block
        }
        this.doCmdFinish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execSuspendDisk() throws VdipException {
        Object object = this.lockObj;
        synchronized (object) {
            this.checkDisk();
            if (this.raf != null) {
                this.throwFileOpen();
            }
        }
        this.doCmdFinish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execWriteToFile() throws IncompleteCmdException, VdipException {
        long l = this.nextArgDWord();
        boolean bl = false;
        Object object = this.lockObj;
        synchronized (object) {
            this.checkDisk();
            if (this.raf == null) {
                this.throwInvalid();
            }
            if (l > 0L) {
                this.startIOTask(IOCmd.WRITE_TO_FILE, l);
                bl = true;
            }
        }
        if (!bl) {
            this.doCmdFinish(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execWriteToFileIO() throws InterruptedException, VdipException {
        boolean bl = false;
        Object object = this.lockObj;
        synchronized (object) {
            block14: {
                try {
                    long l;
                    if (l <= 0L) break block14;
                    this.ioOut = new ByteQueue(1);
                    this.setWriteEnabled(true);
                    for (l = this.ioCount; l > 0L; --l) {
                        byte by = this.ioOut.read();
                        if (this.readOnly) {
                            bl = true;
                        }
                        if (!bl) {
                            try {
                                this.raf.write(by);
                                this.updLastModified();
                            }
                            catch (IOException iOException) {
                                bl = true;
                            }
                        }
                        this.setWriteEnabled(true);
                    }
                }
                catch (IOException iOException) {
                    bl = true;
                }
                finally {
                    this.ioOut = null;
                }
            }
        }
        if (bl) {
            throw new VdipException(VdipErr.DISK_FULL);
        }
    }

    private File findFile(String string) throws VdipException {
        File file;
        block6: {
            File file2;
            block7: {
                file = null;
                file2 = this.curDir;
                File file3 = this.rootDir;
                if (file2 == null || file3 == null) break block6;
                if (!string.equals(".") && !string.equals("..")) break block7;
                if (!file2.equals(file3)) {
                    if (string.equals(".")) {
                        file = file2;
                    }
                    if (string.equals("..")) {
                        file = file2.getParentFile();
                    }
                }
                if (file != null) break block6;
                this.throwBadCommand();
                break block6;
            }
            file = new File(file2, string);
            if (!file.exists()) {
                File[] fileArray;
                file = null;
                if (Main.isUnixLikeOS() && (fileArray = file2.listFiles()) != null) {
                    for (File file4 : fileArray) {
                        String string2 = file4.getName();
                        if (!string2.equalsIgnoreCase(string)) continue;
                        file = file4;
                        break;
                    }
                }
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRunIOTask() {
        Thread thread = this.ioTaskThread;
        synchronized (thread) {
            try {
                this.ioTaskThread.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getDateTimeByMillis(long l) {
        long l2 = 0L;
        Calendar calendar = this.calendar;
        synchronized (calendar) {
            this.calendar.clear();
            this.calendar.setTimeInMillis(l);
            int n = this.calendar.get(1) - 1980;
            if (n > 0) {
                l2 |= (long)(n << 25) & 0xFE000000L;
            }
            l2 |= (long)(this.calendar.get(2) + 1 << 21) & 0x1E00000L;
            l2 |= (long)(this.calendar.get(5) << 16) & 0x1F0000L;
            l2 |= (long)(this.calendar.get(11) << 11) & 0xF800L;
            l2 |= (long)(this.calendar.get(12) << 5) & 0x7E0L;
        }
        return l2 |= (long)(this.calendar.get(13) / 2) & 0x1FL;
    }

    private int getDebugLevel() {
        return this.debugLevel;
    }

    private static boolean isValidFileName(String string) {
        boolean bl = false;
        if (string != null) {
            boolean bl2 = false;
            int n = 0;
            int n2 = 0;
            int n3 = string.length();
            for (int i = 0; i < n3; ++i) {
                char c = string.charAt(i);
                if (c == '.') {
                    if (bl2) {
                        n = 0;
                        break;
                    }
                    bl2 = true;
                    continue;
                }
                if (VDIP.isValidFileNameChar(c)) {
                    if (bl2) {
                        ++n2;
                        continue;
                    }
                    ++n;
                    continue;
                }
                n = 0;
                break;
            }
            if (n >= 1 && n <= 8) {
                bl = bl2 ? n2 >= 1 && n2 <= 3 : n2 == 0;
            }
        }
        return bl;
    }

    private static boolean isValidFileNameChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "$%'-_@~`!(){}^#&".indexOf(c) >= 0;
    }

    private long nextArgByte() throws IncompleteCmdException, VdipException {
        return this.nextArgNumber(1);
    }

    private long nextArgDWord() throws IncompleteCmdException, VdipException {
        return this.nextArgNumber(4);
    }

    private long nextArgQWord() throws IncompleteCmdException, VdipException {
        return this.nextArgNumber(8);
    }

    private long nextArgNumber(int n) throws IncompleteCmdException, VdipException {
        if (this.cmdArgPos < 2) {
            this.throwBadCommand();
        }
        long l = 0L;
        if (this.binaryMode) {
            if (this.cmdArgPos + n - 1 >= this.cmdLineLen) {
                throw new IncompleteCmdException();
            }
            for (int i = 0; i < n; ++i) {
                l <<= 8;
                l |= (long)(this.cmdLineBytes[this.cmdArgPos++] & 0xFF);
            }
            if (this.cmdArgPos < this.cmdLineLen && this.cmdLineBytes[this.cmdArgPos] == 32) {
                ++this.cmdArgPos;
            }
        } else {
            if (this.cmdArgPos >= this.cmdLineLen) {
                this.throwBadCommand();
            }
            int n2 = this.cmdLineBytes[this.cmdArgPos++] & 0xFF;
            while (n2 == 32 && this.cmdArgPos < this.cmdLineLen) {
                n2 = this.cmdLineBytes[this.cmdArgPos++] & 0xFF;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (n2 == 36) {
                bl2 = true;
            } else if (n2 == 48) {
                int n3;
                if (this.cmdArgPos < this.cmdLineLen && ((n3 = this.cmdLineBytes[this.cmdArgPos] & 0xFF) == 120 || n3 == 88)) {
                    ++this.cmdArgPos;
                    bl2 = true;
                }
                if (!bl2) {
                    bl = true;
                }
            } else if (n2 >= 49 && n2 <= 57) {
                l = n2 - 48;
                bl = true;
            } else {
                this.throwBadCommand();
            }
            if (bl2) {
                while (this.cmdArgPos < this.cmdLineLen && (n2 = this.cmdLineBytes[this.cmdArgPos++] & 0xFF) != 32) {
                    if (n2 >= 48 && n2 <= 57) {
                        l <<= 4;
                        l |= (long)(n2 - 48);
                    } else if (n2 >= 65 && n2 <= 70) {
                        l <<= 4;
                        l |= (long)(n2 - 65 + 10);
                    } else if (n2 >= 97 && n2 <= 102) {
                        l <<= 4;
                        l |= (long)(n2 - 97 + 10);
                    } else {
                        this.throwBadCommand();
                    }
                    bl = true;
                }
            } else {
                while (this.cmdArgPos < this.cmdLineLen && (n2 = this.cmdLineBytes[this.cmdArgPos++] & 0xFF) != 32) {
                    if (n2 < 48 || n2 > 57) {
                        this.throwBadCommand();
                    }
                    l *= 10L;
                    l += (long)(n2 - 48);
                    bl = true;
                }
            }
            if (!bl) {
                this.throwBadCommand();
            }
        }
        return l;
    }

    private String nextArgFileName(boolean bl) throws VdipException {
        String string = null;
        if (this.cmdArgPos >= 2) {
            if (this.cmdArgPos < this.cmdLineLen && this.cmdLineBytes[this.cmdArgPos] == 32) {
                ++this.cmdArgPos;
            }
            if (this.cmdArgPos >= this.cmdLineLen) {
                this.throwBadCommand();
            }
            if (this.cmdLineBytes[this.cmdArgPos] == 32) {
                this.throwCommandFailed();
            }
            if (this.cmdArgPos + 1 == this.cmdLineLen && this.cmdLineBytes[this.cmdArgPos] == 46) {
                string = ".";
            } else if (this.cmdArgPos + 2 == this.cmdLineLen && this.cmdLineBytes[this.cmdArgPos] == 46 && this.cmdLineBytes[this.cmdArgPos + 1] == 46) {
                string = "..";
            }
            if (string != null) {
                if (!bl) {
                    this.throwBadCommand();
                }
            } else {
                int n;
                char[] cArray = new char[12];
                char[] cArray2 = new char[3];
                int n2 = 0;
                int n3 = 0;
                boolean bl2 = false;
                while (this.cmdArgPos < this.cmdLineLen && (n = (int)((char)(this.cmdLineBytes[this.cmdArgPos++] & 0xFF))) != 32) {
                    if (n == 46) {
                        if (bl2) {
                            this.throwFilenameInvalid();
                        }
                        bl2 = true;
                        continue;
                    }
                    n = Character.toUpperCase((char)n);
                    if (bl2) {
                        if (n3 >= cArray2.length) continue;
                        cArray2[n3++] = n;
                        continue;
                    }
                    if (n2 >= cArray.length) continue;
                    cArray[n2++] = n;
                }
                if (n3 == 0 && n2 > 8) {
                    for (n = 8; n < n2; ++n) {
                        if (n >= cArray.length || n3 >= cArray2.length) continue;
                        cArray2[n3++] = cArray[n];
                    }
                }
                if (n2 > 0) {
                    if (n2 > 8) {
                        n2 = 8;
                    }
                    for (n = 0; n < n2; ++n) {
                        if (VDIP.isValidFileNameChar(cArray[n])) continue;
                        this.throwFilenameInvalid();
                    }
                    if (n3 > 0) {
                        cArray[n2++] = 46;
                        for (n = 0; n < n3; ++n) {
                            if (n2 >= cArray.length) continue;
                            char c = cArray2[n];
                            if (VDIP.isValidFileNameChar(c)) {
                                cArray[n2++] = c;
                                continue;
                            }
                            this.throwFilenameInvalid();
                        }
                    }
                    string = new String(cArray, 0, n2);
                } else {
                    this.throwFilenameInvalid();
                }
            }
        } else {
            this.throwBadCommand();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long nextOptArgDatetimeInMillis() throws IncompleteCmdException {
        Long l = null;
        if (this.cmdArgPos >= 2 && this.cmdArgPos < this.cmdLineLen) {
            long l2 = 831782912L;
            try {
                long l3 = this.nextArgNumber(4);
                if ((l3 & 0xFF0000L) != 0L) {
                    l2 = l3;
                }
            }
            catch (VdipException vdipException) {
                // empty catch block
            }
            if (!this.forceCurTimestamp) {
                Calendar calendar = this.calendar;
                synchronized (calendar) {
                    this.calendar.clear();
                    this.calendar.set((int)(l2 >> 25 & 0x7FL) + 1980, (int)(l2 >> 21 & 0xFL) - 1, (int)(l2 >> 16) & 0x1F, (int)(l2 >> 11) & 0x1F, (int)(l2 >> 5) & 0x3F, (int)(l2 & 0x1FL) * 2);
                    l = this.calendar.getTimeInMillis();
                }
            }
        }
        return l;
    }

    private void putDiskDetected() {
        this.putResult("Disk Detected P2\r", "DD2");
        this.putResult("No Upgrade\r", "NU\r");
        this.putPrompt();
    }

    private void putDiskRemoved() {
        this.putResult("Disk Removed P2\r", "DR2");
        this.putResult("No Disk\r", "ND\r");
    }

    private void putError(VdipErr vdipErr) {
        String string = null;
        if (this.extendedMode) {
            string = "Command Failed\r";
            switch (vdipErr) {
                case BAD_COMMAND: {
                    string = "Bad Command\r";
                    break;
                }
                case DIR_NOT_EMPTY: {
                    string = "Dir Not Empty\r";
                    break;
                }
                case DISK_FULL: {
                    string = "Disk Full\r";
                    break;
                }
                case FILE_OPEN: {
                    string = "File Open\r";
                    break;
                }
                case FILENAME_INVALID: {
                    string = "Filename Invalid\r";
                    break;
                }
                case INVALID: {
                    string = "Invalid\r";
                    break;
                }
                case NO_DISK: {
                    string = "No Disk\r";
                    break;
                }
                case NO_UPGRADE: {
                    string = "No Upgrade\r";
                    break;
                }
                case READ_ONLY: {
                    string = "Read Only\r";
                }
            }
        } else {
            string = "CF\r";
            switch (vdipErr) {
                case BAD_COMMAND: {
                    string = "BC\r";
                    break;
                }
                case DIR_NOT_EMPTY: {
                    string = "NE";
                    break;
                }
                case DISK_FULL: {
                    string = "DF\r";
                    break;
                }
                case FILE_OPEN: {
                    string = "FO\r";
                    break;
                }
                case FILENAME_INVALID: {
                    string = "FN\r";
                    break;
                }
                case INVALID: {
                    string = "FI\r";
                    break;
                }
                case NO_DISK: {
                    string = "ND\r";
                    break;
                }
                case NO_UPGRADE: {
                    string = "NU\r";
                    break;
                }
                case READ_ONLY: {
                    string = "RO\r";
                }
            }
        }
        this.putString(string);
    }

    public void putNumber(long l, int n) {
        for (int i = 0; i < n; ++i) {
            if (this.binaryMode) {
                this.putResultByte((int)l);
            } else {
                this.putString(String.format("$%02X ", l & 0xFFL));
            }
            l >>= 8;
        }
    }

    private void putPrompt() {
        this.putResult("D:\\>\r", ">\r");
    }

    private void putResult(String string, String string2) {
        this.putString(this.extendedMode ? string : string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putResultByte(int n) {
        ByteQueue byteQueue = this.resultQueue;
        synchronized (byteQueue) {
            boolean bl = this.resultQueue.isEmpty();
            this.resultQueue.add((byte)n);
            if (bl) {
                this.pio.putInValuePortB(0, 1);
                this.pio.strobePortB();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putString(String string) {
        int n;
        if (string != null && (n = string.length()) > 0) {
            ByteQueue byteQueue = this.resultQueue;
            synchronized (byteQueue) {
                for (int i = 0; i < n; ++i) {
                    this.putResultByte(string.charAt(i));
                }
            }
        }
    }

    public void resetVDIP() {
        this.resultQueue.clear();
        this.cmdLineLen = 0;
        this.cmdArgPos = 0;
        this.bitMode = 0;
        this.binaryMode = true;
        this.extendedMode = true;
        this.writeEnabled = false;
        this.fileWrite = false;
        this.file = null;
        this.fileMillis = null;
        this.curDir = this.rootDir;
        this.ioOut = null;
        this.ioCmd = IOCmd.NONE;
        this.ioFile = null;
        this.ioFileMillis = null;
        this.ioFileName = null;
        this.ioCount = 0L;
        this.ioTaskThread.interrupt();
        this.fireRunIOTask();
        this.closeFile();
        this.pio.putInValuePortB(247, 255);
        this.putString("\rVer 03.69VDAPF On-Line:\r");
        if (this.rootDir != null) {
            this.putDiskDetected();
        }
        this.setWriteEnabled(true);
    }

    private void updLastModified() {
        if (this.fileWrite && !this.forceCurTimestamp) {
            File file = this.file;
            Long l = this.fileMillis;
            if (file != null && l != null) {
                file.setLastModified(l);
            }
        }
    }

    private void setWriteEnabled(boolean bl) {
        this.writeEnabled = bl;
        this.pio.putInValuePortB(bl ? 0 : 2, 2);
    }

    private void startIOTask(IOCmd iOCmd, File file, String string, Long l, long l2) {
        this.ioCmd = iOCmd;
        this.ioFile = file;
        this.ioFileName = string;
        this.ioFileMillis = l;
        this.ioCount = l2;
        this.fireRunIOTask();
    }

    private void startIOTask(IOCmd iOCmd, File file, String string, long l) {
        this.startIOTask(iOCmd, null, null, null, 0L);
    }

    private void startIOTask(IOCmd iOCmd) {
        this.startIOTask(iOCmd, null, null, null, 0L);
    }

    private void startIOTask(IOCmd iOCmd, File file) {
        this.startIOTask(iOCmd, file, null, null, 0L);
    }

    private void startIOTask(IOCmd iOCmd, long l) {
        this.startIOTask(iOCmd, null, null, null, l);
    }

    private void throwBadCommand() throws VdipException {
        throw new VdipException(VdipErr.BAD_COMMAND);
    }

    private void throwCommandFailed() throws VdipException {
        throw new VdipException(VdipErr.COMMAND_FAILED);
    }

    private void throwFileOpen() throws VdipException {
        throw new VdipException(VdipErr.FILE_OPEN);
    }

    private void throwFilenameInvalid() throws VdipException {
        throw new VdipException(VdipErr.FILENAME_INVALID);
    }

    private void throwInvalid() throws VdipException {
        throw new VdipException(VdipErr.INVALID);
    }

    private void throwNoDisk() throws VdipException {
        throw new VdipException(VdipErr.NO_DISK);
    }

    private void throwReadOnly() throws VdipException {
        throw new VdipException(VdipErr.READ_ONLY);
    }

    private void writeResultByte(int n) throws IOException {
        boolean bl = this.resultQueue.isEmpty();
        this.resultQueue.write((byte)n);
        if (bl) {
            this.pio.putInValuePortB(0, 1);
            this.pio.strobePortB();
        }
    }

    private static enum IOCmd {
        NONE,
        CLOSE_FILE,
        DELETE_DIR,
        DELETE_FILE,
        DIR,
        OPEN_FILE_FOR_READ,
        OPEN_FILE_FOR_WRITE,
        MAKE_DIR,
        READ_FILE,
        READ_FROM_FILE,
        SECTOR_WRITE,
        SEND_DATA_FAILED,
        SET_BAUD_RATE,
        WRITE_TO_FILE;

    }

    private class VdipException
    extends Exception {
        private VdipErr vdipErr;

        private VdipException(VdipErr vdipErr) {
            int n = VDIP.this.getDebugLevel();
            if (n > 0) {
                System.out.println((Object)vdipErr);
            }
            if (n > 1) {
                this.printStackTrace(System.out);
            }
            this.vdipErr = vdipErr;
        }
    }

    private class IncompleteCmdException
    extends Exception {
        private IncompleteCmdException() {
        }
    }

    public static enum VdipErr {
        BAD_COMMAND,
        COMMAND_FAILED,
        DIR_NOT_EMPTY,
        DISK_FULL,
        FILE_OPEN,
        FILENAME_INVALID,
        INVALID,
        NO_DISK,
        NO_UPGRADE,
        READ_ONLY;

    }
}

