/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jkcemu.Main;
import jkcemu.base.AbstractFileWorker;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileCopier;
import jkcemu.base.FileEntry;
import jkcemu.base.FileMover;
import jkcemu.base.FileTableModel;
import jkcemu.base.FileTreeNode;
import jkcemu.base.FileTreeNodeComparator;
import jkcemu.base.HelpFrm;
import jkcemu.base.ScreenFrm;
import jkcemu.filebrowser.ExtendedFileEntry;
import jkcemu.filebrowser.FileActionMngr;
import jkcemu.filebrowser.FileListSelection;
import jkcemu.filebrowser.FileNode;
import jkcemu.filebrowser.FilePreviewFld;
import jkcemu.filebrowser.FileTreeCellRenderer;
import jkcemu.filebrowser.FindFilesFrm;

public class FileBrowserFrm
extends BaseFrm
implements AbstractFileWorker.PathListener,
DragGestureListener,
DragSourceListener,
DropTargetListener,
FlavorListener,
FocusListener,
ListSelectionListener,
TreeSelectionListener,
TreeWillExpandListener {
    private static FileBrowserFrm instance = null;
    private static final String HELP_PAGE = "/help/tools/filebrowser.htm";
    private static final String PROP_SHOW_HIDDEN_FILES = "jkcemu.filebrowser.show_hidden_files";
    private static final String PROP_SORT_CASE_SENSITIVE = "jkcemu.filebrowser.sort_case_sensitive";
    private static final String PROP_PREVIEW_MAX_FILE_SIZE = "jkcemu.filebrowser.preview.max_file_size";
    private static final String PROP_SPLIT_POSITION = "jkcemu.filebrowser.split.position";
    private ScreenFrm screenFrm;
    private FileActionMngr fileActionMngr;
    private FileSystemView fsv;
    private JMenuItem mnuFileCreateDir;
    private JMenuItem mnuFileFind;
    private JMenuItem mnuFileRefresh;
    private JMenuItem mnuFileClose;
    private JMenuItem mnuEditCut;
    private JMenuItem mnuEditPaste;
    private JCheckBoxMenuItem mnuPhysFileSys;
    private JCheckBoxMenuItem mnuHiddenFiles;
    private JCheckBoxMenuItem mnuSortCaseSensitive;
    private JRadioButtonMenuItem mnuNoPreview;
    private JRadioButtonMenuItem mnuPreviewMaxFileSize100K;
    private JRadioButtonMenuItem mnuPreviewMaxFileSize1M;
    private JRadioButtonMenuItem mnuPreviewMaxFileSize10M;
    private JRadioButtonMenuItem mnuPreviewMaxFileSize100M;
    private JRadioButtonMenuItem mnuPreviewNoFileSizeLimit;
    private JMenuItem mnuHelpContent;
    private JPopupMenu mnuPopup;
    private JMenuItem mnuPopupCut;
    private JMenuItem mnuPopupPaste;
    private JMenuItem mnuPopupCreateDir;
    private JMenuItem mnuPopupFind;
    private JSplitPane splitPane;
    private JTable table;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private int[] treeDragSelectionRows;
    private FileNode rootNode;
    private FilePreviewFld filePreviewFld;
    private Component lastActiveFld;
    private Clipboard clipboard;
    private List<File> cutFiles;
    private boolean ignoreFlavorEvent;
    private boolean pasteState;

    public static void open(ScreenFrm screenFrm) {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new FileBrowserFrm(screenFrm);
        }
        instance.toFront();
        instance.setVisible(true);
    }

    public static void fireFileChanged(Object object) {
        if (object != null) {
            try {
                Frame[] frameArray;
                Path path = null;
                if (object instanceof Path) {
                    path = (Path)object;
                } else if (object instanceof File) {
                    path = ((File)object).toPath();
                }
                if (!(path == null || Files.exists(path, LinkOption.NOFOLLOW_LINKS) && Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS))) {
                    path = path.getParent();
                }
                if (path != null && (frameArray = Frame.getFrames()) != null) {
                    for (Frame frame : frameArray) {
                        if (!(frame instanceof FileBrowserFrm)) continue;
                        ((FileBrowserFrm)frame).fireRefreshNodeFor(path);
                    }
                }
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
    }

    public static void fireFilesChanged(Collection collection) {
        if (collection != null) {
            for (Object e : collection) {
                FileBrowserFrm.fireFileChanged(e);
            }
        }
    }

    @Override
    public void pathsPasted(Set<Path> set) {
        this.fireRefreshParentNodesFor(set);
    }

    @Override
    public void pathsRemoved(Set<Path> set) {
        this.fireRefreshParentNodesFor(set);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int n;
        List<FileActionMngr.FileObject> list = this.getSelectedFileObjects();
        if (list != null && (n = list.size()) > 0) {
            ArrayList<File> arrayList = new ArrayList<File>(n);
            for (FileActionMngr.FileObject fileObject : list) {
                File file = fileObject.getFile();
                if (file == null) continue;
                arrayList.add(file);
            }
            if (!arrayList.isEmpty()) {
                this.treeDragSelectionRows = this.tree.getSelectionRows();
                try {
                    dragGestureEvent.startDrag(null, new FileListSelection(arrayList), this);
                }
                catch (Exception exception) {
                    BaseDlg.showErrorDlg((Component)this, exception);
                }
            }
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        DragSourceContext dragSourceContext;
        this.treeDragSelectionRows = null;
        if ((dragSourceDropEvent.getDropAction() & 2) != 0 && (dragSourceContext = dragSourceDropEvent.getDragSourceContext()) != null) {
            try {
                Object object;
                Transferable transferable = dragSourceContext.getTransferable();
                if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (object = transferable.getTransferData(DataFlavor.javaFileListFlavor)) != null && object instanceof Collection) {
                    this.fireRefreshParentNodesFor((Collection)object);
                }
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        if (this.treeDragSelectionRows != null) {
            this.tree.setSelectionRows(this.treeDragSelectionRows);
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.dragInternal(dropTargetDragEvent, true);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.dragInternal(dropTargetDragEvent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        void var3_7;
        Path path = null;
        Object var3_3 = null;
        int n = dropTargetDropEvent.getDropAction();
        if ((n == 1 || n == 2) && (n & dropTargetDropEvent.getSourceActions()) != 0 && dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            void var3_5;
            FileNode fileNode = this.getSelectedFileNode();
            while (var3_5 != null) {
                Path path2;
                if (var3_5 instanceof FileTreeNode && (path2 = ((FileTreeNode)var3_5).getPath()) != null && Files.isDirectory(path2, LinkOption.NOFOLLOW_LINKS)) {
                    path = path2;
                    break;
                }
                TreeNode treeNode = var3_5.getParent();
            }
        }
        if (path != null && var3_7 != null) {
            boolean bl = false;
            try {
                Object object;
                dropTargetDropEvent.acceptDrop(3);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable == null || (object = transferable.getTransferData(DataFlavor.javaFileListFlavor)) == null || !(object instanceof Collection)) return;
                Collection collection = (Collection)object;
                boolean bl2 = true;
                File file = null;
                int n2 = 0;
                int n3 = 0;
                Object object2 = collection.iterator();
                while (object2.hasNext()) {
                    Object e = object2.next();
                    if (!(e instanceof File)) continue;
                    file = (File)e;
                    if (file.isDirectory()) {
                        ++n3;
                        continue;
                    }
                    ++n2;
                }
                if (n3 <= 0 && n2 <= 0) return;
                if (n == 2 && n3 + n2 == 1 && file != null) {
                    Object object3 = object2 = n3 > 0 ? file : file.getParentFile();
                    if (object2 != null) {
                        try {
                            if (EmuUtil.equals((File)object2, path.toFile())) {
                                File file2;
                                Object object4;
                                TreePath treePath;
                                boolean bl3 = true;
                                Point point = dropTargetDropEvent.getLocation();
                                if (point != null && (treePath = this.tree.getPathForLocation(point.x, point.y)) != null && (object4 = treePath.getLastPathComponent()) != null && object4 instanceof FileNode && (file2 = ((FileNode)object4).getFile()) != null && EmuUtil.equals(file, file2)) {
                                    bl3 = false;
                                }
                                if (bl3) {
                                    BaseDlg.showErrorDlg((Component)this, "Verschieben im selben Verzeichnis ist nicht m\u00f6glich.");
                                }
                                bl2 = false;
                            }
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                    }
                }
                if (bl2) {
                    object2 = new StringBuilder(512);
                    ((StringBuilder)object2).append("M\u00f6chten Sie");
                    if (file != null && n3 == 1 && n2 == 0) {
                        ((StringBuilder)object2).append(" das Verzeichnis ");
                        ((StringBuilder)object2).append(file.getPath());
                    } else if (file != null && n3 == 0 && n2 == 1) {
                        ((StringBuilder)object2).append(" die Datei ");
                        ((StringBuilder)object2).append(file.getPath());
                    } else {
                        if (n3 == 1) {
                            ((StringBuilder)object2).append(" ein Verzeichnis");
                        } else if (n3 > 1) {
                            ((StringBuilder)object2).append(String.format(" %d Verzeichnisse", n3));
                        }
                        if (n2 > 0) {
                            if (n3 > 0) {
                                ((StringBuilder)object2).append(" und");
                            }
                            if (n2 == 1) {
                                ((StringBuilder)object2).append(" eine Datei");
                            } else {
                                ((StringBuilder)object2).append(String.format(" %d Dateien", n2));
                            }
                        }
                    }
                    ((StringBuilder)object2).append("\nnach ");
                    ((StringBuilder)object2).append(path);
                    if (n == 2) {
                        ((StringBuilder)object2).append(" verschieben?");
                    } else {
                        ((StringBuilder)object2).append(" kopieren?");
                    }
                    bl2 = BaseDlg.showYesNoDlg(this, ((StringBuilder)object2).toString());
                }
                if (!bl2) return;
                if (n == 2) {
                    new FileMover(this, collection, path, this, this.fileActionMngr.getFileWorkers()).startWork();
                } else {
                    new FileCopier(this, collection, path, this, this.fileActionMngr.getFileWorkers()).startWork();
                }
                if (var3_7 instanceof FileNode) {
                    object2 = (FileNode)var3_7;
                    this.fireSelectNode((TreeNode)object2);
                }
                bl = true;
                return;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return;
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)this, iOException);
                return;
            }
            finally {
                dropTargetDropEvent.dropComplete(bl);
            }
        }
        dropTargetDropEvent.rejectDrop();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        if (flavorEvent.getSource() == this.clipboard) {
            if (this.ignoreFlavorEvent) {
                this.ignoreFlavorEvent = false;
            } else {
                this.cutFiles.clear();
                this.updPasteState();
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.lastActiveFld = focusEvent.getComponent();
            this.updActionButtons();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updActionButtons();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getSource() == this.tree) {
            TreePath[] treePathArray = this.tree.getSelectionPaths();
            if (treePathArray != null) {
                for (TreePath treePath : treePathArray) {
                    Object object = treePath.getLastPathComponent();
                    if (object == null || !(object instanceof FileNode)) continue;
                    this.refreshNode((FileNode)object);
                }
            }
            this.updActionButtons();
            this.updPreviewFld();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath != null) {
            this.setWaitCursor(true);
            Object object = treePath.getLastPathComponent();
            if (object != null && object instanceof FileNode) {
                FileNode fileNode = (FileNode)object;
                this.refreshNode(fileNode);
                int n = fileNode.getChildCount();
                for (int i = 0; i < n; ++i) {
                    TreeNode treeNode = fileNode.getChildAt(i);
                    if (treeNode == null || !(treeNode instanceof FileNode)) continue;
                    this.refreshNode((FileNode)treeNode);
                }
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public boolean applySettings(Properties properties, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl32 = super.applySettings(properties, bl);
        if (!this.isVisible()) {
            String string = null;
            if (properties != null) {
                string = properties.getProperty(PROP_PREVIEW_MAX_FILE_SIZE);
            }
            if (string != null) {
                if (string.equals("no_preview")) {
                    this.mnuNoPreview.setSelected(true);
                } else if (string.equals("100K")) {
                    this.mnuPreviewMaxFileSize100K.setSelected(true);
                } else if (string.equals("1M")) {
                    this.mnuPreviewMaxFileSize1M.setSelected(true);
                } else if (string.equals("10M")) {
                    this.mnuPreviewMaxFileSize10M.setSelected(true);
                } else if (string.equals("100M")) {
                    this.mnuPreviewMaxFileSize100M.setSelected(true);
                } else {
                    this.mnuPreviewNoFileSizeLimit.setSelected(true);
                }
            } else {
                this.mnuPreviewNoFileSizeLimit.setSelected(true);
            }
            int bl22 = EmuUtil.getIntProperty(properties, PROP_SPLIT_POSITION, -1);
            if (bl22 >= 0) {
                this.splitPane.setDividerLocation(bl22);
            } else {
                Component component = this.splitPane.getLeftComponent();
                if (component != null) {
                    int n;
                    int n2 = component.getWidth() / 2;
                    Dimension dimension = this.tree.getPreferredSize();
                    if (dimension != null && (n = dimension.width * 3 + 50) > n2) {
                        n2 = n;
                    }
                    this.splitPane.setDividerLocation(n2);
                }
            }
        }
        boolean bl4 = false;
        boolean bl5 = EmuUtil.getBooleanProperty(properties, PROP_SHOW_HIDDEN_FILES, false);
        if (bl5 != this.mnuHiddenFiles.isSelected()) {
            this.mnuHiddenFiles.setSelected(bl5);
            bl4 = true;
        }
        if ((bl3 = EmuUtil.getBooleanProperty(properties, PROP_SORT_CASE_SENSITIVE, File.separatorChar == '/')) != this.mnuSortCaseSensitive.isSelected()) {
            this.mnuSortCaseSensitive.setSelected(bl3);
            bl4 = true;
        }
        if (this.mnuPhysFileSys != null && (bl2 = EmuUtil.getBooleanProperty(properties, "jkcemu.show_phys_filesys", false)) != this.mnuPhysFileSys.isSelected()) {
            this.mnuPhysFileSys.setSelected(bl2);
            this.rootNode.setFileSystemView(bl2 ? this.fsv : null);
            bl4 = true;
        }
        if (bl4) {
            this.refreshNode(this.rootNode);
        }
        return bl32;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        try {
            Object object;
            if (eventObject != null && (object = eventObject.getSource()) != null) {
                String string;
                if (object == this.table || object == this.tree) {
                    bl = true;
                    this.doFileAction(object);
                } else if (object == this.mnuFileRefresh) {
                    bl = true;
                    this.doFileRefresh();
                } else if (object == this.mnuFileCreateDir || object == this.mnuPopupCreateDir) {
                    bl = true;
                    this.doFileCreateDir();
                } else if (object == this.mnuFileFind || object == this.mnuPopupFind) {
                    bl = true;
                    this.doFileFind();
                } else if (object == this.mnuFileClose) {
                    bl = true;
                    this.doClose();
                } else if (object == this.mnuEditCut || object == this.mnuPopupCut) {
                    bl = true;
                    this.doEditCut();
                } else if (object == this.mnuEditPaste || object == this.mnuPopupPaste) {
                    bl = true;
                    this.doEditPaste();
                } else if (object == this.mnuHiddenFiles) {
                    bl = true;
                    this.doSettingsHiddenFiles();
                } else if (object == this.mnuPhysFileSys) {
                    bl = true;
                    this.doSettingsPhysFileSys();
                } else if (object == this.mnuSortCaseSensitive) {
                    bl = true;
                    this.doSettingsSortCaseSensitive();
                } else if (object == this.mnuHelpContent) {
                    bl = true;
                    HelpFrm.open(HELP_PAGE);
                }
                if (!bl && eventObject instanceof ActionEvent && (string = ((ActionEvent)eventObject).getActionCommand()) != null) {
                    List<FileActionMngr.FileObject> list;
                    if (string.equals("copy") || string.equals("copy.path") || string.equals("copy.url")) {
                        this.cutFiles.clear();
                        this.ignoreFlavorEvent = false;
                        this.updPasteState();
                    }
                    if ((list = this.getSelectedFileObjects()) != null && !list.isEmpty()) {
                        switch (this.fileActionMngr.actionPerformed(string, list)) {
                            case DONE: {
                                bl = true;
                                break;
                            }
                            case FILES_CHANGED: 
                            case FILE_RENAMED: {
                                for (FileActionMngr.FileObject fileObject : list) {
                                    if (!(fileObject instanceof TreeNode)) continue;
                                    this.treeModel.nodeChanged((TreeNode)((Object)fileObject));
                                }
                                this.fireUpdPreviewFld();
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            BaseDlg.showErrorDlg((Component)this, iOException);
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = AbstractFileWorker.checkWindowClosing(this, this.fileActionMngr.getFileWorkers());
        if (bl) {
            bl = super.doClose();
        }
        if (bl) {
            Main.checkQuit(this);
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        if (this.mnuPopup != null) {
            SwingUtilities.updateComponentTreeUI(this.mnuPopup);
        }
    }

    @Override
    public void putSettingsTo(Properties properties) {
        if (properties != null) {
            super.putSettingsTo(properties);
            properties.setProperty(PROP_SHOW_HIDDEN_FILES, String.valueOf(this.mnuHiddenFiles.isSelected()));
            properties.setProperty(PROP_SORT_CASE_SENSITIVE, String.valueOf(this.mnuSortCaseSensitive.isSelected()));
            String string = "unlimited";
            if (this.mnuNoPreview.isSelected()) {
                string = "no_preview";
            } else if (this.mnuPreviewMaxFileSize100K.isSelected()) {
                string = "100K";
            } else if (this.mnuPreviewMaxFileSize1M.isSelected()) {
                string = "1M";
            } else if (this.mnuPreviewMaxFileSize10M.isSelected()) {
                string = "10M";
            } else if (this.mnuPreviewMaxFileSize100M.isSelected()) {
                string = "100M";
            }
            properties.setProperty(PROP_PREVIEW_MAX_FILE_SIZE, string);
            properties.setProperty(PROP_SPLIT_POSITION, String.valueOf(this.splitPane.getDividerLocation()));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.checkPopup(mouseEvent)) {
            mouseEvent.consume();
        } else {
            Component component;
            boolean bl = false;
            if (mouseEvent.getClickCount() > 1 && mouseEvent.getButton() == 1 && (component = mouseEvent.getComponent()) != null && (component == this.tree || component == this.table)) {
                try {
                    this.doFileAction(component);
                    bl = true;
                }
                catch (IOException iOException) {
                    BaseDlg.showErrorDlg((Component)this, iOException);
                }
                mouseEvent.consume();
            }
            if (!bl) {
                super.mouseClicked(mouseEvent);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.checkPopup(mouseEvent)) {
            mouseEvent.consume();
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.checkPopup(mouseEvent)) {
            mouseEvent.consume();
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    private void doEditCut() throws IOException {
        int n;
        this.cutFiles.clear();
        List<FileActionMngr.FileObject> list = this.getSelectedFileObjects();
        if (list != null && (n = list.size()) > 0) {
            for (FileActionMngr.FileObject fileObject : list) {
                File file = fileObject.getFile();
                if (file == null) continue;
                this.cutFiles.add(file);
            }
        }
        try {
            if (this.clipboard != null) {
                this.ignoreFlavorEvent = true;
                StringSelection stringSelection = new StringSelection("");
                this.clipboard.setContents(stringSelection, stringSelection);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.updPasteState();
    }

    private void doEditPaste() {
        block13: {
            Object object;
            Path path = null;
            FileNode fileNode = this.getSelectedFileNode();
            if (fileNode != null && (object = fileNode.getPath()) != null && Files.isDirectory((Path)object, LinkOption.NOFOLLOW_LINKS)) {
                path = object;
            }
            if (path != null) {
                try {
                    if (this.cutFiles.isEmpty()) {
                        if (this.clipboard != null && (object = this.clipboard.getData(DataFlavor.javaFileListFlavor)) != null) {
                            Collection<File> collection = null;
                            if (object instanceof File) {
                                collection = Collections.singletonList((File)object);
                            } else if (object instanceof Collection) {
                                collection = (Collection)object;
                            }
                            if (!collection.isEmpty()) {
                                new FileCopier(this, collection, path, this, this.fileActionMngr.getFileWorkers()).startWork();
                            }
                        }
                        break block13;
                    }
                    new FileMover(this, this.cutFiles, path, this, this.fileActionMngr.getFileWorkers()).startWork();
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    BaseDlg.showErrorDlg((Component)this, iOException);
                }
            } else {
                BaseDlg.showErrorDlg((Component)this, "Kein Verzeichnis ausgew\u00e4hlt, in das eingef\u00fcgt werden soll");
            }
        }
    }

    private void doFileAction(Object object) throws IOException {
        FileNode fileNode = this.getSelectedFileNode();
        if (fileNode != null) {
            if (object == this.table && !fileNode.isLeaf()) {
                TreeNode[] treeNodeArray = this.treeModel.getPathToRoot(fileNode);
                if (treeNodeArray != null) {
                    this.setWaitCursor(true);
                    this.refreshNode(fileNode);
                    this.fireSelectNode(fileNode);
                    this.setWaitCursor(false);
                }
            } else {
                this.fileActionMngr.doFileAction(fileNode);
            }
        }
    }

    private void doFileCreateDir() {
        FileNode fileNode = this.getSelectedFileNode();
        if (fileNode != null) {
            File file;
            TreeNode treeNode = fileNode;
            File file2 = fileNode.getFile();
            if (file2 != null && !file2.isDirectory()) {
                file2 = file2.getParentFile();
                treeNode = fileNode.getParent();
            }
            if (treeNode != null && file2 != null && (file = EmuUtil.createDir(this, file2)) != null) {
                block5: {
                    boolean bl = false;
                    try {
                        this.rootNode.refreshNodeFor(file2.toPath(), this.treeModel, this.mnuHiddenFiles.isSelected(), this.getFileTreeNodeComparator());
                    }
                    catch (InvalidPathException invalidPathException) {
                        if (!(treeNode instanceof FileNode)) break block5;
                        this.refreshNode((FileNode)treeNode);
                    }
                }
                this.fireSelectNode(treeNode, file);
                this.updActionButtons();
            }
        }
    }

    private void doFileRefresh() {
        FileNode fileNode = this.getSelectedFileNode();
        if (fileNode != null) {
            this.refreshNode(fileNode);
        } else {
            this.refreshNode(this.rootNode);
        }
        this.updActionButtons();
    }

    private void doFileFind() {
        Path path = null;
        FileNode fileNode = this.getSelectedFileNode();
        if (fileNode != null) {
            path = fileNode.getPath();
        }
        FindFilesFrm.open(this.screenFrm, path);
    }

    private void doSettingsHiddenFiles() {
        EmuUtil.setProperty(Main.getProperties(), PROP_SHOW_HIDDEN_FILES, this.mnuHiddenFiles.isSelected());
        this.refreshNode(this.rootNode);
    }

    private void doSettingsPhysFileSys() {
        if (this.mnuPhysFileSys != null) {
            boolean bl = this.mnuPhysFileSys.isSelected();
            EmuUtil.setProperty(Main.getProperties(), "jkcemu.show_phys_filesys", bl);
            this.rootNode.setFileSystemView(bl ? null : this.fsv);
            this.refreshNode(this.rootNode);
        }
    }

    private void doSettingsSortCaseSensitive() {
        EmuUtil.setProperty(Main.getProperties(), PROP_SORT_CASE_SENSITIVE, this.mnuSortCaseSensitive.isSelected());
        this.refreshNode(this.rootNode);
    }

    private FileBrowserFrm(ScreenFrm screenFrm) {
        Object object;
        this.screenFrm = screenFrm;
        this.fileActionMngr = new FileActionMngr(this, screenFrm, this);
        this.fsv = EmuUtil.getDifferentLogicalFileSystemView();
        this.ignoreFlavorEvent = false;
        this.pasteState = false;
        this.lastActiveFld = null;
        this.treeDragSelectionRows = null;
        this.clipboard = null;
        this.cutFiles = new ArrayList<File>();
        this.setTitle("JKCEMU Datei-Browser");
        Main.updIcon(this);
        this.mnuPopup = new JPopupMenu();
        JMenu jMenu = new JMenu("Bearbeiten");
        jMenu.setMnemonic(66);
        this.fileActionMngr.addCopyFileNameMenuItemsTo(this.mnuPopup, jMenu);
        jMenu.addSeparator();
        this.mnuPopup.addSeparator();
        this.mnuEditCut = this.createJMenuItem("Dateien/Verzeichnisse ausschneiden");
        jMenu.add(this.mnuEditCut);
        this.mnuPopupCut = this.createJMenuItem("Dateien/Verzeichnisse ausschneiden");
        this.mnuPopup.add(this.mnuPopupCut);
        this.fileActionMngr.addCopyFileMenuItemTo(this.mnuPopup, jMenu);
        this.mnuEditPaste = this.createJMenuItem("Dateien/Verzeichnisse einf\u00fcgen");
        jMenu.add(this.mnuEditPaste);
        this.mnuPopupPaste = this.createJMenuItem("Dateien/Verzeichnisse einf\u00fcgen");
        this.mnuPopup.add(this.mnuPopupPaste);
        this.mnuPopup.addSeparator();
        JMenu jMenu2 = new JMenu("Datei");
        jMenu2.setMnemonic(68);
        if (this.screenFrm != null) {
            this.fileActionMngr.addLoadIntoEmuMenuItemsTo(this.mnuPopup, jMenu2);
            jMenu2.addSeparator();
        }
        this.fileActionMngr.addFileMenuItemsTo(this.mnuPopup, jMenu2);
        this.mnuPopup.addSeparator();
        jMenu2.addSeparator();
        this.mnuFileCreateDir = this.createJMenuItem("Verzeichnis erstellen...");
        jMenu2.add(this.mnuFileCreateDir);
        this.mnuFileFind = this.createJMenuItem("Im Verzeichnis suchen...");
        jMenu2.add(this.mnuFileFind);
        this.mnuFileRefresh = this.createJMenuItem("Aktualisieren");
        jMenu2.add(this.mnuFileRefresh);
        jMenu2.addSeparator();
        this.mnuFileClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu2.add(this.mnuFileClose);
        this.mnuPopupCreateDir = this.createJMenuItem("Verzeichnis erstellen...");
        this.mnuPopup.add(this.mnuPopupCreateDir);
        this.mnuPopupFind = this.createJMenuItem("Im Verzeichnis suchen...");
        this.mnuPopup.add(this.mnuPopupFind);
        JMenu jMenu3 = new JMenu("Einstellungen");
        jMenu3.setMnemonic(69);
        this.mnuPhysFileSys = null;
        if (this.fsv != null) {
            this.mnuPhysFileSys = new JCheckBoxMenuItem("Physische Dateisystemstruktur anzeigen", Main.getBooleanProperty("jkcemu.show_phys_filesys", false));
            this.mnuPhysFileSys.addActionListener(this);
            jMenu3.add(this.mnuPhysFileSys);
        }
        this.mnuHiddenFiles = new JCheckBoxMenuItem("Versteckte Dateien anzeigen", Main.getBooleanProperty(PROP_SHOW_HIDDEN_FILES, false));
        this.mnuHiddenFiles.addActionListener(this);
        jMenu3.add(this.mnuHiddenFiles);
        this.mnuSortCaseSensitive = new JCheckBoxMenuItem("Gro\u00df-/Kleinschreibung bei Sortierung beachten", Main.getBooleanProperty(PROP_SORT_CASE_SENSITIVE, false));
        this.mnuSortCaseSensitive.addActionListener(this);
        jMenu3.add(this.mnuSortCaseSensitive);
        jMenu3.addSeparator();
        JMenu jMenu4 = new JMenu("Max. Dateigr\u00f6\u00dfe f\u00fcr Vorschau");
        jMenu3.add(jMenu4);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mnuNoPreview = new JRadioButtonMenuItem("Keine Vorschau");
        this.mnuNoPreview.addActionListener(this);
        buttonGroup.add(this.mnuNoPreview);
        jMenu4.add(this.mnuNoPreview);
        this.mnuPreviewMaxFileSize100K = new JRadioButtonMenuItem("100 KByte");
        this.mnuPreviewMaxFileSize100K.addActionListener(this);
        buttonGroup.add(this.mnuPreviewMaxFileSize100K);
        jMenu4.add(this.mnuPreviewMaxFileSize100K);
        this.mnuPreviewMaxFileSize1M = new JRadioButtonMenuItem("1 MByte");
        this.mnuPreviewMaxFileSize1M.addActionListener(this);
        buttonGroup.add(this.mnuPreviewMaxFileSize1M);
        jMenu4.add(this.mnuPreviewMaxFileSize1M);
        this.mnuPreviewMaxFileSize10M = new JRadioButtonMenuItem("10 MByte");
        this.mnuPreviewMaxFileSize10M.addActionListener(this);
        buttonGroup.add(this.mnuPreviewMaxFileSize10M);
        jMenu4.add(this.mnuPreviewMaxFileSize10M);
        this.mnuPreviewMaxFileSize100M = new JRadioButtonMenuItem("100 MByte");
        this.mnuPreviewMaxFileSize100M.addActionListener(this);
        buttonGroup.add(this.mnuPreviewMaxFileSize100M);
        jMenu4.add(this.mnuPreviewMaxFileSize100M);
        this.mnuPreviewNoFileSizeLimit = new JRadioButtonMenuItem("Unbegrenzt");
        this.mnuPreviewNoFileSizeLimit.addActionListener(this);
        buttonGroup.add(this.mnuPreviewNoFileSizeLimit);
        jMenu4.add(this.mnuPreviewNoFileSizeLimit);
        JMenu jMenu5 = new JMenu("?");
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu5.add(this.mnuHelpContent);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu5);
        this.setJMenuBar(jMenuBar);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOrientation(0);
        jToolBar.setRollover(true);
        this.add((Component)jToolBar, gridBagConstraints);
        if (this.screenFrm != null) {
            jToolBar.add(this.fileActionMngr.createLoadIntoEmuButton());
            jToolBar.add(this.fileActionMngr.createStartInEmuButton());
        }
        jToolBar.add(this.fileActionMngr.createEditTextButton());
        jToolBar.add(this.fileActionMngr.createViewImageButton());
        jToolBar.add(this.fileActionMngr.createPlayButton());
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(4);
        this.rootNode = new FileNode(null, null, null, true, null);
        if (this.mnuPhysFileSys != null) {
            this.rootNode.setFileSystemView(this.mnuPhysFileSys.isSelected() ? null : this.fsv);
        }
        this.rootNode.refresh(null, this.mnuHiddenFiles.isSelected(), this.getFileTreeNodeComparator());
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setSelectionModel(defaultTreeSelectionModel);
        this.tree.setEditable(false);
        this.tree.setExpandsSelectedPaths(false);
        this.tree.setRootVisible(false);
        this.tree.setScrollsOnExpand(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new FileTreeCellRenderer());
        this.tree.addFocusListener(this);
        this.tree.addKeyListener(this);
        this.tree.addMouseListener(this);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeWillExpandListener(this);
        this.filePreviewFld = new FilePreviewFld(this);
        this.filePreviewFld.setBorder(BorderFactory.createEtchedBorder());
        this.table = this.filePreviewFld.getJTable();
        if (this.table != null) {
            this.table.addFocusListener(this);
            this.table.addKeyListener(this);
            this.table.addMouseListener(this);
            object = this.table.getSelectionModel();
            if (object != null) {
                object.addListSelectionListener(this);
            }
        }
        this.splitPane = new JSplitPane(1, new JScrollPane(this.tree), this.filePreviewFld);
        this.splitPane.setContinuousLayout(false);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.splitPane, gridBagConstraints);
        this.clipboard = null;
        object = this.getToolkit();
        if (object != null) {
            this.clipboard = ((Toolkit)object).getSystemClipboard();
            if (this.clipboard != null) {
                this.clipboard.addFlavorListener(this);
            }
        }
        this.tree.setDragEnabled(false);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.tree, 3, this);
        if (this.table != null) {
            this.table.setDragEnabled(false);
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.table, 3, this);
        }
        new DropTarget(this.tree, this).setActive(true);
        if (this.table != null) {
            new DropTarget(this.table, this).setActive(true);
        }
        if (!this.applySettings(Main.getProperties(), true)) {
            this.setBoundsToDefaults();
        }
        this.setResizable(true);
        this.updPasteState();
        this.updActionButtons();
    }

    private boolean checkDropAction(DropTargetEvent dropTargetEvent) {
        int n = 0;
        int n2 = 0;
        if (dropTargetEvent instanceof DropTargetDragEvent) {
            n = ((DropTargetDragEvent)dropTargetEvent).getDropAction();
            n2 = ((DropTargetDragEvent)dropTargetEvent).getSourceActions();
        } else if (dropTargetEvent instanceof DropTargetDropEvent) {
            n = ((DropTargetDropEvent)dropTargetEvent).getDropAction();
            n2 = ((DropTargetDropEvent)dropTargetEvent).getSourceActions();
        }
        return (n & n2) != 0 && (n == 1 || n == 2);
    }

    private boolean checkPopup(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent != null && mouseEvent.isPopupTrigger()) {
            Component component = mouseEvent.getComponent();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (component != null) {
                int n3;
                boolean bl2 = false;
                if (component == this.table) {
                    int n4 = this.table.rowAtPoint(new Point(n, n2));
                    if (n4 >= 0) {
                        if (this.table.isRowSelected(n4)) {
                            bl2 = true;
                        } else {
                            this.table.setRowSelectionInterval(n4, n4);
                        }
                        this.lastActiveFld = this.table;
                        this.table.requestFocus();
                    }
                } else if (component == this.tree && (n3 = this.tree.getRowForLocation(n, n2)) >= 0) {
                    if (this.tree.isRowSelected(n3)) {
                        bl2 = true;
                    } else {
                        this.tree.setSelectionRow(n3);
                    }
                    this.lastActiveFld = this.tree;
                    this.tree.requestFocus();
                }
                if (bl2) {
                    this.updActionButtons();
                    this.mnuPopup.show(component, n, n2);
                }
                bl = true;
            }
        }
        return bl;
    }

    private void collapseNode(TreeNode treeNode) {
        if (treeNode != null) {
            try {
                Object[] objectArray = this.treeModel.getPathToRoot(treeNode);
                if (objectArray != null) {
                    this.tree.collapsePath(new TreePath(objectArray));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void dragInternal(DropTargetDragEvent dropTargetDragEvent, boolean bl) {
        DropTargetContext dropTargetContext;
        boolean bl2 = false;
        if (this.checkDropAction(dropTargetDragEvent) && (dropTargetContext = dropTargetDragEvent.getDropTargetContext()) != null) {
            Path path;
            Object object;
            Component component = dropTargetContext.getComponent();
            if (component == this.tree) {
                TreePath treePath;
                Point point;
                if (bl) {
                    this.tree.clearSelection();
                }
                if ((point = dropTargetDragEvent.getLocation()) != null && (treePath = this.tree.getPathForLocation(point.x, point.y)) != null) {
                    TreePath treePath2 = null;
                    while (treePath != null) {
                        Path path2;
                        Object object2 = treePath.getLastPathComponent();
                        if (object2 != null && object2 instanceof FileNode && (path2 = ((FileNode)object2).getPath()) != null && Files.isDirectory(path2, LinkOption.NOFOLLOW_LINKS)) {
                            treePath2 = treePath;
                            break;
                        }
                        treePath = treePath.getParentPath();
                    }
                    if (treePath2 != null) {
                        this.fireSelectPath(treePath2);
                        bl2 = true;
                    }
                }
            } else if (component == this.table && this.tree.getSelectionCount() == 1 && (object = this.tree.getLastSelectedPathComponent()) != null && object instanceof FileNode && (path = ((FileNode)object).getPath()) != null && Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                bl2 = true;
            }
        }
        if (bl2) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private void fireRefreshNodeFor(final Path path) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileBrowserFrm.this.refreshNodeFor(path);
            }
        });
    }

    private void fireRefreshParentNodesFor(Collection collection) {
        if (collection != null) {
            Set<Path> set = EmuUtil.createPathSet();
            for (Object object : collection) {
                if (object == null) continue;
                Path path = null;
                if (object instanceof File) {
                    File file = ((File)object).getParentFile();
                    if (file != null) {
                        try {
                            path = file.toPath();
                        }
                        catch (InvalidPathException invalidPathException) {}
                    }
                } else if (object instanceof Path) {
                    path = ((Path)object).getParent();
                }
                if (path == null) continue;
                set.add(path);
            }
            for (Path path : set) {
                this.fireRefreshNodeFor(path);
            }
        }
    }

    private void fireSelectNode(TreeNode treeNode) {
        Object[] objectArray;
        if (treeNode != null && (objectArray = this.treeModel.getPathToRoot(treeNode)) != null) {
            this.fireSelectPath(new TreePath(objectArray));
        }
    }

    private void fireSelectPath(final TreePath treePath) {
        if (treePath != null) {
            final JTree jTree = this.tree;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTree.setSelectionPath(treePath);
                }
            });
        }
    }

    private void fireUpdPreviewFld() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileBrowserFrm.this.updPreviewFld();
            }
        });
    }

    private FileTreeNodeComparator getFileTreeNodeComparator() {
        return this.mnuSortCaseSensitive.isSelected() ? FileTreeNodeComparator.getCaseSensitiveInstance() : FileTreeNodeComparator.getIgnoreCaseInstance();
    }

    private long getPreviewMaxFileSize() {
        long l = 0L;
        if (this.mnuNoPreview.isSelected()) {
            l = -1L;
        } else if (this.mnuPreviewMaxFileSize100K.isSelected()) {
            l = 102400L;
        } else if (this.mnuPreviewMaxFileSize1M.isSelected()) {
            l = 0x100000L;
        } else if (this.mnuPreviewMaxFileSize10M.isSelected()) {
            l = 0xA00000L;
        } else if (this.mnuPreviewMaxFileSize100M.isSelected()) {
            l = 0x6400000L;
        }
        return l;
    }

    private FileNode getSelectedFileNode() {
        FileNode fileNode = null;
        if (this.lastActiveFld != null) {
            Object object;
            if (this.lastActiveFld == this.table) {
                FileEntry fileEntry;
                int n;
                int n2;
                TableModel tableModel = this.table.getModel();
                if (tableModel != null && tableModel instanceof FileTableModel && this.table.getSelectedRowCount() == 1 && (n2 = this.table.getSelectedRow()) >= 0 && (n = this.table.convertRowIndexToModel(n2)) >= 0 && (fileEntry = ((FileTableModel)tableModel).getRow(n)) != null && fileEntry instanceof ExtendedFileEntry) {
                    fileNode = ((ExtendedFileEntry)fileEntry).getFileNode();
                }
            } else if (this.lastActiveFld == this.tree && this.tree.getSelectionCount() == 1 && (object = this.tree.getLastSelectedPathComponent()) != null && object instanceof FileNode) {
                fileNode = (FileNode)object;
            }
        }
        return fileNode;
    }

    private List<FileActionMngr.FileObject> getSelectedFileObjects() {
        List<FileActionMngr.FileObject> list = null;
        if (this.lastActiveFld != null) {
            list = this.lastActiveFld == this.table ? this.getSelectedTableFileObjects() : this.getSelectedTreeFileObjects();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private List<FileActionMngr.FileObject> getSelectedTreeFileObjects() {
        ArrayList<FileActionMngr.FileObject> arrayList = null;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            ArrayList<void> arrayList2 = new ArrayList<void>(treePathArray.length);
            for (TreePath treePath : treePathArray) {
                void object;
                Iterator iterator = arrayList2.iterator();
                if (treePath == null || iterator == null) continue;
                try {
                    while (iterator.hasNext()) {
                        TreePath treePath2 = (TreePath)iterator.next();
                        if (treePath2.equals(treePath) || treePath2.isDescendant(treePath)) {
                            Object var7_12 = null;
                            break;
                        }
                        if (!treePath.isDescendant(treePath2)) continue;
                        iterator.remove();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                if (object == null) continue;
                arrayList2.add(object);
            }
            int n = arrayList2.size();
            if (n > 0) {
                arrayList = new ArrayList<FileActionMngr.FileObject>(n);
                for (TreePath treePath : arrayList2) {
                    Object object = treePath.getLastPathComponent();
                    if (object == null || !(object instanceof FileActionMngr.FileObject)) continue;
                    arrayList.add((FileActionMngr.FileObject)object);
                }
            }
        }
        return arrayList;
    }

    private List<FileActionMngr.FileObject> getSelectedTableFileObjects() {
        int[] nArray;
        ArrayList<FileNode> arrayList = null;
        TableModel tableModel = this.table.getModel();
        if (tableModel != null && tableModel instanceof FileTableModel && (nArray = this.table.getSelectedRows()) != null && nArray.length > 0) {
            arrayList = new ArrayList<FileNode>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                FileNode fileNode;
                FileEntry fileEntry;
                int n = this.table.convertRowIndexToModel(nArray[i]);
                if (n < 0 || (fileEntry = ((FileTableModel)tableModel).getRow(n)) == null || !(fileEntry instanceof ExtendedFileEntry) || (fileNode = ((ExtendedFileEntry)fileEntry).getFileNode()) == null) continue;
                arrayList.add(fileNode);
            }
        }
        return arrayList;
    }

    private void refreshNode(FileNode fileNode) {
        if (fileNode != null) {
            fileNode.refresh(this.treeModel, this.mnuHiddenFiles.isSelected(), this.getFileTreeNodeComparator());
        }
    }

    private void refreshNodeFor(Path path) {
        Object object;
        List<FileNode> list;
        if (path != null && (list = this.rootNode.refreshNodeFor(path, this.treeModel, this.mnuHiddenFiles.isSelected(), this.getFileTreeNodeComparator())) != null && this.tree.getSelectionCount() == 1 && (object = this.tree.getLastSelectedPathComponent()) != null) {
            for (FileNode fileNode : list) {
                if (!object.equals(fileNode)) continue;
                this.setPreviewedFileNode(fileNode);
                break;
            }
        }
    }

    private void fireSelectNode(TreeNode treeNode, File file) {
        if (treeNode != null && file != null) {
            Object object;
            TreeNode[] treeNodeArray;
            TreeNode[] treeNodeArray2 = null;
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            if (enumeration != null) {
                try {
                    while (enumeration.hasMoreElements()) {
                        treeNodeArray = enumeration.nextElement();
                        if (treeNodeArray == null || !(treeNodeArray instanceof FileNode) || (object = ((FileNode)treeNodeArray).getFile()) == null || !((File)object).equals(file)) continue;
                        treeNodeArray2 = treeNodeArray;
                        break;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            if (treeNodeArray2 != null && (treeNodeArray = this.treeModel.getPathToRoot(treeNode)) != null) {
                object = new Object[treeNodeArray.length + 1];
                System.arraycopy(treeNodeArray, 0, object, 0, treeNodeArray.length);
                object[((Object)object).length - 1] = treeNodeArray2;
                this.fireSelectPath(new TreePath((Object[])object));
            }
        }
    }

    private void setPreviewedFileNode(FileNode fileNode) {
        this.filePreviewFld.setFileNode(fileNode, this.getPreviewMaxFileSize(), this.mnuSortCaseSensitive.isSelected());
    }

    private void updActionButtons() {
        this.updActionButtons(false);
    }

    private void updActionButtons(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        List<FileActionMngr.FileObject> list = this.getSelectedFileObjects();
        if (list != null) {
            Path path;
            int n = list.size();
            if (n > 0) {
                bl3 = true;
            }
            if (n == 1 && (path = list.get(0).getPath()) != null) {
                bl2 = Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS);
            }
        }
        this.mnuEditPaste.setEnabled(bl2 && this.pasteState);
        this.mnuPopupPaste.setEnabled(bl2 && this.pasteState);
        if (!bl) {
            this.mnuFileCreateDir.setEnabled(bl2);
            this.mnuPopupCreateDir.setEnabled(bl2);
            this.mnuFileFind.setEnabled(bl2);
            this.mnuPopupFind.setEnabled(bl2);
            this.mnuEditCut.setEnabled(bl3);
            this.mnuPopupCut.setEnabled(bl3);
            this.fileActionMngr.updActionButtonsEnabled(list);
        }
    }

    private void updPasteState() {
        boolean bl;
        boolean bl2 = bl = !this.cutFiles.isEmpty();
        if (!bl && this.clipboard != null) {
            try {
                bl = this.clipboard.isDataFlavorAvailable(DataFlavor.javaFileListFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.pasteState = bl;
        this.updActionButtons(true);
    }

    private void updPreviewFld() {
        Object object;
        FileNode fileNode = null;
        if (this.tree.getSelectionCount() == 1 && (object = this.tree.getLastSelectedPathComponent()) != null && object instanceof FileNode) {
            fileNode = (FileNode)object;
        }
        this.setPreviewedFileNode(fileNode);
    }
}

