/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import jkcemu.base.EmuUtil;

public class FileInfoFld
extends Component {
    private static final int LABEL_VALUE_DISTANCE = 10;
    private int minRows;
    private Integer rowHeight;
    private String[] labels;
    private String[] values;
    private String[] addonRows;
    private DateFormat dateFmt;

    FileInfoFld(int n) {
        this.minRows = n;
        this.rowHeight = null;
        this.labels = null;
        this.values = null;
        this.addonRows = null;
        this.dateFmt = DateFormat.getDateTimeInstance(2, 2);
    }

    public void setMinRows(int n) {
        this.minRows = n;
    }

    public void setValues(Map<Item, Object> map, String[] stringArray) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Object object = map.get((Object)Item.NAME);
        if (object != null && !(string = object.toString().trim()).isEmpty()) {
            String string2;
            double d;
            arrayList.add("Name:");
            arrayList2.add(object.toString());
            object = map.get((Object)Item.LINKED_TO);
            if (object != null) {
                arrayList.add("Symbolischer Link auf:");
                arrayList2.add(object.toString());
            }
            if ((object = map.get((Object)Item.TYPE)) != null) {
                arrayList.add("Typ:");
                arrayList2.add(object.toString());
            }
            if ((object = map.get((Object)Item.FORMAT)) != null) {
                arrayList.add("Format:");
                arrayList2.add(object.toString());
            }
            if ((object = map.get((Object)Item.DURATION)) != null && object instanceof Number && (d = ((Number)object).doubleValue()) > 0.0) {
                arrayList.add("L\u00e4nge:");
                int n = (int)Math.round(d);
                if (n >= 60) {
                    int n2 = n / 3600;
                    if (n2 > 0) {
                        arrayList2.add(String.format("%02d:%02d:%02d Stunden", n2, n / 60 % 60, n % 60));
                    } else {
                        arrayList2.add(String.format("%02d:%02d Minuten", n / 60, n % 60));
                    }
                } else {
                    arrayList2.add(EmuUtil.getDecimalFormatMax1().format(d) + " Sekunden");
                }
            }
            if ((object = map.get((Object)Item.COMMENT)) != null) {
                arrayList.add("Kommentar:");
                arrayList2.add(object.toString());
            }
            if ((object = map.get((Object)Item.SIZE)) != null && object instanceof Number) {
                arrayList.add("Gr\u00f6\u00dfe:");
                arrayList2.add(EmuUtil.formatSize(((Number)object).longValue(), false, true));
            }
            if ((string2 = this.getDateTimeText(map, Item.LAST_MODIFIED)) != null) {
                arrayList.add("Zuletzt ge\u00e4ndert:");
                arrayList2.add(string2);
            }
        }
        this.labels = arrayList.toArray(new String[arrayList.size()]);
        this.values = arrayList2.toArray(new String[arrayList2.size()]);
        this.addonRows = stringArray;
        this.invalidate();
        this.repaint();
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null) {
            font = new Font("SansSerif", 0, 12);
            this.setFont(font);
        }
        return font;
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 1;
        int n2 = Math.max(this.labels != null ? this.labels.length : 0, this.values != null ? this.values.length : 0);
        if (n2 > 0) {
            ++n2;
        }
        if (this.addonRows != null && this.addonRows.length > 0) {
            n2 += this.addonRows.length + 1;
        }
        if (n2 > 0) {
            n = this.getVerticalListWidth(this.labels) + 10 + this.getVerticalListWidth(this.values);
        }
        if (this.minRows > 0 && n2 < this.minRows) {
            n2 = this.minRows;
        }
        return new Dimension(n, n2 * this.getRowHeight());
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setFont(this.getFont());
        int n = this.drawVerticalList(graphics, this.labels, 0, 0);
        int n2 = this.getVerticalListWidth(this.labels) + 10;
        int n3 = this.drawVerticalList(graphics, this.values, n2, 0);
        if (n3 > n) {
            n = n3;
        }
        this.drawVerticalList(graphics, this.addonRows, 0, n + this.getRowHeight());
    }

    private int drawVerticalList(Graphics graphics, String[] stringArray, int n, int n2) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                n2 += this.getRowHeight();
                String string = stringArray[i];
                if (string == null) continue;
                graphics.drawString(string, n, n2);
            }
        }
        return n2;
    }

    private String getDateTimeText(Map<Item, Object> map, Item item) {
        String string = null;
        Object object = map.get((Object)item);
        if (object != null) {
            string = object instanceof Number ? this.dateFmt.format(new Date(((Number)object).longValue())) : (object instanceof Date ? this.dateFmt.format((Date)object) : object.toString());
        }
        return string;
    }

    private int getRowHeight() {
        if (this.rowHeight == null) {
            this.rowHeight = this.getFont().getSize() + 1;
        }
        return this.rowHeight;
    }

    private int getVerticalListWidth(String[] stringArray) {
        FontMetrics fontMetrics;
        int n = 0;
        if (stringArray != null && (fontMetrics = this.getFontMetrics(this.getFont())) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                String string = stringArray[i];
                if (string == null || (n2 = fontMetrics.stringWidth(string)) <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    public static boolean hasText(String string) {
        return string != null ? string.length() > 0 : false;
    }

    public static enum Item {
        NAME,
        LINKED_TO,
        TYPE,
        FORMAT,
        DURATION,
        COMMENT,
        SIZE,
        LAST_MODIFIED;

    }
}

