/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileListSelection
implements ClipboardOwner,
Transferable {
    private List<File> files;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileListSelection(Collection<File> collection) throws IOException {
        int n = collection.size();
        this.files = new ArrayList<File>(n > 0 ? n : 1);
        for (File file : collection) {
            boolean bl = false;
            try {
                if (file.toPath() == null) {
                    bl = true;
                }
                this.files.add(file);
            }
            catch (InvalidPathException invalidPathException) {
                bl = true;
                return bl;
            }
            finally {
                if (!bl) continue;
                throw new IOException("Kopieren/Verschieben von virtuellen Dateien bzw. Verzeichnisse nicht m\u00f6glich");
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this.files;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.javaFileListFlavor};
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(DataFlavor.javaFileListFlavor);
    }
}

