/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import jkcemu.Main;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuUtil;
import jkcemu.filebrowser.FileBrowserFrm;

public class GZipUnpacker
extends Thread {
    private BaseFrm owner;
    private File srcFile;
    private File outFile;

    public static void unpackFile(BaseFrm baseFrm, File file, File file2) {
        new GZipUnpacker(baseFrm, file, file2).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        BufferedOutputStream bufferedOutputStream;
        GZIPInputStream gZIPInputStream;
        FilterInputStream filterInputStream;
        String string;
        block10: {
            long l = this.srcFile.length();
            long l2 = this.srcFile.lastModified();
            string = null;
            filterInputStream = null;
            gZIPInputStream = null;
            bufferedOutputStream = null;
            try {
                filterInputStream = new BufferedInputStream(new FileInputStream(this.srcFile));
                if (l > 0L) {
                    ProgressMonitorInputStream progressMonitorInputStream = new ProgressMonitorInputStream(this.owner, "Entpacken von " + this.srcFile.getName() + "...", filterInputStream);
                    ProgressMonitor progressMonitor = progressMonitorInputStream.getProgressMonitor();
                    if (progressMonitor != null) {
                        progressMonitor.setMinimum(0);
                        progressMonitor.setMaximum((int)Math.min(l, Integer.MAX_VALUE));
                        progressMonitor.setMillisToDecideToPopup(500);
                        progressMonitor.setMillisToPopup(1000);
                    }
                    filterInputStream = progressMonitorInputStream;
                }
                gZIPInputStream = new GZIPInputStream(filterInputStream);
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.outFile));
                FileBrowserFrm.fireFileChanged(this.outFile.getParentFile());
                int n = gZIPInputStream.read();
                while (n != -1) {
                    ((OutputStream)bufferedOutputStream).write(n);
                    n = gZIPInputStream.read();
                }
                ((OutputStream)bufferedOutputStream).close();
                bufferedOutputStream = null;
                if (l2 == -1L) break block10;
                this.outFile.setLastModified(l2);
            }
            catch (InterruptedIOException interruptedIOException) {
                this.outFile.delete();
                EmuUtil.closeSilent(gZIPInputStream);
                EmuUtil.closeSilent(filterInputStream);
                EmuUtil.closeSilent(bufferedOutputStream);
            }
            catch (Exception exception) {
                this.outFile.delete();
                string = exception.getMessage();
                {
                    catch (Throwable throwable) {
                        EmuUtil.closeSilent(gZIPInputStream);
                        EmuUtil.closeSilent(filterInputStream);
                        EmuUtil.closeSilent(bufferedOutputStream);
                        throw throwable;
                    }
                }
                EmuUtil.closeSilent(gZIPInputStream);
                EmuUtil.closeSilent(filterInputStream);
                EmuUtil.closeSilent(bufferedOutputStream);
            }
        }
        EmuUtil.closeSilent(gZIPInputStream);
        EmuUtil.closeSilent(filterInputStream);
        EmuUtil.closeSilent(bufferedOutputStream);
        FileBrowserFrm.fireFileChanged(this.outFile.getParentFile());
        if (string != null) {
            this.owner.fireShowErrorMsg(string);
        }
    }

    private GZipUnpacker(BaseFrm baseFrm, File file, File file2) {
        super(Main.getThreadGroup(), "JKCEMU gzip unpacker");
        this.owner = baseFrm;
        this.srcFile = file;
        this.outFile = file2;
    }
}

