/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import jkcemu.base.AbstractThreadDlg;
import jkcemu.base.EmuUtil;
import jkcemu.filebrowser.FileBrowserFrm;
import jkcemu.filebrowser.TarEntry;

public class TarUnpacker
extends AbstractThreadDlg {
    private File srcFile;
    private File outDir;
    private boolean compression;
    private boolean posixEnabled;

    public static void unpackFile(Window window, File file, File file2, boolean bl) {
        TarUnpacker tarUnpacker = new TarUnpacker(window, file, file2, bl);
        if (bl) {
            tarUnpacker.setTitle("TGZ-Datei entpacken");
        } else {
            tarUnpacker.setTitle("TAR-Datei entpacken");
        }
        tarUnpacker.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProgress() {
        boolean bl = this.outDir.exists();
        this.outDir.mkdirs();
        InputStream inputStream = null;
        try {
            inputStream = this.openInputFile(this.srcFile, 1);
            if (this.compression) {
                inputStream = new GZIPInputStream(inputStream);
            }
            TarEntry tarEntry = TarEntry.readEntryHeader(inputStream);
            while (!this.cancelled && tarEntry != null) {
                block35: {
                    String string;
                    File file;
                    block34: {
                        String string2 = tarEntry.getName();
                        if (string2 == null) break block35;
                        this.appendToLog(string2 + "\n");
                        String string3 = tarEntry.getErrorMsg();
                        if (string3 != null) {
                            this.appendErrorToLog(string3);
                        }
                        file = null;
                        string = "  ignoriert";
                        try {
                            Object object;
                            int n = string2.length();
                            int n2 = 0;
                            while (n2 < n) {
                                object = null;
                                int n3 = string2.indexOf(47, n2);
                                if (n3 >= n2) {
                                    object = string2.substring(n2, n3);
                                    n2 = n3 + 1;
                                } else {
                                    object = string2.substring(n2);
                                    n2 = n;
                                }
                                if (object == null || ((String)object).isEmpty()) continue;
                                if (file != null) {
                                    file = new File(file, (String)object);
                                    continue;
                                }
                                file = new File(this.outDir, (String)object);
                            }
                            if (file == null) break block34;
                            if (tarEntry.isDirectory()) {
                                file.mkdirs();
                                if (!file.exists()) {
                                    throw new IOException("Verzeichnis kann nicht angelegt werden");
                                }
                                this.setAttributes(file, null, tarEntry);
                                string = null;
                                break block34;
                            }
                            if (tarEntry.isSymbolicLink()) {
                                object = tarEntry.getLinkTarget();
                                if (object == null) break block34;
                                File file2 = file.getParentFile();
                                if (file2 != null) {
                                    file2.mkdirs();
                                }
                                boolean bl2 = false;
                                Path path = file.toPath();
                                if (this.posixEnabled) {
                                    try {
                                        Files.createSymbolicLink(path, Paths.get((String)object, new String[0]), PosixFilePermissions.asFileAttribute(tarEntry.getPosixFilePermissions()));
                                        bl2 = true;
                                    }
                                    catch (UnsupportedOperationException unsupportedOperationException) {
                                        this.posixEnabled = false;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!bl2) {
                                    Files.createSymbolicLink(path, Paths.get((String)object, new String[0]), new FileAttribute[0]);
                                }
                                try {
                                    Files.setLastModifiedTime(path, FileTime.fromMillis(tarEntry.getTime()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                string = null;
                                break block34;
                            }
                            if (!tarEntry.isRegularFile()) break block34;
                            object = file.getParentFile();
                            if (object != null) {
                                ((File)object).mkdirs();
                            }
                            BufferedOutputStream bufferedOutputStream = null;
                            try {
                                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                                long l = tarEntry.getSize();
                                if (l > 0L) {
                                    n2 = 1;
                                    int n4 = inputStream.read();
                                    while (!this.cancelled && (long)n2 < l && n4 != -1) {
                                        ((OutputStream)bufferedOutputStream).write(n4);
                                        n4 = inputStream.read();
                                        ++n2;
                                    }
                                    if (n2 % 512 != 0) {
                                        inputStream.skip((n2 + 512 & 0xFFFFFE00) - n2);
                                    }
                                }
                                ((OutputStream)bufferedOutputStream).close();
                                bufferedOutputStream = null;
                            }
                            catch (Throwable throwable) {
                                EmuUtil.closeSilent(bufferedOutputStream);
                                throw throwable;
                            }
                            EmuUtil.closeSilent(bufferedOutputStream);
                            this.setAttributes(file, null, tarEntry);
                            string = null;
                        }
                        catch (Exception exception) {
                            string = "Fehler";
                            String string4 = exception.getMessage();
                            if (string4 != null && !(string4 = string4.trim()).isEmpty()) {
                                string = string4;
                            }
                            this.incErrorCount();
                        }
                    }
                    if (string != null) {
                        string = string + "\n";
                        this.appendToLog(string);
                        this.disableAutoClose();
                        if (file != null) {
                            file.delete();
                        }
                    }
                }
                tarEntry = TarEntry.readEntryHeader(inputStream);
            }
        }
        catch (Exception exception) {
            try {
                StringBuilder stringBuilder = new StringBuilder(128);
                stringBuilder.append("\nFehler beim Lesen der Datei ");
                stringBuilder.append(this.srcFile.getPath());
                String string = exception.getMessage();
                if (string != null && !string.isEmpty()) {
                    stringBuilder.append(": ");
                    stringBuilder.append(string);
                }
                stringBuilder.append('\n');
                this.appendErrorToLog(stringBuilder.toString());
                this.incErrorCount();
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(inputStream);
                throw throwable;
            }
            EmuUtil.closeSilent(inputStream);
        }
        EmuUtil.closeSilent(inputStream);
        FileBrowserFrm.fireFileChanged(bl ? this.outDir : this.outDir.getParentFile());
    }

    private TarUnpacker(Window window, File file, File file2, boolean bl) {
        super(window, "JKCEMU tar unpacker", true);
        this.srcFile = file;
        this.outDir = file2;
        this.compression = bl;
        this.posixEnabled = true;
    }

    private void setAttributes(File file, Path path, TarEntry tarEntry) {
        boolean bl = false;
        if (path == null) {
            try {
                path = file.toPath();
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        long l = tarEntry.getTime();
        try {
            if (path != null) {
                Files.setLastModifiedTime(path, FileTime.fromMillis(l));
            } else if (l >= 0L) {
                file.setLastModified(l);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Set<PosixFilePermission> set = tarEntry.getPosixFilePermissions();
        if (!this.posixEnabled) {
            try {
                Files.setPosixFilePermissions(file.toPath(), set);
                bl = true;
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                this.posixEnabled = false;
            }
        }
        if (!bl) {
            try {
                file.setExecutable(set.contains((Object)PosixFilePermission.OTHERS_EXECUTE) || set.contains((Object)PosixFilePermission.GROUP_EXECUTE), false);
                file.setExecutable(set.contains((Object)PosixFilePermission.OWNER_EXECUTE), true);
                file.setWritable(set.contains((Object)PosixFilePermission.OTHERS_WRITE) || set.contains((Object)PosixFilePermission.GROUP_WRITE), false);
                file.setWritable(set.contains((Object)PosixFilePermission.OWNER_WRITE), true);
                file.setReadable(set.contains((Object)PosixFilePermission.OTHERS_READ) || set.contains((Object)PosixFilePermission.GROUP_READ), false);
                file.setReadable(set.contains((Object)PosixFilePermission.OWNER_READ), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

