/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.filebrowser;

import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jkcemu.base.AbstractThreadDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileProgressInputStream;
import jkcemu.filebrowser.FileBrowserFrm;

public class ZipPacker
extends AbstractThreadDlg
implements FileVisitor<Path> {
    private Collection<Path> srcPaths;
    private Path curRootPath;
    private File outFile;
    private ZipOutputStream out;

    public static void packFiles(Window window, Collection<Path> collection, File file) {
        try {
            ZipPacker zipPacker = new ZipPacker(window, collection, file);
            zipPacker.setTitle("ZIP-Datei packen");
            zipPacker.setVisible(true);
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        String string;
        FileVisitResult fileVisitResult = FileVisitResult.SKIP_SUBTREE;
        if (this.out == null || this.cancelled) {
            fileVisitResult = FileVisitResult.TERMINATE;
        } else if (path != null && basicFileAttributes != null && basicFileAttributes.isDirectory() && !(string = this.getEntryDir(path)).isEmpty()) {
            this.appendToLog(path.toString() + "\n");
            try {
                ZipEntry zipEntry = new ZipEntry(string);
                zipEntry.setMethod(0);
                zipEntry.setCrc(0L);
                zipEntry.setCompressedSize(0L);
                zipEntry.setSize(0L);
                FileTime fileTime = basicFileAttributes.lastModifiedTime();
                if (fileTime != null) {
                    zipEntry.setTime(fileTime.toMillis());
                }
                this.out.putNextEntry(zipEntry);
                this.out.closeEntry();
                fileVisitResult = FileVisitResult.CONTINUE;
            }
            catch (IOException iOException) {
                this.appendErrorToLog(iOException);
            }
        }
        return fileVisitResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        FileVisitResult fileVisitResult;
        block12: {
            block13: {
                block14: {
                    String string;
                    block11: {
                        fileVisitResult = FileVisitResult.SKIP_SIBLINGS;
                        if (this.out != null && !this.cancelled) break block11;
                        fileVisitResult = FileVisitResult.TERMINATE;
                        break block12;
                    }
                    if (path == null || basicFileAttributes == null) break block12;
                    Path path2 = path.getFileName();
                    if (path2 == null || (string = path2.toString()) == null || string.isEmpty()) break block13;
                    this.appendToLog(path.toString() + "\n");
                    String string2 = this.getEntryDir(path.getParent());
                    if (!basicFileAttributes.isRegularFile()) break block14;
                    FileProgressInputStream fileProgressInputStream = null;
                    try {
                        fileProgressInputStream = this.openInputFile(path.toFile(), 2);
                        CRC32 cRC32 = new CRC32();
                        long l = 0L;
                        int n = fileProgressInputStream.read();
                        while (!this.cancelled && n != -1) {
                            ++l;
                            cRC32.update(n);
                            n = fileProgressInputStream.read();
                        }
                        fileProgressInputStream.seek(0L);
                        ZipEntry zipEntry = new ZipEntry(string2 + string);
                        zipEntry.setCrc(cRC32.getValue());
                        zipEntry.setMethod(8);
                        zipEntry.setSize(l);
                        FileTime fileTime = basicFileAttributes.lastModifiedTime();
                        if (fileTime != null) {
                            zipEntry.setTime(fileTime.toMillis());
                        }
                        this.out.putNextEntry(zipEntry);
                        n = fileProgressInputStream.read();
                        while (!this.cancelled && n != -1) {
                            this.out.write(n);
                            n = fileProgressInputStream.read();
                        }
                        this.out.closeEntry();
                    }
                    catch (IOException iOException) {
                        this.appendErrorToLog(iOException);
                        this.incErrorCount();
                        EmuUtil.closeSilent(fileProgressInputStream);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        this.appendIgnoredToLog();
                        {
                            catch (Throwable throwable) {
                                EmuUtil.closeSilent(fileProgressInputStream);
                                throw throwable;
                            }
                        }
                        EmuUtil.closeSilent(fileProgressInputStream);
                    }
                    EmuUtil.closeSilent(fileProgressInputStream);
                    break block13;
                }
                if (basicFileAttributes.isSymbolicLink()) {
                    this.appendToLog(" Symbolischer Link ignoriert\n");
                    this.disableAutoClose();
                } else {
                    this.appendIgnoredToLog();
                }
            }
            fileVisitResult = FileVisitResult.CONTINUE;
        }
        return fileVisitResult;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException iOException) {
        if (path != null) {
            this.appendToLog(path.toString());
            this.appendErrorToLog(iOException);
            this.incErrorCount();
        }
        return this.cancelled ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProgress() {
        boolean bl = false;
        Object var2_2 = null;
        try {
            this.out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.outFile)));
            FileBrowserFrm.fireFileChanged(this.outFile.getParentFile());
            for (Path path : this.srcPaths) {
                this.curRootPath = path.getParent();
                Files.walkFileTree(path, this);
            }
            this.out.finish();
            this.out.close();
            this.out = null;
            this.appendToLog("\nFertig\n");
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append("\nFehler beim Schreiben in Datei ");
            stringBuilder.append(this.outFile.getPath());
            String string = iOException.getMessage();
            if (string != null && !string.isEmpty()) {
                stringBuilder.append(":\n");
                stringBuilder.append(string);
            }
            stringBuilder.append('\n');
            this.appendToLog(stringBuilder.toString());
            this.incErrorCount();
            bl = true;
        }
        finally {
            EmuUtil.closeSilent(this.out);
        }
        if (this.cancelled || bl) {
            this.outFile.delete();
        }
        FileBrowserFrm.fireFileChanged(this.outFile.getParentFile());
    }

    private ZipPacker(Window window, Collection<Path> collection, File file) throws InvalidPathException {
        super(window, "JKCEMU zip packer", true);
        this.srcPaths = collection;
        this.outFile = file;
        this.out = null;
    }

    private String getEntryDir(Path path) {
        String string = "";
        if (this.curRootPath != null) {
            Path path2 = null;
            if (path != null) {
                try {
                    path2 = this.curRootPath.relativize(path);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (path2 == null) {
                path2 = this.curRootPath;
            }
            if (path2.getNameCount() > 0) {
                StringBuilder stringBuilder = new StringBuilder(256);
                for (Path path3 : path2) {
                    String string2 = path3.toString();
                    if (string2 == null || string2.isEmpty()) continue;
                    stringBuilder.append(string2);
                    stringBuilder.append("/");
                }
                string = stringBuilder.toString();
            }
        }
        return string;
    }
}

