/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.TreeSet;
import jkcemu.Main;
import jkcemu.base.CancelableProgressDlg;
import jkcemu.image.ImgEntry;
import jkcemu.image.ImgUtil;

public class BufferedImgBuilder
implements CancelableProgressDlg.Progressable,
Runnable {
    private Window owner;
    private Image srcImg;
    private BufferedImage retImg;
    private CancelableProgressDlg dlg;
    private Thread thread;
    private ImgEntry.Mode mode;
    private volatile int progressValue;
    private int wImg;
    private int hImg;

    public BufferedImgBuilder(Window window) {
        this.owner = window;
        this.srcImg = null;
        this.retImg = null;
        this.dlg = null;
        this.thread = null;
        this.mode = ImgEntry.Mode.UNSPECIFIED;
        this.progressValue = 0;
        this.wImg = 0;
        this.hImg = 0;
    }

    public BufferedImage buildFrom(Image image, String string) {
        this.srcImg = image;
        this.retImg = null;
        this.dlg = null;
        this.thread = null;
        this.mode = ImgEntry.Mode.UNSPECIFIED;
        this.progressValue = 0;
        this.wImg = 0;
        this.hImg = 0;
        if (this.srcImg != null) {
            if (this.srcImg instanceof BufferedImage) {
                this.retImg = (BufferedImage)image;
                this.mode = ImgEntry.probeMode(this.retImg);
            } else {
                ImgUtil.ensureImageLoaded(this.owner, this.srcImg);
                this.wImg = image.getWidth(this.owner);
                this.hImg = image.getHeight(this.owner);
                this.dlg = new CancelableProgressDlg(this.owner, string, this);
                this.thread = new Thread(Main.getThreadGroup(), this, "JKCEMU image builder");
                this.thread.start();
                this.dlg.setVisible(true);
                if (this.dlg.wasCancelled()) {
                    this.retImg = null;
                }
            }
        }
        return this.retImg;
    }

    public ImgEntry.Mode getMode() {
        return this.mode;
    }

    @Override
    public int getProgressMax() {
        return this.wImg * this.hImg;
    }

    @Override
    public int getProgressValue() {
        return this.progressValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedImage bufferedImage = null;
        try {
            if (this.wImg > 0 && this.hImg > 0) {
                int n;
                BufferedImage bufferedImage2 = new BufferedImage(this.wImg, this.hImg, 2);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.drawImage(this.srcImg, 0, 0, this.owner);
                graphics2D.dispose();
                boolean bl = true;
                boolean bl2 = true;
                boolean bl3 = false;
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                block3: for (n = 0; n < this.hImg; ++n) {
                    for (int i = 0; i < this.wImg; ++i) {
                        int n2 = bufferedImage2.getRGB(i, n);
                        if ((n2 >> 24 & 0xFF) < 255) {
                            bl3 = true;
                        }
                        treeSet.add(n2);
                        int n3 = n2 & 0xFF;
                        if (n3 != (n2 >> 16 & 0xFF) || n3 != (n2 >> 8 & 0xFF)) {
                            bl = false;
                            bl2 = false;
                        }
                        if (n3 != 0 && n3 != 255) {
                            bl2 = false;
                        }
                        ++this.progressValue;
                        if (this.dlg.wasCancelled()) continue block3;
                    }
                }
                n = treeSet.size();
                if (n > 0 && n <= 256) {
                    byte[] byArray = new byte[n];
                    byte[] byArray2 = new byte[n];
                    byte[] byArray3 = new byte[n];
                    byte[] byArray4 = bl3 ? new byte[n] : null;
                    int n4 = 0;
                    Iterator iterator = treeSet.iterator();
                    while (iterator.hasNext()) {
                        int n5 = (Integer)iterator.next();
                        if (n4 >= n) break;
                        if (byArray4 != null) {
                            byArray4[n4] = (byte)(n5 >> 24 & 0xFF);
                        }
                        byArray[n4] = (byte)(n5 >> 16 & 0xFF);
                        byArray2[n4] = (byte)(n5 >> 8 & 0xFF);
                        byArray3[n4] = (byte)(n5 & 0xFF);
                        ++n4;
                    }
                    bufferedImage = ImgUtil.createIndexedColorsImage(this.wImg, this.hImg, treeSet);
                    this.mode = ImgEntry.Mode.INDEXED_COLORS;
                }
                if (bufferedImage == null && !bl3) {
                    bufferedImage = new BufferedImage(this.wImg, this.hImg, 5);
                }
                if (bufferedImage != null) {
                    Graphics2D graphics2D2 = bufferedImage.createGraphics();
                    graphics2D2.drawImage((Image)bufferedImage2, 0, 0, this.owner);
                    graphics2D2.dispose();
                }
                if (bl2) {
                    this.mode = ImgEntry.Mode.MONOCHROME;
                } else if (bl) {
                    this.mode = ImgEntry.Mode.GRAY;
                }
            }
        }
        finally {
            if (!this.dlg.wasCancelled()) {
                this.retImg = bufferedImage;
            }
            this.dlg.fireProgressFinished();
        }
    }
}

