/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.CancelableProgressDlg;
import jkcemu.base.EmuUtil;
import jkcemu.image.ImageFrm;
import jkcemu.image.ImgFld;

public class CropDlg
extends BaseDlg
implements CancelableProgressDlg.Progressable,
ChangeListener,
Runnable {
    private Object[][] ratios = new Object[][]{{"frei \u00e4nderbar", null}, {"beibehalten", null}, {"1:1 (Z1013)", Float.valueOf(1.0f)}, {"1:2", Float.valueOf(0.5f)}, {"2:1", Float.valueOf(2.0f)}, {"2:3", CropDlg.divF(2, 3)}, {"3:2", CropDlg.divF(3, 2)}, {"3:4", CropDlg.divF(3, 4)}, {"4:3 (LLC2)", CropDlg.divF(4, 3)}, {"16:9", CropDlg.divF(16, 9)}, {"16:10 (A5105)", CropDlg.divF(16, 10)}, {"AC1", CropDlg.divF(384, 256)}, {"KC85/1, KC87, Z9001", CropDlg.divF(320, 256)}, {"KC85/2..5, HC900", CropDlg.divF(320, 256)}};
    private Object[][] selectionColors = new Object[][]{{"rot", Color.RED}, {"gr\u00fcn", Color.GREEN}, {"blau", Color.BLUE}, {"gelb", Color.YELLOW}, {"wei\u00df", Color.WHITE}, {"schwarz", Color.BLACK}};
    private ImageFrm imageFrm;
    private ImgFld imgFld;
    private int wImg;
    private int hImg;
    private int progressMax;
    private int progressValue;
    private CancelableProgressDlg progressDlg;
    private BufferedImage image;
    private BufferedImage cropImg;
    private Float orgRatio;
    private SpinnerNumberModel spinnerModelX;
    private SpinnerNumberModel spinnerModelY;
    private SpinnerNumberModel spinnerModelWidth;
    private SpinnerNumberModel spinnerModelHeight;
    private JSpinner spinnerX;
    private JSpinner spinnerY;
    private JSpinner spinnerWidth;
    private JSpinner spinnerHeight;
    private JComboBox<Object> comboRatio;
    private JComboBox<Object> comboSelectionColor;
    private JButton btnCrop;
    private JButton btnClose;

    public void setImageSize(int n, int n2) {
        if (n != this.wImg || n2 != this.hImg) {
            try {
                this.wImg = n > 0 ? n : 0;
                this.hImg = n2 > 0 ? n2 : 0;
                this.orgRatio = this.hImg > 0 && this.wImg > 0 ? Float.valueOf((float)this.wImg / (float)this.hImg) : null;
                this.resetSelectedRatio();
                this.spinnerModelX.setMaximum(Integer.valueOf(this.wImg > 0 ? this.wImg - 1 : 0));
                this.spinnerModelY.setMaximum(Integer.valueOf(this.hImg > 0 ? this.hImg - 1 : 0));
                this.spinnerModelWidth.setMaximum(Integer.valueOf(this.wImg));
                this.spinnerModelHeight.setMaximum(Integer.valueOf(this.hImg));
                this.setValueXSilent(0);
                this.setValueYSilent(0);
                this.setValueWidthSilent(this.wImg);
                this.setValueHeightSilent(this.hImg);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                EmuUtil.exitSysError(this, null, illegalArgumentException);
            }
        }
    }

    public void setSelectedArea(Rectangle rectangle) {
        if (rectangle != null) {
            int n = rectangle.width > 0 ? rectangle.width : 0;
            int n2 = rectangle.height > 0 ? rectangle.height : 0;
            try {
                this.setValueXSilent(rectangle.x > 0 ? rectangle.x : 0);
                this.setValueYSilent(rectangle.y > 0 ? rectangle.y : 0);
                this.setValueWidthSilent(n <= this.wImg ? n : this.wImg);
                this.setValueHeightSilent(n2 <= this.hImg ? n2 : this.hImg);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                EmuUtil.exitSysError(this, null, illegalArgumentException);
            }
        }
    }

    public Rectangle toRatio(int n, int n2, int n3, int n4) {
        Rectangle rectangle = null;
        Float f = this.getSelectedRatio();
        if (f != null) {
            int n5;
            int n6 = n;
            int n7 = n2;
            int n8 = n3;
            int n9 = n4;
            if (n8 < 0) {
                n6 += n8;
                n8 = -n8;
            }
            if (n6 < 0) {
                n8 += n6;
                n6 = 0;
            }
            if (n9 < 0) {
                n7 += n9;
                n9 = -n9;
            }
            if (n7 < 0) {
                n9 += n7;
                n7 = 0;
            }
            if (n6 + n8 > this.wImg) {
                n8 = this.wImg - n6;
            }
            if (n6 + n8 > this.wImg) {
                n8 = this.wImg - n6;
            }
            if ((n5 = this.getHByW(n8, f.floatValue())) != n9) {
                if (n4 < 0 && n7 + n9 - n5 < 0) {
                    n8 = this.getWByH(n9 += n7, f.floatValue());
                } else if (n7 + n5 > this.hImg) {
                    n9 = this.hImg - n7;
                    n8 = this.getWByH(n9, f.floatValue());
                } else {
                    n9 = n5;
                }
                rectangle = new Rectangle(n, n2, n3 > 0 ? n8 : -n8, n4 > 0 ? n9 : -n9);
            }
        }
        return rectangle;
    }

    public CropDlg(ImageFrm imageFrm) {
        super((Window)imageFrm, Dialog.ModalityType.MODELESS);
        this.imageFrm = imageFrm;
        this.imgFld = imageFrm.getImgFld();
        this.wImg = 0;
        this.hImg = 0;
        this.progressMax = 0;
        this.progressValue = 0;
        this.progressDlg = null;
        this.image = null;
        this.cropImg = null;
        this.orgRatio = null;
        this.setTitle("Zuschneiden");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("X:"), gridBagConstraints);
        this.spinnerModelX = new SpinnerNumberModel(0, 0, 9999, 1);
        this.spinnerX = new JSpinner(this.spinnerModelX);
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.spinnerX, gridBagConstraints);
        gridBagConstraints.insets.left = 20;
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("Breite:"), gridBagConstraints);
        this.spinnerModelWidth = new SpinnerNumberModel(0, 0, 9999, 1);
        this.spinnerWidth = new JSpinner(this.spinnerModelWidth);
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.spinnerWidth, gridBagConstraints);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Y:"), gridBagConstraints);
        this.spinnerModelY = new SpinnerNumberModel(0, 0, 9999, 1);
        this.spinnerY = new JSpinner(this.spinnerModelY);
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.spinnerY, gridBagConstraints);
        gridBagConstraints.insets.left = 20;
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("H\u00f6he:"), gridBagConstraints);
        this.spinnerModelHeight = new SpinnerNumberModel(0, 0, 9999, 1);
        this.spinnerHeight = new JSpinner(this.spinnerModelHeight);
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.spinnerHeight, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0);
        jPanel.add((Component)new JLabel("Seitenverh\u00e4ltnis:"), gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)new JLabel("Farbe f\u00fcr Auswahl:"), gridBagConstraints2);
        this.comboRatio = new JComboBox();
        this.comboRatio.setEditable(false);
        for (Object[] objectArray : this.ratios) {
            this.comboRatio.addItem(objectArray[0]);
        }
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 0;
        ++gridBagConstraints2.gridx;
        jPanel.add(this.comboRatio, gridBagConstraints2);
        this.comboSelectionColor = new JComboBox();
        this.comboSelectionColor.setEditable(false);
        for (Object[] objectArray : this.selectionColors) {
            this.comboSelectionColor.addItem(objectArray[0]);
        }
        gridBagConstraints2.anchor = 17;
        ++gridBagConstraints2.gridy;
        jPanel.add(this.comboSelectionColor, gridBagConstraints2);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 5));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        this.btnCrop = new JButton("Zuschneiden");
        jPanel2.add(this.btnCrop);
        this.btnClose = new JButton("Schlie\u00dfen");
        jPanel2.add(this.btnClose);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
        this.spinnerX.addChangeListener(this);
        this.spinnerY.addChangeListener(this);
        this.spinnerWidth.addChangeListener(this);
        this.spinnerHeight.addChangeListener(this);
        this.comboRatio.addActionListener(this);
        this.comboSelectionColor.addActionListener(this);
        this.btnCrop.addActionListener(this);
        this.btnClose.addActionListener(this);
        this.doSelectionColor();
    }

    @Override
    public int getProgressMax() {
        return this.progressMax;
    }

    @Override
    public int getProgressValue() {
        return this.progressValue;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.spinnerX || object == this.spinnerY || object == this.spinnerWidth || object == this.spinnerHeight) {
            int n = EmuUtil.getInt(this.spinnerX);
            int n2 = EmuUtil.getInt(this.spinnerY);
            int n3 = EmuUtil.getInt(this.spinnerWidth);
            int n4 = EmuUtil.getInt(this.spinnerHeight);
            if (object == this.spinnerX) {
                if (n + n3 > this.wImg) {
                    n = Math.max(0, this.wImg - n3);
                    this.setValueXSilent(n);
                }
            } else if (object == this.spinnerY) {
                if (n2 + n4 > this.hImg) {
                    n2 = Math.max(0, this.hImg - n4);
                    this.setValueYSilent(n2);
                }
            } else if (object == this.spinnerWidth) {
                int n5;
                Float f;
                boolean bl = false;
                if (n + n3 > this.wImg && (n3 = Math.max(0, this.wImg - n)) == 0 && this.wImg > 0) {
                    n3 = 1;
                    bl = true;
                }
                if ((f = this.getSelectedRatio()) != null && (n5 = this.getHByW(n3, f.floatValue())) != n4) {
                    if (n2 + n5 > this.hImg) {
                        n3 = this.getWByH(this.hImg - n2, f.floatValue());
                        n5 = this.getHByW(n3, f.floatValue());
                        bl = true;
                    }
                    n4 = n5;
                    this.setValueHeightSilent(n4);
                }
                if (bl) {
                    this.setValueWidthSilent(n3);
                }
            } else if (object == this.spinnerHeight) {
                int n6;
                Float f;
                boolean bl = false;
                if (n2 + n4 > this.hImg && (n4 = Math.max(0, this.hImg - n2)) == 0 && this.hImg > 0) {
                    n4 = 1;
                    bl = true;
                }
                if ((f = this.getSelectedRatio()) != null && (n6 = this.getWByH(n4, f.floatValue())) != n3) {
                    if (n + n6 > this.wImg) {
                        n4 = this.getHByW(this.wImg - n, f.floatValue());
                        n6 = this.getWByH(n4, f.floatValue());
                        bl = true;
                    }
                    n3 = n6;
                    this.setValueWidthSilent(n3);
                }
                if (bl) {
                    this.setValueHeightSilent(n4);
                }
            }
            this.imageFrm.setSelection(n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.cropImg != null && this.progressDlg != null) {
            try {
                boolean bl = false;
                int n = this.cropImg.getWidth();
                int n2 = this.cropImg.getHeight();
                this.progressMax = n * n2;
                this.progressValue = 0;
                block2: for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        if ((this.cropImg.getRGB(j, i) >> 24 & 0xFF) < 255) {
                            bl = true;
                            continue block2;
                        }
                        ++this.progressValue;
                    }
                }
                if (!bl) {
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage((Image)this.cropImg, 0, 0, this);
                    graphics2D.dispose();
                    this.cropImg = bufferedImage;
                }
                this.progressDlg.fireProgressFinished();
            }
            catch (Throwable throwable) {
                this.progressDlg.fireProgressFinished();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CropDlg.this.showCropImage();
                    }
                });
                throw throwable;
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.comboRatio) {
            bl = true;
            this.ensureRatio();
        } else if (object == this.comboSelectionColor) {
            bl = true;
            this.doSelectionColor();
        } else if (object == this.btnCrop) {
            bl = true;
            this.doCrop();
        } else if (object == this.btnClose) {
            bl = true;
            this.doClose();
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl) {
            this.resetSelectedRatio();
        }
        return bl;
    }

    private static Float divF(int n, int n2) {
        return Float.valueOf((float)n / (float)n2);
    }

    private void doCrop() {
        this.image = this.imgFld.getImage();
        if (this.image != null) {
            boolean bl = true;
            if (this.ensureRatio()) {
                bl = CropDlg.showYesNoDlg(this, "Der ausgew\u00e4hlte Bereich entsprach nicht dem gew\u00fcnschten\nSeitenverh\u00e4ltnis und wurde deshalb angepasst.\nM\u00f6chten Sie das Bild nun auf die angepassten Werte zuschneiden?");
            }
            if (bl) {
                Rectangle rectangle;
                int n = EmuUtil.getInt(this.spinnerX);
                int n2 = EmuUtil.getInt(this.spinnerY);
                int n3 = EmuUtil.getInt(this.spinnerWidth);
                int n4 = EmuUtil.getInt(this.spinnerHeight);
                if (n >= 0 && n2 >= 0 && n3 > 0 && n4 > 0 && (rectangle = this.imgFld.toUnrotated(n, n2, n3, n4)) != null) {
                    int n5;
                    int n6;
                    n = rectangle.x;
                    n2 = rectangle.y;
                    n3 = rectangle.width;
                    n4 = rectangle.height;
                    if (n < 0) {
                        n3 += n;
                        n = 0;
                    }
                    if (n2 < 0) {
                        n4 += n2;
                        n2 = 0;
                    }
                    if (n + n3 > (n6 = this.image.getWidth())) {
                        n3 = n6 - n;
                    }
                    if (n2 + n4 > (n5 = this.image.getHeight())) {
                        n4 = n5 - n2;
                    }
                    if (n3 > 0 && n4 > 0) {
                        this.doClose();
                        this.cropImg = this.image.getSubimage(n, n2, n3, n4);
                        if (this.cropImg.getTransparency() == 1) {
                            this.showCropImage();
                        } else {
                            this.progressDlg = new CancelableProgressDlg((Window)this, "Schneide Bild zu...", this);
                            new Thread(Main.getThreadGroup(), this, "JKCEMU image crop").start();
                            this.progressDlg.setVisible(true);
                        }
                    }
                }
            }
        }
    }

    private void doSelectionColor() {
        Object object;
        int n = this.comboSelectionColor.getSelectedIndex();
        if (n >= 0 && n < this.selectionColors.length && (object = this.selectionColors[n][1]) instanceof Color) {
            this.imageFrm.setSelectionColor((Color)object);
        }
    }

    private boolean ensureRatio() {
        Rectangle rectangle;
        boolean bl = false;
        Float f = this.getSelectedRatio();
        if (f != null && (rectangle = this.toRatio(EmuUtil.getInt(this.spinnerX), EmuUtil.getInt(this.spinnerY), EmuUtil.getInt(this.spinnerWidth), EmuUtil.getInt(this.spinnerHeight))) != null) {
            this.setValueWidthSilent(rectangle.width);
            this.setValueHeightSilent(rectangle.height);
            this.imageFrm.setSelection(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            bl = true;
        }
        return bl;
    }

    private Float getSelectedRatio() {
        Object object;
        Float f = null;
        int n = this.comboRatio.getSelectedIndex();
        if (n == 1) {
            f = this.orgRatio;
        } else if (n >= 2 && n < this.ratios.length && (object = this.ratios[n][1]) != null && object instanceof Float) {
            f = (Float)object;
        }
        return f;
    }

    private int getHByW(int n, float f) {
        int n2 = Math.round((float)n / f);
        if (n2 <= 0 && this.hImg > 0) {
            n2 = 1;
        }
        return n2;
    }

    private int getWByH(int n, float f) {
        int n2 = Math.round((float)n * f);
        if (n2 <= 0 && this.wImg > 0) {
            n2 = 1;
        }
        return n2;
    }

    private void resetSelectedRatio() {
        try {
            this.comboRatio.setSelectedIndex(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void setValueXSilent(int n) {
        this.spinnerX.removeChangeListener(this);
        this.spinnerX.setValue(n);
        this.spinnerX.addChangeListener(this);
    }

    private void setValueYSilent(int n) {
        this.spinnerY.removeChangeListener(this);
        this.spinnerY.setValue(n);
        this.spinnerY.addChangeListener(this);
    }

    private void setValueHeightSilent(int n) {
        this.spinnerHeight.removeChangeListener(this);
        this.spinnerHeight.setValue(n);
        this.spinnerHeight.addChangeListener(this);
    }

    private void setValueWidthSilent(int n) {
        this.spinnerWidth.removeChangeListener(this);
        this.spinnerWidth.setValue(n);
        this.spinnerWidth.addChangeListener(this);
    }

    private void showCropImage() {
        if (this.cropImg != null) {
            this.imageFrm.showDerivatedImage(this.cropImg, "Zugeschnitten");
        }
    }
}

