/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuUtil;
import jkcemu.base.ScreenFrm;
import jkcemu.image.ImageFrm;

public class ImageCaptureFrm
extends BaseFrm {
    private static final String DEFAULT_STATUS_TEXT = "Bereit";
    private static ImageCaptureFrm instance = null;
    private ScreenFrm screenFrm;
    private int waitForWindowMillis;
    private Robot robot;
    private Timer statusTimer;
    private JRadioButton btnCaptureEmuSysScreen;
    private JRadioButton btnCaptureScreenFrm;
    private JRadioButton btnCaptureOtherWindow;
    private JLabel labelWinSelectTime;
    private JLabel labelWinSelectUnit;
    private JSpinner spinnerWinSelectSec;
    private JLabel labelStatus;
    private JButton btnTakePhoto;
    private JButton btnClose;

    public static void open(ScreenFrm screenFrm) {
        if (instance != null) {
            if (instance.getExtendedState() == 1) {
                instance.setExtendedState(0);
            }
        } else {
            instance = new ImageCaptureFrm(screenFrm);
        }
        instance.toFront();
        instance.setVisible(true);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnCaptureEmuSysScreen || object == this.btnCaptureScreenFrm || object == this.btnCaptureOtherWindow) {
                bl = true;
                this.updFieldsEnabled();
            } else if (object == this.btnTakePhoto) {
                bl = true;
                this.doTakePhoto();
            } else if (object == this.btnClose) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl) {
            if (this.statusTimer.isRunning()) {
                this.statusTimer.stop();
            }
            this.btnTakePhoto.setEnabled(true);
            this.updFieldsEnabled();
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.pack();
    }

    private ImageCaptureFrm(ScreenFrm screenFrm) {
        Object object;
        Object object2;
        this.screenFrm = screenFrm;
        this.waitForWindowMillis = 0;
        this.robot = null;
        this.setTitle("JKCEMU Bildschirmfoto");
        Main.updIcon(this);
        this.statusTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageCaptureFrm.this.updStatusText();
            }
        });
        try {
            object2 = null;
            object = this.getGraphicsConfiguration();
            if (object != null) {
                object2 = ((GraphicsConfiguration)object).getDevice();
            }
            this.robot = object2 != null ? new Robot((GraphicsDevice)object2) : new Robot();
        }
        catch (AWTException aWTException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setLayout(new GridBagLayout());
        object2 = new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        object = new ButtonGroup();
        this.btnCaptureEmuSysScreen = new JRadioButton("Bildschirmausgabe des emulierten Systems ohne Fenster", true);
        ((ButtonGroup)object).add(this.btnCaptureEmuSysScreen);
        this.btnCaptureEmuSysScreen.addActionListener(this);
        this.add((Component)this.btnCaptureEmuSysScreen, object2);
        this.btnCaptureScreenFrm = new JRadioButton("Bildschirmausgabe des emulierten Systems mit Fenster", false);
        ((ButtonGroup)object).add(this.btnCaptureScreenFrm);
        this.btnCaptureScreenFrm.addActionListener(this);
        ((GridBagConstraints)object2).insets.top = 0;
        ++((GridBagConstraints)object2).gridy;
        this.add((Component)this.btnCaptureScreenFrm, object2);
        this.btnCaptureOtherWindow = new JRadioButton("Beliebiges JKCEMU-Fenster", false);
        ((ButtonGroup)object).add(this.btnCaptureOtherWindow);
        this.btnCaptureOtherWindow.addActionListener(this);
        ++((GridBagConstraints)object2).gridy;
        this.add((Component)this.btnCaptureOtherWindow, object2);
        this.labelWinSelectTime = new JLabel("Zeit f\u00fcr Fensterauswahl:");
        ((GridBagConstraints)object2).insets.left = 50;
        ((GridBagConstraints)object2).insets.bottom = 5;
        ((GridBagConstraints)object2).gridwidth = 1;
        ++((GridBagConstraints)object2).gridy;
        this.add((Component)this.labelWinSelectTime, object2);
        this.spinnerWinSelectSec = new JSpinner(new SpinnerNumberModel(3, 1, 9, 1));
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).insets.left = 5;
        ++((GridBagConstraints)object2).gridx;
        this.add((Component)this.spinnerWinSelectSec, object2);
        this.labelWinSelectUnit = new JLabel("Sekunden");
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ++((GridBagConstraints)object2).gridx;
        this.add((Component)this.labelWinSelectUnit, object2);
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).insets.left = 0;
        ((GridBagConstraints)object2).insets.right = 0;
        ((GridBagConstraints)object2).gridwidth = 0;
        ((GridBagConstraints)object2).gridx = 0;
        ++((GridBagConstraints)object2).gridy;
        this.add((Component)new JSeparator(), object2);
        this.labelStatus = new JLabel(DEFAULT_STATUS_TEXT);
        ((GridBagConstraints)object2).anchor = 17;
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).insets.top = 0;
        ((GridBagConstraints)object2).insets.left = 5;
        ((GridBagConstraints)object2).insets.right = 5;
        ++((GridBagConstraints)object2).gridy;
        this.add((Component)this.labelStatus, object2);
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        ((GridBagConstraints)object2).anchor = 12;
        ((GridBagConstraints)object2).insets.top = 5;
        ((GridBagConstraints)object2).gridwidth = 1;
        ((GridBagConstraints)object2).gridheight = 4;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).gridx = 3;
        this.add((Component)jPanel, object2);
        this.btnTakePhoto = new JButton("Aufnehmen");
        this.btnTakePhoto.addActionListener(this);
        jPanel.add(this.btnTakePhoto);
        this.btnClose = new JButton("Schlie\u00dfen");
        this.btnClose.addActionListener(this);
        jPanel.add(this.btnClose);
        this.updFieldsEnabled();
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setScreenCentered();
        }
        this.setResizable(true);
    }

    private void doTakePhoto() {
        this.waitForWindowMillis = 0;
        if (this.btnCaptureEmuSysScreen.isSelected()) {
            this.fireTakePhoto(null);
        }
        if (this.btnCaptureScreenFrm.isSelected()) {
            this.fireTakePhoto(this.screenFrm);
        } else if (this.btnCaptureOtherWindow.isSelected()) {
            int n;
            Object object;
            this.waitForWindowMillis = 5000;
            if (this.spinnerWinSelectSec != null && (object = this.spinnerWinSelectSec.getValue()) instanceof Number && (n = ((Number)object).intValue()) >= 1 && n < 10) {
                this.waitForWindowMillis = (n + 1) * 1000;
            }
            this.labelWinSelectTime.setEnabled(false);
            this.spinnerWinSelectSec.setEnabled(false);
            this.labelWinSelectUnit.setEnabled(false);
            this.btnTakePhoto.setEnabled(false);
            this.statusTimer.start();
        }
    }

    private void fireTakePhoto(final Window window) {
        if (window != null) {
            EmuUtil.frameToFront(window);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageCaptureFrm.this.takePhoto(window);
                }
            });
        } else {
            this.takePhoto(null);
        }
    }

    private void takePhoto(Window window) {
        BufferedImage bufferedImage = null;
        if (window != null) {
            if (this.robot != null) {
                int n = window.getX();
                int n2 = window.getY();
                int n3 = window.getWidth();
                int n4 = window.getHeight();
                if (n < 0) {
                    n3 += n;
                    n = 0;
                }
                if (n2 < 0) {
                    n4 += n2;
                    n2 = 0;
                }
                if (n3 > 0 && n4 > 0) {
                    bufferedImage = this.robot.createScreenCapture(new Rectangle(n, n2, n3, n4));
                }
            } else {
                BaseDlg.showErrorDlg((Component)this, "Aufnehmen des Bildschirmfotos fehlgeschlagen");
            }
        } else {
            bufferedImage = this.screenFrm.createSnapshot();
        }
        if (bufferedImage != null) {
            ImageFrm.open(bufferedImage, "Bildschirmfoto");
        }
    }

    private void updFieldsEnabled() {
        boolean bl = this.btnCaptureOtherWindow.isSelected();
        this.labelWinSelectTime.setEnabled(bl);
        this.labelWinSelectUnit.setEnabled(bl);
        this.spinnerWinSelectSec.setEnabled(bl);
    }

    private void updStatusText() {
        boolean bl = false;
        String string = DEFAULT_STATUS_TEXT;
        if (this.waitForWindowMillis > 0) {
            this.waitForWindowMillis -= 500;
            if (this.waitForWindowMillis > 0) {
                int n = this.waitForWindowMillis / 1000;
                if (n == 1) {
                    string = "Aufzunehmendes Fenster aktivieren! Noch 1 Sekunde...";
                } else if (n > 1) {
                    string = String.format("Aufzunehmendes Fenster aktivieren! Noch %d Sekunden...", n);
                }
                bl = true;
            } else {
                Window window = null;
                Window[] windowArray = Window.getWindows();
                if (windowArray != null) {
                    for (Window window2 : windowArray) {
                        if (!window2.isFocused()) continue;
                        window = window2;
                    }
                }
                if (window != null) {
                    this.fireTakePhoto(window);
                } else {
                    BaseDlg.showErrorDlg((Component)this, "Kein JKCEMU-Fenster aktiv");
                    string = DEFAULT_STATUS_TEXT;
                }
                this.btnTakePhoto.setEnabled(true);
                this.updFieldsEnabled();
            }
        }
        this.labelStatus.setText(string);
        if (!bl) {
            this.statusTimer.stop();
        }
    }
}

