/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Window;
import java.awt.image.BufferedImage;
import jkcemu.Main;
import jkcemu.base.CancelableProgressDlg;

public class ImgCopier
implements CancelableProgressDlg.Progressable,
Runnable {
    private BufferedImage srcImg;
    private BufferedImage dstImg;
    private int wImg;
    private int hImg;
    private volatile int progressValue;
    private CancelableProgressDlg dlg;

    public static boolean work(Window window, String string, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        ImgCopier imgCopier = new ImgCopier(bufferedImage, bufferedImage2);
        imgCopier.dlg = new CancelableProgressDlg(window, string, imgCopier);
        new Thread(Main.getThreadGroup(), imgCopier, "JKCEMU image copier").start();
        imgCopier.dlg.setVisible(true);
        return !imgCopier.dlg.wasCancelled();
    }

    @Override
    public int getProgressMax() {
        return this.wImg * this.hImg;
    }

    @Override
    public int getProgressValue() {
        return this.progressValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (int i = 0; i < this.hImg; ++i) {
                for (int j = 0; j < this.wImg && !this.dlg.wasCancelled(); ++j) {
                    this.dstImg.setRGB(j, i, this.srcImg.getRGB(j, i));
                    ++this.progressValue;
                }
            }
        }
        finally {
            this.dlg.fireProgressFinished();
        }
    }

    private ImgCopier(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.srcImg = bufferedImage;
        this.dstImg = bufferedImage2;
        this.wImg = Math.min(bufferedImage.getWidth(), bufferedImage2.getWidth());
        this.hImg = Math.min(bufferedImage.getHeight(), bufferedImage2.getHeight());
        this.progressValue = 0;
        this.dlg = null;
    }
}

