/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EventObject;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.image.ImgUtil;

public class ImgPropsDlg
extends BaseDlg
implements Runnable {
    private static final String TEXT_IS_DETERMINING = "wird ermittelt...";
    private BufferedImage image;
    private int wImg;
    private int hImg;
    private int transparentPixels;
    private int translucentPixels;
    private boolean gray;
    private boolean monochrome;
    private Set<Integer> totalColors;
    private Set<Integer> visibleColors;
    private JLabel labelColorCount;
    private JLabel labelTransparency;
    private JButton btnClose;

    public static void showDlg(Window window, BufferedImage bufferedImage, File file) {
        new ImgPropsDlg(window, bufferedImage, file).setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.transparentPixels = 0;
            this.translucentPixels = 0;
            this.gray = true;
            this.monochrome = true;
            this.totalColors.clear();
            this.visibleColors.clear();
            for (int i = 0; i < this.hImg; ++i) {
                for (int j = 0; j < this.wImg; ++j) {
                    int n = this.image.getRGB(j, i);
                    int n2 = n & 0xFF;
                    int n3 = n >> 8 & 0xFF;
                    int n4 = n >> 16 & 0xFF;
                    int n5 = n >> 24 & 0xFF;
                    if (n5 == 0) {
                        ++this.transparentPixels;
                    } else if (n5 < 255) {
                        ++this.translucentPixels;
                    }
                    if (n4 != n3 || n4 != n2) {
                        this.gray = false;
                        this.monochrome = false;
                    }
                    if (n4 > 0 && n4 < 255 || n3 > 0 && n3 < 255 || n2 > 0 && n2 < 255) {
                        this.monochrome = false;
                    }
                    this.totalColors.add(n);
                    if (n5 <= 0) continue;
                    this.visibleColors.add(n);
                }
            }
        }
        catch (Throwable throwable) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImgPropsDlg.this.colorsChecked();
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.btnClose) {
            bl = true;
            this.doClose();
        }
        return bl;
    }

    private ImgPropsDlg(Window window, BufferedImage bufferedImage, File file) {
        super(window, "Bildeigenschaften");
        this.image = bufferedImage;
        this.wImg = bufferedImage.getWidth(this);
        this.hImg = bufferedImage.getHeight(this);
        this.transparentPixels = 0;
        this.translucentPixels = 0;
        this.gray = false;
        this.monochrome = false;
        this.totalColors = new TreeSet<Integer>();
        this.visibleColors = new TreeSet<Integer>();
        int n = -1;
        IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
        if (indexColorModel != null) {
            n = indexColorModel.getMapSize();
        }
        new Thread(Main.getThreadGroup(), this, "JKCEMU imageviewer color counter").start();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        if (file != null) {
            this.add((Component)new JLabel("Datei:"), gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel(file.getPath()), gridBagConstraints);
            gridBagConstraints.insets.top = 0;
            long l = file.length();
            if (l > 0L) {
                gridBagConstraints.gridx = 0;
                ++gridBagConstraints.gridy;
                this.add((Component)new JLabel("Dateigr\u00f6\u00dfe:"), gridBagConstraints);
                ++gridBagConstraints.gridx;
                this.add((Component)new JLabel(EmuUtil.formatSize(l, false, true)), gridBagConstraints);
                gridBagConstraints.gridx = 0;
                ++gridBagConstraints.gridy;
            }
        }
        this.add((Component)new JLabel("Bildgr\u00f6\u00dfe:"), gridBagConstraints);
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(EmuUtil.formatInt(this.wImg));
        stringBuilder.append(" x ");
        stringBuilder.append(EmuUtil.formatInt(this.hImg));
        stringBuilder.append(" = ");
        stringBuilder.append(EmuUtil.formatInt(this.wImg * this.hImg));
        stringBuilder.append(" Pixel");
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel(stringBuilder.toString()), gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Anzahl  Farben:"), gridBagConstraints);
        this.labelColorCount = new JLabel(TEXT_IS_DETERMINING);
        ++gridBagConstraints.gridx;
        this.add((Component)this.labelColorCount, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Farbpalette:"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel(n > 0 ? String.format("%d indexierte Farben", n) : "16,7 Mio Farben (nicht indexiert)"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Transparenz:"), gridBagConstraints);
        this.labelTransparency = new JLabel(bufferedImage.getTransparency() == 1 ? "keine" : TEXT_IS_DETERMINING);
        ++gridBagConstraints.gridx;
        this.add((Component)this.labelTransparency, gridBagConstraints);
        this.btnClose = new JButton("Schlie\u00dfen");
        this.btnClose.addActionListener(this);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnClose, gridBagConstraints);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
    }

    private void colorsChecked() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(EmuUtil.formatInt(this.totalColors.size()));
        if (this.visibleColors.size() != this.totalColors.size()) {
            stringBuilder.append(", davon ");
            stringBuilder.append(EmuUtil.formatInt(this.visibleColors.size()));
            stringBuilder.append(" sichtbar");
        }
        if (this.monochrome) {
            stringBuilder.append(" (schwarz/wei\u00df)");
        } else if (this.gray) {
            stringBuilder.append(" (Graustufen)");
        }
        this.labelColorCount.setText(stringBuilder.toString());
        stringBuilder.setLength(0);
        if (this.transparentPixels > 0 || this.translucentPixels > 0) {
            float f = this.wImg * this.hImg;
            stringBuilder.append(EmuUtil.formatInt(this.transparentPixels));
            stringBuilder.append(" Pixel (");
            stringBuilder.append(ImgPropsDlg.toPercent((float)this.transparentPixels / f));
            stringBuilder.append("%)");
            if (this.translucentPixels > 0) {
                stringBuilder.append(" voll- und ");
                stringBuilder.append(EmuUtil.formatInt(this.translucentPixels));
                stringBuilder.append(" Pixel (");
                stringBuilder.append(ImgPropsDlg.toPercent((float)this.translucentPixels / f));
                stringBuilder.append("%) teiltransparent");
            } else {
                stringBuilder.append(" volltransparent");
            }
        } else {
            stringBuilder.append("keine");
        }
        this.labelTransparency.setText(stringBuilder.toString());
        this.pack();
    }

    private static String toPercent(float f) {
        NumberFormat numberFormat;
        String string = "##0.0";
        if (Math.round(f * 100.0f) == 0) {
            string = string + "##";
        }
        if ((numberFormat = NumberFormat.getNumberInstance()) instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).applyPattern(string);
        }
        return numberFormat.format(f * 100.0f);
    }
}

