/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Component;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuMemView;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileFormat;
import jkcemu.base.FileSaver;
import jkcemu.image.IFFFile;
import jkcemu.image.ImgUtil;

public class ImgSaver {
    private static final byte[] ac1AccAppMemBytes = new byte[]{49, 0, 32, 33, 32, 32, 17, 0, 16, 1, 0, 8, -19, -80, -51, -6, 7, -26, 127, 40, -7, -51, 8, 0, 62, 12, -51, 16, 0, -61, -3, 7};
    private static final byte[] ac1ScchAppMemBytes = new byte[]{49, 0, 32, 33, 29, 32, 17, 0, 16, 1, 0, 8, -19, -80, -51, -6, 7, -26, 127, 40, -7, 62, 12, -51, 16, 0, -61, -3, 7};
    private static final byte[] kc852BWAppMemBytes = new byte[]{127, 127, 83, 72, 79, 87, 73, 77, 71, 1, -37, -120, -11, -10, 4, -45, -120, 17, 88, 3, 33, 0, -128, -51, 58, 3, 33, 0, -88, 62, 7, 14, 10, 6, 0, 119, 35, 16, -4, 13, 32, -9, -51, 3, -16, 14, 48, -6, -15, -45, -120, 62, 12, -51, 3, -16, 0, -55, 26, 19, -2, -128, -56, 56, 13, 71, 62, 1, -112, 71, 26, 19, 119, 35, 16, -4, 24, -20, 60, 71, 26, 19, 119, 35, 16, -6, 24, -30};
    private static final byte[] kc854HiresAppMemBytes = new byte[]{127, 127, 83, 72, 79, 87, 73, 77, 71, 1, -37, -120, -11, -10, 4, -45, -120, -35, 126, 1, -11, -26, -15, -18, 1, 40, 2, -10, 4, -45, -124, -35, 119, 1, -11, 17, 104, 3, 33, 0, -128, -51, 74, 3, -15, -10, 2, -45, -124, -35, 119, 1, 33, 0, -128, -51, 74, 3, -51, 3, -16, 14, 48, -6, -15, -45, -124, -35, 119, 1, -15, -45, -120, -55, 26, 19, -2, -128, -56, 56, 13, 71, 62, 1, -112, 71, 26, 19, 119, 35, 16, -4, 24, -20, 60, 71, 26, 19, 119, 35, 16, -6, 24, -30};
    private static final byte[] kc854LowresBWAppMemBytes = new byte[]{127, 127, 83, 72, 79, 87, 73, 77, 71, 1, -37, -120, -11, -10, 4, -45, -120, -35, 126, 1, -11, -26, -15, -10, 8, -18, 1, 40, 2, -10, 4, -45, -124, -35, 119, 1, -11, 17, 116, 3, 33, 0, -128, -51, 86, 3, -15, -10, 2, -45, -124, -35, 119, 1, 33, 0, -128, 62, 7, 14, 40, 6, 0, 119, 35, 16, -4, 13, 32, -9, -51, 3, -16, 14, 48, -6, -15, -45, -124, -35, 119, 1, -15, -45, -120, -55, 26, 19, -2, -128, -56, 56, 13, 71, 62, 1, -112, 71, 26, 19, 119, 35, 16, -4, 24, -20, 60, 71, 26, 19, 119, 35, 16, -6, 24, -30};
    private static final byte[] llc2HiresAppMemBytes = new byte[]{49, 0, 32, 17, 57, 32, 33, 0, -128, 26, 19, -2, -128, 40, 25, 56, 13, 71, 62, 1, -112, 71, 26, 19, 119, 35, 16, -4, 24, -21, 60, 71, 26, 19, 119, 35, 16, -6, 24, -31, 62, 80, -45, -18, -51, -6, 7, -26, 127, 40, -7, -81, -45, -18, -61, -3, 7};
    private static final byte[] z1013AppMemBytes = new byte[]{33, 22, 1, 17, 0, -20, 1, 0, 4, -19, -80, -25, 1, 0, 62, 12, -25, 0, 0, -61, 56, 0};
    private static final byte[] z9001AppMemBytes = new byte[]{-61, 13, 3, 86, 73, 69, 87, 73, 77, 71, 32, 0, 0, 14, 29, -51, 5, 0, 33, 0, -24, 54, 112, 17, 1, -24, 1, -65, 4, -19, -80, 33, 62, 3, 17, 0, -20, 1, -64, 3, -19, -80, 14, 1, -51, 5, 0, 14, 30, -51, 5, 0, 30, 12, 14, 2, -51, 5, 0, -61, 0, 0};
    private static final byte[] kcUnpackBytes = new byte[]{33, 30, 64, 17, 0, -128, 62, -88, -70, -56, 126, 35, -2, 27, 40, 4, 18, 19, 24, -14, 126, 35, 70, 35, 18, 19, 16, -4, 24, -24};

    public static void saveAppAC1ACC(byte[] byArray, File file) throws IOException {
        ImgSaver.saveApp(file, false, 8192, ac1AccAppMemBytes, byArray);
    }

    public static void saveAppAC1SCCH(byte[] byArray, File file) throws IOException {
        ImgSaver.saveApp(file, false, 8192, ac1ScchAppMemBytes, byArray);
    }

    public static void saveAppKC852BW(BufferedImage bufferedImage, File file) throws IOException {
        byte[] byArray = new byte[10240];
        ImgUtil.createKC852MonochromeMemBytes(bufferedImage, byArray);
        byte[] byArray2 = ImgUtil.toPackBits(byArray);
        if (byArray2 != null && byArray2.length > 0) {
            ImgSaver.saveApp(file, false, 768, kc852BWAppMemBytes, byArray2);
        }
    }

    public static void saveAppKC854Hires(BufferedImage bufferedImage, File file) throws IOException {
        byte[] byArray = new byte[10240];
        byte[] byArray2 = new byte[10240];
        ImgUtil.createKC854HiresMemBytes(bufferedImage, byArray, byArray2);
        byte[] byArray3 = ImgUtil.toPackBits(byArray);
        byte[] byArray4 = ImgUtil.toPackBits(byArray2);
        if (byArray3 != null && byArray4 != null && byArray3.length > 0 && byArray4.length > 0) {
            ImgSaver.saveApp(file, false, 768, kc854HiresAppMemBytes, byArray3, byArray4);
        }
    }

    public static void saveAppKC854LowresBW(BufferedImage bufferedImage, File file) throws IOException {
        byte[] byArray = new byte[10240];
        ImgUtil.createKC854MonochromeMemBytes(bufferedImage, byArray);
        byte[] byArray2 = ImgUtil.toPackBits(byArray);
        if (byArray2 != null && byArray2.length > 0) {
            ImgSaver.saveApp(file, false, 768, kc854LowresBWAppMemBytes, byArray2);
        }
    }

    public static void saveAppLLC2Hires(byte[] byArray, File file) throws IOException {
        byte[] byArray2 = ImgUtil.toPackBits(byArray);
        if (byArray2 != null && byArray2.length > 0) {
            ImgSaver.saveApp(file, false, 8192, llc2HiresAppMemBytes, byArray2);
        }
    }

    public static void saveAppZ1013(byte[] byArray, File file) throws IOException {
        ImgSaver.saveApp(file, true, 256, z1013AppMemBytes, byArray);
    }

    public static void saveAppZ9001(byte[] byArray, File file) throws IOException {
        ImgSaver.saveApp(file, true, 768, z9001AppMemBytes, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveImageAs(Frame frame, BufferedImage bufferedImage, File file) {
        File file2;
        block12: {
            boolean bl = false;
            IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
            if (indexColorModel != null && indexColorModel.getMapSize() == 2) {
                bl = true;
            }
            if (file == null) {
                file = Main.getLastDirFile("image");
            }
            if ((file2 = EmuUtil.showFileSaveDlg(frame, "Bilddatei speichern", file, ImgSaver.createFileFilters(bl))) == null) break block12;
            try {
                if (IFFFile.accept(file2)) {
                    IFFFile.writeImage(file2, bufferedImage);
                    Main.setLastFile(file2, "image");
                    break block12;
                }
                String string = file2.getName();
                if (string == null) break block12;
                String string2 = string.toLowerCase();
                String string3 = null;
                String[] stringArray = ImageIO.getWriterFormatNames();
                if (stringArray != null) {
                    for (int i = 0; string3 == null && i < stringArray.length; ++i) {
                        String string4 = stringArray[i];
                        if (string4 == null || !string2.endsWith("." + string4.toLowerCase())) continue;
                        string3 = string4;
                    }
                }
                if (string3 == null) {
                    throw new IOException(ImgUtil.createFileSuffixNotSupportedMsg(stringArray, IFFFile.getFileSuffixes()));
                }
                String string5 = string3.toLowerCase();
                if (string5.equals("bmp") && bufferedImage.getTransparency() != 1) {
                    throw new IOException("Das Bild enth\u00e4lt transparente Pixel,\ndie nicht im BMP-Format gespeichert werden k\u00f6nnen.");
                }
                boolean bl2 = file2.exists();
                boolean bl3 = false;
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file2);
                    bl3 = ImageIO.write((RenderedImage)bufferedImage, string3, fileOutputStream);
                    ((OutputStream)fileOutputStream).close();
                    fileOutputStream = null;
                }
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(fileOutputStream);
                    throw throwable;
                }
                EmuUtil.closeSilent(fileOutputStream);
                if (bl3) {
                    Main.setLastFile(file2, "image");
                    break block12;
                }
                file2.delete();
                throw new IOException("Das Bild l\u00e4sst sich mit seinen Eigenschaften nicht\nin dem durch die Dateiendung angegebenen Format speichern.");
            }
            catch (IOException iOException) {
                BaseDlg.showErrorDlg((Component)frame, iOException.getMessage());
                file2 = null;
            }
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveImageA5105(Component component, BufferedImage bufferedImage, File file) throws IOException {
        IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(bufferedImage);
        if (indexColorModel != null) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            FileOutputStream fileOutputStream = null;
            try {
                int n3;
                fileOutputStream = new FileOutputStream(file);
                HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
                ((OutputStream)fileOutputStream).write(253);
                ((OutputStream)fileOutputStream).write(0);
                ((OutputStream)fileOutputStream).write(64);
                int n4 = 16000;
                int n5 = 16384 + n4 - 1;
                ((OutputStream)fileOutputStream).write(n5 & 0xFF);
                ((OutputStream)fileOutputStream).write(n5 >> 8 & 0xFF);
                ((OutputStream)fileOutputStream).write(0);
                ((OutputStream)fileOutputStream).write(64);
                for (n3 = 0; n3 < 200; ++n3) {
                    int n6 = 0;
                    for (int i = 0; i < 80; ++i) {
                        int n7 = 0;
                        int n8 = 0;
                        for (int j = 0; j < 4; ++j) {
                            int n9;
                            Integer n10;
                            n7 >>= 1;
                            n8 >>= 1;
                            int n11 = 0;
                            if (n6 < n && n3 < n2) {
                                n11 = bufferedImage.getRGB(n6++, n3);
                            }
                            if ((n10 = (Integer)hashMap.get(n11)) == null) {
                                n10 = ImgUtil.getNearestIndex(indexColorModel, n11);
                                hashMap.put(n11, n10);
                            }
                            if (((n9 = n10.intValue()) & 1) != 0) {
                                n7 |= 8;
                            }
                            if ((n9 & 2) != 0) {
                                n7 |= 0x80;
                            }
                            if ((n9 & 4) != 0) {
                                n8 |= 8;
                            }
                            if ((n9 & 8) == 0) continue;
                            n8 |= 0x80;
                        }
                        ((OutputStream)fileOutputStream).write(n7);
                        ((OutputStream)fileOutputStream).write(n8);
                    }
                }
                ((OutputStream)fileOutputStream).write(26);
                n3 = 8 + 2 * n4;
                while ((n3 & 0x7F) != 0) {
                    ((OutputStream)fileOutputStream).write(0);
                    ++n3;
                }
                ((OutputStream)fileOutputStream).close();
                fileOutputStream = null;
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(fileOutputStream);
                throw throwable;
            }
            EmuUtil.closeSilent(fileOutputStream);
        }
    }

    public static void saveImageKC852Monochrome(BufferedImage bufferedImage, File file) throws IOException {
        byte[] byArray = new byte[10240];
        ImgUtil.createKC852MonochromeMemBytes(bufferedImage, byArray);
        ImgSaver.saveKC85File(file, 1, 3, byArray);
    }

    public static void saveImageKC854Hires(BufferedImage bufferedImage, File file) throws IOException {
        File file2 = file.getParentFile();
        String string = file.getName();
        if (string == null) {
            ImgSaver.throwInvalidKC854HiresFileSuffix();
        }
        String string2 = "";
        int n = string.lastIndexOf(46);
        string2 = n >= 0 ? string.substring(0, n + 1) : string + ".";
        byte[] byArray = new byte[10240];
        byte[] byArray2 = new byte[10240];
        ImgUtil.createKC854HiresMemBytes(bufferedImage, byArray, byArray2);
        ImgSaver.saveKC85File(file2 != null ? new File(file2, string2 + "hip") : new File(string2 + "hip"), -1, -1, byArray);
        ImgSaver.saveKC85File(file2 != null ? new File(file2, string2 + "hif") : new File(string2 + "hif"), -1, -1, byArray2);
    }

    public static void saveImageKC854Monochrome(BufferedImage bufferedImage, File file) throws IOException {
        byte[] byArray = new byte[10240];
        ImgUtil.createKC854MonochromeMemBytes(bufferedImage, byArray);
        ImgSaver.saveKC85File(file, 5, 7, byArray);
    }

    private static EmuMemView createEmuMemView(final int n, final byte[] ... byArray) {
        return new EmuMemView(){

            @Override
            public int getBasicMemByte(int n2) {
                return this.getMemByte(n2, false);
            }

            @Override
            public int getMemByte(int n4, boolean bl) {
                int n2 = 0;
                int n3 = n4 - n;
                for (byte[] byArray2 : byArray) {
                    if (byArray2 == null) continue;
                    if (n3 < 0) break;
                    if (n3 < byArray2.length) {
                        n2 = byArray2[n3] & 0xFF;
                        break;
                    }
                    n3 -= byArray2.length;
                }
                return n2;
            }

            @Override
            public int getMemWord(int n2) {
                return this.getMemByte(n2 + 1, false) << 8 & 0xFF00 | this.getMemByte(n2, false) & 0xFF;
            }
        };
    }

    private static FileFilter[] createFileFilters(boolean bl) {
        FileFilter[] fileFilterArray = null;
        try {
            String[] stringArray = ImageIO.getWriterFileSuffixes();
            if (stringArray != null) {
                ArrayList<FileNameExtensionFilter> arrayList = new ArrayList<FileNameExtensionFilter>();
                TreeSet<String> treeSet = new TreeSet<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (string == null || string.isEmpty()) continue;
                    treeSet.add(string.toUpperCase());
                }
                if (!bl) {
                    treeSet.remove("WBMP");
                }
                while (!treeSet.isEmpty()) {
                    String string = (String)treeSet.first();
                    if (string.equals("JPEG")) {
                        if (treeSet.remove("JPG")) {
                            arrayList.add(new FileNameExtensionFilter("JPEG-Dateien (*.jpg; *.jpeg)", "jpeg", "jpg"));
                        }
                    } else if (string.equals("TIF")) {
                        if (treeSet.remove("TIFF")) {
                            arrayList.add(new FileNameExtensionFilter("TIFF-Dateien (*.tif; *.tiff)", "tiff", "tif"));
                        }
                    } else {
                        arrayList.add(new FileNameExtensionFilter(String.format("%s-Dateien (*.%s)", string, string.toLowerCase()), string));
                    }
                    treeSet.remove(string);
                }
                arrayList.add(IFFFile.getImageFileFilter());
                fileFilterArray = arrayList.toArray(new FileFilter[arrayList.size()]);
            }
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        return fileFilterArray;
    }

    private static void saveApp(File file, boolean bl, int n, byte[] ... byArray) throws IOException {
        FileFormat fileFormat = FileFormat.BIN;
        String string = "SHOWIMG COM";
        String string2 = file.getName();
        if (string2 != null) {
            if ((string2 = string2.toLowerCase()).endsWith(".hex")) {
                fileFormat = FileFormat.INTELHEX;
            } else if (string2.endsWith(".kcc")) {
                fileFormat = FileFormat.KCC;
            } else if (string2.endsWith(".rmc")) {
                fileFormat = FileFormat.RMC;
            } else if (string2.endsWith(".tap")) {
                fileFormat = bl ? FileFormat.KCTAP_Z9001 : FileFormat.KCTAP_KC85;
            } else if (string2.endsWith(".z80")) {
                fileFormat = FileFormat.HEADERSAVE;
                string = "ShowImage";
            }
        }
        int n2 = 0;
        for (byte[] byArray2 : byArray) {
            if (byArray2 == null) continue;
            n2 += byArray2.length;
        }
        FileSaver.saveFile(file, fileFormat, ImgSaver.createEmuMemView(n, byArray), n, n + n2 - 1, false, n, n, string, "C", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveKC85File(File file, int n, int n2, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            int n3;
            int n4;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10240);
            byteArrayOutputStream.write(kcUnpackBytes);
            int n5 = 0;
            while (n5 < 10240) {
                n4 = 1;
                n3 = 0;
                if (byArray != null && n5 < byArray.length) {
                    n3 = byArray[n5];
                }
                for (int i = n5 + 1; n4 < 256 && i < 10240; ++n4, ++i) {
                    int n6 = 0;
                    if (byArray != null && i < byArray.length) {
                        n6 = byArray[i];
                    }
                    if (n6 != n3) break;
                }
                if (n4 > 3 || n3 == 27) {
                    byteArrayOutputStream.write(27);
                    byteArrayOutputStream.write(n3);
                    byteArrayOutputStream.write(n4);
                    n5 += n4;
                    continue;
                }
                byteArrayOutputStream.write(n3);
                ++n5;
            }
            byteArrayOutputStream.close();
            if (byteArrayOutputStream.size() >= 10240) {
                byteArrayOutputStream = null;
            }
            fileOutputStream = new FileOutputStream(file);
            for (n4 = 0; n4 < 16; ++n4) {
                ((OutputStream)fileOutputStream).write(0);
            }
            if (n >= 0 || n2 >= 0) {
                ((OutputStream)fileOutputStream).write(2);
                ((OutputStream)fileOutputStream).write(255);
                ((OutputStream)fileOutputStream).write(63);
            } else {
                ((OutputStream)fileOutputStream).write(byteArrayOutputStream != null ? 3 : 2);
                ((OutputStream)fileOutputStream).write(0);
                ((OutputStream)fileOutputStream).write(64);
            }
            if (byteArrayOutputStream != null) {
                n4 = 16384 + byteArrayOutputStream.size();
                ((OutputStream)fileOutputStream).write(n4);
                ((OutputStream)fileOutputStream).write(n4 >> 8);
                ((OutputStream)fileOutputStream).write(0);
                ((OutputStream)fileOutputStream).write(64);
                for (n3 = 0; n3 < 105; ++n3) {
                    ((OutputStream)fileOutputStream).write(0);
                }
                if (n2 >= 0) {
                    ((OutputStream)fileOutputStream).write(n2);
                }
                byteArrayOutputStream.writeTo(fileOutputStream);
                n3 = byteArrayOutputStream.size();
                while ((n3 & 0x7F) != 0) {
                    ((OutputStream)fileOutputStream).write(0);
                    ++n3;
                }
            } else {
                ((OutputStream)fileOutputStream).write(0);
                ((OutputStream)fileOutputStream).write(104);
                for (n4 = 0; n4 < 107; ++n4) {
                    ((OutputStream)fileOutputStream).write(0);
                }
                if (n >= 0) {
                    ((OutputStream)fileOutputStream).write(n);
                }
                n4 = 0;
                if (byArray != null && (n4 = Math.min(byArray.length, 10240)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n4);
                }
                while (n4 < 10240) {
                    ((OutputStream)fileOutputStream).write(0);
                    ++n4;
                }
            }
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(fileOutputStream);
    }

    private static void throwInvalidKC854HiresFileSuffix() throws IOException {
        throw new IOException("Der Dateiname muss die Endung *.hif oder *.hip haben.");
    }

    private ImgSaver() {
    }
}

