/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;
import jkcemu.base.UserInputException;
import jkcemu.image.ColorReducer;
import jkcemu.image.Dithering;
import jkcemu.image.IFFFile;
import jkcemu.image.ImgEntry;
import jkcemu.image.ImgLoader;
import jkcemu.image.ImgUtil;
import jkcemu.image.JASCPaletteFile;

public class IndexColorsDlg
extends BaseDlg {
    private static Dithering.Algorithm[] dithAlgorithms = new Dithering.Algorithm[]{Dithering.Algorithm.FLOYD_STEINBERG, Dithering.Algorithm.SIERRA3, Dithering.Algorithm.ATKINSON};
    private static final int MODE_REDUCE_COLORS = 0;
    private static final int MODE_TO_A5105_COLORS = 1;
    private static final int MODE_TO_KC854HIRES_COLORS = 2;
    private static final int MODE_IMPORT_COLORTAB = 3;
    private static int lastColorTabMode = 0;
    private static int lastMaxColors = 256;
    private static int lastTransparencyMode = 0;
    private static int lastDitheringIndex = 0;
    private static File lastColorTabFile = null;
    private static IndexColorModel lastImportedColorTab = null;
    private BufferedImage image;
    private BufferedImage appliedImage;
    private IndexColorModel importedICM;
    private JRadioButton btnReduceColors;
    private JRadioButton btnToA5105Colors;
    private JRadioButton btnToKC854HiresColors;
    private JRadioButton btnImportColorTab;
    private JRadioButton btnTranspToWhite;
    private JRadioButton btnTranspToBlack;
    private JRadioButton btnTranspKeep;
    private JLabel labelMaxColors;
    private JLabel labelMaxColorsInfo;
    private JLabel labelTranspColor;
    private JLabel labelDithering;
    private JComboBox<Integer> comboMaxColors;
    private JComboBox<Object> comboDithering;
    private FileNameFld fldColorTabFile;
    private JButton btnColorTabSelect;
    private JButton btnApply;
    private JButton btnCancel;

    public static BufferedImage showDlg(Window window, BufferedImage bufferedImage) {
        IndexColorsDlg indexColorsDlg = new IndexColorsDlg(window, bufferedImage);
        indexColorsDlg.setVisible(true);
        return indexColorsDlg.appliedImage;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        try {
            Object object = eventObject.getSource();
            if (object == this.btnReduceColors || object == this.btnToA5105Colors || object == this.btnToKC854HiresColors || object == this.btnImportColorTab) {
                bl = true;
                this.updFieldsEnabled();
            } else if (object == this.btnColorTabSelect) {
                bl = true;
                this.doImportColorTabFile();
            } else if (object == this.btnApply) {
                bl = true;
                this.doApply();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            }
        }
        catch (IOException | UserInputException exception) {
            BaseDlg.showErrorDlg((Component)this, exception);
        }
        return bl;
    }

    private IndexColorsDlg(Window window, BufferedImage bufferedImage) {
        super(window, "Farben reduzieren und indexieren");
        this.image = bufferedImage;
        this.appliedImage = null;
        this.importedICM = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Farbpalette"));
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnReduceColors = new JRadioButton("Farbpalette ermitteln", lastColorTabMode == 0);
        buttonGroup.add(this.btnReduceColors);
        jPanel.add((Component)this.btnReduceColors, gridBagConstraints2);
        this.labelMaxColors = new JLabel("Max. Anzahl Farben:");
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.left = 50;
        gridBagConstraints2.gridwidth = 1;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.labelMaxColors, gridBagConstraints2);
        DefaultComboBoxModel<Integer> defaultComboBoxModel = new DefaultComboBoxModel<Integer>(){

            @Override
            public void addElement(Integer n) {
                if (n != null && n >= 2 && n <= 256) {
                    super.addElement(n);
                }
            }

            @Override
            public void insertElementAt(Integer n, int n2) {
                if (n != null && n >= 2 && n <= 256) {
                    super.insertElementAt(n, n2);
                }
            }
        };
        defaultComboBoxModel.addElement(256);
        defaultComboBoxModel.addElement(64);
        defaultComboBoxModel.addElement(32);
        defaultComboBoxModel.addElement(27);
        defaultComboBoxModel.addElement(16);
        defaultComboBoxModel.addElement(8);
        defaultComboBoxModel.addElement(4);
        defaultComboBoxModel.addElement(2);
        this.comboMaxColors = new JComboBox<Integer>(defaultComboBoxModel);
        this.comboMaxColors.setEditable(true);
        this.comboMaxColors.setSelectedItem(lastMaxColors);
        gridBagConstraints2.insets.left = 5;
        ++gridBagConstraints2.gridx;
        jPanel.add(this.comboMaxColors, gridBagConstraints2);
        this.labelMaxColorsInfo = new JLabel("inkl. Farbe f\u00fcr Transparenz");
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.labelMaxColorsInfo, gridBagConstraints2);
        this.btnToA5105Colors = new JRadioButton("A5105 (16 Farben)", lastColorTabMode == 1);
        buttonGroup.add(this.btnToA5105Colors);
        gridBagConstraints2.insets.left = 5;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnToA5105Colors, gridBagConstraints2);
        this.btnToKC854HiresColors = new JRadioButton("KC85/4 HIRES (4 Farben)", lastColorTabMode == 2);
        buttonGroup.add(this.btnToKC854HiresColors);
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnToKC854HiresColors, gridBagConstraints2);
        this.btnImportColorTab = new JRadioButton("Farbpalette importieren", lastColorTabMode == 3);
        buttonGroup.add(this.btnImportColorTab);
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnImportColorTab, gridBagConstraints2);
        this.fldColorTabFile = new FileNameFld();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets.left = 50;
        gridBagConstraints2.gridwidth = 3;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.fldColorTabFile, gridBagConstraints2);
        this.btnColorTabSelect = this.createImageButton("/images/file/open.png", "Ausw\u00e4hlen...");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets.left = 5;
        gridBagConstraints2.insets.bottom = 5;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx += 3;
        jPanel.add((Component)this.btnColorTabSelect, gridBagConstraints2);
        if (lastColorTabFile != null && lastImportedColorTab != null) {
            this.fldColorTabFile.setFile(lastColorTabFile);
            this.importedICM = lastImportedColorTab;
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Optionen"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.labelTranspColor = new JLabel("Transparenz:");
        jPanel2.add((Component)this.labelTranspColor, gridBagConstraints3);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnTranspToWhite = new JRadioButton("Transparente Bereiche hell f\u00e4rben");
        buttonGroup2.add(this.btnTranspToWhite);
        gridBagConstraints3.insets.top = 0;
        gridBagConstraints3.gridwidth = 0;
        ++gridBagConstraints3.gridx;
        jPanel2.add((Component)this.btnTranspToWhite, gridBagConstraints3);
        this.btnTranspToBlack = new JRadioButton("Transparente Bereiche dunkel f\u00e4rben");
        buttonGroup2.add(this.btnTranspToBlack);
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnTranspToBlack, gridBagConstraints3);
        this.btnTranspKeep = new JRadioButton("Transparenz behalten (1 volltransparente Farbe)");
        buttonGroup2.add(this.btnTranspKeep);
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.btnTranspKeep, gridBagConstraints3);
        if (lastTransparencyMode < 0) {
            this.btnTranspToBlack.setSelected(true);
        } else if (lastTransparencyMode > 0) {
            this.btnTranspToWhite.setSelected(true);
        } else {
            this.btnTranspKeep.setSelected(true);
        }
        if (bufferedImage.getTransparency() == 1) {
            this.labelTranspColor.setEnabled(false);
            this.btnTranspKeep.setEnabled(false);
            this.btnTranspToBlack.setEnabled(false);
            this.btnTranspToWhite.setEnabled(false);
        }
        this.labelDithering = new JLabel("Dithering:");
        gridBagConstraints3.insets.top = 5;
        gridBagConstraints3.gridx = 0;
        ++gridBagConstraints3.gridy;
        jPanel2.add((Component)this.labelDithering, gridBagConstraints3);
        this.comboDithering = new JComboBox();
        this.comboDithering.setEditable(false);
        this.comboDithering.addItem("Kein Dithering anwenden");
        for (Dithering.Algorithm algorithm : dithAlgorithms) {
            this.comboDithering.addItem(Dithering.getAlgorithmText(algorithm));
        }
        try {
            this.comboDithering.setSelectedIndex(lastDitheringIndex);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        gridBagConstraints3.gridwidth = 0;
        ++gridBagConstraints3.gridx;
        jPanel2.add(this.comboDithering, gridBagConstraints3);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel3, gridBagConstraints);
        this.btnApply = new JButton("OK");
        jPanel3.add(this.btnApply);
        this.btnCancel = new JButton("Abbrechen");
        jPanel3.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
        this.updFieldsEnabled();
        this.btnReduceColors.addActionListener(this);
        this.btnToA5105Colors.addActionListener(this);
        this.btnToKC854HiresColors.addActionListener(this);
        this.btnImportColorTab.addActionListener(this);
        this.btnApply.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    private void doApply() throws IOException, UserInputException {
        if (this.btnReduceColors.isSelected()) {
            this.doReduceColors();
            lastColorTabMode = 0;
        } else if (this.btnToA5105Colors.isSelected()) {
            this.doApplyIndexColorModel(ImgUtil.getColorModelA5105());
            lastColorTabMode = 1;
        } else if (this.btnToKC854HiresColors.isSelected()) {
            this.doApplyIndexColorModel(ImgUtil.getColorModelKC854Hires());
            lastColorTabMode = 2;
        } else if (this.btnImportColorTab.isSelected()) {
            if (this.fldColorTabFile.getFile() == null || this.importedICM == null) {
                this.doImportColorTabFile();
            }
            if (this.fldColorTabFile.getFile() != null && this.importedICM != null) {
                this.doApplyIndexColorModel(this.importedICM);
                lastColorTabMode = 3;
            }
        }
    }

    private void doApplyIndexColorModel(IndexColorModel indexColorModel) throws UserInputException {
        if (indexColorModel != null) {
            BufferedImage bufferedImage = null;
            BufferedImage bufferedImage2 = this.removeTransparency(this.image);
            Dithering.Algorithm algorithm = this.getSelectedDithAlgorithm();
            if (algorithm != null) {
                this.doClose();
                bufferedImage = Dithering.work(this.getOwner(), bufferedImage2, indexColorModel, algorithm);
            } else {
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), indexColorModel.getMapSize() > 16 ? 13 : 12, indexColorModel);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage((Image)bufferedImage2, 0, 0, this);
                graphics2D.dispose();
                this.doClose();
            }
            if (bufferedImage != null) {
                this.appliedImage = bufferedImage;
            }
        }
    }

    public void doImportColorTabFile() throws IOException {
        Object object;
        Object[] objectArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = ImageIO.getReaderFileSuffixes();
        if (stringArray != null) {
            objectArray = new String[]{"bmp", "gif", "png", "tif", "tiff"};
            object = stringArray;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                String string = object[i];
                if (Arrays.binarySearch(objectArray, string = string.toString()) < 0) continue;
                arrayList.add(string);
            }
        }
        if ((objectArray = this.fldColorTabFile.getFile()) == null) {
            objectArray = Main.getLastDirFile("image");
        }
        if ((object = EmuUtil.showFileOpenDlg(this, "Farbpalette importieren", (File)objectArray, ImgUtil.createFileFilter("Unterst\u00fctzte Farbpaletten- und Bilddateien", arrayList.toArray(new String[arrayList.size()]), IFFFile.getFileSuffixes(), JASCPaletteFile.getFileSuffixes()))) != null) {
            IndexColorModel indexColorModel = null;
            if (IFFFile.accept((File)object)) {
                indexColorModel = IFFFile.readPalette((File)object);
            } else if (JASCPaletteFile.accept((File)object)) {
                indexColorModel = JASCPaletteFile.read((File)object);
            } else {
                ImgEntry imgEntry = ImgLoader.load((File)object);
                if (imgEntry != null) {
                    indexColorModel = ImgUtil.getIndexColorModel(imgEntry.getImage());
                }
            }
            if (indexColorModel != null) {
                this.importedICM = indexColorModel;
                this.fldColorTabFile.setFile((File)object);
                lastImportedColorTab = indexColorModel;
                lastColorTabFile = object;
            }
        }
    }

    private void doReduceColors() {
        Object object = this.comboMaxColors.getSelectedItem();
        if (object != null) {
            int n = 0;
            if (object instanceof Integer) {
                n = (Integer)object;
            } else {
                try {
                    n = Integer.parseInt(object.toString().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n >= 2 && n <= 256) {
                int n2 = -1;
                boolean bl = true;
                IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(this.image);
                if (indexColorModel != null && (n2 = indexColorModel.getMapSize()) <= n) {
                    bl = BaseDlg.showYesNoDlg(this, String.format("Das Bild hat bereits ein indexiertes Farbmodell mit %d Farben.\nM\u00f6glicherweise werden nicht alle diese Farben verwendet,\nso dass die Farbpalette vielleicht verkleinert werden kann.\nM\u00f6chten Sie versuchen, die Farbpalette zu verkleinern?", n2));
                }
                if (bl) {
                    Dithering.Algorithm algorithm = this.getSelectedDithAlgorithm();
                    Color color = this.getSelectedColorForTransp();
                    lastMaxColors = n;
                    this.btnApply.setEnabled(false);
                    this.doClose();
                    BufferedImage bufferedImage = ColorReducer.work(this.getOwner(), "Reduziere Farben...", this.image, n, color, algorithm);
                    if (bufferedImage != null && n2 > 0 && (indexColorModel = ImgUtil.getIndexColorModel(bufferedImage)) != null && indexColorModel.getMapSize() >= n2) {
                        bufferedImage = null;
                        BaseDlg.showErrorDlg((Component)this.getOwner(), "Die Anzahl der Farben konnte nicht reduziert werden.");
                    }
                    if (bufferedImage != null) {
                        this.appliedImage = bufferedImage;
                    }
                }
            } else {
                this.comboMaxColors.setSelectedItem(lastMaxColors);
            }
        }
    }

    private Color getSelectedColorForTransp() {
        Color color = null;
        if (this.btnTranspToBlack.isSelected()) {
            color = Color.BLACK;
            lastTransparencyMode = -1;
        } else if (this.btnTranspToWhite.isSelected()) {
            color = Color.WHITE;
            lastTransparencyMode = 1;
        } else {
            lastTransparencyMode = 0;
        }
        return color;
    }

    private Dithering.Algorithm getSelectedDithAlgorithm() {
        Dithering.Algorithm algorithm = null;
        lastDitheringIndex = this.comboDithering.getSelectedIndex();
        if (lastDitheringIndex > 0 && lastDitheringIndex <= dithAlgorithms.length) {
            algorithm = dithAlgorithms[lastDitheringIndex - 1];
        }
        return algorithm;
    }

    private BufferedImage removeTransparency(BufferedImage bufferedImage) throws UserInputException {
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage.getTransparency() != 1) {
            Color color = this.getSelectedColorForTransp();
            if (color == null) {
                throw new UserInputException("Bei dieser Funktion ist die Option\n'" + this.btnTranspKeep.getText() + "' nicht m\u00f6glich,\n" + "da die Farbpalette keine transparenten Farben" + " enth\u00e4lt.\n" + "W\u00e4hlen Sie bitte die Option\n'" + this.btnTranspToWhite.getText() + "' oder\n'" + this.btnTranspToBlack.getText() + "' aus!");
            }
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            if (n > 0 && n2 > 0) {
                BufferedImage bufferedImage3 = new BufferedImage(n, n2, 5);
                Graphics2D graphics2D = bufferedImage3.createGraphics();
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.drawImage((Image)bufferedImage, 0, 0, this);
                graphics2D.dispose();
                bufferedImage = bufferedImage3;
            }
        }
        return bufferedImage;
    }

    private void updFieldsEnabled() {
        boolean bl = this.btnReduceColors.isSelected();
        this.labelMaxColors.setEnabled(bl);
        this.comboMaxColors.setEnabled(bl);
        this.labelMaxColorsInfo.setEnabled(bl && this.labelTranspColor.isEnabled());
        bl = this.btnImportColorTab.isSelected();
        this.fldColorTabFile.setEnabled(bl);
        this.btnColorTabSelect.setEnabled(bl);
    }
}

