/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.image.IndexColorModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.filechooser.FileNameExtensionFilter;
import jkcemu.base.EmuUtil;
import jkcemu.image.ImgUtil;

public class JASCPaletteFile {
    private static final String MAGIC = "JASC-PAL";
    private static final String[] fileSuffixes = new String[]{"pal"};
    private static FileNameExtensionFilter fileFilter = null;

    public static boolean accept(File file) {
        return EmuUtil.accept(file, fileSuffixes);
    }

    public static FileNameExtensionFilter getFileFilter() {
        if (fileFilter == null) {
            fileFilter = ImgUtil.createFileFilter("Paintshop Pro Farbpalettendatei", new String[][]{fileSuffixes});
        }
        return fileFilter;
    }

    public static String[] getFileSuffixes() {
        return fileSuffixes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexColorModel read(File file) throws IOException {
        IndexColorModel indexColorModel = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            if (string == null) {
                EmuUtil.throwUnsupportedFileFormat();
            }
            if (!string.equals(MAGIC)) {
                EmuUtil.throwUnsupportedFileFormat();
            }
            bufferedReader.readLine();
            string = bufferedReader.readLine();
            if (string == null) {
                EmuUtil.throwUnsupportedFileFormat();
            }
            try {
                int n = Integer.parseInt(string.trim());
                if (n < 1) {
                    EmuUtil.throwUnsupportedFileFormat();
                }
                byte[] byArray = new byte[n];
                byte[] byArray2 = new byte[n];
                byte[] byArray3 = new byte[n];
                for (int i = 0; i < n; ++i) {
                    int n2;
                    String[] stringArray;
                    string = bufferedReader.readLine();
                    if (string == null) {
                        EmuUtil.throwUnsupportedFileFormat();
                    }
                    if ((stringArray = string.split("\\s")) == null) {
                        EmuUtil.throwUnsupportedFileFormat();
                    }
                    if (stringArray.length != 3) {
                        EmuUtil.throwUnsupportedFileFormat();
                    }
                    if ((n2 = Integer.parseInt(stringArray[0].trim())) < 0 || n2 > 255) {
                        EmuUtil.throwUnsupportedFileFormat();
                    }
                    byArray[i] = (byte)n2;
                    int n3 = Integer.parseInt(stringArray[1].trim());
                    if (n3 < 0 || n3 > 255) {
                        EmuUtil.throwUnsupportedFileFormat();
                    }
                    byArray2[i] = (byte)n3;
                    int n4 = Integer.parseInt(stringArray[2].trim());
                    if (n4 < 0 || n4 > 255) {
                        EmuUtil.throwUnsupportedFileFormat();
                    }
                    byArray3[i] = (byte)n4;
                }
                indexColorModel = ImgUtil.createIndexColorModel(n, byArray, byArray2, byArray3, null);
            }
            catch (NumberFormatException numberFormatException) {
                EmuUtil.throwUnsupportedFileFormat();
            }
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(bufferedReader);
            throw throwable;
        }
        EmuUtil.closeSilent(bufferedReader);
        if (indexColorModel == null) {
            ImgUtil.throwNoColorTab();
        }
        return indexColorModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, IndexColorModel indexColorModel) throws IOException {
        FileWriter fileWriter = null;
        try {
            int n = indexColorModel.getMapSize();
            fileWriter = new FileWriter(file);
            fileWriter.write(MAGIC);
            JASCPaletteFile.writeNewLine(fileWriter);
            fileWriter.write("0100");
            JASCPaletteFile.writeNewLine(fileWriter);
            fileWriter.write(String.valueOf(n));
            JASCPaletteFile.writeNewLine(fileWriter);
            for (int i = 0; i < n; ++i) {
                int n2 = indexColorModel.getRGB(i);
                fileWriter.write(String.format("%d %d %d", n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF));
                JASCPaletteFile.writeNewLine(fileWriter);
            }
            ((Writer)fileWriter).close();
            fileWriter = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileWriter);
            throw throwable;
        }
        EmuUtil.closeSilent(fileWriter);
    }

    private JASCPaletteFile() {
    }

    private static void writeNewLine(Writer writer) throws IOException {
        writer.write("\r\n");
    }
}

