/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.util.Arrays;
import jkcemu.base.EmuUtil;
import z80emu.Z80CPU;
import z80emu.Z80Memory;
import z80emu.Z80PCListener;
import z80emu.Z80TStatesListener;

public class KC85ImgUnpacker
implements Z80Memory,
Z80PCListener,
Z80TStatesListener {
    private boolean cancelled = false;
    private long totalTStates = 0L;
    private Z80CPU cpu = new Z80CPU(this, null);
    private byte[] memory = new byte[65536];

    public KC85ImgUnpacker() {
        Arrays.fill(this.memory, (byte)-1);
    }

    public synchronized boolean unpack(int n) {
        this.cancelled = false;
        this.totalTStates = 0L;
        this.cpu.addPCListener(this, 56);
        this.cpu.addTStatesListener(this);
        this.cpu.setRegSP(0);
        this.cpu.setRegPC(n);
        this.cpu.run();
        this.cpu.removeTStatesListener(this);
        this.cpu.removePCListener(this);
        return !this.cancelled;
    }

    @Override
    public void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        this.totalTStates += (long)n;
        if (this.totalTStates > 2000000L) {
            this.cancelled = true;
            this.cpu.fireExit();
        }
    }

    @Override
    public int getMemByte(int n, boolean bl) {
        return this.memory[n & 0xFFFF] & 0xFF;
    }

    @Override
    public int getMemWord(int n) {
        return EmuUtil.getWord(this.memory, n & 0xFFFF);
    }

    @Override
    public boolean setMemByte(int n, int n2) {
        this.memory[n & 0xFFFF] = (byte)n2;
        return true;
    }

    @Override
    public int readMemByte(int n, boolean bl) {
        return this.getMemByte(n, bl);
    }

    @Override
    public void writeMemByte(int n, int n2) {
        this.setMemByte(n, n2);
    }

    @Override
    public void z80PCChanged(Z80CPU z80CPU, int n) {
        this.cpu.fireExit();
    }
}

