/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class LZWEncoder {
    private static final int BITS = 12;
    private static final int MAX_MAX_CODE = 4096;
    private static final int HASH_SIZE = 5003;
    private static final int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    private byte[] dataBuf;
    private int initBits;
    private int initCodeSize;
    private int curAcc = 0;
    private int curBits = 0;
    private int clearCode = 0;
    private int eofCode = 0;
    private int freeEntry = 0;
    private int nBits = 0;
    private int dataPos = 0;
    private int maxCode = 0;
    private int outPos = 0;
    private boolean clearFlag = false;
    private byte[] outBuf = new byte[256];
    private int[] codeTab = new int[5003];
    private int[] hashTab = new int[5003];
    private OutputStream out;

    public LZWEncoder(byte[] byArray, int n) {
        this.dataBuf = byArray;
        this.initCodeSize = n;
        this.initBits = this.initCodeSize + 1;
    }

    public void encode(OutputStream outputStream) throws IOException {
        int n;
        this.out = outputStream;
        this.outPos = 0;
        this.dataPos = 0;
        this.freeEntry = 0;
        this.clearFlag = false;
        this.nBits = this.initBits;
        this.maxCode = LZWEncoder.getMaxCode(this.nBits);
        this.clearCode = 1 << this.initBits - 1;
        this.eofCode = this.clearCode + 1;
        this.freeEntry = this.clearCode + 2;
        this.out.write(this.initCodeSize);
        int n2 = 0;
        for (n = 5003; n < 65536; n *= 2) {
            ++n2;
        }
        n2 = 8 - n2;
        n = 5003;
        this.clearHash(n);
        this.writeCode(this.clearCode);
        int n3 = this.nextByte();
        int n4 = this.nextByte();
        while (n4 >= 0) {
            boolean bl = false;
            int n5 = n4 << n2 ^ n3;
            int n6 = (n4 << 12) + n3;
            if (this.hashTab[n5] == n6) {
                n3 = this.codeTab[n5];
                bl = true;
            } else if (this.hashTab[n5] >= 0) {
                int n7 = n - n5;
                if (n5 == 0) {
                    n7 = 1;
                }
                do {
                    if ((n5 -= n7) < 0) {
                        n5 += n;
                    }
                    if (this.hashTab[n5] != n6) continue;
                    n3 = this.codeTab[n5];
                    bl = true;
                    break;
                } while (this.hashTab[n5] >= 0);
            }
            if (!bl) {
                this.writeCode(n3);
                n3 = n4;
                if (this.freeEntry < 4096) {
                    ++this.freeEntry;
                    this.hashTab[n5] = n6;
                } else {
                    this.clearBlock();
                }
            }
            n4 = this.nextByte();
        }
        this.writeCode(n3);
        this.writeCode(this.eofCode);
        this.out.write(0);
    }

    private void clearBlock() throws IOException {
        this.clearHash(5003);
        this.freeEntry = this.clearCode + 2;
        this.clearFlag = true;
        this.writeCode(this.clearCode);
    }

    private void clearHash(int n) {
        if (n < this.hashTab.length) {
            Arrays.fill(this.hashTab, 0, n, -1);
        } else {
            Arrays.fill(this.hashTab, -1);
        }
    }

    private void flushBuf() throws IOException {
        if (this.outPos > 0) {
            this.out.write(this.outPos);
            this.out.write(this.outBuf, 0, this.outPos);
            this.outPos = 0;
        }
    }

    private static int getMaxCode(int n) {
        return (1 << n) - 1;
    }

    private int nextByte() {
        int n = -1;
        if (this.dataPos < this.dataBuf.length) {
            n = this.dataBuf[this.dataPos++] & 0xFF;
        }
        return n;
    }

    private void putByte(int n) throws IOException {
        this.outBuf[this.outPos++] = (byte)n;
        if (this.outPos >= 254) {
            this.flushBuf();
        }
    }

    private void writeCode(int n) throws IOException {
        this.curAcc &= masks[this.curBits];
        this.curAcc = this.curBits > 0 ? (this.curAcc |= n << this.curBits) : n;
        this.curBits += this.nBits;
        while (this.curBits >= 8) {
            this.putByte(this.curAcc & 0xFF);
            this.curAcc >>= 8;
            this.curBits -= 8;
        }
        if (this.freeEntry > this.maxCode || this.clearFlag) {
            if (this.clearFlag) {
                this.nBits = this.initBits;
                this.maxCode = LZWEncoder.getMaxCode(this.nBits);
                this.clearFlag = false;
            } else {
                ++this.nBits;
                this.maxCode = this.nBits == 12 ? 4096 : LZWEncoder.getMaxCode(this.nBits);
            }
        }
        if (n == this.eofCode) {
            while (this.curBits > 0) {
                this.putByte(this.curAcc & 0xFF);
                this.curAcc >>= 8;
                this.curBits -= 8;
            }
            this.flushBuf();
        }
    }
}

