/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import jkcemu.image.GrayScaler;

public class OcTree {
    private static final int MIN_COLOR_MASK = 4;
    private Node root = new Node(null, 128);
    private Set<Integer> allRGBs = new TreeSet<Integer>();
    private Integer darkestRGB = null;
    private Integer darkestGray = null;
    private int leafCnt = 0;

    public void putPixel(int n) {
        this.root.putPixel(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
        if (this.allRGBs != null) {
            this.allRGBs.add(n & 0xFFFFFF);
            if (this.allRGBs.size() > 256) {
                this.allRGBs = null;
            }
        }
        int n2 = GrayScaler.toGray(n) & 0xFF;
        if (this.darkestGray != null) {
            if (n2 < this.darkestGray) {
                this.darkestRGB = n;
                this.darkestGray = n2;
            }
        } else {
            this.darkestRGB = n;
            this.darkestGray = n2;
        }
    }

    public int[] reduceColors(int n) {
        int n2;
        int[] nArray = null;
        if (this.allRGBs != null && (n2 = this.allRGBs.size()) > 0 && n2 <= n) {
            nArray = new int[n2];
            int n3 = 0;
            for (Integer n4 : this.allRGBs) {
                if (n3 >= n2) {
                    nArray = null;
                    break;
                }
                nArray[n3++] = 0xFF000000 | n4;
            }
        }
        if (nArray == null) {
            n2 = n;
            if (this.darkestRGB != null) {
                --n2;
            }
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (n2 > 0) {
                this.reduceTreeLeafs(n2, arrayList);
            }
            int n5 = arrayList.size();
            if (this.darkestRGB != null) {
                ++n5;
            }
            if (n5 > n) {
                n5 = n;
            }
            if (n5 > 0) {
                nArray = new int[n5];
                int n6 = 0;
                for (Node node : arrayList) {
                    if (n6 >= nArray.length) break;
                    double d = node.pixelCnt;
                    int n7 = (int)Math.round((double)node.totalR / d);
                    int n8 = (int)Math.round((double)node.totalG / d);
                    int n9 = (int)Math.round((double)node.totalB / d);
                    nArray[n6++] = 0xFF000000 | (n7 << 16 & 0xFF0000 | n8 << 8 & 0xFF00 | n9 & 0xFF);
                }
                if (n6 < nArray.length && this.darkestRGB != null) {
                    nArray[n6++] = 0xFF000000 | this.darkestRGB;
                }
            }
        }
        if (nArray != null) {
            Arrays.sort(nArray);
        }
        return nArray;
    }

    private void addLeafCount(int n) {
        this.leafCnt += n;
    }

    private int getLeafCount() {
        return this.leafCnt;
    }

    private void incLeafCount() {
        ++this.leafCnt;
    }

    private void reduceTreeLeafs(int n, List<Node> list) {
        for (int i = 4; this.leafCnt > n && i < 256; i <<= 1) {
            Node node;
            while (this.leafCnt > n && (node = this.root.getMinPixelsParent(i)) != null) {
                node.reduce(n);
            }
        }
        this.root.getLeafs(list);
    }

    private class Node {
        private Node parent;
        private int colorMask;
        private int pixelCnt;
        private long totalR;
        private long totalG;
        private long totalB;
        private Node[] subNodes;

        private Node(Node node, int n) {
            this.parent = node;
            this.colorMask = n;
            this.pixelCnt = 0;
            this.totalR = 0L;
            this.totalG = 0L;
            this.totalB = 0L;
            if (n == 4) {
                OcTree.this.incLeafCount();
                this.subNodes = null;
            } else {
                this.subNodes = new Node[8];
                Arrays.fill(this.subNodes, null);
            }
        }

        private void getLeafs(Collection<Node> collection) {
            if (this.subNodes != null) {
                for (int i = 0; i < this.subNodes.length; ++i) {
                    if (this.subNodes[i] == null) continue;
                    this.subNodes[i].getLeafs(collection);
                }
            } else {
                collection.add(this);
            }
        }

        private Node getMinPixelsParent(int n) {
            Node node = null;
            if (this.subNodes != null) {
                int n2 = -1;
                for (int i = 0; i < this.subNodes.length; ++i) {
                    Node node2;
                    if (this.subNodes[i] == null || (node2 = this.subNodes[i].getMinPixelsParent(n)) == null) continue;
                    int n3 = node2.pixelCnt;
                    if (node != null && n2 >= 0) {
                        if (n3 >= n2) continue;
                        node = node2;
                        n2 = n3;
                        continue;
                    }
                    node = node2;
                    n2 = n3;
                }
                if (node == null && (n == 0 || n == this.colorMask)) {
                    node = this;
                }
            }
            return node;
        }

        private void putPixel(int n, int n2, int n3) {
            ++this.pixelCnt;
            this.totalR += (long)n;
            this.totalG += (long)n2;
            this.totalB += (long)n3;
            if (this.subNodes != null) {
                int n4 = 0;
                if ((n & this.colorMask) != 0) {
                    n4 += 4;
                }
                if ((n2 & this.colorMask) != 0) {
                    n4 += 2;
                }
                if ((n3 & this.colorMask) != 0) {
                    ++n4;
                }
                if (this.subNodes[n4] == null) {
                    this.subNodes[n4] = new Node(this, this.colorMask >> 1);
                }
                this.subNodes[n4].putPixel(n, n2, n3);
            }
        }

        private void reduce(int n) {
            if (this.subNodes != null) {
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < this.subNodes.length; ++n2) {
                    if (this.subNodes[n2] == null) continue;
                    ++n3;
                }
                if (OcTree.this.getLeafCount() - n3 + 1 >= n) {
                    for (n2 = 0; n2 < this.subNodes.length; ++n2) {
                        if (this.subNodes[n2] == null) continue;
                        this.subNodes[n2].reduce(n);
                    }
                    this.subNodes = null;
                    OcTree.this.addLeafCount(1 - n3);
                } else {
                    Node node = null;
                    long l = 0L;
                    long l2 = 0L;
                    long l3 = 0L;
                    int n4 = 0;
                    for (int i = 0; i < this.subNodes.length; ++i) {
                        node = this.subNodes[i];
                        if (node == null) continue;
                        node.reduce(n);
                        l += node.totalR;
                        l2 += node.totalG;
                        l3 += node.totalB;
                        n4 += node.pixelCnt;
                        this.subNodes[i] = null;
                        OcTree.this.addLeafCount(-1);
                        if (OcTree.this.getLeafCount() < n) break;
                    }
                    if (n4 > 0) {
                        node = new Node(this, 4);
                        node.colorMask = this.colorMask >> 1;
                        node.totalR = l;
                        node.totalG = l2;
                        node.totalB = l3;
                        node.pixelCnt = n4;
                        this.subNodes[0] = node;
                    }
                }
            }
        }
    }
}

