/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.image.ImageFrm;
import jkcemu.image.ImgFld;
import jkcemu.image.ImgUtil;

public class RotateDlg
extends BaseDlg
implements ChangeListener {
    private static final int MIN_DEGREES = -180;
    private static final int MAX_DEGREES = 180;
    private static final Object[][] backgrounds = new Object[][]{{"transparent", new Color(128, 128, 128, 0)}, {"wei\u00df", Color.WHITE}, {"grau", Color.GRAY}, {"schwarz", Color.BLACK}};
    private static boolean suppressIndexedColorsMsg = false;
    private static int lastBgColorIdx = 0;
    private ImageFrm imageFrm;
    private ImgFld imgFld;
    private BufferedImage appliedImg;
    private BufferedImage orgImg;
    private BufferedImage previewImg;
    private JSlider slider;
    private JSpinner spinner;
    private JComboBox<Object> comboBackground;
    private JButton btnApply;
    private JButton btnCancel;

    public static BufferedImage showDlg(ImageFrm imageFrm) {
        RotateDlg rotateDlg = new RotateDlg(imageFrm);
        rotateDlg.setVisible(true);
        return rotateDlg.appliedImg;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.slider) {
            this.spinner.removeChangeListener(this);
            this.spinner.setValue(this.slider.getValue());
            this.spinner.addChangeListener(this);
            this.updPreview();
        } else if (object == this.spinner) {
            this.slider.removeChangeListener(this);
            this.slider.setValue(Math.round(EmuUtil.getFloat(this.spinner)));
            this.slider.addChangeListener(this);
            this.updPreview();
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object == this.comboBackground) {
            bl = true;
            this.updPreview();
        } else if (object == this.btnCancel) {
            bl = true;
            this.doClose();
        } else if (object == this.btnApply) {
            bl = true;
            this.doApply();
        }
        return bl;
    }

    private RotateDlg(ImageFrm imageFrm) {
        super((Window)imageFrm, "Drehen");
        this.imageFrm = imageFrm;
        this.imgFld = imageFrm.getImgFld();
        this.appliedImg = null;
        this.orgImg = this.imgFld.getImage();
        this.previewImg = this.imgFld.getNewPreviewImage();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.add((Component)jPanel, gridBagConstraints);
        jPanel.add(new JLabel("Winkel:"));
        jPanel.add(Box.createHorizontalStrut(5));
        this.spinner = new JSpinner(new SpinnerNumberModel(0.0, -180.0, 180.0, 0.25));
        jPanel.add(this.spinner);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(new JLabel("Grad"));
        this.slider = new JSlider(0, -180, 180, 0);
        this.slider.setLabelTable(this.slider.createStandardLabels(90));
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setPaintTrack(true);
        this.slider.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        this.add((Component)this.slider, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        jPanel2.add(new JLabel("Hintergrund:"));
        jPanel2.add(Box.createHorizontalStrut(5));
        this.comboBackground = new JComboBox();
        this.comboBackground.setEditable(false);
        for (Object[] objectArray : backgrounds) {
            this.comboBackground.addItem(objectArray[0]);
        }
        jPanel2.add(this.comboBackground);
        try {
            this.comboBackground.setSelectedIndex(lastBgColorIdx);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 5, 5));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel3, gridBagConstraints);
        this.btnApply = new JButton("Anwenden");
        jPanel3.add(this.btnApply);
        this.btnCancel = new JButton("Abbrechen");
        jPanel3.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
        this.imgFld.setRotation(ImgFld.Rotation.NONE);
        this.updPreview();
        imageFrm.fireFitImage();
        this.slider.addChangeListener(this);
        this.spinner.addChangeListener(this);
        this.comboBackground.addActionListener(this);
        this.btnApply.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    private BufferedImage createRotatedImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = null;
        if (bufferedImage != null) {
            int n;
            int n2;
            int n3;
            IndexColorModel indexColorModel;
            Object object;
            Color color = null;
            int n4 = this.comboBackground.getSelectedIndex();
            if (n4 >= 0 && n4 < backgrounds.length && (object = backgrounds[n4][1]) != null && object instanceof Color) {
                color = (Color)object;
            }
            int n5 = 2;
            if (color != null && color.getAlpha() > 128) {
                n5 = 5;
            }
            if (color == null) {
                color = ImgUtil.transparentColor;
            }
            if ((indexColorModel = ImgUtil.getIndexColorModel(bufferedImage)) != null) {
                n3 = 0;
                n2 = indexColorModel.getMapSize();
                for (n = 0; n < n2; ++n) {
                    if (indexColorModel.getRGB(n) != color.getRGB()) continue;
                    n3 = 1;
                    break;
                }
                if (n3 != 0) {
                    n5 = n2 > 16 ? 13 : 12;
                } else {
                    indexColorModel = null;
                }
            }
            n3 = bufferedImage.getWidth();
            n2 = bufferedImage.getHeight();
            n = -(n3 / 2);
            int n6 = -(n2 / 2);
            int n7 = (int)Math.round(Math.sqrt(n3 * n3 / 4 + n2 * n2 / 4));
            int n8 = 2 * n7;
            bufferedImage2 = indexColorModel != null ? new BufferedImage(n8, n8, n5, indexColorModel) : new BufferedImage(n8, n8, n5);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, n8, n8);
            }
            if (graphics2D instanceof Graphics2D) {
                ((Graphics)graphics2D).translate(n7, n7);
                graphics2D.rotate(this.getRotateAngle());
                graphics2D.drawImage((Image)bufferedImage, n, n6, this);
                graphics2D.dispose();
            }
        }
        return bufferedImage2;
    }

    private void doApply() {
        BufferedImage bufferedImage = this.createRotatedImage(this.orgImg);
        if (this.orgImg != null && bufferedImage != null) {
            int n = this.orgImg.getWidth();
            int n2 = this.orgImg.getHeight();
            int n3 = -(n / 2);
            int n4 = -(n2 / 2);
            int n5 = (int)Math.round(Math.sqrt(n * n / 4 + n2 * n2 / 4));
            double d = Math.sqrt(n * n / 4 + n2 * n2 / 4);
            double d2 = Math.asin((double)n4 / d);
            double d3 = this.getRotateAngle();
            double d4 = d2 - d3;
            double d5 = Math.sin(d4) * d;
            double d6 = Math.sqrt(d * d - d5 * d5);
            double d7 = d2 + d3;
            double d8 = Math.sin(d7) * d;
            double d9 = Math.sqrt(d * d - d8 * d8);
            double d10 = Math.abs(d6);
            double d11 = Math.abs(d5);
            double d12 = Math.abs(d9);
            double d13 = Math.abs(d8);
            d6 = -d10;
            d5 = -d11;
            d9 = -d12;
            d8 = -d13;
            int n6 = (int)Math.round(Math.min(d6, d9));
            int n7 = (int)Math.round(Math.min(d5, d8));
            int n8 = (int)Math.round(Math.max(d10, d12)) - n6;
            int n9 = (int)Math.round(Math.max(d11, d13)) - n7;
            int n10 = 2 * n5;
            n7 += n5;
            if ((n6 += n5) < 0) {
                n6 = 0;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            if (n8 > n10) {
                n6 = n10;
            }
            if (n7 > n10) {
                n7 = n10;
            }
            this.appliedImg = bufferedImage.getSubimage(n6, n7, n8, n9);
            lastBgColorIdx = this.comboBackground.getSelectedIndex();
            this.doClose();
            IndexColorModel indexColorModel = ImgUtil.getIndexColorModel(this.orgImg);
            if (indexColorModel != null && ImgUtil.getIndexColorModel(bufferedImage) == null && !suppressIndexedColorsMsg) {
                StringBuilder stringBuilder = new StringBuilder(512);
                stringBuilder.append("Das urspr\u00fcngliche Bild hat ein indexiertes Farbmodell mit ");
                stringBuilder.append(indexColorModel.getMapSize());
                stringBuilder.append(" Farben.\nDurch die Drehung ist eine zus\u00e4tzliche Farbe f\u00fcr den Hintergrund hinzugekommen.\nDadurch hat das gedrehte Bild kein indexiertes Farbmodel mehr.\nFalls Sie jedoch eins ben\u00f6tigen, k\u00f6nnen Sie mit dem Men\u00fcpunkt\n");
                stringBuilder.append(this.imageFrm.getMenuPathTextReduceColors());
                stringBuilder.append("\nwieder eins erzeugen.");
                JCheckBox jCheckBox = new JCheckBox("Diesen Hinweis zuk\u00fcnftig nicht mehr anzeigen", false);
                JOptionPane.showMessageDialog(this.imageFrm, new Object[]{stringBuilder.toString(), jCheckBox}, "Hinweis", 1);
                suppressIndexedColorsMsg = jCheckBox.isSelected();
            }
        }
    }

    private double getRotateAngle() {
        return (double)EmuUtil.getFloat(this.spinner) / 180.0 * Math.PI;
    }

    private void updPreview() {
        BufferedImage bufferedImage = this.createRotatedImage(this.previewImg);
        if (bufferedImage != null) {
            this.imgFld.setImage(bufferedImage);
            this.imgFld.repaint();
        }
    }
}

