/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.image;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.filechooser.FileSystemView;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;
import jkcemu.base.ScreenFrm;
import jkcemu.image.AnimatedGIFWriter;
import jkcemu.image.VideoPlayFrm;

public class VideoCaptureFrm
extends BaseFrm
implements Runnable {
    private static final String DEFAULT_STATUS_TEXT = "Bereit";
    private static VideoCaptureFrm instance = null;
    private ScreenFrm screenFrm;
    private volatile boolean pause;
    private volatile boolean focusedWindowOnly;
    private volatile boolean waitForReset;
    private volatile boolean running;
    private volatile long recordedMillis;
    private int waitForWindowMillis;
    private volatile int frameMillis;
    private volatile int captureWidth;
    private volatile int captureHeight;
    private volatile boolean capturing;
    private volatile Window captureWindow;
    private boolean fileCheckEnabled;
    private Robot robot;
    private Thread thread;
    private VideoPlayFrm videoPlayFrm;
    private Timer statusTimer;
    private JRadioButton btnCaptureEmuSysScreen;
    private JRadioButton btnCaptureScreenFrm;
    private JRadioButton btnCaptureOtherWindow;
    private JLabel labelWinSelectTime;
    private JLabel labelWinSelectUnit;
    private JSpinner spinnerWinSelectSec;
    private JLabel labelFramesPerSec;
    private JComboBox<Integer> comboFramesPerSec;
    private JLabel labelColorReduction;
    private JRadioButton btnColorReductionSmooth;
    private JRadioButton btnColorReductionHard;
    private JLabel labelPlayCnt;
    private JRadioButton btnPlayOnce;
    private JRadioButton btnPlayInfinite;
    private JCheckBox btnStartAfterReset;
    private JCheckBox btnFocusedWindowOnly;
    private FileNameFld fldFile;
    private JLabel labelStatus;
    private JButton btnFileSelect;
    private JButton btnRecord;
    private JButton btnPause;
    private JButton btnStop;
    private JButton btnPlay;
    private JButton btnClose;

    public static void open(ScreenFrm screenFrm) {
        if (instance == null) {
            instance = new VideoCaptureFrm(screenFrm);
        }
        EmuUtil.showFrame(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Exception exception;
        block17: {
            this.recordedMillis = 0L;
            boolean bl = false;
            exception = null;
            File file = this.fldFile.getFile();
            if (file == null) break block17;
            object = null;
            try {
                boolean bl2 = true;
                if (this.btnColorReductionSmooth != null) {
                    bl2 = this.btnColorReductionSmooth.isSelected();
                }
                object = new BufferedOutputStream(new FileOutputStream(file));
                AnimatedGIFWriter animatedGIFWriter = new AnimatedGIFWriter((OutputStream)object, bl2, this.btnPlayInfinite.isSelected());
                long l = System.currentTimeMillis();
                long l2 = 0L;
                try {
                    while (this.running) {
                        long l3 = l + (l2 += (long)this.frameMillis) - System.currentTimeMillis();
                        if (l3 > 0L) {
                            Thread.sleep(l3);
                        }
                        if (this.pause || this.waitForReset) continue;
                        BufferedImage bufferedImage = null;
                        if (this.focusedWindowOnly) {
                            Window window = this.captureWindow;
                            if (window != null && window.isFocused()) {
                                bufferedImage = this.createSnapshot();
                                if (!window.isFocused()) {
                                    bufferedImage = null;
                                }
                            }
                        } else {
                            bufferedImage = this.createSnapshot();
                        }
                        if (bufferedImage != null) {
                            animatedGIFWriter.addFrame(this.frameMillis, bufferedImage);
                            this.recordedMillis += (long)this.frameMillis;
                            this.capturing = true;
                            continue;
                        }
                        this.capturing = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!animatedGIFWriter.finish()) {
                    bl = true;
                }
                ((OutputStream)object).close();
                object = null;
            }
            catch (Exception exception2) {
                block16: {
                    try {
                        exception = exception2;
                        if (object == null) break block16;
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        EmuUtil.closeSilent(object);
                        throw throwable;
                    }
                }
                EmuUtil.closeSilent((Closeable)object);
            }
            EmuUtil.closeSilent((Closeable)object);
            if (file != null && bl) {
                file.delete();
            }
        }
        object = exception;
        EventQueue.invokeLater(new Runnable((Exception)object){
            final /* synthetic */ Exception val$retEx;
            {
                this.val$retEx = exception;
            }

            @Override
            public void run() {
                VideoCaptureFrm.this.threadTerminated(this.val$retEx);
            }
        });
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnCaptureEmuSysScreen || object == this.btnCaptureScreenFrm || object == this.btnCaptureOtherWindow) {
                bl = true;
                this.updOptionFieldsEnabled();
            } else if (object == this.btnFileSelect) {
                bl = true;
                this.doFileSelect();
            } else if (object == this.btnRecord) {
                bl = true;
                this.doRecord();
            } else if (object == this.btnPause) {
                bl = true;
                this.doPause();
            } else if (object == this.btnStop) {
                bl = true;
                this.doStop();
            } else if (object == this.btnPlay) {
                bl = true;
                this.doPlay();
            } else if (object == this.btnClose) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl) {
            this.setIdle();
            if (this.videoPlayFrm != null) {
                this.videoPlayFrm.doClose();
            }
            if (this.thread != null) {
                this.doStop();
                try {
                    this.thread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.pack();
    }

    @Override
    public void resetFired() {
        if (this.waitForReset) {
            this.waitForReset = false;
            this.btnPause.setEnabled(true);
        }
    }

    private VideoCaptureFrm(ScreenFrm screenFrm) {
        File file;
        ButtonGroup buttonGroup;
        Serializable serializable;
        GridBagConstraints gridBagConstraints;
        Object object;
        Object object2;
        this.screenFrm = screenFrm;
        this.pause = false;
        this.waitForReset = false;
        this.running = false;
        this.capturing = false;
        this.recordedMillis = 0L;
        this.frameMillis = 100;
        this.waitForWindowMillis = 0;
        this.captureWidth = 0;
        this.captureHeight = 0;
        this.captureWindow = null;
        this.fileCheckEnabled = false;
        this.robot = null;
        this.thread = null;
        this.videoPlayFrm = null;
        this.setTitle("JKCEMU Bildschirmvideo");
        Main.updIcon(this);
        this.statusTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoCaptureFrm.this.updStatusText();
            }
        });
        try {
            object2 = null;
            object = this.getGraphicsConfiguration();
            if (object != null) {
                object2 = ((GraphicsConfiguration)object).getDevice();
            }
            this.robot = object2 != null ? new Robot((GraphicsDevice)object2) : new Robot();
        }
        catch (AWTException aWTException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setLayout(new GridBagLayout());
        object2 = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
        if (this.robot != null) {
            object = new JPanel(new GridBagLayout());
            ((JComponent)object).setBorder(BorderFactory.createTitledBorder("Aufzunehmender Bereich"));
            this.add((Component)object, object2);
            ++((GridBagConstraints)object2).gridy;
            gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
            serializable = new ButtonGroup();
            this.btnCaptureEmuSysScreen = new JRadioButton("Bildschirmausgabe des emulierten Systems ohne Fenster", true);
            ((ButtonGroup)serializable).add(this.btnCaptureEmuSysScreen);
            this.btnCaptureEmuSysScreen.addActionListener(this);
            ((Container)object).add((Component)this.btnCaptureEmuSysScreen, gridBagConstraints);
            this.btnCaptureScreenFrm = new JRadioButton("Bildschirmausgabe des emulierten Systems mit Fenster", false);
            ((ButtonGroup)serializable).add(this.btnCaptureScreenFrm);
            this.btnCaptureScreenFrm.addActionListener(this);
            gridBagConstraints.insets.top = 0;
            ++gridBagConstraints.gridy;
            ((Container)object).add((Component)this.btnCaptureScreenFrm, gridBagConstraints);
            this.btnCaptureOtherWindow = new JRadioButton("Beliebiges JKCEMU-Fenster", false);
            ((ButtonGroup)serializable).add(this.btnCaptureOtherWindow);
            this.btnCaptureOtherWindow.addActionListener(this);
            gridBagConstraints.insets.bottom = 5;
            ++gridBagConstraints.gridy;
            ((Container)object).add((Component)this.btnCaptureOtherWindow, gridBagConstraints);
        } else {
            this.btnCaptureEmuSysScreen = null;
            this.btnCaptureScreenFrm = null;
            this.btnCaptureOtherWindow = null;
        }
        object = new JPanel(new GridBagLayout());
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder("Optionen"));
        this.add((Component)object, object2);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        if (this.btnCaptureOtherWindow != null) {
            this.labelWinSelectTime = new JLabel("Zeit f\u00fcr Fensterauswahl:");
            ((Container)object).add((Component)this.labelWinSelectTime, gridBagConstraints);
            this.spinnerWinSelectSec = new JSpinner(new SpinnerNumberModel(5, 1, 9, 1));
            gridBagConstraints.fill = 2;
            ++gridBagConstraints.gridx;
            ((Container)object).add((Component)this.spinnerWinSelectSec, gridBagConstraints);
            this.labelWinSelectUnit = new JLabel("Sekunden");
            ++gridBagConstraints.gridx;
            ((Container)object).add((Component)this.labelWinSelectUnit, gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
        } else {
            this.labelWinSelectTime = null;
            this.spinnerWinSelectSec = null;
            this.labelWinSelectUnit = null;
        }
        this.labelFramesPerSec = new JLabel("Bilder pro Sekunde:");
        ((Container)object).add((Component)this.labelFramesPerSec, gridBagConstraints);
        serializable = Integer.valueOf(10);
        this.comboFramesPerSec = new JComboBox();
        this.comboFramesPerSec.setEditable(false);
        this.comboFramesPerSec.addItem(5);
        this.comboFramesPerSec.addItem(7);
        this.comboFramesPerSec.addItem((Integer)serializable);
        this.comboFramesPerSec.addItem(15);
        this.comboFramesPerSec.addItem(20);
        this.comboFramesPerSec.addItem(25);
        this.comboFramesPerSec.addItem(30);
        this.comboFramesPerSec.addItem(50);
        this.comboFramesPerSec.setSelectedItem(serializable);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridx;
        ((Container)object).add(this.comboFramesPerSec, gridBagConstraints);
        if (this.robot != null) {
            this.labelColorReduction = new JLabel("Farbanpassung:");
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            ((Container)object).add((Component)this.labelColorReduction, gridBagConstraints);
            buttonGroup = new ButtonGroup();
            this.btnColorReductionSmooth = new JRadioButton("weich", true);
            buttonGroup.add(this.btnColorReductionSmooth);
            ++gridBagConstraints.gridx;
            ((Container)object).add((Component)this.btnColorReductionSmooth, gridBagConstraints);
            this.btnColorReductionHard = new JRadioButton("hart", false);
            buttonGroup.add(this.btnColorReductionHard);
            ++gridBagConstraints.gridx;
            ((Container)object).add((Component)this.btnColorReductionHard, gridBagConstraints);
            gridBagConstraints.insets.top = 0;
        } else {
            this.labelColorReduction = null;
            this.btnColorReductionSmooth = null;
            this.btnColorReductionHard = null;
        }
        this.labelPlayCnt = new JLabel("Wiedergabe:");
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        ((Container)object).add((Component)this.labelPlayCnt, gridBagConstraints);
        buttonGroup = new ButtonGroup();
        this.btnPlayOnce = new JRadioButton("einmal", false);
        buttonGroup.add(this.btnPlayOnce);
        ++gridBagConstraints.gridx;
        ((Container)object).add((Component)this.btnPlayOnce, gridBagConstraints);
        this.btnPlayInfinite = new JRadioButton("st\u00e4ndig wiederholen", true);
        buttonGroup.add(this.btnPlayInfinite);
        ++gridBagConstraints.gridx;
        ((Container)object).add((Component)this.btnPlayInfinite, gridBagConstraints);
        this.btnStartAfterReset = new JCheckBox("Aufnahme erst nach RESET starten", false);
        gridBagConstraints.insets.bottom = this.robot != null ? 0 : 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        ((Container)object).add((Component)this.btnStartAfterReset, gridBagConstraints);
        if (this.robot != null) {
            this.btnFocusedWindowOnly = new JCheckBox("Automatische Pause bei inaktiven Fenster", false);
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            ((Container)object).add((Component)this.btnFocusedWindowOnly, gridBagConstraints);
        } else {
            this.btnFocusedWindowOnly = null;
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Ausgabedatei"));
        ++((GridBagConstraints)object2).gridy;
        this.add((Component)jPanel, object2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.fldFile = new FileNameFld();
        this.fldFile.setText("--- Bitte ausw\u00e4hlen ---");
        jPanel.add((Component)this.fldFile, gridBagConstraints2);
        this.btnFileSelect = this.createImageButton("/images/file/open.png", "Ausw\u00e4hlen");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.btnFileSelect, gridBagConstraints2);
        ((GridBagConstraints)object2).insets.left = 0;
        ((GridBagConstraints)object2).insets.right = 0;
        ((GridBagConstraints)object2).gridwidth = 0;
        ++((GridBagConstraints)object2).gridy;
        this.add((Component)new JSeparator(), object2);
        this.labelStatus = new JLabel(DEFAULT_STATUS_TEXT);
        ((GridBagConstraints)object2).anchor = 17;
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).insets.top = 0;
        ((GridBagConstraints)object2).insets.left = 5;
        ((GridBagConstraints)object2).insets.right = 5;
        ++((GridBagConstraints)object2).gridy;
        this.add((Component)this.labelStatus, object2);
        JPanel jPanel2 = new JPanel(new GridLayout(5, 1, 5, 5));
        ((GridBagConstraints)object2).anchor = 12;
        ((GridBagConstraints)object2).insets.top = 5;
        ((GridBagConstraints)object2).gridwidth = 1;
        ((GridBagConstraints)object2).gridheight = this.robot != null ? 3 : 2;
        ((GridBagConstraints)object2).gridy = 0;
        ++((GridBagConstraints)object2).gridx;
        this.add((Component)jPanel2, object2);
        this.btnRecord = new JButton("Aufnehmen");
        this.btnRecord.setEnabled(false);
        this.btnRecord.addActionListener(this);
        jPanel2.add(this.btnRecord);
        this.btnPause = new JButton("Pause");
        this.btnPause.setEnabled(false);
        this.btnPause.addActionListener(this);
        jPanel2.add(this.btnPause);
        this.btnStop = new JButton("Stopp");
        this.btnStop.setEnabled(false);
        this.btnStop.addActionListener(this);
        jPanel2.add(this.btnStop);
        this.btnPlay = new JButton("Wiedergabe");
        this.btnPlay.setEnabled(false);
        this.btnPlay.addActionListener(this);
        jPanel2.add(this.btnPlay);
        this.btnClose = new JButton("Schlie\u00dfen");
        this.btnClose.addActionListener(this);
        jPanel2.add(this.btnClose);
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        if (fileSystemView != null && (file = fileSystemView.getHomeDirectory()) != null) {
            this.fldFile.setFile(new File(file, "jkcemu.gif"));
            this.fileCheckEnabled = true;
            this.btnRecord.setEnabled(true);
        }
        this.updOptionFieldsEnabled();
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setScreenCentered();
        }
        this.setResizable(true);
    }

    private void appendRecordedTimeText(StringBuilder stringBuilder) {
        int n = (int)(this.recordedMillis / 1000L);
        int n2 = n / 3600;
        int n3 = n / 60;
        n %= 60;
        if (n2 > 0) {
            stringBuilder.append(String.format("%d:%02d:%02d", n2, n3, n));
            stringBuilder.append(" Stunden");
        } else if (n3 > 0) {
            stringBuilder.append(String.format("%d:%02d", n3, n));
            stringBuilder.append(" Minuten");
        } else if (n == 1) {
            stringBuilder.append("1 Sekunde");
        } else {
            stringBuilder.append(n);
            stringBuilder.append(" Sekunden");
        }
        stringBuilder.append(" aufgenommen");
    }

    private BufferedImage createSnapshot() {
        BufferedImage bufferedImage = null;
        Window window = this.captureWindow;
        if (window != null && this.robot != null) {
            int n = window.getX();
            int n2 = window.getY();
            int n3 = this.captureWidth;
            int n4 = this.captureHeight;
            if (n3 < 1 || n4 < 1) {
                n3 = window.getWidth();
                n4 = window.getHeight();
            }
            if (n3 > 0 && n4 > 0) {
                bufferedImage = this.robot.createScreenCapture(new Rectangle(n, n2, n3, n4));
            }
        } else {
            bufferedImage = this.screenFrm.createSnapshot();
        }
        return bufferedImage;
    }

    private void doFileSelect() {
        File file;
        if (this.thread == null && (file = EmuUtil.showFileSaveDlg(this, "GIF-Datei speichern", this.fldFile.getFile(), EmuUtil.getGIFFileFilter())) != null) {
            if (!file.exists() || file.canWrite()) {
                String string = file.getName();
                if (string != null) {
                    if (string.toLowerCase().endsWith(".gif")) {
                        this.fldFile.setFile(file);
                        this.fileCheckEnabled = false;
                        this.btnRecord.setEnabled(true);
                    } else {
                        BaseDlg.showErrorDlg((Component)this, "Das aufgenommene Bildschirmvideo kann nur in eine\nanimierte GIF-Datei geschrieben werden.\nDer Dateiname muss deshalb mit '.gif' enden.");
                    }
                }
            } else {
                BaseDlg.showErrorDlg((Component)this, "Datei kann nicht angelegt bzw. geschrieben werden");
            }
        }
    }

    private void doPause() {
        if (this.thread != null) {
            this.btnPause.setEnabled(false);
            this.btnRecord.setEnabled(true);
            this.pause = true;
        }
    }

    private void doPlay() {
        if (this.videoPlayFrm != null) {
            this.videoPlayFrm.setState(0);
        } else {
            this.videoPlayFrm = new VideoPlayFrm();
        }
        this.videoPlayFrm.setFile(this.fldFile.getFile());
        this.videoPlayFrm.setVisible(true);
        this.videoPlayFrm.toFront();
    }

    private void doRecord() {
        if (this.thread != null) {
            if (this.pause) {
                this.btnPause.setEnabled(true);
                this.pause = false;
            }
        } else {
            File file = this.fldFile.getFile();
            if (file != null) {
                boolean bl = true;
                if (this.fileCheckEnabled && file.exists() && JOptionPane.showConfirmDialog(this, "Sie \u00fcberschreiben die Datei\n" + file.getPath() + " !", "Warnung", 2, 2) != 0) {
                    bl = false;
                }
                if (bl) {
                    int n = 100;
                    Object object = this.comboFramesPerSec.getSelectedItem();
                    if (object != null && object instanceof Integer) {
                        n = Math.max(1000 / (Integer)object, 10);
                    }
                    if (this.videoPlayFrm != null) {
                        this.videoPlayFrm.doClose();
                    }
                    this.frameMillis = n;
                    this.waitForWindowMillis = 0;
                    this.waitForReset = false;
                    this.pause = false;
                    this.focusedWindowOnly = false;
                    this.capturing = false;
                    this.captureWidth = 0;
                    this.captureHeight = 0;
                    this.captureWindow = null;
                    if (this.btnCaptureEmuSysScreen != null && this.btnCaptureScreenFrm != null && this.btnCaptureOtherWindow != null) {
                        if (this.btnCaptureScreenFrm.isSelected()) {
                            this.captureWindow = this.screenFrm;
                        } else if (this.btnCaptureOtherWindow.isSelected()) {
                            int n2;
                            this.waitForWindowMillis = 5000;
                            if (this.spinnerWinSelectSec != null && (object = this.spinnerWinSelectSec.getValue()) instanceof Number && (n2 = ((Number)object).intValue()) >= 1 && n2 < 10) {
                                this.waitForWindowMillis = (n2 + 1) * 1000;
                            }
                        }
                        if (this.btnCaptureEmuSysScreen.isSelected() || this.btnCaptureScreenFrm.isSelected()) {
                            this.waitForReset = this.btnStartAfterReset.isSelected();
                        }
                        if ((this.btnCaptureScreenFrm.isSelected() || this.btnCaptureOtherWindow.isSelected()) && this.btnFocusedWindowOnly != null) {
                            this.focusedWindowOnly = this.btnFocusedWindowOnly.isSelected();
                        }
                        this.btnCaptureEmuSysScreen.setEnabled(false);
                        this.btnCaptureScreenFrm.setEnabled(false);
                        this.btnCaptureOtherWindow.setEnabled(false);
                    } else {
                        this.waitForReset = this.btnStartAfterReset.isSelected();
                    }
                    if (this.labelWinSelectTime != null) {
                        this.labelWinSelectTime.setEnabled(false);
                    }
                    if (this.spinnerWinSelectSec != null) {
                        this.spinnerWinSelectSec.setEnabled(false);
                    }
                    if (this.labelWinSelectUnit != null) {
                        this.labelWinSelectUnit.setEnabled(false);
                    }
                    this.labelFramesPerSec.setEnabled(false);
                    this.comboFramesPerSec.setEnabled(false);
                    if (this.labelColorReduction != null) {
                        this.labelColorReduction.setEnabled(false);
                    }
                    if (this.btnColorReductionSmooth != null) {
                        this.btnColorReductionSmooth.setEnabled(false);
                    }
                    if (this.btnColorReductionHard != null) {
                        this.btnColorReductionHard.setEnabled(false);
                    }
                    this.labelPlayCnt.setEnabled(false);
                    this.btnPlayOnce.setEnabled(false);
                    this.btnPlayInfinite.setEnabled(false);
                    this.btnStartAfterReset.setEnabled(false);
                    if (this.btnFocusedWindowOnly != null) {
                        this.btnFocusedWindowOnly.setEnabled(false);
                    }
                    this.btnFileSelect.setEnabled(false);
                    this.btnRecord.setEnabled(false);
                    this.btnStop.setEnabled(true);
                    if (this.waitForWindowMillis <= 0) {
                        if (!this.waitForReset) {
                            this.btnPause.setEnabled(true);
                        }
                        this.running = true;
                        this.thread = new Thread(Main.getThreadGroup(), this, "JKCEMU screen video recorder");
                        this.thread.start();
                    }
                    this.statusTimer.start();
                }
            }
        }
    }

    private void doStop() {
        if (this.thread != null || this.waitForWindowMillis > 0) {
            this.btnPause.setEnabled(false);
            this.btnStop.setEnabled(false);
            this.running = false;
            this.waitForWindowMillis = 0;
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            } else {
                this.setIdle();
            }
        }
    }

    private void setIdle() {
        this.thread = null;
        this.statusTimer.stop();
        this.waitForWindowMillis = 0;
        this.waitForReset = false;
        this.capturing = false;
        this.captureWidth = 0;
        this.captureHeight = 0;
        this.captureWindow = null;
        if (this.btnCaptureEmuSysScreen != null) {
            this.btnCaptureEmuSysScreen.setEnabled(true);
        }
        if (this.btnCaptureScreenFrm != null) {
            this.btnCaptureScreenFrm.setEnabled(true);
        }
        if (this.btnCaptureOtherWindow != null) {
            this.btnCaptureOtherWindow.setEnabled(true);
        }
        this.labelFramesPerSec.setEnabled(true);
        this.comboFramesPerSec.setEnabled(true);
        if (this.labelColorReduction != null) {
            this.labelColorReduction.setEnabled(true);
        }
        if (this.btnColorReductionSmooth != null) {
            this.btnColorReductionSmooth.setEnabled(true);
        }
        if (this.btnColorReductionHard != null) {
            this.btnColorReductionHard.setEnabled(true);
        }
        this.labelPlayCnt.setEnabled(true);
        this.btnPlayOnce.setEnabled(true);
        this.btnPlayInfinite.setEnabled(true);
        this.btnFileSelect.setEnabled(true);
        this.btnRecord.setEnabled(true);
        this.btnPause.setEnabled(false);
        this.btnStop.setEnabled(false);
        this.updOptionFieldsEnabled();
        this.labelStatus.setText(DEFAULT_STATUS_TEXT);
    }

    private void threadTerminated(Exception exception) {
        if (exception != null) {
            if (exception instanceof IOException) {
                BaseDlg.showErrorDlg((Component)this, exception);
            } else {
                EmuUtil.exitSysError(this, "Aufnehmen des Bildschirmvideo fehlgeschlagen", exception);
            }
            this.btnPlay.setEnabled(false);
        } else {
            boolean bl = false;
            File file = this.fldFile.getFile();
            if (file != null) {
                bl = file.isFile() && file.canRead();
            }
            this.btnPlay.setEnabled(bl);
            this.fileCheckEnabled = true;
        }
        this.setIdle();
    }

    private void updOptionFieldsEnabled() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        if (this.btnCaptureEmuSysScreen != null) {
            bl = this.btnCaptureEmuSysScreen.isSelected();
        }
        if (this.btnCaptureScreenFrm != null) {
            bl2 = this.btnCaptureScreenFrm.isSelected();
        }
        if (this.btnCaptureOtherWindow != null) {
            bl3 = this.btnCaptureOtherWindow.isSelected();
        }
        if (this.labelWinSelectTime != null) {
            this.labelWinSelectTime.setEnabled(bl3);
        }
        if (this.spinnerWinSelectSec != null) {
            this.spinnerWinSelectSec.setEnabled(bl3);
        }
        if (this.labelWinSelectUnit != null) {
            this.labelWinSelectUnit.setEnabled(bl3);
        }
        if (this.labelColorReduction != null) {
            this.labelColorReduction.setEnabled(bl2 || bl3);
        }
        if (this.btnColorReductionSmooth != null) {
            this.btnColorReductionSmooth.setEnabled(bl2 || bl3);
        }
        if (this.btnColorReductionHard != null) {
            this.btnColorReductionHard.setEnabled(bl2 || bl3);
        }
        if (this.btnStartAfterReset != null) {
            this.btnStartAfterReset.setEnabled(bl || bl2);
        }
        if (this.btnFocusedWindowOnly != null) {
            this.btnFocusedWindowOnly.setEnabled(bl2 || bl3);
        }
    }

    private void updStatusText() {
        String string = DEFAULT_STATUS_TEXT;
        if (this.thread != null) {
            if (this.waitForReset) {
                string = "Warte auf RESET...";
            } else if (this.pause) {
                StringBuilder stringBuilder = new StringBuilder(64);
                this.appendRecordedTimeText(stringBuilder);
                stringBuilder.append(", Pause");
                string = stringBuilder.toString();
            } else {
                StringBuilder stringBuilder = new StringBuilder(64);
                this.appendRecordedTimeText(stringBuilder);
                if (this.focusedWindowOnly && !this.capturing) {
                    stringBuilder.append(", automatische Pause (Fenster inaktiv)");
                } else {
                    stringBuilder.append(", Aufnahme l\u00e4uft...");
                }
                string = stringBuilder.toString();
            }
        } else if (this.waitForWindowMillis > 0) {
            string = "Aufnahme startet jetzt...";
            this.waitForWindowMillis -= 500;
            if (this.waitForWindowMillis > 0) {
                int n = this.waitForWindowMillis / 1000;
                if (n == 1) {
                    string = "Aufzunehmendes Fenster aktivieren! Noch 1 Sekunde...";
                } else if (n > 1) {
                    string = String.format("Aufzunehmendes Fenster aktivieren! Noch %d Sekunden...", n);
                }
            } else {
                Window[] windowArray = Window.getWindows();
                if (windowArray != null) {
                    for (Window window : windowArray) {
                        if (!window.isFocused()) continue;
                        this.captureWindow = window;
                    }
                }
                if (this.captureWindow != null) {
                    this.btnPause.setEnabled(true);
                    this.waitForWindowMillis = 0;
                    this.running = true;
                    this.thread = new Thread((Runnable)this, "JKCEMU screen video recorder");
                    this.thread.start();
                } else {
                    this.setIdle();
                    BaseDlg.showErrorDlg((Component)this, "Kein JKCEMU-Fenster aktiv");
                    string = DEFAULT_STATUS_TEXT;
                }
            }
        }
        this.labelStatus.setText(string);
    }
}

