/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.net;

import java.io.IOException;
import java.net.DatagramPacket;
import jkcemu.net.DhcpProcess;
import jkcemu.net.W5100;

public class DhcpServer {
    private W5100 w5100;
    private DhcpProcess dhcpProcess;

    public DhcpServer(W5100 w5100) {
        this.w5100 = w5100;
    }

    public synchronized boolean receive(DatagramPacket datagramPacket) throws IOException {
        boolean bl = false;
        if (this.dhcpProcess != null && this.dhcpProcess.isTimeout()) {
            this.dhcpProcess = null;
        }
        if (this.dhcpProcess != null && this.dhcpProcess.fillAnswerToClientInto(datagramPacket)) {
            if (this.dhcpProcess.hasFinished()) {
                this.dhcpProcess = null;
            }
            bl = true;
        }
        return bl;
    }

    public synchronized void send(DatagramPacket datagramPacket) throws IOException {
        DhcpProcess dhcpProcess;
        if (this.dhcpProcess != null && this.dhcpProcess.isTimeout()) {
            this.dhcpProcess = null;
        }
        if ((dhcpProcess = DhcpProcess.checkDiscover(this.w5100, datagramPacket)) != null) {
            this.dhcpProcess = dhcpProcess;
        } else if (this.dhcpProcess != null && !this.dhcpProcess.processRequest(datagramPacket)) {
            this.dhcpProcess = null;
        }
    }
}

