/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.net;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import jkcemu.base.AbstractSettingsFld;
import jkcemu.base.EmuUtil;
import jkcemu.base.SettingsFrm;
import jkcemu.base.UserInputException;

public class KCNetSettingsFld
extends AbstractSettingsFld
implements DocumentListener {
    private JTextField fldIpAddr;
    private JTextField fldSubnetMask;
    private JTextField fldGateway;
    private JTextField fldDNSServer;
    private JCheckBox btnAutoConfig;

    public KCNetSettingsFld(SettingsFrm settingsFrm, String string) {
        super(settingsFrm, string);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)new JLabel("Beim \"Einschalten\" KCNet konfigurieren (optional):"), gridBagConstraints);
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("IP-Adresse (d.d.d.d):"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Subnetzmaske (d.d.d.d):"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("Gateway (d.d.d.d):"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)new JLabel("DNS-Server (d.d.d.d):"), gridBagConstraints);
        this.btnAutoConfig = new JCheckBox("IP-Adressen der leer gelassenen Felder automatisch ermitteln", true);
        this.btnAutoConfig.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnAutoConfig, gridBagConstraints);
        this.fldIpAddr = this.createJTextField();
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldIpAddr, gridBagConstraints);
        this.fldSubnetMask = this.createJTextField();
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldSubnetMask, gridBagConstraints);
        this.fldGateway = this.createJTextField();
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldGateway, gridBagConstraints);
        this.fldDNSServer = this.createJTextField();
        ++gridBagConstraints.gridy;
        this.add((Component)this.fldDNSServer, gridBagConstraints);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireDataChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireDataChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireDataChanged();
    }

    @Override
    public void applyInput(Properties properties, boolean bl) throws UserInputException {
        properties.setProperty("jkcemu.kcnet.ip_address", this.parseIpAddrText(this.fldIpAddr, "IP-Adresse"));
        properties.setProperty("jkcemu.kcnet.subnet_mask", this.parseIpAddrText(this.fldSubnetMask, "Subnetzmaske"));
        properties.setProperty("jkcemu.kcnet.gateway", this.parseIpAddrText(this.fldGateway, "Gateway"));
        properties.setProperty("jkcemu.kcnet.dns_server", this.parseIpAddrText(this.fldDNSServer, "DNS-Server"));
        EmuUtil.setProperty(properties, "jkcemu.kcnet.auto_config", this.btnAutoConfig.isSelected());
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject.getSource() == this.btnAutoConfig) {
            bl = true;
            this.fireDataChanged();
        }
        return bl;
    }

    @Override
    public void updFields(Properties properties) {
        this.fldIpAddr.setText(EmuUtil.getProperty(properties, "jkcemu.kcnet.ip_address"));
        this.fldSubnetMask.setText(EmuUtil.getProperty(properties, "jkcemu.kcnet.subnet_mask"));
        this.fldGateway.setText(EmuUtil.getProperty(properties, "jkcemu.kcnet.gateway"));
        this.fldDNSServer.setText(EmuUtil.getProperty(properties, "jkcemu.kcnet.dns_server"));
        this.btnAutoConfig.setSelected(EmuUtil.getBooleanProperty(properties, "jkcemu.kcnet.auto_config", true));
    }

    private JTextField createJTextField() {
        JTextField jTextField = new JTextField(15);
        Document document = jTextField.getDocument();
        if (document != null) {
            document.addDocumentListener(this);
        }
        return jTextField;
    }

    private String parseIpAddrText(JTextField jTextField, String string) throws UserInputException {
        String string2 = "";
        String string3 = jTextField.getText();
        if (string3 != null && !(string3 = string3.trim()).isEmpty()) {
            string2 = null;
            try {
                String[] stringArray = string3.split("\\.", 5);
                if (stringArray != null && stringArray.length == 4) {
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    int n4 = Integer.parseInt(stringArray[3]);
                    if (n >= 0 && n <= 255 && n2 >= 0 && n2 <= 255 && n3 >= 0 && n3 <= 255 && n4 >= 0 && n4 <= 255) {
                        string2 = String.format("%d.%d.%d.%d", n, n2, n3, n4);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
            if (string2 == null) {
                throw new UserInputException(string + ": Ung\u00fcltige Eingabe", string);
            }
        }
        return string2;
    }
}

