/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import jkcemu.Main;
import jkcemu.base.EmuUtil;

public class Ping {
    private static final int TIMEOUT_MILLIS = 20000;
    private static final String httpRequestString = "GET / HTTP/1.1\r\n\r\n";
    private static byte[] httpRequestBytes = null;
    private InetAddress inetAddress;
    private byte[] packageData;
    private Thread thread1;
    private Thread thread2;
    private Boolean reachable;
    private boolean err;

    public Ping(InetAddress inetAddress, byte[] byArray) {
        this.inetAddress = inetAddress;
        this.packageData = byArray;
        this.thread1 = null;
        this.thread2 = null;
        this.reachable = null;
        this.err = false;
    }

    public boolean checkError() {
        return this.err;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public byte[] getPackageData() {
        return this.packageData;
    }

    public Boolean getReachable() {
        return this.reachable;
    }

    public synchronized void start() {
        if (this.thread2 == null) {
            this.thread1 = new Thread(Main.getThreadGroup(), new Runnable(){

                @Override
                public void run() {
                    Ping.this.runThread1();
                }
            }, "JKCEMU ping 1");
            this.thread1.start();
            this.thread2 = new Thread(Main.getThreadGroup(), new Runnable(){

                @Override
                public void run() {
                    Ping.this.runThread2();
                }
            }, "JKCEMU ping 2");
            this.thread2.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runThread1() {
        Socket socket = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            if (httpRequestBytes == null) {
                httpRequestBytes = httpRequestString.getBytes("US-ASCII");
            }
            if (httpRequestBytes != null) {
                socket = new Socket();
                socket.setSoTimeout(20000);
                socket.connect(new InetSocketAddress(this.inetAddress, 80), 20000);
                outputStream = socket.getOutputStream();
                outputStream.write(httpRequestBytes);
                outputStream.flush();
                inputStream = socket.getInputStream();
                if (inputStream.read() >= 0) {
                    this.reachable = Boolean.TRUE;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            EmuUtil.closeSilent(inputStream);
            EmuUtil.closeSilent(outputStream);
            EmuUtil.closeSilent(socket);
        }
        this.thread1 = null;
    }

    public void runThread2() {
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = this.inetAddress.isReachable(20000);
        }
        catch (Exception exception) {
            bl2 = true;
        }
        Thread thread = this.thread1;
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.reachable == null) {
            this.err = bl2;
            this.reachable = bl;
        }
    }
}

