/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import jkcemu.Main;
import jkcemu.print.PrintUtil;

public class PlainTextPrintable
implements Printable {
    private String text;
    private int tabSize;
    private String fileName;

    public PlainTextPrintable(String string, int n, String string2) {
        this.text = string;
        this.tabSize = n;
        this.fileName = string2;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = 1;
        if (this.text != null && this.tabSize > 0) {
            int n3;
            int n4;
            int n5 = Main.getPrintFontSize();
            int n6 = (int)pageFormat.getImageableHeight() / n5;
            if (Main.getPrintFileName() || Main.getPrintPageNum()) {
                n6 -= 2;
            }
            if (n6 < 1 || pageFormat.getImageableWidth() < 1.0) {
                throw new PrinterException("Die Seite hat keinen bedruckbaren Bereich,\nda die R\u00e4nder zu gro\u00df sind.");
            }
            int n7 = this.text.length();
            int n8 = 0;
            for (n4 = n * n6; n4 > 0 && n8 < n7; --n4) {
                n3 = this.text.indexOf(10, n8);
                if (n3 < n8) {
                    n8 = n7;
                    break;
                }
                n8 = n3 + 1;
            }
            if (n4 == 0 && n8 < n7) {
                graphics.setFont(new Font("Monospaced", 0, n5));
                graphics.setColor(Color.black);
                n3 = (int)pageFormat.getImageableX();
                int n9 = (int)pageFormat.getImageableY() + n5;
                while (n6 > 0 && n8 < n7) {
                    int n10 = this.text.indexOf(10, n8);
                    if (n10 >= n8) {
                        graphics.drawString(PrintUtil.expandTabs(this.text.substring(n8, n10), this.tabSize), n3, n9);
                        n8 = n10 + 1;
                    } else {
                        graphics.drawString(PrintUtil.expandTabs(this.text.substring(n8), this.tabSize), n3, n9);
                        n8 = n7;
                    }
                    n9 += n5;
                    --n6;
                }
                if ((n5 -= 2) < 6) {
                    n5 = 6;
                }
                n9 = (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight());
                if (Main.getPrintFileName() && this.fileName != null) {
                    graphics.setFont(new Font("Monospaced", 0, n5));
                    graphics.drawString(this.fileName, n3, n9);
                    if (Main.getPrintPageNum()) {
                        String string = String.valueOf(n + 1);
                        graphics.drawString(string, (int)(pageFormat.getImageableX() + pageFormat.getImageableWidth() - (double)graphics.getFontMetrics().stringWidth(string)), n9);
                    }
                } else if (Main.getPrintPageNum()) {
                    PrintUtil.printCenteredPageNum(graphics, pageFormat, n5, n + 1);
                }
                n2 = 0;
            }
        }
        return n2;
    }
}

