/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jkcemu.Main;
import jkcemu.base.EmuUtil;
import jkcemu.print.PrintDataScanner;
import jkcemu.print.PrintUtil;

public class PrintData
implements Printable {
    private int entryNum;
    private ByteArrayOutputStream byteStream;
    private byte[] byteArray;

    public PrintData(int n) {
        this.entryNum = n;
        this.byteStream = null;
        this.byteArray = null;
    }

    public synchronized byte[] getBytes() {
        if (this.byteArray == null && this.byteStream != null) {
            this.byteArray = this.byteStream.toByteArray();
        }
        return this.byteArray;
    }

    public int getEntryNum() {
        return this.entryNum;
    }

    public synchronized void putByte(int n) {
        if (this.byteStream == null) {
            this.byteStream = new ByteArrayOutputStream(4096);
        }
        this.byteStream.write(n);
        this.byteArray = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = this.getBytes();
            if (byArray != null) {
                ((OutputStream)fileOutputStream).write(byArray);
            }
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(fileOutputStream);
    }

    public int size() {
        return this.byteStream != null ? this.byteStream.size() : 0;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        int n3;
        byte[] byArray = this.getBytes();
        if (byArray == null) {
            return n == 0 ? 0 : 1;
        }
        PrintDataScanner printDataScanner = new PrintDataScanner(byArray);
        int n4 = Main.getPrintFontSize();
        int n5 = (int)pageFormat.getImageableHeight() / n4;
        if (Main.getPrintPageNum()) {
            n5 -= 2;
        }
        if (n5 < 1 || pageFormat.getImageableWidth() < 1.0) {
            throw new PrinterException("Die Seite hat keinen bedruckbaren Bereich,\nda die R\u00e4nder zu gro\u00df sind.");
        }
        if (n > 0) {
            for (n3 = n; n3 > 0 && !printDataScanner.endReached(); --n3) {
                for (n2 = n5; n2 > 0 && printDataScanner.skipLine(); --n2) {
                }
                printDataScanner.skipFormFeed();
            }
            if (n3 > 0 || printDataScanner.endReached()) {
                return 1;
            }
        }
        graphics.setColor(Color.black);
        graphics.setFont(new Font("Monospaced", 0, n4));
        n3 = (int)pageFormat.getImageableX();
        n2 = (int)pageFormat.getImageableY() + n4;
        String string = printDataScanner.readLine();
        while (string != null && n5 > 0) {
            graphics.drawString(PrintUtil.expandTabs(string, 8), n3, n2);
            n2 += n4;
            --n5;
            string = printDataScanner.readLine();
        }
        if (Main.getPrintPageNum()) {
            if ((n4 -= 2) < 6) {
                n4 = 6;
            }
            PrintUtil.printCenteredPageNum(graphics, pageFormat, n4, n + 1);
        }
        return 0;
    }
}

