/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.print;

public class PrintDataScanner {
    private byte[] dataBytes;
    private int pos;

    public PrintDataScanner(byte[] byArray) {
        this.dataBytes = byArray;
        this.pos = 0;
    }

    public boolean endReached() {
        return this.pos >= this.dataBytes.length;
    }

    public String readLine() {
        int n;
        StringBuilder stringBuilder = null;
        while (this.pos < this.dataBytes.length && (n = this.dataBytes[this.pos] & 0xFF) != 12) {
            ++this.pos;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (n == 10 || n == 13 || n == 30) {
                if (n != 13 || this.pos >= this.dataBytes.length || this.dataBytes[this.pos] != 10) break;
                ++this.pos;
                break;
            }
            if (n == 0 || n == 3) continue;
            stringBuilder.append((char)n);
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    public boolean skipFormFeed() {
        if (this.pos < this.dataBytes.length && this.dataBytes[this.pos] == 12) {
            ++this.pos;
            return true;
        }
        return false;
    }

    public boolean skipLine() {
        int n;
        boolean bl = false;
        while (this.pos < this.dataBytes.length && (n = this.dataBytes[this.pos] & 0xFF) != 12) {
            ++this.pos;
            bl = true;
            if (n != 10 && n != 13 && n != 30) continue;
            if (n != 13 || this.pos >= this.dataBytes.length || this.dataBytes[this.pos] != 10) break;
            ++this.pos;
            break;
        }
        return bl;
    }
}

