/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;
import jkcemu.base.LimitedDocument;
import jkcemu.base.UserInputException;
import jkcemu.programming.PrgOptions;

public abstract class AbstractOptionsDlg
extends BaseDlg {
    protected PrgOptions appliedOptions;
    protected EmuThread emuThread;
    private Frame owner;
    private JCheckBox btnCodeToEmu;
    private JCheckBox btnCodeToFile;
    private JRadioButton btnCodeToPrimarySys;
    private JRadioButton btnCodeToSecondSys;
    private FileNameFld fldFileName;
    private JLabel labelFileName;
    private JButton btnFileSelect;
    private JButton btnApply;
    private JButton btnCancel;
    private LimitedDocument docFileDesc;

    public PrgOptions getAppliedOptions() {
        return this.appliedOptions;
    }

    public void settingsChanged() {
        this.updCodeToEmuFieldsVisible();
        this.updCodeToEmuFieldsEnabled();
    }

    protected AbstractOptionsDlg(Frame frame, EmuThread emuThread, String string) {
        super((Window)frame, string);
        this.owner = frame;
        this.emuThread = emuThread;
        this.appliedOptions = null;
    }

    protected void applyCodeDestOptionsTo(PrgOptions prgOptions) throws UserInputException {
        prgOptions.setCodeToFile(this.btnCodeToFile.isSelected(), this.fldFileName.getFile());
        prgOptions.setCodeToEmu(this.btnCodeToEmu != null ? this.btnCodeToEmu.isSelected() : false);
        prgOptions.setCodeToSecondSystem(this.btnCodeToSecondSys != null ? this.btnCodeToSecondSys.isSelected() : false);
    }

    protected void codeToEmuChanged(boolean bl) {
    }

    protected JPanel createButtons(String string) {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        this.btnApply = new JButton(string);
        this.btnApply.addActionListener(this);
        this.btnApply.addKeyListener(this);
        jPanel.add(this.btnApply);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        jPanel.add(this.btnCancel);
        return jPanel;
    }

    protected JPanel createCodeDestOptions() {
        Serializable serializable;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        if (this.emuThread != null) {
            this.btnCodeToEmu = new JCheckBox();
            this.btnCodeToEmu.addActionListener(this);
            jPanel.add((Component)this.btnCodeToEmu, gridBagConstraints);
            serializable = new ButtonGroup();
            this.btnCodeToPrimarySys = new JRadioButton("Grundger\u00e4t", true);
            ((ButtonGroup)serializable).add(this.btnCodeToPrimarySys);
            gridBagConstraints.insets.left = 20;
            ++gridBagConstraints.gridx;
            jPanel.add((Component)this.btnCodeToPrimarySys, gridBagConstraints);
            this.btnCodeToSecondSys = new JRadioButton();
            ((ButtonGroup)serializable).add(this.btnCodeToSecondSys);
            gridBagConstraints.insets.left = 5;
            ++gridBagConstraints.gridx;
            jPanel.add((Component)this.btnCodeToSecondSys, gridBagConstraints);
            ++gridBagConstraints.gridy;
        } else {
            this.btnCodeToEmu = null;
            this.btnCodeToPrimarySys = null;
            this.btnCodeToSecondSys = null;
        }
        this.btnCodeToFile = new JCheckBox("Programmcode in Datei speichern");
        this.btnCodeToFile.addActionListener(this);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.btnCodeToFile, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.left = 50;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)serializable, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
        this.labelFileName = new JLabel("Dateiname:");
        ((Container)serializable).add(this.labelFileName, gridBagConstraints2);
        this.fldFileName = new FileNameFld();
        this.fldFileName.setEditable(false);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        ++gridBagConstraints2.gridx;
        ((Container)serializable).add(this.fldFileName, gridBagConstraints2);
        this.btnFileSelect = this.createImageButton("/images/file/open.png", "\u00d6ffnen...");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        ((Container)serializable).add(this.btnFileSelect, gridBagConstraints2);
        return jPanel;
    }

    protected abstract void doApply();

    protected void setCodeToEmu(boolean bl) {
        if (this.btnCodeToEmu != null) {
            this.btnCodeToEmu.setSelected(bl);
        }
    }

    protected void updCodeDestFields(PrgOptions prgOptions, boolean bl) {
        this.updCodeToEmuFieldsVisible();
        if (prgOptions != null) {
            if (this.btnCodeToEmu != null) {
                this.btnCodeToEmu.setSelected(prgOptions.getCodeToEmu());
            }
            if (this.btnCodeToSecondSys != null) {
                this.btnCodeToSecondSys.setSelected(prgOptions.getCodeToSecondSystem());
            }
            this.btnCodeToFile.setSelected(prgOptions.getCodeToFile());
            this.fldFileName.setFile(prgOptions.getCodeFile());
        } else {
            if (this.btnCodeToEmu != null) {
                this.btnCodeToEmu.setSelected(bl);
            }
            this.btnCodeToFile.setSelected(false);
        }
        this.updCodeToEmuFieldsEnabled();
        this.updCodeToFileFieldsEnabled();
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnCodeToEmu) {
                bl = true;
                this.updCodeToEmuFieldsEnabled();
            } else if (object == this.btnCodeToFile) {
                bl = true;
                this.updCodeToFileFieldsEnabled();
            } else if (object == this.fldFileName || object == this.btnFileSelect) {
                bl = true;
                this.doSelectFile();
            } else if (object == this.btnApply) {
                bl = true;
                this.doApply();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    private void doSelectFile() {
        File file = EmuUtil.showFileSaveDlg(this.owner, "Programmcode speichern", this.fldFileName.getFile(), EmuUtil.getKCSystemFileFilter(), EmuUtil.getKCTapFileFilter(), EmuUtil.getHeadersaveFileFilter(), EmuUtil.getHexFileFilter(), EmuUtil.getBinaryFileFilter(), EmuUtil.getComFileFilter());
        if (file != null) {
            this.fldFileName.setFile(file);
        }
    }

    private void updCodeToEmuFieldsVisible() {
        if (this.btnCodeToEmu != null && this.btnCodeToSecondSys != null && this.btnCodeToPrimarySys != null) {
            EmuSys emuSys;
            String string = null;
            if (this.emuThread != null && (emuSys = this.emuThread.getEmuSys()) != null) {
                string = emuSys.getSecondSystemName();
            }
            if (string != null) {
                this.btnCodeToEmu.setText("Programmmcode in Emulator laden:");
                this.btnCodeToSecondSys.setText(string);
                this.btnCodeToSecondSys.setVisible(true);
                this.btnCodeToPrimarySys.setVisible(true);
            } else {
                this.btnCodeToEmu.setText("Programmmcode in Emulator laden");
                this.btnCodeToSecondSys.setVisible(false);
                this.btnCodeToPrimarySys.setVisible(false);
            }
        }
    }

    private void updCodeToEmuFieldsEnabled() {
        if (this.btnCodeToEmu != null && this.btnCodeToSecondSys != null && this.btnCodeToPrimarySys != null) {
            boolean bl = this.btnCodeToEmu.isSelected();
            if (this.btnCodeToPrimarySys.isVisible()) {
                this.btnCodeToPrimarySys.setEnabled(bl);
            }
            if (this.btnCodeToSecondSys.isVisible()) {
                this.btnCodeToSecondSys.setEnabled(bl);
            }
            this.codeToEmuChanged(this.btnCodeToEmu.isSelected());
        }
    }

    private void updCodeToFileFieldsEnabled() {
        boolean bl = this.btnCodeToFile.isSelected();
        this.labelFileName.setEnabled(bl);
        this.fldFileName.setEnabled(bl);
        this.btnFileSelect.setEnabled(bl);
    }
}

