/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;

public class CmdLineArgIterator
implements Closeable {
    private Reader reader;
    private String[] ary;
    private int idx;

    public static CmdLineArgIterator createFromStringArray(String[] stringArray, int n) {
        return new CmdLineArgIterator(null, stringArray, n);
    }

    public static CmdLineArgIterator createFromReader(Reader reader) {
        return new CmdLineArgIterator(reader, null, 0);
    }

    public synchronized String next() throws IOException {
        String string = null;
        if (this.ary != null) {
            if (this.idx < this.ary.length && (string = this.ary[this.idx++]) == null) {
                string = "";
            }
        } else if (this.reader != null) {
            int n = this.reader.read();
            while (n >= 0 && CmdLineArgIterator.isWhitespace(n)) {
                n = this.reader.read();
            }
            if (n >= 0) {
                StringBuilder stringBuilder = new StringBuilder(64);
                if (n == 34) {
                    n = this.reader.read();
                    while (n >= 0 && n != 34 && !CmdLineArgIterator.isWhitespace(n)) {
                        stringBuilder.append((char)n);
                        n = this.reader.read();
                    }
                    if (n != 34) {
                        throw new IOException("In '\"' eingeschlossenes Argument nicht abgeschlossen");
                    }
                } else {
                    stringBuilder.append((char)n);
                    n = this.reader.read();
                    while (n >= 0 && !CmdLineArgIterator.isWhitespace(n)) {
                        stringBuilder.append((char)n);
                        n = this.reader.read();
                    }
                }
                string = stringBuilder.toString();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        finally {
            this.reader = null;
            this.ary = null;
        }
    }

    private static boolean isWhitespace(int n) {
        return n < 32 || Character.isWhitespace(n);
    }

    private CmdLineArgIterator(Reader reader, String[] stringArray, int n) {
        this.reader = reader;
        this.ary = stringArray;
        this.idx = n;
    }
}

