/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import jkcemu.base.EmuUtil;

public class PrgSource {
    private List<String> lines;
    private String text;
    private String name;
    private File file;
    private int pos;
    private int lineNum;
    private Map<Integer, Integer> lineNum2Addr;

    public File getFile() {
        return this.file;
    }

    public static File getIncludeFile(PrgSource prgSource, String string) {
        String[] stringArray;
        File file = null;
        File file2 = null;
        if (prgSource != null && (stringArray = prgSource.getFile()) != null) {
            file2 = stringArray.getParentFile();
        }
        if (!(string.startsWith("/") || string.indexOf(47) < 0 || File.separatorChar != '/' && string.indexOf(File.separatorChar) >= 0)) {
            try {
                stringArray = string.split("/");
                if (stringArray != null && stringArray.length > 0) {
                    file = file2;
                    for (String string2 : stringArray) {
                        file = file != null ? new File(file, string2) : new File(string2);
                    }
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        if (file == null) {
            file = new File(string);
            if (file2 != null && !file.isAbsolute()) {
                file = new File(file2, string);
            }
        }
        return file;
    }

    public Map<Integer, Integer> getLineAddrMap() {
        return this.lineNum2Addr;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public static PrgSource readFile(File file) throws IOException {
        return new PrgSource(PrgSource.readLines(new FileReader(file)), null, file.getName(), file);
    }

    public static PrgSource readText(String string, String string2, File file) {
        if (string2 == null && file != null) {
            string2 = file.getName();
        }
        return new PrgSource(null, string, string2, file);
    }

    public String readLine() throws IOException {
        int n;
        String string = null;
        if (this.lines != null) {
            if (this.lineNum >= 0 && this.lineNum < this.lines.size()) {
                string = this.lines.get(this.lineNum++);
            }
        } else if (this.text != null && this.pos < (n = this.text.length())) {
            int n2 = this.text.indexOf(10, this.pos);
            if (n2 >= this.pos) {
                string = this.text.substring(this.pos, n2);
                this.pos = n2 + 1;
            } else {
                string = this.text.substring(this.pos);
                this.pos = n;
            }
            ++this.lineNum;
        }
        return string;
    }

    public void reset() {
        this.lineNum = 0;
        this.pos = 0;
        if (this.lineNum2Addr != null) {
            this.lineNum2Addr.clear();
        }
    }

    public void setLineAddr(int n) {
        if (this.lineNum2Addr == null) {
            this.lineNum2Addr = new HashMap<Integer, Integer>();
        }
        this.lineNum2Addr.put(this.lineNum, n);
    }

    private PrgSource(List<String> list, String string, String string2, File file) {
        this.lines = list;
        this.file = file;
        this.text = string;
        this.name = string2;
        this.pos = 0;
        this.lineNum = 0;
        this.lineNum2Addr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readLines(Reader reader) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(4096);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            while (string != null) {
                arrayList.add(string);
                string = bufferedReader.readLine();
            }
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(bufferedReader);
            throw throwable;
        }
        EmuUtil.closeSilent(bufferedReader);
        return arrayList;
    }
}

