/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming;

import java.awt.EventQueue;
import java.io.IOException;
import jkcemu.Main;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.ErrorMsg;
import jkcemu.base.LoadData;
import jkcemu.programming.PrgOptions;
import jkcemu.programming.assembler.Z80Assembler;
import jkcemu.text.EditText;
import jkcemu.text.TextEditFrm;

public abstract class PrgThread
extends Thread {
    protected EmuThread emuThread;
    protected EditText editText;
    protected PrgOptions options;
    private Appendable logOut;
    private boolean execEnabled;

    public PrgThread(String string, EmuThread emuThread, EditText editText, PrgOptions prgOptions, Appendable appendable) {
        super(Main.getThreadGroup(), string);
        this.emuThread = emuThread;
        this.editText = editText;
        this.options = prgOptions;
        this.logOut = appendable;
        this.execEnabled = true;
    }

    protected void appendToLog(String string) {
        if (string != null) {
            try {
                this.logOut.append(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void cancel() {
        this.execEnabled = false;
    }

    protected abstract boolean execute() throws IOException;

    protected void fireReplaceSourceText(final String string) {
        final EditText editText = this.editText;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                editText.replaceText(string);
            }
        });
    }

    public EditText getEditText() {
        return this.editText;
    }

    protected void writeCodeToEmu(Z80Assembler z80Assembler, boolean bl) {
        boolean bl2 = this.options.getForceRun();
        byte[] byArray = z80Assembler.getCreatedCode();
        if (byArray != null) {
            int n;
            int n2 = n = z80Assembler.getBegAddr();
            Integer n3 = z80Assembler.getEntryAddr();
            if (n3 != null) {
                n2 = n3;
            }
            if (this.emuThread != null && n >= 0 && n <= 65535) {
                String string = null;
                EmuSys emuSys = null;
                if (this.options.getCodeToSecondSystem() && (emuSys = this.emuThread.getEmuSys()) != null) {
                    string = emuSys.getSecondSystemName();
                }
                this.appendToLog("Lade Programmcode in Arbeitsspeicher");
                if (bl || string != null) {
                    this.appendToLog(" (");
                    if (string != null) {
                        this.appendToLog(string);
                        this.appendToLog(", ");
                    }
                    this.appendToLog(String.format("Bereich %04X-%04X)", n, n + byArray.length - 1));
                }
                if (bl2 && n2 >= 0) {
                    this.appendToLog(String.format("\nund starte Programm auf Adresse %04X", n2));
                } else if (bl2) {
                    this.appendToLog("\nStart des Programms nicht m\u00f6glich,\nda Quelltext keine ENT-Anweisung (Programmeintrittspunkt) enth\u00e4lt");
                }
                this.appendToLog("...\n");
                if (emuSys != null && string != null) {
                    emuSys.loadIntoSecondSystem(byArray, n, bl2 ? n2 : -1);
                } else {
                    this.emuThread.loadIntoMemory(new LoadData(byArray, 0, byArray.length, n, bl2 ? n2 : -1, null));
                }
            }
        } else {
            this.appendToLog("Programmcode kann nicht in Emulator geladen");
            if (bl2) {
                this.appendToLog(" und dort gestartet");
            }
            this.appendToLog(" werden,\nda kein einziges Byte erzeugt wurde.\n");
        }
    }

    @Override
    public void run() {
        TextEditFrm textEditFrm;
        block10: {
            textEditFrm = this.editText.getTextEditFrm();
            try {
                if (this.execute()) {
                    this.appendToLog("Fertig\n");
                }
            }
            catch (IOException iOException) {
                if (this.execEnabled) {
                    boolean bl = false;
                    String string = iOException.getMessage();
                    if (string != null && !string.isEmpty()) {
                        this.appendToLog("Fehler: ");
                        this.appendToLog(string);
                        if (!string.endsWith("\n")) {
                            this.appendToLog("\n");
                        }
                        bl = true;
                    }
                    if (!bl) {
                        this.appendToLog("Ein-/Ausgabefehler\n");
                    }
                } else {
                    this.appendToLog("Abgebrochen\n");
                }
            }
            catch (Exception exception) {
                if (!this.execEnabled) break block10;
                EventQueue.invokeLater(new ErrorMsg(textEditFrm, exception));
            }
        }
        if (textEditFrm != null) {
            textEditFrm.threadTerminated(this);
        }
    }
}

