/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.assembler;

import jkcemu.tools.Label;

public class AsmLabel
implements Label {
    private String labelName;
    private Object labelValue;
    private String hex16String;
    private int varSize;

    public AsmLabel(String string, int n) {
        this.labelName = string;
        this.labelValue = n;
        this.hex16String = null;
        this.varSize = -1;
    }

    public Object getLabelValue() {
        return this.labelValue;
    }

    public static boolean isIdentifierPart(char c) {
        return c == '_' || c == '@' || c == '?' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    public static boolean isIdentifierStart(char c) {
        return c == '_' || c == '@' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public void setLabelValue(Object object) {
        this.labelValue = object;
    }

    public void setVarSize(int n) {
        this.varSize = n;
    }

    @Override
    public String getLabelName() {
        return this.labelName;
    }

    @Override
    public int getVarSize() {
        return this.varSize;
    }

    @Override
    public int intValue() {
        int n = 0;
        if (this.labelValue != null && this.labelValue instanceof Number) {
            n = ((Number)this.labelValue).intValue();
        }
        return n;
    }

    @Override
    public int compareTo(Label label) {
        return label != null ? this.intValue() - label.intValue() : -1;
    }
}

