/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.assembler;

import java.io.IOException;
import java.util.Collection;
import jkcemu.Main;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.ScreenFrm;
import jkcemu.emusys.Z9001;
import jkcemu.programming.PrgLogger;
import jkcemu.programming.PrgOptions;
import jkcemu.programming.PrgSource;
import jkcemu.programming.PrgThread;
import jkcemu.programming.assembler.Z80Assembler;
import jkcemu.text.EditText;
import jkcemu.tools.Label;
import jkcemu.tools.ReassFrm;
import jkcemu.tools.debugger.DebugFrm;

public class AsmThread
extends PrgThread {
    private Z80Assembler assembler;

    public AsmThread(EmuThread emuThread, EditText editText, PrgOptions prgOptions, Appendable appendable) {
        super("JKCEMU assembler", emuThread, editText, prgOptions, appendable);
        this.assembler = new Z80Assembler(editText.getText(), null, editText.getFile(), prgOptions, PrgLogger.createLogger(appendable), true);
    }

    public Collection<PrgSource> getPrgSources() {
        return this.assembler.getPrgSources();
    }

    @Override
    public boolean execute() throws IOException {
        boolean bl;
        EmuSys emuSys;
        this.appendToLog("Assembliere...\n");
        boolean bl2 = false;
        if (this.emuThread != null && (emuSys = this.emuThread.getEmuSys()) != null) {
            bl2 = emuSys instanceof Z9001;
        }
        if (bl = this.assembler.assemble(null, bl2)) {
            Object object;
            if (this.options.getFormatSource() && (object = this.assembler.getFormattedSourceText()) != null) {
                this.fireReplaceSourceText((String)object);
            }
            if ((this.options.getCodeToEmu() || this.options.getForceRun()) && (object = (Object)this.assembler.getCreatedCode()) != null) {
                this.writeCodeToEmu(this.assembler, true);
                if (this.options.getLabelsToDebugger()) {
                    this.labelsToDebugger(this.options.getCodeToSecondSystem());
                }
                if (this.options.getLabelsToReassembler()) {
                    this.labelsToReass(this.options.getCodeToSecondSystem());
                }
            }
        }
        return bl;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.assembler.cancel();
    }

    private void labelsToDebugger(boolean bl) {
        ScreenFrm screenFrm;
        Label[] labelArray = this.assembler.getSortedLabels();
        if (labelArray != null && labelArray.length > 0 && (screenFrm = Main.getScreenFrm()) != null) {
            EmuSys emuSys;
            boolean bl2 = false;
            DebugFrm debugFrm = null;
            if (bl && this.emuThread != null && (emuSys = this.emuThread.getEmuSys()) != null && emuSys.getSecondSystemName() != null) {
                debugFrm = screenFrm.openSecondDebugger();
                bl2 = true;
            }
            if (!bl2) {
                debugFrm = screenFrm.openPrimaryDebugger();
            }
            if (debugFrm != null) {
                debugFrm.setLabels(labelArray, this.options.getSuppressLabelRecreateInDebugger(), this.options.getLabelsCaseSensitive());
            }
        }
    }

    private void labelsToReass(boolean bl) {
        ScreenFrm screenFrm;
        Label[] labelArray = this.assembler.getSortedLabels();
        if (labelArray != null && labelArray.length > 0 && (screenFrm = Main.getScreenFrm()) != null) {
            EmuSys emuSys;
            boolean bl2 = false;
            ReassFrm reassFrm = null;
            if (bl && this.emuThread != null && (emuSys = this.emuThread.getEmuSys()) != null && emuSys.getSecondSystemName() != null) {
                reassFrm = screenFrm.openSecondReassembler();
                bl2 = true;
            }
            if (!bl2) {
                reassFrm = screenFrm.openPrimaryReassembler();
            }
            if (reassFrm != null) {
                reassFrm.setLabels(labelArray, this.assembler.getBegAddr(), this.assembler.getEndAddr());
            }
        }
    }
}

