/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.util.HashMap;
import java.util.Map;
import jkcemu.base.EmuSys;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicLibrary;

public abstract class AbstractTarget {
    protected boolean xoutchAppended;
    protected boolean usesX_M_PEN;
    private Map<String, Integer> namedValues = new HashMap<String, Integer>();

    protected AbstractTarget() {
        this.setNamedValue("TARGET_CPM", 100);
        this.setNamedValue("TARGET_HUEBLER", 300);
        this.setNamedValue("TARGET_KC85", 400);
        this.setNamedValue("TARGET_KC85_4", 410);
        this.setNamedValue("TARGET_KRAMER", 600);
        this.setNamedValue("TARGET_SCCH", 700);
        this.setNamedValue("TARGET_AC1", 710);
        this.setNamedValue("TARGET_LLC2", 720);
        this.setNamedValue("TARGET_Z1013", 800);
        this.setNamedValue("TARGET_Z1013_64X16", 810);
        this.setNamedValue("TARGET_Z9001", 900);
        this.setNamedValue("TARGET_Z9001_KRT", 910);
        this.setNamedValue("GRAPHICSCREEN", -1);
        for (String string : new String[]{"LASTSCREEN", "BLACK", "JOYST_LEFT", "JOYST_RIGHT", "JOYST_UP", "JOYST_DOWN", "JOYST_BUTTON1", "JOYST_BUTTON2"}) {
            this.setNamedValue(string, 0);
        }
        for (String string : new String[]{"BLINKING", "BLUE", "CYAN", "GREEN", "MAGENTA", "RED", "WHITE", "YELLOW"}) {
            this.setNamedValue(string, 1);
        }
        this.reset();
    }

    protected static String[] add(String[] stringArray, String string) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = string;
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        } else {
            stringArray2 = new String[]{string};
        }
        return stringArray2;
    }

    public void appendDataTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendBssTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesX_M_PEN) {
            asmCodeBuf.append("X_M_PEN:\tDS\t1\n");
        }
    }

    public void appendEnableVdipTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendEtcPreXOutTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendEtcPastXOutTo(AsmCodeBuf asmCodeBuf) {
    }

    public abstract void appendExitTo(AsmCodeBuf var1);

    public void appendPreExitTo(AsmCodeBuf asmCodeBuf) {
    }

    protected void appendExitNoGraphicsScreenTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        this.appendSwitchToTextScreenTo(asmCodeBuf);
        asmCodeBuf.append("\tCALL\tXOUTST\n");
        if (basicCompiler.isLangCode("DE")) {
            asmCodeBuf.append("\tDB\t'Kein Grafik-SCREEN'\n");
        } else {
            asmCodeBuf.append("\tDB\t'No graphics screen'\n");
        }
        asmCodeBuf.append("\tDB\t00H\n");
        if (basicCompiler.getBasicOptions().getPrintLineNumOnAbort() && basicCompiler.usesLibItem(BasicLibrary.LibItem.E_EXIT)) {
            asmCodeBuf.append("\tJP\tE_EXIT\n");
        } else {
            asmCodeBuf.append("\tCALL\tXOUTNL\n\tJP\tXEXIT\n");
            basicCompiler.getLibItems().add(BasicLibrary.LibItem.XOUTNL);
        }
        basicCompiler.getLibItems().add(BasicLibrary.LibItem.XOUTST);
    }

    public void appendFileHandler(BasicCompiler basicCompiler) {
    }

    public void appendHCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0FFFFH\n");
    }

    public void appendHPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0000H\n");
    }

    public void appendInitTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesX_M_PEN) {
            asmCodeBuf.append("\tLD\tA,01H\n\tLD\t(X_M_PEN),A\n");
        }
    }

    public abstract void appendInputTo(AsmCodeBuf var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public void appendPrologTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler, String string) {
    }

    public void appendSwitchToTextScreenTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendWCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0FFFFH\n");
    }

    public void appendWPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0000H\n");
    }

    public void appendXBorderTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendXClsTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendXColorTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendXCursTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendXHLineTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
    }

    public void appendXInkTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendXJoyTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendXLocateTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendXLPtchTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLPTCH:\tRET\n");
    }

    public abstract void appendXOutchTo(AsmCodeBuf var1);

    public void appendXOutnlTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XOUTNL:\tLD\tA,0DH\n\tCALL\tXOUTCH\n\tLD\tA,0AH\n");
        if (this.xoutchAppended) {
            asmCodeBuf.append("\tJP\tXOUTCH\n");
        } else {
            this.appendXOutchTo(asmCodeBuf);
        }
    }

    public void appendXPaperTo(AsmCodeBuf asmCodeBuf) {
    }

    public void appendXPenTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XPEN:\tLD\t(X_M_PEN),A\n\tRET\n");
        this.usesX_M_PEN = true;
    }

    public void appendXPaintTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
    }

    public void appendXPointTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPOINT:\tLD\tHL,0FFFFH\n\tRET\n");
    }

    public void appendXPResTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
    }

    public void appendXPSetTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
    }

    public void appendXPTestTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPTEST:\tLD\tHL,0FFFFH\n\tRET\n");
    }

    public void appendXScreenTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XSCREEN:\n\tLD\tA,H\n\tOR\tL\n\tRET\tZ\n\tSCF\n\tRET\n");
    }

    public abstract int get100msLoopCount();

    public abstract String[] getBasicTargetNames();

    public abstract int getDefaultBegAddr();

    public int getCompatibilityLevel(EmuSys emuSys) {
        return 0;
    }

    public String getFileHandlerLabel() {
        return null;
    }

    public int getFileIOChannelSize() {
        return 0;
    }

    public int getMaxAppNameLen() {
        return 0;
    }

    public int getNamedValue(String string) {
        Integer n = this.namedValues.get(string);
        return n != null ? n : 0;
    }

    public String getStartCmd(EmuSys emuSys, String string, int n) {
        return null;
    }

    public int[] getTargetIDs() {
        int[] nArray = null;
        String[] stringArray = this.getBasicTargetNames();
        if (stringArray != null) {
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = this.getNamedValue(stringArray[i]);
            }
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public int[] getVdipBaseIOAddresses() {
        return null;
    }

    public boolean isReservedWord(String string) {
        return this.namedValues.containsKey(string.toUpperCase());
    }

    public boolean needsEnableVdip() {
        return false;
    }

    public void preAppendLibraryCode(BasicCompiler basicCompiler) {
    }

    public void reset() {
        this.xoutchAppended = false;
        this.usesX_M_PEN = false;
    }

    protected void setNamedValue(String string, int n) {
        this.namedValues.put(string, n);
    }

    public boolean startsWithFileDevice(String string) {
        return false;
    }

    public boolean supportsColors() {
        return false;
    }

    public boolean supportsBorderColor() {
        return false;
    }

    public boolean supportsGraphics() {
        return false;
    }

    public boolean supportsXCLS() {
        return false;
    }

    public boolean supportsXCURS() {
        return false;
    }

    public boolean supportsXHLINE() {
        return false;
    }

    public boolean supportsXJOY() {
        return false;
    }

    public boolean supportsXLOCAT() {
        return false;
    }

    public boolean supportsXPAINT_LEFT_RIGHT() {
        return false;
    }

    public boolean supportsXLPTCH() {
        return false;
    }
}

