/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.util.ArrayList;
import java.util.List;

public class AsmCodeBuf {
    private StringBuilder buf;
    private boolean enabled;

    public AsmCodeBuf(int n) {
        this.buf = new StringBuilder(n);
        this.enabled = true;
    }

    public void append(char c) {
        if (this.enabled) {
            this.buf.append(c);
        }
    }

    public void append(CharSequence charSequence) {
        if (this.enabled) {
            this.buf.append(charSequence);
        }
    }

    public void append(long l) {
        if (this.enabled) {
            this.buf.append(l);
        }
    }

    public void append(AsmCodeBuf asmCodeBuf) {
        if (this.enabled) {
            this.buf.append((CharSequence)asmCodeBuf.buf);
        }
    }

    public void appendHex2(int n) {
        if (this.enabled) {
            this.appendHex2Internal(n);
        }
    }

    public void appendHex4(int n) {
        if (this.enabled) {
            this.appendHex4Internal(n);
        }
    }

    public void appendStringLiteral(CharSequence charSequence, String string) {
        if (this.enabled) {
            int n = 0;
            int n2 = 0;
            if (charSequence != null) {
                int n3 = charSequence.length();
                for (int i = 0; i < n3; ++i) {
                    char c = charSequence.charAt(i);
                    if (c < ' ' || c > '~' || c == '\'' || c == '\"') {
                        if (n > 0) {
                            this.buf.append("'\n");
                            n = 0;
                        }
                        if (n2 > 0) {
                            this.buf.append(',');
                        } else {
                            this.buf.append("\tDB\t");
                        }
                        this.appendHex2Internal(c);
                        if (++n2 < 8) continue;
                        this.buf.append('\n');
                        n2 = 0;
                        continue;
                    }
                    if (n2 > 0) {
                        this.buf.append('\n');
                        n2 = 0;
                    }
                    if (n == 0) {
                        this.buf.append("\tDB\t'");
                    }
                    this.buf.append(c);
                    if (++n < 40) continue;
                    this.buf.append("'\n");
                    n = 0;
                }
            }
            if (n > 0) {
                this.buf.append("'\n");
            }
            if (n2 > 0) {
                this.buf.append(",");
            } else {
                this.buf.append("\tDB\t");
            }
            this.buf.append(string);
            this.buf.append('\n');
        }
    }

    public void appendStringLiteral(CharSequence charSequence) {
        this.appendStringLiteral(charSequence, "00H");
    }

    public void append_LD_A_n(int n) {
        if (this.enabled) {
            if (n == 0) {
                this.buf.append("\tXOR\tA\n");
            } else {
                this.buf.append("\tLD\tA,");
                this.appendHex2Internal(n);
                this.buf.append('\n');
            }
        }
    }

    public void append_LD_BC_nn(int n) {
        if (this.enabled) {
            this.buf.append("\tLD\tBC,");
            this.appendHex4Internal(n);
            this.buf.append('\n');
        }
    }

    public void append_LD_BC_xx(String string) {
        if (this.enabled && string != null) {
            this.buf.append("\tLD\tBC,");
            this.buf.append(string);
            this.buf.append('\n');
        }
    }

    public void append_LD_DE_nn(int n) {
        if (this.enabled) {
            this.buf.append("\tLD\tDE,");
            this.appendHex4Internal(n);
            this.buf.append('\n');
        }
    }

    public void append_LD_DE_xx(String string) {
        if (this.enabled && string != null) {
            this.buf.append("\tLD\tDE,");
            this.buf.append(string);
            this.buf.append('\n');
        }
    }

    public void append_LD_DE_IndirectIY(int n) {
        if (this.enabled) {
            if (n < 0) {
                n = -n;
                this.buf.append("\tLD\tD,(IY-");
                this.buf.append(n - 1);
                this.buf.append(")\n\tLD\tE,(IY-");
                this.buf.append(n);
                this.buf.append(")\n");
            } else {
                this.buf.append("\tLD\tD,(IY+");
                this.buf.append(n + 1);
                this.buf.append(")\n\tLD\tE,(IY+");
                this.buf.append(n);
                this.buf.append(")\n");
            }
        }
    }

    public void append_LD_HL_nn(int n) {
        if (this.enabled) {
            this.buf.append("\tLD\tHL,");
            this.appendHex4Internal(n);
            this.buf.append('\n');
        }
    }

    public void append_LD_HL_xx(String string) {
        if (this.enabled && string != null) {
            this.buf.append("\tLD\tHL,");
            this.buf.append(string);
            this.buf.append('\n');
        }
    }

    public void append_LD_HL_IndirectIY(int n) {
        if (this.enabled) {
            if (n < 0) {
                n = -n;
                this.buf.append("\tLD\tH,(IY-");
                this.buf.append(n - 1);
                this.buf.append(")\n\tLD\tL,(IY-");
                this.buf.append(n);
                this.buf.append(")\n");
            } else {
                this.buf.append("\tLD\tH,(IY+");
                this.buf.append(n + 1);
                this.buf.append(")\n\tLD\tL,(IY+");
                this.buf.append(n);
                this.buf.append(")\n");
            }
        }
    }

    public void append_LD_IndirectIY_HL(int n) {
        if (this.enabled) {
            if (n < 0) {
                n = -n;
                this.buf.append("\tLD\t(IY-");
                this.buf.append(n - 1);
                this.buf.append("),H\n\tLD\t(IY-");
                this.buf.append(n);
                this.buf.append("),L\n");
            } else {
                this.buf.append("\tLD\t(IY+");
                this.buf.append(n + 1);
                this.buf.append("),H\n\tLD\t(IY+");
                this.buf.append(n);
                this.buf.append("),L\n");
            }
        }
    }

    public boolean contains(String string) {
        return this.buf.indexOf(string) >= 0;
    }

    public String cut(int n) {
        String string = "";
        if (this.enabled) {
            string = this.buf.substring(n);
            this.buf.setLength(n);
        }
        return string;
    }

    public void delete(int n, int n2) {
        if (this.enabled) {
            this.buf.delete(n, n2);
        }
    }

    public int getLastLinePos() {
        int n = 0;
        int n2 = this.buf.length() - 1;
        if (n2 > 0 && this.buf.charAt(n2) == '\n') {
            while (n2 > 0) {
                if (this.buf.charAt(--n2) != '\n') continue;
                n = n2 + 1;
                break;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLinesAsList(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = this.buf;
        synchronized (stringBuilder) {
            int n2 = this.buf.length();
            if (n < 0) {
                n = 0;
            }
            while (n < n2) {
                int n3 = this.buf.indexOf("\n", n);
                if (n3 < n) {
                    arrayList.add(this.buf.substring(n));
                    break;
                }
                arrayList.add(this.buf.substring(n, ++n3));
                n = n3;
            }
        }
        return arrayList;
    }

    public int getNumOccurences(String string) {
        int n = 0;
        if (string != null) {
            int n2;
            int n3 = this.buf.length();
            int n4 = 0;
            while (n4 < n3 && (n2 = this.buf.indexOf(string, n4)) >= 0) {
                ++n;
                n4 = n2 + 1;
            }
        }
        return n;
    }

    public void insert(int n, CharSequence charSequence) {
        if (this.enabled && charSequence != null) {
            this.buf.insert(n, charSequence);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int length() {
        return this.buf.length();
    }

    public void newLine() {
        if (this.enabled) {
            this.buf.append('\n');
        }
    }

    public void removeAllOccurences(String string) {
        int n;
        if (this.enabled && string != null && (n = string.length()) > 0) {
            int n2;
            int n3 = this.buf.length();
            int n4 = 0;
            while (n4 < n3 && (n2 = this.buf.indexOf(string, n4)) >= 0) {
                this.buf.delete(n2, n2 + n);
                n4 = n2;
            }
        }
    }

    public boolean replace(String string, String string2) {
        boolean bl = false;
        if (this.enabled && this.contains(string)) {
            String string3 = this.buf.toString().replace(string, string2);
            this.buf.setLength(0);
            this.buf.append(string3);
            bl = true;
        }
        return bl;
    }

    public void replace(int n, int n2, String string) {
        if (this.enabled) {
            this.buf.replace(n, n2, string);
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setLength(int n) {
        if (this.enabled) {
            this.buf.setLength(n);
        }
    }

    public void setLines(List<String> list) {
        if (this.enabled) {
            this.buf.setLength(0);
            if (list != null) {
                for (String string : list) {
                    this.buf.append(string);
                }
            }
        }
    }

    public String substring(int n) {
        return this.buf.substring(n);
    }

    public String toString() {
        return this.buf.toString();
    }

    private void appendHex2Internal(int n) {
        if ((n &= 0xFF) >= 160) {
            this.buf.append('0');
        }
        this.buf.append(String.format("%02XH", n));
    }

    private void appendHex4Internal(int n) {
        if ((n &= 0xFFFF) >= 40960) {
            this.buf.append('0');
        }
        this.buf.append(String.format("%04XH", n));
    }
}

