/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import jkcemu.programming.PrgException;
import jkcemu.programming.assembler.AsmLine;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicLibrary;

public class AsmCodeOptimizer {
    private static final String CODE_CALL_O_GE = "\tCALL\tO_GE\n";
    private static final String CODE_CALL_O_LT = "\tCALL\tO_LT\n";
    private static final String CODE_CALL_SCREEN = "\tCALL\tSCREEN\n";
    private static final String CODE_SCREEN_0 = "\tLD\tHL,0000H\n\tCALL\tSCREEN\n";

    public static void optimize1(BasicCompiler basicCompiler) {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        if (asmCodeBuf != null) {
            asmCodeBuf.setEnabled(true);
            int n = asmCodeBuf.getNumOccurences(CODE_CALL_SCREEN);
            int n2 = asmCodeBuf.getNumOccurences(CODE_SCREEN_0);
            if (n > 0 && n == n2) {
                asmCodeBuf.removeAllOccurences(CODE_SCREEN_0);
                basicCompiler.getLibItems().remove((Object)BasicLibrary.LibItem.SCREEN);
            }
            List<String> list = asmCodeBuf.getLinesAsList(0);
            AsmCodeOptimizer.removeUnusedLineLabels(list, basicCompiler);
            asmCodeBuf.setLines(list);
            if (asmCodeBuf.replace("\tCALL\tO_LT\n\tLD\tA,H\n\tOR\tL\n\tJP\tZ,", "\tCALL\tCPHLDE\n\tJP\tNC,") && !asmCodeBuf.contains(CODE_CALL_O_LT)) {
                basicCompiler.getLibItems().remove((Object)BasicLibrary.LibItem.O_LT);
                basicCompiler.getLibItems().add(BasicLibrary.LibItem.CPHLDE);
            }
            if (asmCodeBuf.replace("\tCALL\tO_GE\n\tLD\tA,H\n\tOR\tL\n\tJP\tZ,", "\tCALL\tCPHLDE\n\tJP\tC,") && !asmCodeBuf.contains(CODE_CALL_O_GE)) {
                basicCompiler.getLibItems().remove((Object)BasicLibrary.LibItem.O_GE);
                basicCompiler.getLibItems().add(BasicLibrary.LibItem.CPHLDE);
            }
        }
    }

    public static void optimize2(BasicCompiler basicCompiler) {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        if (asmCodeBuf != null) {
            asmCodeBuf.setEnabled(true);
            List<String> list = asmCodeBuf.getLinesAsList(0);
            AsmCodeOptimizer.removeUselessJumpsAndUnreachableCode(list);
            AsmCodeOptimizer.removeUselessLoadReg(list);
            asmCodeBuf.setLines(list);
        }
    }

    private static void removeUnusedLineLabels(List<String> list, BasicCompiler basicCompiler) {
        SortedSet<String> sortedSet = basicCompiler.getAllLineLabels();
        SortedSet<String> sortedSet2 = basicCompiler.getUsedLineLabels();
        if (sortedSet != null && sortedSet2 != null) {
            int n = 0;
            while (n < list.size()) {
                String string;
                int n2;
                String string2;
                int n3;
                if ((n3 = (string2 = list.get(n++)).length()) <= (n2 = "L_".length()) + 2 || !string2.startsWith("L_") || !string2.endsWith(":\n") || !sortedSet.contains(string = string2.substring(n2, n3 - 2)) || sortedSet2.contains(string)) continue;
                list.remove(--n);
            }
        }
    }

    private static void removeUselessJumpsAndUnreachableCode(List<String> list) {
        boolean bl = false;
        int n = 0;
        while (n < list.size()) {
            try {
                String string;
                AsmLine asmLine;
                if ((asmLine = AsmLine.scanLine(null, list.get(n++), true)) == null) continue;
                String string2 = asmLine.getLabel();
                if (!bl && string2 != null && string2.equals("MSTART")) {
                    bl = true;
                }
                if (!bl || (string = asmLine.getInstruction()) == null) continue;
                boolean bl2 = false;
                String string3 = null;
                if (string.equals("JP") || string.equals("JR")) {
                    if (asmLine.hasMoreArgs()) {
                        bl2 = true;
                        string3 = asmLine.nextArg().toString();
                        if (asmLine.hasMoreArgs()) {
                            bl2 = false;
                            string3 = asmLine.nextArg().toString();
                        }
                    }
                } else if (string.equals("RET") && !asmLine.hasMoreArgs()) {
                    bl2 = true;
                }
                if (!bl2 && string3 == null) continue;
                String string4 = null;
                int n2 = n;
                while (string4 == null & n2 < list.size()) {
                    AsmLine asmLine2;
                    String string5 = null;
                    if ((asmLine2 = AsmLine.scanLine(null, list.get(n2++), true)) != null) {
                        string5 = asmLine2.getInstruction();
                        string4 = asmLine2.getLabel();
                        if (string4 == null && bl2 && string5 != null) {
                            list.remove(--n2);
                            string5 = null;
                        }
                    }
                    if (string4 == null && string5 == null) continue;
                    break;
                }
                if (string3 == null || string4 == null || !string3.equals(string4)) continue;
                if (string2 != null) {
                    list.set(n - 1, string2 + ":\n");
                    continue;
                }
                list.remove(--n);
            }
            catch (PrgException prgException) {}
        }
    }

    private static void removeUselessLoadReg(List<String> list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        int n = 0;
        while (n < list.size()) {
            int n2;
            String string;
            if (!((string = list.get(n++)).isEmpty() || string.startsWith("\n") || string.startsWith(";") || string.startsWith("\t"))) {
                treeSet.clear();
                treeSet2.clear();
                n2 = string.indexOf(9);
                if (n2 > 0 && string.indexOf(59) < 0) {
                    string = string.substring(n2);
                }
            }
            if (string.isEmpty() || string.startsWith("\n") || string.startsWith(";")) continue;
            if (string.startsWith("\tLD\t")) {
                String string2;
                n2 = string.length();
                if (string.startsWith("\tLD\tA,")) {
                    if (!(n2 <= 7 || !string.endsWith("\n") || string.startsWith("\tLD\tA,(HL)") || string.startsWith("\tLD\tA,(IX)") || string.startsWith("\tLD\tA,(IX+") || string.startsWith("\tLD\tA,(IX-") || string.startsWith("\tLD\tA,(IY)") || string.startsWith("\tLD\tA,(IY+") || string.startsWith("\tLD\tA,(IY-"))) {
                        string2 = string.substring(6, n2 - 1);
                        if (treeSet.contains(string2)) {
                            list.remove(--n);
                            continue;
                        }
                        treeSet.clear();
                        treeSet.add(string2);
                        continue;
                    }
                    treeSet.clear();
                    continue;
                }
                if (string.startsWith("\tLD\tHL,")) {
                    if (n2 <= 8 || !string.endsWith("\n")) continue;
                    string2 = string.substring(7, n2 - 1);
                    if (treeSet2.contains(string2)) {
                        list.remove(--n);
                        continue;
                    }
                    treeSet2.clear();
                    treeSet2.add(string2);
                    continue;
                }
                if (string.startsWith("\tLD\tH,") || string.startsWith("\tLD\tL,")) {
                    treeSet2.clear();
                    continue;
                }
                if (string.startsWith("\tLD\t(") && string.endsWith("),A\n") && n2 > 8) {
                    if (string.startsWith("\tLD\t(HL)") || string.startsWith("\tLD\t(IX)") || string.startsWith("\tLD\t(IX+") || string.startsWith("\tLD\t(IX-") || string.startsWith("\tLD\t(IY)") || string.startsWith("\tLD\t(IY+") || string.startsWith("\tLD\t(IY-")) continue;
                    treeSet.add(string.substring(4, n2 - 4));
                    continue;
                }
                if (!string.startsWith("\tLD\t(") || !string.endsWith("),HL\n") || n2 <= 9) continue;
                treeSet2.add(string.substring(4, n2 - 4));
                continue;
            }
            if (string.startsWith("\tXOR\tA\n")) {
                String string3 = "00H";
                if (treeSet.contains(string3)) {
                    list.remove(--n);
                    continue;
                }
                treeSet.clear();
                treeSet.add(string3);
                continue;
            }
            treeSet.clear();
            treeSet2.clear();
        }
    }
}

