/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.io.File;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import jkcemu.programming.PrgException;
import jkcemu.programming.PrgLogger;
import jkcemu.programming.PrgSource;
import jkcemu.programming.TooManyErrorsException;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.AsmCodeOptimizer;
import jkcemu.programming.basic.BasicExprParser;
import jkcemu.programming.basic.BasicLibrary;
import jkcemu.programming.basic.BasicLineExpr;
import jkcemu.programming.basic.BasicOptions;
import jkcemu.programming.basic.BasicSourcePos;
import jkcemu.programming.basic.BasicUtil;
import jkcemu.programming.basic.CallableEntry;
import jkcemu.programming.basic.DoEntry;
import jkcemu.programming.basic.ForEntry;
import jkcemu.programming.basic.FunctionEntry;
import jkcemu.programming.basic.IfEntry;
import jkcemu.programming.basic.LoopEntry;
import jkcemu.programming.basic.SimpleVarInfo;
import jkcemu.programming.basic.SubEntry;
import jkcemu.programming.basic.VarDecl;
import jkcemu.programming.basic.WhileEntry;

public class BasicCompiler {
    public static final int DATA_INT1 = 1;
    public static final int DATA_INT2 = 2;
    public static final int DATA_STRING = 17;
    public static final int MAGIC_GOSUB = 71;
    public static final int MAX_INT_VALUE = Short.MAX_VALUE;
    public static final int MAX_STR_LEN = 255;
    public static final String ERR_POS_TEXT = " ??? ";
    public static final String DATA_LABEL_PREFIX = "D_";
    public static final String LINE_LABEL_PREFIX = "L_";
    public static final String START_LABEL = "MSTART";
    public static final String TOP_LABEL = "MTOP";
    private static final String[] sortedReservedWords = new String[]{"ABS", "ADD", "AND", "APPEND", "AS", "ASC", "ASM", "AT", "BIN$", "BINARY", "BORDER", "BSS", "CALL", "CASE", "CHR$", "CIRCLE", "CLOSE", "CLS", "CODE", "COLOR", "CURSOR", "DATA", "DECLARE", "DEEK", "DEF", "DEFUSR", "DEFUSR0", "DEFUSR1", "DEFUSR2", "DEFUSR3", "DEFUSR4", "DEFUSR5", "DEFUSR6", "DEFUSR7", "DEFUSR8", "DEFUSR9", "DIM", "DO", "DOKE", "DRAW", "DRAWR", "ELSE", "ELSEIF", "END", "ENDIF", "EOF", "ERR", "ERR$", "EXIT", "E_CHANNEL_ALREADY_OPEN", "E_CHANNEL_CLOSED", "E_DEVICE_LOCKED", "E_DEVICE_NOT_FOUND", "E_DISK_FULL", "E_EOF", "E_ERROR", "E_FILE_NOT_FOUND", "E_INVALID", "E_IO_ERROR", "E_IO_MODE", "E_NO_DISK", "E_OK", "E_OVERFLOW", "E_PATH_NOT_FOUND", "E_READ_ONLY", "E_SOCKET_STATUS", "E_UNKNOWN_HOST", "FALSE", "FOR", "FUNCTION", "GOSUB", "GOTO", "HEX$", "HIBYTE", "H_CHAR", "H_PIXEL", "IF", "IN", "INCLUDE", "INK", "INKEY$", "INP", "INPUT", "INPUT$", "INSTR", "JOYST", "JOYST_BUTTONS", "LABEL", "LCASE$", "LEFT$", "LEN", "LET", "LINE", "LOBYTE", "LOCAL", "LOCATE", "LOOP", "LOWER$", "LPRINT", "LTRIM$", "MAX", "MEMSTR$", "MID$", "MIN", "MIRROR$", "MOD", "MOVE", "MOVER", "NEXT", "NOT", "ON", "OPEN", "OR", "OUT", "OUTPUT", "PAINT", "PAPER", "PASSWORD", "PAUSE", "PEEK", "PEN", "PEN_NONE", "PEN_NORMAL", "PEN_RUBBER", "PEN_XOR", "PLOT", "PLOTR", "POINT", "POKE", "PRESET", "PRINT", "PSET", "PTEST", "READ", "REM", "RESTORE", "RETURN", "RIGHT$", "RND", "RTRIM$", "SCREEN", "SELECT", "SGN", "SHL", "SHR", "SPACE$", "SQR", "STEP", "STOP", "STR$", "STRING$", "SUB", "TEXT", "THEN", "TO", "TOP", "TRIM$", "TRUE", "UCASE$", "UNTIL", "UPPER$", "USING", "USR", "USR0", "USR1", "USR2", "USR3", "USR4", "USR5", "USR6", "USR7", "USR8", "USR9", "VAL", "VDIP", "WAIT", "WEND", "WHILE", "WRITE", "W_CHAR", "W_PIXEL", "XOR", "XPOS", "YPOS"};
    private PrgSource curSource;
    private PrgSource mainSource = null;
    private AbstractTarget target;
    private BasicOptions options;
    private PrgLogger logger;
    private Map<IODriver, Set<Integer>> ioDriverModes;
    private Set<BasicLibrary.LibItem> libItems;
    private SortedSet<String> basicLines;
    private Collection<BasicLineExpr> destBasicLines;
    private Set<String> dataBasicLines;
    private Collection<BasicLineExpr> restoreBasicLines;
    private Stack<BasicSourcePos> structureStack;
    private Map<String, CallableEntry> name2Callable;
    private Map<String, VarDecl> name2GlobalVar;
    private Map<String, String> str2Label;
    private SortedSet<String> usrLabels;
    private AsmCodeBuf asmOut;
    private AsmCodeBuf dataOut;
    private StringBuilder userData;
    private StringBuilder userBSS;
    private boolean gcRequired;
    private boolean execEnabled;
    private boolean mainPrg;
    private boolean separatorChecked;
    private boolean tmpStrBufUsed;
    private int errCnt;
    private int labelNum;
    private int codeCreationDisabledLevel;
    private int codePosAtBegOfSrcLine;
    private long curBasicLineNum;
    private long lastBasicLineNum;
    private String lastBasicLineExpr;

    public BasicCompiler(String string, File file, BasicOptions basicOptions, PrgLogger prgLogger) {
        this.target = basicOptions.getTarget();
        this.options = basicOptions;
        this.logger = prgLogger;
        this.ioDriverModes = new HashMap<IODriver, Set<Integer>>();
        this.libItems = new HashSet<BasicLibrary.LibItem>();
        this.basicLines = new TreeSet<String>();
        this.destBasicLines = new ArrayList<BasicLineExpr>(1024);
        this.dataBasicLines = null;
        this.restoreBasicLines = null;
        this.structureStack = new Stack();
        this.name2Callable = new HashMap<String, CallableEntry>();
        this.str2Label = new HashMap<String, String>();
        this.name2GlobalVar = new HashMap<String, VarDecl>();
        this.usrLabels = new TreeSet<String>();
        this.asmOut = new AsmCodeBuf(32768);
        this.dataOut = null;
        this.userData = null;
        this.userBSS = null;
        this.execEnabled = true;
        this.mainPrg = true;
        this.gcRequired = false;
        this.separatorChecked = false;
        this.tmpStrBufUsed = false;
        this.codeCreationDisabledLevel = 0;
        this.errCnt = 0;
        this.labelNum = 1;
        this.curBasicLineNum = -1L;
        this.lastBasicLineNum = -1L;
        this.lastBasicLineExpr = null;
        if (string != null) {
            this.mainSource = PrgSource.readText(string, null, file);
        } else if (file != null) {
            try {
                this.mainSource = PrgSource.readFile(file);
            }
            catch (IOException iOException) {
                String string2 = iOException.getMessage();
                if (string2 != null && (string2 = string2.trim()).isEmpty()) {
                    string2 = null;
                }
                if (string2 == null) {
                    string2 = "Datei kann nicht ge\u00f6ffnet werden";
                }
                this.appendToErrLog(file.getPath() + ": " + string2);
            }
        }
        this.curSource = this.mainSource;
    }

    public void addLibItem(BasicLibrary.LibItem libItem) {
        if (this.asmOut.isEnabled()) {
            this.libItems.add(libItem);
        }
    }

    public void cancel() {
        this.execEnabled = false;
    }

    public SimpleVarInfo checkVariable(CharacterIterator characterIterator, String string) throws PrgException {
        SimpleVarInfo simpleVarInfo = null;
        if (string != null && !string.isEmpty() && !this.isReservedWord(string)) {
            boolean bl = false;
            String string2 = null;
            Integer n = null;
            CallableEntry callableEntry = this.getEnclosingCallableEntry();
            if (callableEntry != null && !string.equals(callableEntry.getName()) && (n = callableEntry.getIYOffs(string)) != null) {
                callableEntry.setVarUsed(string);
                bl = true;
            }
            if (!bl && !this.name2Callable.containsKey(string)) {
                VarDecl varDecl = this.name2GlobalVar.get(string);
                if (varDecl != null) {
                    varDecl.setUsed();
                    if (varDecl.getDimCount() > 0) {
                        BasicUtil.parseToken(characterIterator, '(');
                        if (varDecl.getDimCount() == 1) {
                            int n2 = this.asmOut.length();
                            BasicExprParser.parseExpr(this, characterIterator);
                            Integer n3 = BasicUtil.removeLastCodeIfConstExpr(this, n2);
                            if (n3 != null) {
                                if (n3 < 0 || n3 > varDecl.getDim1()) {
                                    BasicUtil.throwIndexOutOfRange();
                                }
                                string2 = n3 > 0 ? (n3 >= 40960 ? String.format("%s+0%04XH", varDecl.getLabel(), n3 * 2) : String.format("%s+%04XH", varDecl.getLabel(), n3 * 2)) : varDecl.getLabel();
                            } else if (this.options.getCheckBounds()) {
                                this.asmOut.append_LD_BC_nn(varDecl.getDim1() + 1);
                                this.asmOut.append_LD_DE_xx(varDecl.getLabel());
                                this.asmOut.append("\tCALL\tARYADR\n");
                                this.addLibItem(BasicLibrary.LibItem.ARYADR);
                            } else {
                                this.asmOut.append("\tADD\tHL,HL\n");
                                this.asmOut.append_LD_DE_xx(varDecl.getLabel());
                                this.asmOut.append("\tADD\tHL,DE\n");
                            }
                        } else if (varDecl.getDimCount() == 2) {
                            int n4 = this.asmOut.length();
                            BasicExprParser.parseExpr(this, characterIterator);
                            Integer n5 = BasicUtil.removeLastCodeIfConstExpr(this, n4);
                            if (n5 != null) {
                                if (n5 < 0 || n5 > varDecl.getDim1()) {
                                    BasicUtil.throwIndexOutOfRange();
                                }
                            } else if (this.options.getCheckBounds()) {
                                this.asmOut.append_LD_BC_nn(varDecl.getDim1() + 1);
                                this.asmOut.append("\tCALL\tCKIDX\n");
                                this.addLibItem(BasicLibrary.LibItem.CKIDX);
                            }
                            BasicUtil.parseToken(characterIterator, ',');
                            n4 = this.asmOut.length();
                            BasicExprParser.parseExpr(this, characterIterator);
                            Integer n6 = BasicUtil.removeLastCodeIfConstExpr(this, n4);
                            if (n6 != null) {
                                if (n6 < 0 || n6 > varDecl.getDim2()) {
                                    BasicUtil.throwIndexOutOfRange();
                                }
                                if (n5 != null) {
                                    this.asmOut.append("\tLD\tHL,");
                                    this.asmOut.append(varDecl.getLabel());
                                    int n7 = (n5 * (varDecl.getDim2() + 1) + n6) * 2;
                                    if (n7 > 0) {
                                        this.asmOut.append('+');
                                        this.asmOut.appendHex4(n7);
                                    }
                                    this.asmOut.newLine();
                                } else {
                                    if (varDecl.getDim2() == 1) {
                                        this.asmOut.append("\tADD\tHL,HL\n");
                                    } else {
                                        this.asmOut.append_LD_DE_nn(varDecl.getDim2() + 1);
                                        this.asmOut.append("\tCALL\tO_MUL\n");
                                        this.addLibItem(BasicLibrary.LibItem.O_MUL);
                                    }
                                    if (n6 == 1) {
                                        this.asmOut.append("\tINC\tHL\n");
                                    } else if (n6 > 1) {
                                        this.asmOut.append_LD_DE_nn(n6);
                                        this.asmOut.append("\tADD\tHL,DE\n");
                                    }
                                    this.asmOut.append("\tADD\tHL,HL\n\tLD\tDE,");
                                    this.asmOut.append(varDecl.getLabel());
                                    this.asmOut.append("\n\tADD\tHL,DE\n");
                                }
                            } else {
                                if (this.options.getCheckBounds()) {
                                    this.asmOut.append_LD_BC_nn(varDecl.getDim2() + 1);
                                    this.asmOut.append("\tCALL\tCKIDX\n");
                                    this.addLibItem(BasicLibrary.LibItem.CKIDX);
                                }
                                if (n5 != null) {
                                    this.asmOut.append_LD_DE_nn(n5 * (varDecl.getDim2() + 1));
                                } else {
                                    if (varDecl.getDim2() == 1) {
                                        this.asmOut.insert(n4, "\tADD\tHL,HL\n\tPUSH\tHL\n");
                                    } else {
                                        this.asmOut.insert(n4, String.format("\tLD\tDE,%04XH\n\tCALL\tO_MUL\n\tPUSH\tHL\n", varDecl.getDim2() + 1));
                                        this.addLibItem(BasicLibrary.LibItem.O_MUL);
                                    }
                                    this.asmOut.append("\tPOP\tDE\n");
                                }
                                this.asmOut.append("\tADD\tHL,DE\n\tADD\tHL,HL\n\tLD\tDE,");
                                this.asmOut.append(varDecl.getLabel());
                                this.asmOut.append("\n\tADD\tHL,DE\n");
                            }
                        }
                        BasicUtil.parseToken(characterIterator, ')');
                    } else {
                        string2 = varDecl.getLabel();
                    }
                } else {
                    if (callableEntry != null) {
                        throw new PrgException("Implizite Variablendeklaration in einer Funktion/Prozedur nicht erlaubt");
                    }
                    varDecl = new VarDecl(this.curSource, this.curBasicLineNum, string);
                    varDecl.setUsed();
                    this.name2GlobalVar.put(string, varDecl);
                    string2 = varDecl.getLabel();
                }
                bl = true;
            }
            if (bl) {
                simpleVarInfo = string.endsWith("$") ? new SimpleVarInfo(DataType.STRING, string2, n) : new SimpleVarInfo(DataType.INTEGER, string2, n);
            }
        }
        return simpleVarInfo;
    }

    public String compile() throws IOException {
        String string = null;
        this.execEnabled = true;
        this.errCnt = 0;
        this.setCodeCreationDisabledLevel(0);
        this.target.reset();
        try {
            if (this.options.getShowAssemblerText()) {
                this.asmOut.append("\n;Eigentliches Programm\n");
            }
            this.parseSourceText();
            if (this.execEnabled) {
                AsmCodeOptimizer.optimize1(this);
                this.target.preAppendLibraryCode(this);
                BasicLibrary.appendCodeTo(this);
                AsmCodeBuf asmCodeBuf = new AsmCodeBuf(1024);
                int n = this.options.getBssBegAddr();
                if (n < 0 || n > this.options.getCodeBegAddr()) {
                    this.appendHeadCommentTo(asmCodeBuf);
                }
                asmCodeBuf.append("\n\tORG\t");
                asmCodeBuf.appendHex4(this.options.getCodeBegAddr());
                asmCodeBuf.newLine();
                this.target.appendPrologTo(asmCodeBuf, this, this.options.getAppName());
                BasicLibrary.appendInitTo(asmCodeBuf, this, this.name2GlobalVar, this.usrLabels);
                asmCodeBuf.append(this.asmOut);
                this.asmOut = asmCodeBuf;
                AsmCodeOptimizer.optimize2(this);
                if (this.libItems.contains((Object)BasicLibrary.LibItem.DATA)) {
                    if (this.options.getShowAssemblerText()) {
                        this.asmOut.append("\n;DATA-Zeilen\n");
                    }
                    this.asmOut.append("DBEG:\n");
                    if (this.dataOut != null) {
                        this.asmOut.append(this.dataOut);
                        this.asmOut.append("\tDB\t00H\n");
                    }
                }
                BasicLibrary.appendDataTo(this, this.str2Label, this.userData);
                AsmCodeBuf asmCodeBuf2 = this.asmOut;
                if (n >= 0) {
                    if (n < this.options.getCodeBegAddr()) {
                        asmCodeBuf2 = new AsmCodeBuf(1024);
                        this.appendHeadCommentTo(asmCodeBuf2);
                    }
                    asmCodeBuf2.append("\n\tORG\t");
                    asmCodeBuf2.appendHex4(n);
                    asmCodeBuf2.append("\n");
                }
                BasicLibrary.appendBssTo(asmCodeBuf2, this, this.name2GlobalVar, this.usrLabels, this.userBSS);
                if (asmCodeBuf2 != this.asmOut) {
                    asmCodeBuf2.append("\n");
                    asmCodeBuf2.append(this.asmOut);
                    this.asmOut = asmCodeBuf2;
                }
                if (this.errCnt == 0) {
                    string = this.asmOut.toString();
                }
            }
        }
        catch (TooManyErrorsException tooManyErrorsException) {
            this.appendToErrLog("\nAbgebrochen aufgrund zu vieler Fehler\n");
        }
        if (this.execEnabled && this.errCnt > 0) {
            this.appendToErrLog(String.format("%d Fehler\n", this.errCnt));
        }
        return string;
    }

    public SortedSet<String> getAllLineLabels() {
        return this.basicLines;
    }

    public BasicOptions getBasicOptions() {
        return this.options;
    }

    public CallableEntry getCallableEntry(String string) {
        return string != null ? this.name2Callable.get(string) : null;
    }

    public AsmCodeBuf getCodeBuf() {
        return this.asmOut;
    }

    public CallableEntry getEnclosingCallableEntry() {
        BasicSourcePos basicSourcePos;
        CallableEntry callableEntry = null;
        if (!this.structureStack.isEmpty() && (basicSourcePos = (BasicSourcePos)this.structureStack.get(0)) instanceof CallableEntry) {
            callableEntry = (CallableEntry)basicSourcePos;
        }
        return callableEntry;
    }

    public int getIOChannelSize() {
        int n = 10;
        if (this.usesLibItem(BasicLibrary.LibItem.IO_FILE_HANDLER)) {
            n = Math.max(n, this.target.getFileIOChannelSize());
        }
        return n;
    }

    public Set<Integer> getIODriverModes(IODriver iODriver) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        if (iODriver != null) {
            Set<Integer> set;
            Set<Integer> set2 = this.ioDriverModes.get((Object)iODriver);
            if (set2 != null) {
                treeSet.addAll(set2);
            }
            if (iODriver != IODriver.ALL && (set = this.ioDriverModes.get((Object)IODriver.ALL)) != null) {
                treeSet.addAll(set);
            }
        }
        return treeSet;
    }

    public Set<BasicLibrary.LibItem> getLibItems() {
        return this.libItems;
    }

    public String getStringLiteralLabel(String string) {
        String string2 = this.str2Label.get(string);
        if (string2 == null) {
            string2 = this.nextLabel();
            this.str2Label.put(string, string2);
        }
        return string2;
    }

    public AbstractTarget getTarget() {
        return this.target;
    }

    public SortedSet<String> getUsedLineLabels() {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (this.destBasicLines != null) {
            for (BasicLineExpr basicLineExpr : this.destBasicLines) {
                treeSet.add(basicLineExpr.getExprText().toUpperCase());
            }
        }
        if (this.restoreBasicLines != null) {
            for (BasicLineExpr basicLineExpr : this.restoreBasicLines) {
                treeSet.add(basicLineExpr.getExprText().toUpperCase());
            }
        }
        return treeSet;
    }

    public String getUsrLabel(int n) {
        String string = String.format("M_USR%d", n);
        this.usrLabels.add(string);
        return string;
    }

    public boolean isLangCode(String string) {
        String string2;
        boolean bl = false;
        if (string != null && (string2 = this.options.getLangCode()) != null) {
            bl = string.equalsIgnoreCase(string2);
        }
        return bl;
    }

    public boolean needsDriver(IODriver iODriver) {
        return this.ioDriverModes.containsKey((Object)iODriver) || this.ioDriverModes.containsKey((Object)IODriver.ALL);
    }

    public void lockTmpStrBuf() throws PrgException {
        if (this.tmpStrBufUsed) {
            throw new PrgException("String-Funktion hier nicht erlaubt, da der interne String-Puffer bereits durch eine andere String-Funktion belegt ist\nWeisen Sie bitte den String-Ausdruck einer Variablen zu und verwenden Sie diese hier.");
        }
        this.tmpStrBufUsed = true;
    }

    public String nextLabel() {
        return String.format("M%d", this.labelNum++);
    }

    public void parseASM(CharacterIterator characterIterator, boolean bl) throws PrgException {
        if (bl) {
            BasicUtil.parseToken(characterIterator, '(');
        }
        do {
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl && !BasicUtil.checkKeyword(characterIterator, "CODE")) {
                if (BasicUtil.checkKeyword(characterIterator, "DATA")) {
                    bl2 = true;
                } else if (BasicUtil.checkKeyword(characterIterator, "BSS")) {
                    bl3 = true;
                }
            }
            String string = this.parseStringLiteral(characterIterator);
            if (bl2) {
                if (this.userData == null) {
                    this.userData = new StringBuilder(2048);
                }
                this.userData.append(string);
                this.userData.append('\n');
                continue;
            }
            if (bl3) {
                if (this.userBSS == null) {
                    this.userBSS = new StringBuilder(2048);
                }
                this.userBSS.append(string);
                this.userBSS.append('\n');
                continue;
            }
            this.asmOut.append(string);
            this.asmOut.newLine();
        } while (BasicUtil.checkToken(characterIterator, ','));
        if (bl) {
            BasicUtil.parseToken(characterIterator, ')');
        }
    }

    public void parseCallableCall(CharacterIterator characterIterator, CallableEntry callableEntry) throws PrgException {
        int n;
        int n2;
        if (this.options.getCheckStack() && this.options.getStackSize() > 0) {
            this.asmOut.append_LD_DE_nn(callableEntry.getTotalArgSize() + callableEntry.getTotalVarSize());
            this.asmOut.append("\tCALL\tCKSTKN\n");
            this.addLibItem(BasicLibrary.LibItem.CKSTK);
        }
        if ((n2 = callableEntry.getArgCount()) > 0) {
            BasicUtil.parseToken(characterIterator, '(');
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    BasicUtil.parseToken(characterIterator, ',');
                }
                if (callableEntry.getArgType(n) == DataType.STRING) {
                    String string = BasicUtil.checkStringLiteral(this, characterIterator);
                    if (string != null) {
                        this.asmOut.append("\tLD\tHL,");
                        this.asmOut.append(this.getStringLiteralLabel(string));
                        this.asmOut.append("\n\tPUSH\tHL\n");
                        continue;
                    }
                    SimpleVarInfo simpleVarInfo = this.checkVariable(characterIterator);
                    if (simpleVarInfo != null) {
                        simpleVarInfo.ensureValueInDE(this.asmOut);
                        this.asmOut.append("\tCALL\tSVDUP\n\tPUSH\tDE\n");
                        this.addLibItem(BasicLibrary.LibItem.SVDUP);
                        continue;
                    }
                    BasicExprParser.parseStringPrimExpr(this, characterIterator);
                    this.asmOut.append("\tCALL\tSMACP\n\tPUSH\tHL\n");
                    this.addLibItem(BasicLibrary.LibItem.SMACP);
                    continue;
                }
                BasicExprParser.parseExpr(this, characterIterator);
                this.asmOut.append("\tPUSH\tHL\n");
            }
            BasicUtil.parseToken(characterIterator, ')');
        } else if (BasicUtil.checkToken(characterIterator, '(')) {
            BasicUtil.parseToken(characterIterator, ')');
        }
        this.asmOut.append("\tCALL\t");
        this.asmOut.append(callableEntry.getLabel());
        this.asmOut.newLine();
        if (n2 > 0) {
            if (n2 > 5) {
                this.asmOut.append_LD_HL_nn(2 * n2);
                this.asmOut.append("\tADD\tHL,SP\n\tLD\tSP,HL\n");
            } else {
                for (n = 0; n < n2; ++n) {
                    this.asmOut.append("\tPOP\tHL\n");
                }
            }
        }
        if (callableEntry instanceof FunctionEntry) {
            this.asmOut.append("\tLD\tHL,(M_FRET)\n");
            this.addLibItem(BasicLibrary.LibItem.M_FRET);
            if (((FunctionEntry)callableEntry).getReturnType() == DataType.STRING) {
                this.gcRequired = true;
            }
        }
        callableEntry.putCallPos(this.curSource, this.curBasicLineNum);
    }

    public void parseIOChannelNumToPtrFldAddrInHL(CharacterIterator characterIterator, AtomicBoolean atomicBoolean) throws PrgException {
        Integer n = BasicUtil.readNumber(characterIterator);
        if (n != null) {
            switch (n) {
                case 1: {
                    this.asmOut.append("\tLD\tHL,IOCTB1\n");
                    this.addLibItem(BasicLibrary.LibItem.IOCTB1);
                    break;
                }
                case 2: {
                    this.asmOut.append("\tLD\tHL,IOCTB2\n");
                    this.addLibItem(BasicLibrary.LibItem.IOCTB2);
                    break;
                }
                default: {
                    BasicCompiler.throwIOChannelNumOutOfRange();
                }
            }
            if (atomicBoolean != null) {
                atomicBoolean.set(true);
            }
        } else {
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tCALL\tIOCADR\n");
            this.addLibItem(BasicLibrary.LibItem.IOCADR);
            this.addLibItem(BasicLibrary.LibItem.IOCTB1);
            this.addLibItem(BasicLibrary.LibItem.IOCTB2);
            if (atomicBoolean != null) {
                atomicBoolean.set(false);
            }
        }
    }

    public void putWarningNonAsciiChar(char c) {
        this.putWarning(String.format("'%c': kein ASCII-Zeichen, kann im Zielsystem ein anderes Zeichen sein", Character.valueOf(c)));
    }

    public void putWarningOutOfRange() {
        this.putWarning("Wert au\u00dferhalb des Wertebereiches");
    }

    public boolean usesErrorVars() {
        return this.libItems.contains((Object)BasicLibrary.LibItem.M_ERN) || this.libItems.contains((Object)BasicLibrary.LibItem.M_ERT);
    }

    public boolean usesLibItem(BasicLibrary.LibItem libItem) {
        return this.libItems.contains((Object)libItem);
    }

    private void appendHeadCommentTo(AsmCodeBuf asmCodeBuf) {
        if (this.options.getShowAssemblerText()) {
            asmCodeBuf.append(";\n;Dieser Quelltext wurde vom JKCEMU-BASIC-Compiler erzeugt.\n;http://www.jens-mueller.org/jkcemu/\n;\n");
        }
    }

    private void appendLineNotFoundToErrLog(BasicLineExpr basicLineExpr, String string) throws TooManyErrorsException {
        if (basicLineExpr != null) {
            StringBuilder stringBuilder = new StringBuilder(128);
            if (basicLineExpr.appendMsgPrefixTo("Fehler", stringBuilder)) {
                stringBuilder.append(": ");
            }
            if (basicLineExpr.isLabel()) {
                stringBuilder.append("Marke '");
                stringBuilder.append(basicLineExpr.getExprText());
                stringBuilder.append('\'');
            } else {
                stringBuilder.append("BASIC-Zeilennummer ");
                stringBuilder.append(basicLineExpr.getExprText());
            }
            stringBuilder.append(" nicht gefunden");
            if (string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append('\n');
            this.appendToErrLog(stringBuilder.toString());
            this.incErrorCount();
        }
    }

    private void appendLineNumMsgToErrLog(BasicSourcePos basicSourcePos, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (basicSourcePos != null && basicSourcePos.appendMsgPrefixTo(string2, stringBuilder)) {
            stringBuilder.append(": ");
        }
        stringBuilder.append(string);
        if (!string.endsWith("\n")) {
            stringBuilder.append('\n');
        }
        this.appendToErrLog(stringBuilder.toString());
    }

    private void appendLineNumMsgToErrLog(String string, String string2) {
        this.appendLineNumMsgToErrLog(new BasicSourcePos(this.curSource, this.curBasicLineNum), string, string2);
    }

    private void appendToErrLog(String string) {
        if (this.logger != null) {
            this.logger.appendToErrLog(string);
        }
    }

    private boolean checkInstruction(CharacterIterator characterIterator, String string) {
        return BasicUtil.checkKeyword(characterIterator, string, true, true);
    }

    private void checkPutWarningFileDriverDisabled() {
        if (!this.options.isOpenFileEnabled()) {
            this.putWarning("Dateisystemtreiber in den Compiler-Optionen deaktiviert");
        }
    }

    private void checkPutWarningVdipDriverDisabled() {
        if (!this.options.isOpenVdipEnabled()) {
            this.putWarning("VDIP-Treiber in den Compiler-Optionen deaktiviert");
        }
    }

    private Integer checkSignedNumber(CharacterIterator characterIterator) throws PrgException {
        boolean bl = false;
        char c = BasicUtil.skipSpaces(characterIterator);
        int n = characterIterator.getIndex();
        if (c == '+') {
            characterIterator.next();
        } else if (c == '-') {
            characterIterator.next();
            bl = true;
        }
        Integer n2 = BasicUtil.readNumber(characterIterator);
        if (n2 != null && bl) {
            n2 = -n2.intValue();
        }
        if (n2 == null) {
            characterIterator.setIndex(n);
        }
        return n2;
    }

    private SimpleVarInfo checkVariable(CharacterIterator characterIterator) throws PrgException {
        int n = characterIterator.getIndex();
        SimpleVarInfo simpleVarInfo = this.checkVariable(characterIterator, BasicUtil.checkIdentifier(characterIterator));
        if (simpleVarInfo == null) {
            characterIterator.setIndex(n);
        }
        return simpleVarInfo;
    }

    private static String createBasicLineLabel(String string) {
        return LINE_LABEL_PREFIX + string.toUpperCase();
    }

    private static String createDataLineLabel(String string) {
        return DATA_LABEL_PREFIX + string.toUpperCase();
    }

    private void incErrorCount() throws TooManyErrorsException {
        ++this.errCnt;
        if (this.errCnt >= 100) {
            throw new TooManyErrorsException();
        }
    }

    private void parseSourceText() throws IOException, TooManyErrorsException {
        Object object;
        Object object2;
        this.structureStack.clear();
        this.mainPrg = true;
        this.gcRequired = false;
        while (this.curSource != null) {
            object2 = this.curSource.readLine();
            if (object2 != null) {
                this.parseSourceLine((String)object2);
                continue;
            }
            if (this.curSource != this.mainSource) {
                this.curSource = this.mainSource;
                if (this.curSource == null || !this.libItems.contains((Object)BasicLibrary.LibItem.M_SRNM)) continue;
                this.asmOut.append("\tLD\tHL,0000H\n\tLD\t(M_SRNM),HL\n");
                continue;
            }
            this.curSource = null;
        }
        if (this.mainPrg) {
            if (this.options.getShowAssemblerText()) {
                this.asmOut.append("\n;Programmende\n");
            }
            this.asmOut.append("\tJP\tXEXIT\n");
        }
        object2 = this.structureStack.iterator();
        while (object2.hasNext()) {
            object = (BasicSourcePos)object2.next();
            this.appendLineNumMsgToErrLog((BasicSourcePos)object, object.toString() + " nicht abgeschlossen", "Fehler");
            ++this.errCnt;
        }
        if (this.destBasicLines != null) {
            object2 = this.destBasicLines.iterator();
            while (object2.hasNext()) {
                object = (BasicLineExpr)object2.next();
                if (this.basicLines.contains(((BasicLineExpr)object).getExprText().toUpperCase())) continue;
                this.appendLineNotFoundToErrLog((BasicLineExpr)object, null);
            }
        }
        if (this.restoreBasicLines != null) {
            object2 = this.restoreBasicLines.iterator();
            while (object2.hasNext()) {
                object = (BasicLineExpr)object2.next();
                boolean bl = false;
                if (this.dataBasicLines != null) {
                    bl = this.dataBasicLines.contains(((BasicLineExpr)object).getExprText().toUpperCase());
                }
                if (bl) continue;
                this.appendLineNotFoundToErrLog((BasicLineExpr)object, " oder enth\u00e4lt keine DATA-Anweisung");
            }
        }
        if ((object2 = this.name2Callable.values()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                CallableEntry callableEntry = (CallableEntry)object.next();
                if (!callableEntry.isCalled() && this.errCnt == 0 && this.options.getWarnUnusedItems()) {
                    this.putWarning(callableEntry, callableEntry.toString() + " wird nicht aufgerufen");
                }
                if (callableEntry.isImplemented()) {
                    if (!this.options.getWarnUnusedItems()) continue;
                    int n = callableEntry.getVarCount();
                    for (int i = 0; i < n; ++i) {
                        String string = callableEntry.getVarName(i);
                        if (string == null || callableEntry.isVarUsed(string)) continue;
                        this.putWarning(callableEntry.getVarSourcePos(string), "Lokale Variable " + string + " wird nicht verwendet");
                    }
                    continue;
                }
                BasicSourcePos basicSourcePos = callableEntry.getFirstCallSourcePos();
                this.appendLineNumMsgToErrLog(basicSourcePos != null ? basicSourcePos : callableEntry, callableEntry.toString() + " nicht implementiert", "Fehler");
                this.incErrorCount();
            }
        }
        if (this.options.getWarnUnusedItems() && (object = this.name2GlobalVar.values()) != null) {
            Iterator<VarDecl> iterator = object.iterator();
            while (iterator.hasNext()) {
                VarDecl varDecl = iterator.next();
                if (varDecl.isUsed()) continue;
                this.putWarning(varDecl, varDecl.toString() + " wird nicht verwendet");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSourceLine(String string) throws IOException, TooManyErrorsException {
        CharSequence charSequence;
        Object object;
        StringCharacterIterator stringCharacterIterator = null;
        try {
            Object object2;
            char c;
            char c2;
            stringCharacterIterator = new StringCharacterIterator(string);
            this.curBasicLineNum = -1L;
            if (this.options.getShowAssemblerText() && this.options.getIncludeBasicLines() && (c2 = BasicUtil.skipSpaces(stringCharacterIterator)) != '\uffff') {
                c = this.asmOut.isEnabled() ? '\u0001' : '\u0000';
                this.asmOut.setEnabled(true);
                this.asmOut.append("\n;");
                while (c2 != '\uffff') {
                    this.asmOut.append(c2);
                    c2 = stringCharacterIterator.next();
                }
                this.asmOut.newLine();
                this.asmOut.setEnabled(c != '\u0000');
            }
            stringCharacterIterator.setIndex(0);
            Object object3 = null;
            c = BasicUtil.skipSpaces(stringCharacterIterator);
            int n = stringCharacterIterator.getIndex();
            int n2 = this.asmOut.length();
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                c = stringCharacterIterator.next();
                while (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') {
                    c = stringCharacterIterator.next();
                }
                if (c == ':') {
                    stringCharacterIterator.next();
                    if (BasicUtil.skipSpaces(stringCharacterIterator) == '\uffff') {
                        int n3 = stringCharacterIterator.getIndex() - 1;
                        StringBuilder stringBuilder = new StringBuilder(n3 - n);
                        stringCharacterIterator.setIndex(n);
                        while (stringCharacterIterator.getIndex() < n3) {
                            stringBuilder.append(stringCharacterIterator.current());
                            stringCharacterIterator.next();
                        }
                        object3 = stringBuilder.toString();
                        object2 = ((String)object3).toUpperCase();
                        if (this.isReservedWord((String)object2)) {
                            throw new PrgException("Reserviertes Schl\u00fcsselwort als Marke nicht erlaubt");
                        }
                        if (this.basicLines.contains(object2)) {
                            this.appendLineNumMsgToErrLog("'" + (String)object3 + "': Marke bereits vorhanden", "Fehler");
                            this.incErrorCount();
                        }
                        this.basicLines.add((String)object2);
                        this.lastBasicLineExpr = object2;
                        this.asmOut.append(BasicCompiler.createBasicLineLabel((String)object2));
                        this.asmOut.append(":\n");
                        n2 = this.asmOut.length();
                    }
                }
            }
            if (object3 == null) {
                stringCharacterIterator.setIndex(0);
                c = BasicUtil.skipSpaces(stringCharacterIterator);
                Long l = BasicCompiler.readLineNum(stringCharacterIterator);
                if (l != null) {
                    this.lastBasicLineExpr = l.toString();
                    if (this.basicLines.contains(this.lastBasicLineExpr)) {
                        this.appendLineNumMsgToErrLog(String.format("BASIC-Zeilennummer %s bereits vorhanden", this.lastBasicLineExpr), "Fehler");
                        this.incErrorCount();
                    }
                    this.curBasicLineNum = l;
                    if (this.curBasicLineNum <= this.lastBasicLineNum) {
                        this.putWarning("BASIC-Zeilennummer nicht in aufsteigender Reihenfolge");
                    }
                    this.basicLines.add(this.lastBasicLineExpr);
                    this.lastBasicLineNum = this.curBasicLineNum;
                    this.asmOut.append(BasicCompiler.createBasicLineLabel(this.lastBasicLineExpr));
                    this.asmOut.append(":\n");
                    n2 = this.asmOut.length();
                }
                int n4 = -1;
                if (this.options.getPrintLineNumOnAbort()) {
                    int n5;
                    n4 = this.asmOut.length();
                    object2 = this.curSource;
                    if (object2 != null && (n5 = ((PrgSource)object2).getLineNum()) < Short.MAX_VALUE) {
                        this.asmOut.append_LD_HL_nn(n5);
                        this.asmOut.append("\tLD\t(M_SRLN),HL\n");
                    }
                    if (this.curBasicLineNum >= 0L && this.curBasicLineNum < 32767L) {
                        this.asmOut.append_LD_HL_nn((int)this.curBasicLineNum);
                        this.asmOut.append("\tLD\t(M_BALN),HL\n");
                        this.libItems.add(BasicLibrary.LibItem.M_BALN);
                    }
                }
                int n6 = this.asmOut.length();
                this.parseInstructions(stringCharacterIterator, n4);
                if (this.gcRequired) {
                    this.gcRequired = false;
                    this.asmOut.append("\tCALL\tMRGC\n");
                    this.addLibItem(BasicLibrary.LibItem.MRGC);
                }
                if (this.asmOut.length() == n6 && n6 > n2) {
                    this.asmOut.setLength(n2);
                }
            }
        }
        catch (PrgException prgException) {
            object = prgException.getMessage();
            if (object == null) {
                object = "Unbekannter Fehler";
            }
            this.appendLineNumMsgToErrLog((String)object, "Fehler");
            if (stringCharacterIterator != null) {
                charSequence = new StringBuilder(stringCharacterIterator.getEndIndex() + 16);
                ((StringBuilder)charSequence).append("    ");
                int n = stringCharacterIterator.getIndex();
                char c = stringCharacterIterator.first();
                boolean bl = false;
                while (c != '\uffff') {
                    ((StringBuilder)charSequence).append(c);
                    if (stringCharacterIterator.getIndex() == n) {
                        ((StringBuilder)charSequence).append(ERR_POS_TEXT);
                        bl = true;
                    }
                    c = stringCharacterIterator.next();
                }
                if (!bl) {
                    ((StringBuilder)charSequence).append(ERR_POS_TEXT);
                }
                ((StringBuilder)charSequence).append('\n');
                this.appendToErrLog(((StringBuilder)charSequence).toString());
            }
            this.incErrorCount();
        }
        finally {
            BasicSourcePos basicSourcePos;
            while (!this.structureStack.isEmpty() && (basicSourcePos = this.structureStack.peek()) instanceof IfEntry && !((IfEntry)(object = (IfEntry)basicSourcePos)).isMultiLine()) {
                this.structureStack.pop();
                this.setCodeCreationDisabledLevel(((IfEntry)object).getCodeCreationDisabledLevel());
                charSequence = ((IfEntry)object).getElseLabel();
                if (charSequence != null) {
                    this.asmOut.append(charSequence);
                    this.asmOut.append(":\n");
                }
                this.asmOut.append(((IfEntry)object).getEndifLabel());
                this.asmOut.append(":\n");
            }
        }
    }

    private void parseInstructions(CharacterIterator characterIterator, int n) throws PrgException {
        if (BasicUtil.skipSpaces(characterIterator) != '\uffff') {
            while (true) {
                this.separatorChecked = false;
                this.parseInstruction(characterIterator, n);
                char c = BasicUtil.skipSpaces(characterIterator);
                if (c == '\uffff') break;
                if (!this.separatorChecked) {
                    if (c != ':') {
                        BasicUtil.throwUnexpectedChar(c);
                    }
                    characterIterator.next();
                }
                n = -1;
            }
        }
    }

    private void parseInstruction(CharacterIterator characterIterator, int n) throws PrgException {
        this.tmpStrBufUsed = false;
        char c = BasicUtil.skipSpaces(characterIterator);
        int n2 = characterIterator.getIndex();
        if (c == '!' || c == '\'') {
            characterIterator.next();
            this.parseREM(characterIterator);
        } else if (c == '?') {
            characterIterator.next();
            this.checkMainPrgScope();
            this.checkCreateStackFrame();
            this.parsePRINT(characterIterator);
        } else {
            boolean bl = false;
            String string = BasicUtil.checkIdentifier(characterIterator);
            if (string != null) {
                bl = true;
                if (string.equals("ASM")) {
                    this.checkCreateStackFrame();
                    if (n >= 0 && n < this.asmOut.length()) {
                        this.asmOut.setLength(n);
                        n = -1;
                    }
                    this.parseASM(characterIterator, false);
                } else if (string.equals("DECLARE")) {
                    this.parseDECLARE(characterIterator);
                } else if (string.equals("REM")) {
                    this.parseREM(characterIterator);
                } else if (string.equals("FUNCTION")) {
                    this.parseCallableImpl(characterIterator, true);
                } else if (string.equals("LOCAL")) {
                    this.parseLOCAL(characterIterator);
                } else if (string.equals("SUB")) {
                    this.parseCallableImpl(characterIterator, false);
                } else {
                    this.checkMainPrgScope();
                    this.checkCreateStackFrame();
                    if (string.equals("BORDER")) {
                        this.parseBORDER(characterIterator);
                    } else if (string.equals("CALL")) {
                        this.parseCALL(characterIterator);
                    } else if (string.equals("CIRCLE")) {
                        this.parseCIRCLE(characterIterator);
                    } else if (string.equals("CLOSE")) {
                        this.parseCLOSE(characterIterator);
                    } else if (string.equals("CLS")) {
                        this.parseCLS();
                    } else if (string.equals("COLOR")) {
                        this.parseCOLOR(characterIterator);
                    } else if (string.equals("CURSOR")) {
                        this.parseCURSOR(characterIterator);
                    } else if (string.equals("DATA")) {
                        this.parseDATA(characterIterator);
                    } else if (string.equals("DEF")) {
                        this.parseDEF(characterIterator);
                    } else if (string.equals("DEFUSR")) {
                        this.parseDEFUSR(characterIterator);
                    } else if (string.equals("DEFUSR0")) {
                        this.parseDEFUSR(characterIterator, 0);
                    } else if (string.equals("DEFUSR1")) {
                        this.parseDEFUSR(characterIterator, 1);
                    } else if (string.equals("DEFUSR2")) {
                        this.parseDEFUSR(characterIterator, 2);
                    } else if (string.equals("DEFUSR3")) {
                        this.parseDEFUSR(characterIterator, 3);
                    } else if (string.equals("DEFUSR4")) {
                        this.parseDEFUSR(characterIterator, 4);
                    } else if (string.equals("DEFUSR5")) {
                        this.parseDEFUSR(characterIterator, 5);
                    } else if (string.equals("DEFUSR6")) {
                        this.parseDEFUSR(characterIterator, 6);
                    } else if (string.equals("DEFUSR7")) {
                        this.parseDEFUSR(characterIterator, 7);
                    } else if (string.equals("DEFUSR8")) {
                        this.parseDEFUSR(characterIterator, 8);
                    } else if (string.equals("DEFUSR9")) {
                        this.parseDEFUSR(characterIterator, 9);
                    } else if (string.equals("DIM")) {
                        this.parseDIM(characterIterator);
                    } else if (string.equals("DOKE")) {
                        this.parseDOKE(characterIterator);
                    } else if (string.equals("DO")) {
                        this.parseDO(characterIterator);
                    } else if (string.equals("DRAW")) {
                        this.parseDRAW(characterIterator);
                    } else if (string.equals("DRAWR")) {
                        this.parseDRAWR(characterIterator);
                    } else if (string.equals("ELSE")) {
                        this.parseELSE(characterIterator);
                    } else if (string.equals("ELSEIF")) {
                        this.parseELSEIF(characterIterator);
                    } else if (string.equals("END")) {
                        this.parseEND(characterIterator);
                    } else if (string.equals("ENDIF")) {
                        this.parseENDIF(characterIterator);
                    } else if (string.equals("EXIT")) {
                        this.parseEXIT(characterIterator);
                    } else if (string.equals("FOR")) {
                        this.parseFOR(characterIterator);
                    } else if (string.equals("GOSUB")) {
                        this.parseGOSUB(characterIterator);
                    } else if (string.equals("GOTO")) {
                        this.parseGOTO(characterIterator);
                    } else if (string.equals("IF")) {
                        this.parseIForELSEIF(characterIterator, null);
                    } else if (string.equals("INCLUDE")) {
                        this.parseINCLUDE(characterIterator);
                    } else if (string.equals("INK")) {
                        this.parseINK(characterIterator);
                    } else if (string.equals("INPUT")) {
                        this.parseINPUT(characterIterator);
                    } else if (string.equals("LABEL")) {
                        this.parseLABEL(characterIterator);
                    } else if (string.equals("LET")) {
                        this.parseLET(characterIterator);
                    } else if (string.equals("LINE")) {
                        this.parseLINE(characterIterator);
                    } else if (string.equals("LOCATE")) {
                        this.parseLOCATE(characterIterator);
                    } else if (string.equals("LOOP")) {
                        this.parseLOOP(characterIterator);
                    } else if (string.equals("LPRINT")) {
                        this.parseLPRINT(characterIterator);
                    } else if (string.equals("MOVE")) {
                        this.parseMOVE(characterIterator);
                    } else if (string.equals("MOVER")) {
                        this.parseMOVER(characterIterator);
                    } else if (string.equals("NEXT")) {
                        this.parseNEXT(characterIterator);
                    } else if (string.equals("ON")) {
                        this.parseON(characterIterator);
                    } else if (string.equals("OPEN")) {
                        this.parseOPEN(characterIterator);
                    } else if (string.equals("OUT")) {
                        this.parseOUT(characterIterator);
                    } else if (string.equals("PAINT")) {
                        this.parsePAINT(characterIterator);
                    } else if (string.equals("PAPER")) {
                        this.parsePAPER(characterIterator);
                    } else if (string.equals("PASSWORD")) {
                        this.parsePASSWORD(characterIterator);
                    } else if (string.equals("PAUSE")) {
                        this.parsePAUSE(characterIterator);
                    } else if (string.equals("PEN")) {
                        this.parsePEN(characterIterator);
                    } else if (string.equals("PLOT")) {
                        this.parsePLOT(characterIterator);
                    } else if (string.equals("PLOTR")) {
                        this.parsePLOTR(characterIterator);
                    } else if (string.equals("POKE")) {
                        this.parsePOKE(characterIterator);
                    } else if (string.equals("PRESET")) {
                        this.parsePRESET(characterIterator);
                    } else if (string.equals("PRINT")) {
                        this.parsePRINT(characterIterator);
                    } else if (string.equals("PSET")) {
                        this.parsePSET(characterIterator);
                    } else if (string.equals("READ")) {
                        this.parseREAD(characterIterator);
                    } else if (string.equals("REM")) {
                        this.parseREM(characterIterator);
                    } else if (string.equals("RESTORE")) {
                        this.parseRESTORE(characterIterator);
                    } else if (string.equals("RETURN")) {
                        this.parseRETURN();
                    } else if (string.equals("SCREEN")) {
                        this.parseSCREEN(characterIterator);
                    } else if (string.equals("WAIT")) {
                        this.parseWAIT(characterIterator);
                    } else if (string.equals("WEND")) {
                        this.parseWEND(characterIterator);
                    } else if (string.equals("WHILE")) {
                        this.parseWHILE(characterIterator);
                    } else if (!this.checkReturnValueAssignment(characterIterator, string)) {
                        CallableEntry callableEntry = this.name2Callable.get(string);
                        if (callableEntry != null) {
                            this.parseCallableCall(characterIterator, callableEntry);
                        } else {
                            SimpleVarInfo simpleVarInfo = this.checkVariable(characterIterator, string);
                            if (simpleVarInfo != null) {
                                this.parseAssignment(characterIterator, simpleVarInfo);
                            } else {
                                bl = false;
                            }
                        }
                    }
                }
            }
            if (!bl) {
                throw new PrgException("Anweisung, Prozedur oder Variable erwartet");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBORDER(CharacterIterator characterIterator) throws PrgException {
        if (this.target.supportsBorderColor()) {
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tCALL\tXBORDER\n");
            this.addLibItem(BasicLibrary.LibItem.XBORDER);
        } else {
            try {
                this.pushCodeCreationDisabled();
                BasicExprParser.parseExpr(this, characterIterator);
            }
            finally {
                this.popCodeCreationDisabled();
            }
        }
    }

    private void parseCALL(CharacterIterator characterIterator) throws PrgException {
        boolean bl;
        if (BasicUtil.checkToken(characterIterator, '*')) {
            BasicUtil.skipSpaces(characterIterator);
            Integer n = BasicUtil.readHex(characterIterator);
            if (n == null) {
                BasicUtil.throwHexDigitExpected();
            }
            this.asmOut.append_LD_HL_nn(n);
        } else {
            BasicExprParser.parseExpr(this, characterIterator);
        }
        boolean bl2 = bl = this.getEnclosingCallableEntry() != null;
        if (bl) {
            this.asmOut.append("\tPUSH\tIY\n");
        }
        this.asmOut.append("\tCALL\tJP_HL\n");
        if (bl) {
            this.asmOut.append("\tPOP\tIY\n");
        }
        this.addLibItem(BasicLibrary.LibItem.JP_HL);
    }

    private void parseCIRCLE(CharacterIterator characterIterator) throws PrgException {
        this.checkGraphicsSupported();
        this.parsePointToMem(characterIterator, "CIRCLE_M_X", "CIRCLE_M_Y");
        BasicUtil.parseToken(characterIterator, ',');
        BasicExprParser.parseExpr(this, characterIterator);
        this.asmOut.append("\tLD\t(CIRCLE_M_R),HL\n\tCALL\tCIRCLE\n");
        this.addLibItem(BasicLibrary.LibItem.CIRCLE);
    }

    private void parseCLOSE(CharacterIterator characterIterator) throws PrgException {
        BasicUtil.parseToken(characterIterator, '#');
        this.parseIOChannelNumToPtrFldAddrInHL(characterIterator, null);
        this.asmOut.append("\tCALL\tIOCLOSE\n");
        this.addLibItem(BasicLibrary.LibItem.IOCLOSE);
    }

    private void parseCLS() {
        if (this.target.supportsXCLS()) {
            this.asmOut.append("\tCALL\tXCLS\n");
            this.addLibItem(BasicLibrary.LibItem.XCLS);
        } else {
            this.asmOut.append("\tLD\tA,0CH\n\tCALL\tXOUTCH\n");
            this.addLibItem(BasicLibrary.LibItem.XOUTCH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCOLOR(CharacterIterator characterIterator) throws PrgException {
        if (this.target.supportsColors()) {
            BasicExprParser.parseExpr(this, characterIterator);
            if (BasicUtil.checkToken(characterIterator, ',')) {
                int n = this.asmOut.length();
                BasicExprParser.parseExpr(this, characterIterator);
                String string = this.asmOut.cut(n);
                String string2 = BasicUtil.convertCodeToValueInDE(string);
                if (string2 != null) {
                    this.asmOut.append(string2);
                } else {
                    this.asmOut.append("\tPUSH\tHL\n");
                    this.asmOut.append(string);
                    this.asmOut.append("\tEX\tHL,DE\n\tPOP\tHL\n");
                }
                this.asmOut.append("\tCALL\tXCOLOR\n");
                this.addLibItem(BasicLibrary.LibItem.XCOLOR);
            } else {
                this.asmOut.append("\tCALL\tXINK\n");
                this.addLibItem(BasicLibrary.LibItem.XINK);
            }
        } else {
            try {
                this.pushCodeCreationDisabled();
                BasicExprParser.parseExpr(this, characterIterator);
                if (BasicUtil.checkToken(characterIterator, ',')) {
                    BasicExprParser.parseExpr(this, characterIterator);
                }
            }
            finally {
                this.popCodeCreationDisabled();
            }
        }
        if (BasicUtil.checkToken(characterIterator, ',')) {
            this.parseBORDER(characterIterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCURSOR(CharacterIterator characterIterator) throws PrgException {
        if (this.target.supportsXCURS()) {
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tCALL\tXCURS\n");
            this.addLibItem(BasicLibrary.LibItem.XCURS);
        } else {
            try {
                this.pushCodeCreationDisabled();
                BasicExprParser.parseExpr(this, characterIterator);
            }
            finally {
                this.popCodeCreationDisabled();
            }
        }
    }

    private void parseDATA(CharacterIterator characterIterator) throws PrgException {
        if (this.dataOut == null) {
            this.dataOut = new AsmCodeBuf(1024);
        }
        if (this.lastBasicLineExpr != null) {
            if (this.dataBasicLines == null) {
                this.dataBasicLines = new TreeSet<String>();
            }
            if (this.dataBasicLines.add(this.lastBasicLineExpr)) {
                this.dataOut.append(BasicCompiler.createDataLineLabel(this.lastBasicLineExpr));
                this.dataOut.append(":\n");
            }
        }
        do {
            String string;
            if ((string = BasicUtil.checkStringLiteral(this, characterIterator)) != null) {
                this.dataOut.append("\tDB\t");
                this.dataOut.appendHex2(17);
                this.dataOut.newLine();
                this.dataOut.appendStringLiteral(string);
                continue;
            }
            Integer n = this.checkSignedNumber(characterIterator);
            if (n == null) {
                throw new PrgException("Integer- oder String-Literal erwartet");
            }
            if (n >= 0 && n < 256) {
                this.dataOut.append("\tDB\t");
                this.dataOut.appendHex2(1);
                this.dataOut.append(',');
                this.dataOut.appendHex2(n);
                this.dataOut.newLine();
                continue;
            }
            this.dataOut.append("\tDB\t");
            this.dataOut.appendHex2(2);
            this.dataOut.newLine();
            this.dataOut.append("\tDW\t");
            this.dataOut.appendHex4(n);
            this.dataOut.newLine();
        } while (BasicUtil.checkToken(characterIterator, ','));
        this.addLibItem(BasicLibrary.LibItem.DATA);
    }

    private void parseDECLARE(CharacterIterator characterIterator) throws PrgException {
        Object var2_2 = null;
        if (BasicUtil.checkKeyword(characterIterator, "FUNCTION")) {
            this.parseCallableDecl(characterIterator, true, false);
        } else if (BasicUtil.checkKeyword(characterIterator, "SUB")) {
            this.parseCallableDecl(characterIterator, false, false);
        } else {
            throw new PrgException("FUNCTION oder SUB erwartet");
        }
    }

    private void parseDEF(CharacterIterator characterIterator) throws PrgException {
        if (!BasicUtil.checkKeyword(characterIterator, "USR")) {
            throw new PrgException("USR erwartet");
        }
        int n = BasicUtil.parseUsrNum(characterIterator);
        this.parseDEFUSR(characterIterator, n);
    }

    private void parseDEFUSR(CharacterIterator characterIterator) throws PrgException {
        int n = BasicUtil.parseUsrNum(characterIterator);
        this.parseDEFUSR(characterIterator, n);
    }

    private void parseDEFUSR(CharacterIterator characterIterator, int n) throws PrgException {
        BasicUtil.parseToken(characterIterator, '=');
        BasicExprParser.parseExpr(this, characterIterator);
        this.asmOut.append("\tLD\t(");
        this.asmOut.append(this.getUsrLabel(n));
        this.asmOut.append("),HL\n");
    }

    private void parseDIM(CharacterIterator characterIterator) throws PrgException {
        CallableEntry callableEntry = this.getEnclosingCallableEntry();
        if (callableEntry != null) {
            throw new PrgException("Anweisung in einer Funktion/Prozedur nicht zul\u00e4ssig");
        }
        do {
            String string;
            if ((string = BasicUtil.checkIdentifier(characterIterator)) == null) {
                BasicCompiler.throwVarNameExpected();
            }
            this.checkVarName(string);
            BasicUtil.parseToken(characterIterator, '(');
            VarDecl varDecl = null;
            int n = BasicUtil.parseNumber(characterIterator);
            if (n < 1) {
                BasicCompiler.throwDimTooSmall();
            }
            if (BasicUtil.checkToken(characterIterator, ',')) {
                int n2 = BasicUtil.parseNumber(characterIterator);
                if (n2 < 1) {
                    BasicCompiler.throwDimTooSmall();
                }
                varDecl = new VarDecl(this.curSource, this.curBasicLineNum, string, n, n2);
            } else {
                varDecl = new VarDecl(this.curSource, this.curBasicLineNum, string, n);
            }
            VarDecl varDecl2 = this.name2GlobalVar.get(string);
            if (varDecl2 != null) {
                if (varDecl2.getDimCount() > 0) {
                    throw new PrgException("Feldvariable bereits deklariert");
                }
                throw new PrgException("Variable implizit als einfache Variable bereits deklariert");
            }
            BasicUtil.parseToken(characterIterator, ')');
            this.name2GlobalVar.put(string, varDecl);
        } while (BasicUtil.checkToken(characterIterator, ','));
    }

    private void parseDO(CharacterIterator characterIterator) throws PrgException {
        String string = this.nextLabel();
        this.asmOut.append(string);
        this.asmOut.append(":\n");
        this.checkAppendBreakCheck();
        this.structureStack.push(new DoEntry(this.curSource, this.curBasicLineNum, string, this.nextLabel()));
    }

    private void parseDOKE(CharacterIterator characterIterator) throws PrgException {
        int n = this.asmOut.length();
        BasicExprParser.parseExpr(this, characterIterator);
        BasicUtil.parseToken(characterIterator, ',');
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(this, n);
        if (n2 != null) {
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tLD\t(");
            this.asmOut.appendHex4(n2);
            this.asmOut.append("),HL\n");
        } else {
            n = this.asmOut.length();
            BasicExprParser.parseExpr(this, characterIterator);
            Integer n3 = BasicUtil.removeLastCodeIfConstExpr(this, n);
            if (n3 != null) {
                this.asmOut.append("\tLD\t(HL),");
                this.asmOut.appendHex2(n3);
                this.asmOut.append("\n\tINC\tHL\n\tLD\t(HL),");
                this.asmOut.appendHex2(n3 >> 8);
                this.asmOut.newLine();
            } else {
                String string = this.asmOut.cut(n);
                String string2 = BasicUtil.convertCodeToValueInDE(string);
                if (string2 != null) {
                    this.asmOut.append(string2);
                } else {
                    this.asmOut.append("\tPUSH\tHL\n");
                    this.asmOut.append(string);
                    this.asmOut.append("\tEX\tDE,HL\n\tPOP\tHL\n");
                }
                this.asmOut.append("\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n");
            }
        }
    }

    private void parseDRAW(CharacterIterator characterIterator) throws PrgException {
        if (BasicUtil.checkKeyword(characterIterator, "STEP")) {
            this.parseDRAWR(characterIterator);
        } else {
            this.checkGraphicsSupported();
            String string = BasicUtil.checkStringLiteral(this, characterIterator);
            if (string != null) {
                this.asmOut.append("\tCALL\tDRAWST\n");
                this.asmOut.appendStringLiteral(string);
                this.addLibItem(BasicLibrary.LibItem.DRAWST);
            } else if (BasicExprParser.checkParseStringPrimVarExpr(this, characterIterator)) {
                this.asmOut.append("\tCALL\tDRAWS\n");
                this.addLibItem(BasicLibrary.LibItem.DRAWS);
            } else {
                BasicUtil.checkKeyword(characterIterator, "TO");
                this.parsePointToMem(characterIterator, "LINE_M_EX", "LINE_M_EY");
                this.asmOut.append("\tCALL\tDRAW\n");
                this.addLibItem(BasicLibrary.LibItem.DRAW);
            }
        }
    }

    private void parseDRAWR(CharacterIterator characterIterator) throws PrgException {
        this.checkGraphicsSupported();
        this.parsePointTo_DE_HL(characterIterator);
        this.asmOut.append("\tCALL\tDRAWR\n");
        this.addLibItem(BasicLibrary.LibItem.DRAWR);
    }

    private void parseELSE(CharacterIterator characterIterator) throws PrgException {
        IfEntry ifEntry;
        while (true) {
            String string;
            BasicSourcePos basicSourcePos;
            ifEntry = null;
            if (!this.structureStack.isEmpty() && (basicSourcePos = this.structureStack.peek()) instanceof IfEntry) {
                ifEntry = (IfEntry)basicSourcePos;
            }
            if (ifEntry == null) {
                throw new PrgException("ELSE ohne IF");
            }
            boolean bl = ifEntry.isIfCodeCreationDisabled();
            if (bl) {
                ifEntry.setIfCodeCreationDisabled(false);
                this.popCodeCreationDisabled();
            }
            if ((string = ifEntry.getElseLabel()) != null) {
                if (ifEntry.isElseCodeCreationDisabled()) {
                    this.pushCodeCreationDisabled();
                    break;
                }
                if (!bl) {
                    if (!ifEntry.isMultiLine() && this.options.getPreferRelativeJumps()) {
                        this.asmOut.append("\tJR\t");
                    } else {
                        this.asmOut.append("\tJP\t");
                    }
                    this.asmOut.append(ifEntry.getEndifLabel());
                    this.asmOut.newLine();
                }
                this.asmOut.append(string);
                this.asmOut.append(":\n");
                break;
            }
            this.asmOut.append(ifEntry.getEndifLabel());
            this.asmOut.append(":\n");
            this.structureStack.pop();
        }
        ifEntry.setElseLabel(null);
    }

    private void parseELSEIF(CharacterIterator characterIterator) throws PrgException {
        Object object;
        IfEntry ifEntry = null;
        if (!this.structureStack.isEmpty() && (object = this.structureStack.peek()) instanceof IfEntry) {
            ifEntry = (IfEntry)object;
        }
        if (ifEntry == null) {
            throw new PrgException("ELSE ohne IF");
        }
        object = ifEntry.getElseLabel();
        if (object == null) {
            throw new PrgException("ELSEIF hinter ELSE nicht zul\u00e4ssig");
        }
        this.setCodeCreationDisabledLevel(ifEntry.getCodeCreationDisabledLevel());
        if (ifEntry.isIfCodeCreationDisabled()) {
            ifEntry.setIfCodeCreationDisabled(false);
        } else if (ifEntry.isElseCodeCreationDisabled()) {
            this.pushCodeCreationDisabled();
        } else {
            if (!ifEntry.isMultiLine() && this.options.getPreferRelativeJumps()) {
                this.asmOut.append("\tJR\t");
            } else {
                this.asmOut.append("\tJP\t");
            }
            this.asmOut.append(ifEntry.getEndifLabel());
            this.asmOut.newLine();
            this.asmOut.append((CharSequence)object);
            this.asmOut.append(":\n");
            ifEntry.setElseLabel(this.nextLabel());
        }
        this.parseIForELSEIF(characterIterator, ifEntry);
    }

    private void parseEND(CharacterIterator characterIterator) throws PrgException {
        int n;
        CallableEntry callableEntry = this.getEnclosingCallableEntry();
        if (BasicUtil.checkKeyword(characterIterator, "FUNCTION")) {
            n = 0;
            if (callableEntry != null && callableEntry instanceof FunctionEntry) {
                n = 1;
            }
            if (n == 0) {
                throw new PrgException("Anweisung nur am Ende einer Funktion erlaubt");
            }
        } else if (BasicUtil.checkKeyword(characterIterator, "SUB")) {
            n = 0;
            if (callableEntry != null && callableEntry instanceof SubEntry) {
                n = 1;
            }
            if (n == 0) {
                throw new PrgException("Anweisung nur am Ende einer Prozedur erlaubt");
            }
        }
        if (callableEntry != null) {
            if (callableEntry instanceof FunctionEntry) {
                this.asmOut.append_LD_HL_IndirectIY(((FunctionEntry)callableEntry).getReturnVarIYOffs());
                this.asmOut.append("\tLD\t(M_FRET),HL\n");
                this.addLibItem(BasicLibrary.LibItem.M_FRET);
            }
            while (!this.structureStack.isEmpty()) {
                BasicSourcePos basicSourcePos = this.structureStack.pop();
                if (basicSourcePos == callableEntry) continue;
                this.appendLineNumMsgToErrLog(basicSourcePos, basicSourcePos.toString() + " nicht abgeschlossen", "Fehler");
                ++this.errCnt;
            }
            if (callableEntry.hasStackFrame()) {
                int n2;
                n = callableEntry.getVarCount();
                int n3 = callableEntry.getArgCount();
                if (n3 > 0) {
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (callableEntry.getArgType(n2) != DataType.STRING) continue;
                        this.asmOut.append_LD_DE_IndirectIY(callableEntry.getArgIYOffs(n2, n3));
                        this.asmOut.append("\tCALL\tMFREE\n");
                        this.addLibItem(BasicLibrary.LibItem.MFREE);
                    }
                }
                if (n > 0) {
                    for (n2 = 0; n2 < n; ++n2) {
                        if (callableEntry.getVarType(n2) != DataType.STRING) continue;
                        boolean bl = false;
                        int n4 = callableEntry.getVarIYOffs(n2);
                        if (callableEntry instanceof FunctionEntry && ((FunctionEntry)callableEntry).getReturnVarIYOffs() == n4) {
                            this.asmOut.append_LD_DE_IndirectIY(n4);
                            this.asmOut.append("\tCALL\tMMGC\n");
                            this.addLibItem(BasicLibrary.LibItem.MMGC);
                            bl = true;
                        }
                        if (bl) continue;
                        this.asmOut.append_LD_DE_IndirectIY(n4);
                        this.asmOut.append("\tCALL\tMFREE\n");
                        this.addLibItem(BasicLibrary.LibItem.MFREE);
                    }
                    this.asmOut.append("\tLD\tSP,IY\n");
                }
                this.asmOut.append("\tPOP\tIY\n");
            }
            this.asmOut.append("\tRET\n");
        } else {
            this.asmOut.append("\tJP\tXEXIT\n");
        }
    }

    private void parseENDIF(CharacterIterator characterIterator) throws PrgException {
        Object object;
        IfEntry ifEntry = null;
        if (!this.structureStack.isEmpty() && (object = this.structureStack.peek()) instanceof IfEntry) {
            ifEntry = (IfEntry)object;
            this.structureStack.pop();
        }
        if (ifEntry == null) {
            throw new PrgException("ENDIF ohne IF");
        }
        this.setCodeCreationDisabledLevel(ifEntry.getCodeCreationDisabledLevel());
        object = ifEntry.getElseLabel();
        if (object != null) {
            this.asmOut.append((CharSequence)object);
            this.asmOut.append(":\n");
        }
        this.asmOut.append(ifEntry.getEndifLabel());
        this.asmOut.append(":\n");
    }

    private void parseEXIT(CharacterIterator characterIterator) throws PrgException {
        LoopEntry loopEntry = null;
        for (int i = this.structureStack.size() - 1; i >= 0; --i) {
            BasicSourcePos basicSourcePos = (BasicSourcePos)this.structureStack.get(i);
            if (basicSourcePos instanceof LoopEntry) {
                loopEntry = (LoopEntry)basicSourcePos;
                break;
            }
            if (!(basicSourcePos instanceof IfEntry)) break;
        }
        if (loopEntry == null) {
            throw new PrgException("EXIT aus\u00dferhalb einer Schleife");
        }
        if (!this.isEndOfInstr(characterIterator) && !BasicUtil.checkKeyword(characterIterator, loopEntry.getLoopBegKeyword())) {
            throw new PrgException(loopEntry.getLoopBegKeyword() + " oder Ende der Anweisung erwartet");
        }
        this.asmOut.append("\tJP\t");
        this.asmOut.append(loopEntry.getExitLabel());
        this.asmOut.newLine();
    }

    private void parseFOR(CharacterIterator characterIterator) throws PrgException {
        SimpleVarInfo simpleVarInfo = this.checkVariable(characterIterator);
        if (simpleVarInfo != null && simpleVarInfo.getDataType() != DataType.INTEGER) {
            simpleVarInfo = null;
        }
        if (simpleVarInfo == null) {
            throw new PrgException("Integer-Variable erwartet");
        }
        if (!simpleVarInfo.hasStaticAddr()) {
            throw new PrgException("Laufvariable darf keine Feldvariable mit variablen Indexangaben sein.");
        }
        this.parseAssignment(characterIterator, simpleVarInfo);
        if (!this.checkInstruction(characterIterator, "TO")) {
            throw new PrgException("TO erwartet");
        }
        int n = this.asmOut.length();
        BasicExprParser.parseExpr(this, characterIterator);
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(this, n);
        if (n2 == null) {
            this.asmOut.append("\tPUSH\tHL\n");
        }
        Integer n3 = null;
        if (this.checkInstruction(characterIterator, "STEP")) {
            int n4 = this.asmOut.length();
            BasicExprParser.parseExpr(this, characterIterator);
            n3 = BasicUtil.removeLastCodeIfConstExpr(this, n4);
            if (n3 == null) {
                this.asmOut.append("\tPUSH\tHL\n");
            }
        } else {
            n3 = 1;
        }
        String string = this.nextLabel();
        this.asmOut.append(string);
        this.asmOut.append(':');
        this.checkAppendBreakCheck();
        this.asmOut.newLine();
        this.structureStack.push(new ForEntry(this.curSource, this.curBasicLineNum, string, this.nextLabel(), simpleVarInfo, n2, n3));
    }

    private void parseGOSUB(CharacterIterator characterIterator) throws PrgException {
        this.checkAppendBreakCheck();
        if (this.options.getCheckStack() && this.options.getStackSize() > 0) {
            this.asmOut.append("\tCALL\tCKSTK\n");
            this.addLibItem(BasicLibrary.LibItem.CKSTK);
        }
        String string = this.parseDestLineExpr(characterIterator);
        if (this.options.getCheckStack()) {
            String string2 = this.nextLabel();
            this.asmOut.append("\tLD\tHL,");
            this.asmOut.append(string2);
            this.asmOut.append("\n\tPUSH\tHL\n");
            this.asmOut.append_LD_A_n(71);
            this.asmOut.append("\tPUSH\tAF\n\tJP\t");
            this.asmOut.append(string);
            this.asmOut.newLine();
            this.asmOut.append(string2);
            this.asmOut.append(":\n");
        } else {
            this.asmOut.append("\tCALL\t");
            this.asmOut.append(string);
            this.asmOut.newLine();
        }
    }

    private void parseGOTO(CharacterIterator characterIterator) throws PrgException {
        this.checkAppendBreakCheck();
        String string = this.parseDestLineExpr(characterIterator);
        this.asmOut.append("\tJP\t");
        this.asmOut.append(string);
        this.asmOut.newLine();
    }

    private void parseIForELSEIF(CharacterIterator characterIterator, IfEntry ifEntry) throws PrgException {
        char c;
        Object object;
        boolean bl = false;
        if (ifEntry != null) {
            bl = ifEntry.isElseCodeCreationDisabled();
        }
        Integer n = null;
        if (!bl) {
            n = BasicExprParser.checkParseConstExpr(this, characterIterator);
        }
        Set<BasicLibrary.LibItem> set = null;
        int n2 = this.asmOut.length();
        boolean bl2 = false;
        if (n == null) {
            object = this.libItems;
            this.libItems = new HashSet<BasicLibrary.LibItem>();
            BasicExprParser.parseExpr(this, characterIterator);
            set = this.libItems;
            this.libItems = object;
            this.asmOut.append("\tLD\tA,H\n\tOR\tL\n");
        }
        object = null;
        boolean bl3 = false;
        if (BasicUtil.checkKeyword(characterIterator, "THEN")) {
            if (this.isEndOfInstr(characterIterator)) {
                bl3 = true;
            } else {
                c = BasicUtil.skipSpaces(characterIterator);
                if (c >= '0' && c <= '9') {
                    object = BasicLineExpr.checkBasicLineExpr(characterIterator, this.curSource, this.curBasicLineNum);
                }
            }
        } else if (this.isEndOfInstr(characterIterator)) {
            bl3 = true;
        }
        if (!bl3 && object == null && BasicUtil.checkKeyword(characterIterator, "GOTO") && (object = BasicLineExpr.checkBasicLineExpr(characterIterator, this.curSource, this.curBasicLineNum)) == null) {
            BasicCompiler.throwBasicLineExprExpected();
        }
        if (n == null && object != null && !this.options.canBreakAlways() && this.isEndOfInstr(characterIterator)) {
            this.asmOut.append("\tJP\tNZ,");
            this.asmOut.append(BasicCompiler.createBasicLineLabel(((BasicLineExpr)object).getExprText()));
            this.asmOut.newLine();
            this.destBasicLines.add((BasicLineExpr)object);
        } else {
            c = '\u0000';
            boolean bl4 = bl;
            if (n != null) {
                if (n == 0) {
                    c = '\u0001';
                } else {
                    bl4 = true;
                }
            }
            if (ifEntry != null) {
                ifEntry.setIfCodeCreationDisabled(c != '\u0000');
                if (bl4) {
                    ifEntry.setElseCodeCreationDisabled(true);
                }
            } else {
                ifEntry = new IfEntry(this.curSource, this.curBasicLineNum, bl3, this.nextLabel(), this.nextLabel(), this.codeCreationDisabledLevel, c != '\u0000', bl4);
                this.structureStack.push(ifEntry);
            }
            if (!bl && c) {
                this.pushCodeCreationDisabled();
            } else {
                String string = ifEntry.getElseLabel();
                String string2 = "\tJP\t";
                if (!bl3 && this.options.getPreferRelativeJumps()) {
                    string2 = "\tJR\t";
                }
                if (!bl4) {
                    List<String> list = this.asmOut.getLinesAsList(n2);
                    if (list.size() == 5) {
                        String string3 = list.get(0);
                        String string4 = list.get(1);
                        String string5 = list.get(2);
                        if (string3.startsWith("\tLD\tHL,") && string4.startsWith("\tLD\tDE,")) {
                            if (string5.equals("\tCALL\tO_LT\n")) {
                                if (string4.equals("\tLD\tDE,0000H\n")) {
                                    this.asmOut.cut(n2);
                                    this.asmOut.append(string3);
                                    this.asmOut.append("\tBIT\t7,H\n");
                                    this.asmOut.append(string2);
                                    this.asmOut.append("Z,");
                                    this.asmOut.append(string);
                                    this.asmOut.newLine();
                                    bl2 = true;
                                }
                            } else if (string5.equals("\tCALL\tO_GE\n")) {
                                if (string4.equals("\tLD\tDE,0000H\n")) {
                                    this.asmOut.cut(n2);
                                    this.asmOut.append(string3);
                                    this.asmOut.append("\tBIT\t7,H\n");
                                    this.asmOut.append(string2);
                                    this.asmOut.append("NZ,");
                                    this.asmOut.append(string);
                                    this.asmOut.newLine();
                                    bl2 = true;
                                }
                            } else if (string5.equals("\tCALL\tO_EQ\n")) {
                                this.asmOut.cut(n2);
                                this.asmOut.append(string3);
                                if (string4.equals("\tLD\tDE,0000H\n")) {
                                    this.asmOut.append("\tLD\tA,H\n\tOR\tL\n");
                                } else {
                                    this.asmOut.append(string4);
                                    this.asmOut.append("\tOR\tA\n\tSBC\tHL,DE\n");
                                }
                                this.asmOut.append(string2);
                                this.asmOut.append("NZ,");
                                this.asmOut.append(string);
                                this.asmOut.newLine();
                                bl2 = true;
                            } else if (string5.equals("\tCALL\tO_NE\n")) {
                                this.asmOut.cut(n2);
                                this.asmOut.append(string3);
                                if (string4.equals("\tLD\tDE,0000H\n")) {
                                    this.asmOut.append("\tLD\tA,H\n\tOR\tL\n");
                                } else {
                                    this.asmOut.cut(n2);
                                    this.asmOut.append(string3);
                                    this.asmOut.append(string4);
                                    this.asmOut.append("\tOR\tA\n\tSBC\tHL,DE\n");
                                }
                                this.asmOut.append(string2);
                                this.asmOut.append("Z,");
                                this.asmOut.append(string);
                                this.asmOut.newLine();
                                bl2 = true;
                            }
                        }
                    }
                    if (!bl2) {
                        this.asmOut.append(string2);
                        this.asmOut.append("Z,");
                        this.asmOut.append(ifEntry.getElseLabel());
                        this.asmOut.newLine();
                    }
                }
                if (object != null) {
                    this.checkAppendBreakCheck();
                    this.asmOut.append("\tJP\t");
                    this.asmOut.append(BasicCompiler.createBasicLineLabel(((BasicLineExpr)object).getExprText()));
                    this.asmOut.newLine();
                    this.destBasicLines.add((BasicLineExpr)object);
                }
            }
            if (object == null) {
                this.separatorChecked = true;
            }
        }
        if (!bl2 && set != null) {
            this.libItems.addAll(set);
        }
    }

    private void parseINCLUDE(CharacterIterator characterIterator) throws PrgException {
        String string;
        File file = PrgSource.getIncludeFile(this.curSource, this.parseStringLiteral(characterIterator));
        char c = BasicUtil.skipSpaces(characterIterator);
        if (c != '\uffff') {
            BasicUtil.throwUnexpectedChar(c);
        }
        if (this.curSource != this.mainSource) {
            throw new PrgException("In sich geschachtelte INCLUDE-Anweisungen nicht erlaubt");
        }
        try {
            this.curSource = PrgSource.readFile(file);
        }
        catch (IOException iOException) {
            String string2 = iOException.getMessage();
            if (string2 != null && (string2 = string2.trim()).isEmpty()) {
                string2 = null;
            }
            if (string2 == null) {
                string2 = "Datei kann nicht ge\u00f6ffnet werden.";
            }
            throw new PrgException(string2);
        }
        if (this.options.getPrintLineNumOnAbort() && (string = this.curSource.getName()) != null && !string.isEmpty()) {
            this.asmOut.append_LD_HL_xx(this.getStringLiteralLabel(string));
            this.asmOut.append("\tLD\t(M_SRNM),HL\n");
            this.libItems.add(BasicLibrary.LibItem.M_SRNM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseINK(CharacterIterator characterIterator) throws PrgException {
        if (this.target.supportsColors()) {
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tCALL\tXINK\n");
            this.addLibItem(BasicLibrary.LibItem.XINK);
        } else {
            try {
                this.pushCodeCreationDisabled();
                BasicExprParser.parseExpr(this, characterIterator);
            }
            finally {
                this.popCodeCreationDisabled();
            }
        }
    }

    private void parseINPUT(CharacterIterator characterIterator) throws PrgException {
        if (BasicUtil.checkToken(characterIterator, '#')) {
            this.parseIOChannelNumToPtrFldAddrInHL(characterIterator, null);
            int n = this.asmOut.length();
            this.asmOut.append("\tLD\t(IO_M_CADDR),HL\n");
            int n2 = this.asmOut.length();
            BasicUtil.parseToken(characterIterator, ',');
            BasicLibrary.appendResetErrorUseBC(this);
            boolean bl = false;
            while (true) {
                this.asmOut.append("\tLD\tC,2CH\n\tCALL\tIOINL\n");
                this.addLibItem(BasicLibrary.LibItem.IOINL);
                int n3 = this.asmOut.length();
                SimpleVarInfo simpleVarInfo = this.checkVariable(characterIterator);
                if (simpleVarInfo == null) {
                    BasicCompiler.throwVarExpected();
                }
                simpleVarInfo.ensureAddrInHL(this.asmOut);
                String string = this.asmOut.cut(n3);
                if (simpleVarInfo.getDataType() == DataType.INTEGER) {
                    this.asmOut.append("\tCALL\tF_VLI1\n");
                    if (BasicUtil.isSingleInst_LD_HL_xx(string)) {
                        this.asmOut.append("\tEX\tDE,HL\n");
                        this.asmOut.append(string);
                    } else {
                        this.asmOut.append("\tPUSH\tHL\n");
                        this.asmOut.append(string);
                        this.asmOut.append("\tPOP\tDE\n");
                    }
                    this.asmOut.append("\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n");
                    this.addLibItem(BasicLibrary.LibItem.F_VLI);
                } else if (simpleVarInfo.getDataType() == DataType.STRING) {
                    String string2 = BasicUtil.convertCodeToValueInDE(string);
                    if (string2 != null) {
                        this.asmOut.append(string2);
                    } else {
                        this.asmOut.append("\tPUSH\tHL\n");
                        this.asmOut.append(string);
                        this.asmOut.append("\tEX\tDE,HL\n\tPOP\tHL\n");
                    }
                    this.asmOut.append("\tCALL\tASSIGN_STR_TO_NEW_MEM_VS\n");
                    this.addLibItem(BasicLibrary.LibItem.ASSIGN_STR_TO_NEW_MEM_VS);
                }
                if (!BasicUtil.checkToken(characterIterator, ',')) break;
                this.asmOut.append("\tLD\tHL,(IO_M_CADDR)\n");
                bl = true;
            }
            if (!bl) {
                this.asmOut.delete(n, n2);
            }
        } else {
            do {
                Object object;
                String string = this.nextLabel();
                this.asmOut.append(string);
                this.asmOut.append(":\n");
                String string3 = BasicUtil.checkStringLiteral(this, characterIterator);
                if (string3 != null) {
                    object = this.str2Label.get(string3);
                    if (object != null) {
                        this.asmOut.append("\tLD\tHL,");
                        this.asmOut.append((CharSequence)object);
                        this.asmOut.append("\n\tCALL\tXOUTS\n");
                        this.addLibItem(BasicLibrary.LibItem.XOUTS);
                    } else {
                        this.asmOut.append("\tCALL\tXOUTST\n");
                        this.asmOut.appendStringLiteral(string3);
                        this.addLibItem(BasicLibrary.LibItem.XOUTST);
                    }
                    BasicUtil.checkToken(characterIterator, ';');
                } else {
                    this.asmOut.append_LD_A_n(63);
                    this.asmOut.append("\tCALL\tXOUTCH\n");
                    this.addLibItem(BasicLibrary.LibItem.XOUTCH);
                }
                object = this.checkVariable(characterIterator);
                if (object == null) {
                    if (string3 != null) {
                        BasicCompiler.throwVarExpected();
                    }
                    BasicCompiler.throwStringLitOrVarExpected();
                }
                if (((SimpleVarInfo)object).getDataType() == DataType.INTEGER) {
                    ((SimpleVarInfo)object).ensureAddrInHL(this.asmOut);
                    this.asmOut.append("\tCALL\tINIV\n");
                    if (this.options.getPreferRelativeJumps()) {
                        this.asmOut.append("\tJR\tC,");
                    } else {
                        this.asmOut.append("\tJP\tC,");
                    }
                    this.asmOut.append(string);
                    this.asmOut.newLine();
                    this.addLibItem(BasicLibrary.LibItem.INIV);
                    continue;
                }
                if (((SimpleVarInfo)object).getDataType() != DataType.STRING) continue;
                ((SimpleVarInfo)object).ensureAddrInHL(this.asmOut);
                this.asmOut.append("\tCALL\tINSV\n");
                this.addLibItem(BasicLibrary.LibItem.INSV);
            } while (BasicUtil.checkToken(characterIterator, ';'));
        }
    }

    private void parseLET(CharacterIterator characterIterator) throws PrgException {
        String string = BasicUtil.checkIdentifier(characterIterator);
        if (string == null) {
            BasicCompiler.throwVarExpected();
        }
        if (!this.checkReturnValueAssignment(characterIterator, string)) {
            SimpleVarInfo simpleVarInfo = this.checkVariable(characterIterator, string);
            if (simpleVarInfo != null) {
                this.parseAssignment(characterIterator, simpleVarInfo);
            } else {
                BasicCompiler.throwVarExpected();
            }
        }
    }

    private void parseLABEL(CharacterIterator characterIterator) throws PrgException {
        this.checkGraphicsSupported();
        while (true) {
            String string;
            if ((string = BasicUtil.checkStringLiteral(this, characterIterator)) != null) {
                if (!string.isEmpty()) {
                    String string2 = this.str2Label.get(string);
                    if (string2 != null) {
                        this.asmOut.append("\tLD\tHL,");
                        this.asmOut.append(string2);
                        this.asmOut.append("\n\tCALL\tDRLBL\n");
                        this.addLibItem(BasicLibrary.LibItem.DRLBL);
                    } else {
                        this.asmOut.append("\tCALL\tDRLBLT\n");
                        this.asmOut.appendStringLiteral(string);
                        this.addLibItem(BasicLibrary.LibItem.DRLBLT);
                    }
                }
            } else {
                if (!BasicExprParser.checkParseStringPrimVarExpr(this, characterIterator)) {
                    BasicUtil.throwStringExprExpected();
                }
                this.asmOut.append("\tCALL\tDRLBL\n");
                this.addLibItem(BasicLibrary.LibItem.DRLBL);
            }
            if (BasicUtil.skipSpaces(characterIterator) != '+') break;
            characterIterator.next();
        }
    }

    private void parseLINE(CharacterIterator characterIterator) throws PrgException {
        if (BasicUtil.checkKeyword(characterIterator, "INPUT")) {
            if (BasicUtil.checkToken(characterIterator, '#')) {
                this.parseInputLineIO(characterIterator);
            } else {
                this.parseInputLine(characterIterator, false);
            }
        } else {
            this.checkGraphicsSupported();
            boolean bl = BasicUtil.checkToken(characterIterator, '(');
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tLD\t(LINE_M_BX),HL\n");
            BasicUtil.parseToken(characterIterator, ',');
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tLD\t(LINE_M_BY),HL\n");
            if (bl) {
                BasicUtil.parseToken(characterIterator, ')');
                BasicUtil.parseToken(characterIterator, '-');
                BasicUtil.parseToken(characterIterator, '(');
            } else {
                BasicUtil.parseToken(characterIterator, ',');
            }
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tLD\t(LINE_M_EX),HL\n");
            BasicUtil.parseToken(characterIterator, ',');
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tLD\t(LINE_M_EY),HL\n");
            if (bl) {
                BasicUtil.parseToken(characterIterator, ')');
            }
            if (BasicUtil.checkToken(characterIterator, ',')) {
                if (BasicUtil.checkKeyword(characterIterator, "BF")) {
                    this.asmOut.append("\tCALL\tDRBOXF\n");
                    this.addLibItem(BasicLibrary.LibItem.DRBOXF);
                } else {
                    if (!BasicUtil.checkKeyword(characterIterator, "B")) {
                        throw new PrgException("B oder BF erwartet");
                    }
                    this.asmOut.append("\tCALL\tDRBOX\n");
                    this.addLibItem(BasicLibrary.LibItem.DRBOX);
                }
            } else {
                this.asmOut.append("\tCALL\tDRAW_LINE\n");
                this.addLibItem(BasicLibrary.LibItem.DRAW_LINE);
            }
        }
    }

    private void parseLOCAL(CharacterIterator characterIterator) throws PrgException {
        CallableEntry callableEntry = this.getEnclosingCallableEntry();
        if (callableEntry == null) {
            throw new PrgException("Anweisung nur in einer Funktion/Prozedur erlaubt");
        }
        do {
            String string;
            if ((string = BasicUtil.checkIdentifier(characterIterator)) == null) {
                BasicCompiler.throwVarNameExpected();
            }
            this.checkVarName(string);
            if (string.equals(callableEntry.getName())) {
                throw new PrgException("Name der Funktion/Prozedur als Variablenname nicht zul\u00e4ssig");
            }
            callableEntry.addVar(this.curSource, this.curBasicLineNum, string);
        } while (BasicUtil.checkToken(characterIterator, ','));
    }

    private void parseLOCATE(CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parse2ArgsTo_DE_HL(this, characterIterator);
        if (!this.target.supportsXLOCAT()) {
            throw new PrgException("LOCATE-Anweisung f\u00fcr das Zielsystem nicht unterst\u00fctzt");
        }
        this.asmOut.append("\tCALL\tLOCATE\n");
        this.addLibItem(BasicLibrary.LibItem.LOCATE);
    }

    private void parseLOOP(CharacterIterator characterIterator) throws PrgException {
        BasicSourcePos basicSourcePos;
        DoEntry doEntry = null;
        if (!this.structureStack.isEmpty() && (basicSourcePos = this.structureStack.peek()) instanceof DoEntry) {
            doEntry = (DoEntry)basicSourcePos;
            this.structureStack.pop();
        }
        if (doEntry == null) {
            throw new PrgException("LOOP ohne DO");
        }
        if (BasicUtil.checkKeyword(characterIterator, "UNTIL")) {
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tLD\tA,H\n\tOR\tL\n\tJP\tZ," + doEntry.getLoopLabel() + "\n");
        } else if (BasicUtil.checkKeyword(characterIterator, "WHILE")) {
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tLD\tA,H\n\tOR\tL\n\tJP\tNZ," + doEntry.getLoopLabel() + "\n");
        } else {
            if (!this.isEndOfInstr(characterIterator)) {
                throw new PrgException("UNTIL, WHILE oder Ende der Anweisung erwartet");
            }
            this.asmOut.append("\tJP\t");
            this.asmOut.append(doEntry.getLoopLabel());
            this.asmOut.newLine();
        }
        this.asmOut.append(doEntry.getExitLabel());
        this.asmOut.append(":\n");
    }

    private void parseLPRINT(CharacterIterator characterIterator) throws PrgException {
        if (!this.target.supportsXLPTCH()) {
            throw new PrgException("Druckerausgaben f\u00fcr das Zielsystem nicht unterst\u00fctzt");
        }
        this.asmOut.append("\tLD\tHL,XLPTCH\n\tLD\t(IO_M_COUT),HL\n");
        this.addLibItem(BasicLibrary.LibItem.XLPTCH);
        this.addLibItem(BasicLibrary.LibItem.IO_M_COUT);
        this.parsePrint(characterIterator, false);
    }

    private void parseMOVE(CharacterIterator characterIterator) throws PrgException {
        if (BasicUtil.checkKeyword(characterIterator, "STEP")) {
            this.parseMOVER(characterIterator);
        } else {
            this.checkGraphicsSupported();
            BasicUtil.checkKeyword(characterIterator, "TO");
            this.parsePointToMem(characterIterator, "M_XPOS", "M_YPOS");
            this.addLibItem(BasicLibrary.LibItem.M_XYPO);
        }
    }

    private void parseMOVER(CharacterIterator characterIterator) throws PrgException {
        this.checkGraphicsSupported();
        this.parsePointTo_DE_HL(characterIterator);
        this.asmOut.append("\tCALL\tMOVER\n");
        this.addLibItem(BasicLibrary.LibItem.MOVER);
    }

    private void parseNEXT(CharacterIterator characterIterator) throws PrgException {
        Object object;
        Object object2;
        ForEntry forEntry = null;
        if (!this.structureStack.isEmpty() && (object2 = this.structureStack.peek()) instanceof ForEntry) {
            forEntry = (ForEntry)object2;
            this.structureStack.pop();
        }
        if (forEntry == null) {
            throw new PrgException("NEXT ohne FOR");
        }
        if (!this.isEndOfInstr(characterIterator)) {
            int n = this.asmOut.length();
            object = this.checkVariable(characterIterator);
            this.asmOut.setLength(n);
            if (object == null) {
                throw new PrgException("Variable oder Ende der Anweisung erwartet");
            }
            if (!((SimpleVarInfo)object).equals(forEntry.getSimpleVarInfo())) {
                throw new PrgException("Variable stimmt nicht mit der bei der FOR-Anweisung angegebenen \u00fcberein.");
            }
        }
        forEntry.getSimpleVarInfo().ensureValueInHL(this.asmOut);
        object2 = forEntry.getStepValue();
        if (object2 != null) {
            if ((Integer)object2 == -1) {
                this.asmOut.append("\tCALL\tO_DEC\n");
                this.addLibItem(BasicLibrary.LibItem.O_DEC);
            } else if ((Integer)object2 == 1) {
                this.asmOut.append("\tCALL\tO_INC\n");
                this.addLibItem(BasicLibrary.LibItem.O_INC);
            } else {
                this.asmOut.append_LD_DE_nn((Integer)object2);
                this.asmOut.append("\tCALL\tO_ADD\n");
                this.addLibItem(BasicLibrary.LibItem.O_ADD);
            }
        } else {
            this.asmOut.append("\tPOP\tDE\n\tCALL\tO_ADD\n");
            this.addLibItem(BasicLibrary.LibItem.O_ADD);
        }
        forEntry.getSimpleVarInfo().writeCode_LD_Var_HL(this.asmOut);
        object = forEntry.getToValue();
        if (object2 != null) {
            if (object != null) {
                this.asmOut.append_LD_DE_nn((Integer)object);
                this.asmOut.append("\tCALL\tCPHLDE\n");
                this.addLibItem(BasicLibrary.LibItem.CPHLDE);
                if ((Integer)object2 < 0) {
                    this.asmOut.append("\tJP\tNC,");
                } else {
                    this.asmOut.append("\tJP\tZ,");
                    this.asmOut.append(forEntry.getLoopLabel());
                    this.asmOut.append("\n\tJP\tC,");
                }
                this.asmOut.append(forEntry.getLoopLabel());
                this.asmOut.newLine();
            } else {
                this.asmOut.append("\tPOP\tDE\n");
                this.asmOut.append("\tCALL\tCPHLDE\n");
                this.addLibItem(BasicLibrary.LibItem.CPHLDE);
                String string = this.nextLabel();
                if ((Integer)object2 < 0) {
                    this.asmOut.append("\tJR\tC,");
                    this.asmOut.append(string);
                    this.asmOut.newLine();
                } else {
                    String string2 = this.nextLabel();
                    this.asmOut.append("\tJR\tZ,");
                    this.asmOut.append(string2);
                    this.asmOut.append("\n\tJR\tNC,");
                    this.asmOut.append(string);
                    this.asmOut.newLine();
                    this.asmOut.append(string2);
                    this.asmOut.append(':');
                }
                this.asmOut.append("\tPUSH\tDE\n\tJP\t");
                this.asmOut.append(forEntry.getLoopLabel());
                this.asmOut.newLine();
                this.asmOut.append(string);
                this.asmOut.append(":\n");
            }
        } else {
            this.asmOut.append("\tLD\tB,D\n\tLD\tC,E\n");
            if (object != null) {
                this.asmOut.append_LD_DE_nn((Integer)object);
            } else {
                this.asmOut.append("\tPOP\tDE\n");
            }
            this.asmOut.append("\tLD\tA,B\n\tOR\tA\n\tJP\tM,");
            String string = this.nextLabel();
            this.asmOut.append(string);
            this.asmOut.append("\n\tCALL\tCPHLDE\n");
            this.addLibItem(BasicLibrary.LibItem.CPHLDE);
            String string3 = this.nextLabel();
            this.asmOut.append("\tJR\tZ,");
            this.asmOut.append(string3);
            this.asmOut.append("\n\tJR\tC,");
            this.asmOut.append(string3);
            this.asmOut.append("\n\tJR\t");
            this.asmOut.append(forEntry.getExitLabel());
            this.asmOut.newLine();
            this.asmOut.append(string);
            this.asmOut.append(":\n\tCALL\tCPHLDE\n\tJR\tC,");
            this.asmOut.append(forEntry.getExitLabel());
            this.asmOut.newLine();
            this.asmOut.append(string3);
            this.asmOut.append(":\n");
            if (object == null) {
                this.asmOut.append("\tPUSH\tDE\n");
            }
            this.asmOut.append("\tPUSH\tBC\n\tJP\t");
            this.asmOut.append(forEntry.getLoopLabel());
            this.asmOut.newLine();
        }
        this.asmOut.append(forEntry.getExitLabel());
        this.asmOut.append(":\n");
    }

    private void parseON(CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseExpr(this, characterIterator);
        if (BasicUtil.checkKeyword(characterIterator, "GOSUB")) {
            this.asmOut.append("\tCALL\tONGOAD\n");
            this.parseLineExprList(characterIterator);
            String string = this.nextLabel();
            this.asmOut.append("\tJR\tZ,");
            this.asmOut.append(string);
            this.asmOut.append("\n\tLD\tDE,");
            this.asmOut.append(string);
            this.asmOut.append("\n\tPUSH\tDE\n");
            if (this.options.getCheckStack()) {
                this.asmOut.append_LD_A_n(71);
                this.asmOut.append("\tPUSH\tAF\n");
            }
            this.asmOut.append("\tJP\t(HL)\n");
            this.asmOut.append(string);
            this.asmOut.append(":\n");
            this.addLibItem(BasicLibrary.LibItem.ONGOAD);
        } else if (BasicUtil.checkKeyword(characterIterator, "GOTO")) {
            this.asmOut.append("\tCALL\tONGOAD\n");
            this.parseLineExprList(characterIterator);
            String string = this.nextLabel();
            this.asmOut.append("\tJR\tZ,");
            this.asmOut.append(string);
            this.asmOut.append("\n\tJP\t(HL)\n");
            this.asmOut.append(string);
            this.asmOut.append(":\n");
            this.addLibItem(BasicLibrary.LibItem.ONGOAD);
        } else {
            throw new PrgException("GOSUB oder GOTO erwartet");
        }
    }

    private void parseOPEN(CharacterIterator characterIterator) throws PrgException {
        TreeSet<Integer> treeSet;
        int n = 17;
        IODriver iODriver = IODriver.ALL;
        boolean bl = false;
        String string = BasicUtil.checkStringLiteral(this, characterIterator);
        if (string != null) {
            treeSet = this.getStringLiteralLabel(string);
            this.asmOut.append("\tLD\tHL,");
            this.asmOut.append((CharSequence)((Object)treeSet));
            this.asmOut.newLine();
            string = string.trim().toUpperCase();
            if (string.startsWith("CRT:")) {
                iODriver = IODriver.CRT;
                if (!this.options.isOpenCrtEnabled()) {
                    this.putWarning("CRT-Treiber in den Compiler-Optionen deaktiviert");
                }
            } else if (string.startsWith("LPT:")) {
                iODriver = IODriver.LPT;
                if (!this.options.isOpenLptEnabled()) {
                    this.putWarning("LPT-Treiber in den Compiler-Optionen deaktiviert");
                }
            } else if (string.startsWith("V:")) {
                iODriver = IODriver.VDIP;
                this.checkPutWarningVdipDriverDisabled();
            } else if (this.target.startsWithFileDevice(string)) {
                iODriver = IODriver.FILE;
                this.checkPutWarningFileDriverDisabled();
            } else {
                int n2 = string.indexOf(58);
                if (n2 >= 0) {
                    this.putWarning("Unbekanntes Ger\u00e4t");
                } else if (this.target.getFileHandlerLabel() != null) {
                    iODriver = IODriver.FILE;
                    this.checkPutWarningFileDriverDisabled();
                } else {
                    int[] nArray = this.target.getVdipBaseIOAddresses();
                    if (nArray != null && nArray.length > 0) {
                        iODriver = IODriver.VDIP;
                        this.checkPutWarningVdipDriverDisabled();
                    }
                }
            }
        } else if (!BasicExprParser.checkParseStringPrimVarExpr(this, characterIterator)) {
            BasicUtil.throwStringExprExpected();
        }
        if (!(iODriver != IODriver.ALL || this.options.isOpenCrtEnabled() || this.options.isOpenLptEnabled() || this.options.isOpenFileEnabled() || this.options.isOpenVdipEnabled())) {
            this.putWarning("Alle betreffenden Treiber in den Compiler-Optionen deaktiviert");
        }
        this.asmOut.append("\tLD\t(IO_M_NAME),HL\n");
        if (BasicUtil.checkKeyword(characterIterator, "FOR")) {
            boolean bl2 = BasicUtil.checkKeyword(characterIterator, "BINARY");
            if (BasicUtil.checkKeyword(characterIterator, "INPUT")) {
                n = bl2 ? 34 : 18;
            } else if (BasicUtil.checkKeyword(characterIterator, "OUTPUT")) {
                n = bl2 ? 36 : 20;
            } else if (BasicUtil.checkKeyword(characterIterator, "APPEND")) {
                n = bl2 ? 40 : 24;
            } else if (BasicUtil.checkKeyword(characterIterator, "AS")) {
                bl = true;
                n = bl2 ? 33 : 17;
            } else {
                throw new PrgException("INPUT, OUTPUT oder APPEND erwartet");
            }
        }
        if (!bl) {
            this.parseKeywordAS(characterIterator);
        }
        this.asmOut.append_LD_A_n(n);
        this.asmOut.append("\tLD\t(IO_M_ACCESS),A\n");
        BasicUtil.checkToken(characterIterator, '#');
        this.parseIOChannelNumToPtrFldAddrInHL(characterIterator, null);
        this.asmOut.append("\tCALL\tIOOPEN\n");
        if (!(iODriver != IODriver.CRT && iODriver != IODriver.LPT || n != 20 && n != 24 && n != 36 && n != 40)) {
            this.putWarning("Ger\u00e4t kann nicht mit der angegebenen Betriebsart ge\u00f6ffnet werden");
        }
        if ((treeSet = this.ioDriverModes.get((Object)iODriver)) == null) {
            treeSet = new TreeSet<Integer>();
        }
        treeSet.add(n);
        this.ioDriverModes.put(iODriver, treeSet);
        this.addLibItem(BasicLibrary.LibItem.IOOPEN);
    }

    private void parseOUT(CharacterIterator characterIterator) throws PrgException {
        boolean bl = BasicUtil.checkToken(characterIterator, '(');
        int n = this.asmOut.length();
        BasicExprParser.parseExpr(this, characterIterator);
        String string = this.asmOut.cut(n);
        String string2 = BasicUtil.convertCodeToValueInBC(string);
        if (bl) {
            BasicUtil.parseToken(characterIterator, ')');
        }
        if (bl) {
            if (!BasicUtil.checkToken(characterIterator, '=')) {
                BasicUtil.parseToken(characterIterator, ',');
            }
        } else {
            BasicUtil.parseToken(characterIterator, ',');
        }
        BasicExprParser.parseExpr(this, characterIterator);
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(this, n);
        if (n2 != null) {
            if (string2 != null) {
                this.asmOut.append(string2);
            } else {
                this.asmOut.append(string);
                this.asmOut.append("\tLD\tB,H\n\tLD\tC,L\n");
            }
            this.asmOut.append_LD_A_n(n2);
            this.asmOut.append("\tOUT\t(C),A\n");
        } else {
            if (string2 != null) {
                this.asmOut.append(string2);
            } else {
                String string3 = this.asmOut.cut(n);
                if (BasicUtil.isOnly_LD_HL_xx(string3)) {
                    if (string2 != null) {
                        this.asmOut.append(string2);
                    } else {
                        this.asmOut.append(string);
                        this.asmOut.append("\tLD\tB,H\n\tLD\tC,L\n");
                    }
                    this.asmOut.append(string3);
                } else {
                    this.asmOut.append(string);
                    this.asmOut.append("\tPUSH\tHL\n");
                    this.asmOut.append(string3);
                    this.asmOut.append("\tPOP\tBC\n");
                }
            }
            this.asmOut.append("\tOUT\t(C),L\n");
        }
    }

    private void parsePAINT(CharacterIterator characterIterator) throws PrgException {
        this.checkGraphicsSupported();
        this.parsePointToMem(characterIterator, "PAINT_M_X", "PAINT_M_Y");
        this.asmOut.append("\tCALL\tPAINT\n");
        this.addLibItem(BasicLibrary.LibItem.PAINT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePAPER(CharacterIterator characterIterator) throws PrgException {
        if (this.target.supportsColors()) {
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tCALL\tXPAPER\n");
            this.addLibItem(BasicLibrary.LibItem.XPAPER);
        } else {
            try {
                this.pushCodeCreationDisabled();
                BasicExprParser.parseExpr(this, characterIterator);
            }
            finally {
                this.popCodeCreationDisabled();
            }
        }
    }

    private void parsePASSWORD(CharacterIterator characterIterator) throws PrgException {
        if (!BasicUtil.checkKeyword(characterIterator, "INPUT")) {
            throw new PrgException("INPUT erwartet");
        }
        this.parseInputLine(characterIterator, true);
    }

    private void parsePAUSE(CharacterIterator characterIterator) throws PrgException {
        if (this.isEndOfInstr(characterIterator)) {
            this.asmOut.append("\tCALL\tPAUSE\n");
            this.addLibItem(BasicLibrary.LibItem.PAUSE);
        } else {
            int n = this.asmOut.length();
            BasicExprParser.parseExpr(this, characterIterator);
            Integer n2 = BasicUtil.removeLastCodeIfConstExpr(this, n);
            if (n2 != null) {
                if (n2 < 0) {
                    this.putWarningOutOfRange();
                }
                this.asmOut.append_LD_HL_nn(n2);
            }
            this.asmOut.append("\tCALL\tPAUSE_N\n");
            this.addLibItem(BasicLibrary.LibItem.PAUSE_N);
        }
    }

    private void parsePOKE(CharacterIterator characterIterator) throws PrgException {
        int n = this.asmOut.length();
        BasicExprParser.parseExpr(this, characterIterator);
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(this, n);
        BasicUtil.parseToken(characterIterator, ',');
        n = this.asmOut.length();
        BasicExprParser.parseExpr(this, characterIterator);
        if (n2 != null) {
            Integer n3 = BasicUtil.removeLastCodeIfConstExpr(this, n);
            if (n3 != null) {
                if ((n3 & 0xFF) == 0) {
                    this.asmOut.append("\tXOR\tA\n");
                } else {
                    this.asmOut.append("\tLD\tA,");
                    this.asmOut.appendHex2(n3);
                    this.asmOut.newLine();
                }
            } else {
                this.asmOut.append("\tLD\tA,L\n");
            }
            this.asmOut.append("\tLD\t(");
            this.asmOut.appendHex4(n2);
            this.asmOut.append("),A\n");
        } else {
            Integer n4 = BasicUtil.removeLastCodeIfConstExpr(this, n);
            if (n4 != null) {
                this.asmOut.append("\tLD\t(HL),");
                this.asmOut.appendHex2(n4);
                this.asmOut.newLine();
            } else {
                String string = this.asmOut.cut(n);
                String string2 = BasicUtil.convertCodeToValueInDE(string);
                if (string2 != null) {
                    this.asmOut.append(string2);
                    this.asmOut.append("\tLD\t(HL),E\n");
                } else {
                    this.asmOut.append("\tPUSH\tHL\n");
                    this.asmOut.append(string);
                    this.asmOut.append("\tLD\tA,L\n\tPOP\tHL\n\tLD\t(HL),A\n");
                }
            }
        }
    }

    private void parsePEN(CharacterIterator characterIterator) throws PrgException {
        int n = this.asmOut.length();
        BasicExprParser.parseExpr(this, characterIterator);
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(this, n);
        if (n2 != null) {
            if (n2 < 0 || n2 > 3) {
                throw new PrgException("Ung\u00fcltiger Wert bei PEN");
            }
            this.asmOut.append_LD_A_n(n2);
            this.asmOut.append("\tCALL\tXPEN\n");
            this.addLibItem(BasicLibrary.LibItem.XPEN);
        } else {
            this.asmOut.append("\tCALL\tPEN\n");
            this.addLibItem(BasicLibrary.LibItem.PEN);
        }
    }

    private void parsePLOT(CharacterIterator characterIterator) throws PrgException {
        if (BasicUtil.checkKeyword(characterIterator, "STEP")) {
            this.parsePLOTR(characterIterator);
        } else {
            this.checkGraphicsSupported();
            BasicUtil.checkKeyword(characterIterator, "TO");
            this.parsePointTo_DE_HL(characterIterator);
            this.asmOut.append("\tLD\t(M_XPOS),DE\n\tLD\t(M_YPOS),HL\n\tCALL\tXPSET\n");
            this.addLibItem(BasicLibrary.LibItem.XPSET);
        }
    }

    private void parsePLOTR(CharacterIterator characterIterator) throws PrgException {
        this.checkGraphicsSupported();
        this.parsePointTo_DE_HL(characterIterator);
        this.asmOut.append("\tCALL\tPLOTR\n");
        this.addLibItem(BasicLibrary.LibItem.PLOTR);
    }

    private void parsePRESET(CharacterIterator characterIterator) throws PrgException {
        this.checkGraphicsSupported();
        this.parsePointTo_DE_HL(characterIterator);
        this.asmOut.append("\tCALL\tXPRES\n");
        this.addLibItem(BasicLibrary.LibItem.XPRES);
    }

    private void parsePRINT(CharacterIterator characterIterator) throws PrgException {
        if (BasicUtil.checkToken(characterIterator, '#')) {
            this.parseIOChannelNumToWriteRoutineInHL(characterIterator);
            this.asmOut.append("\tCALL\tIO_SET_COUT\n");
            this.addLibItem(BasicLibrary.LibItem.IO_SET_COUT);
            if (this.options.getPreferRelativeJumps()) {
                this.asmOut.append("\tJR\tC,");
            } else {
                this.asmOut.append("\tJP\tC,");
            }
            String string = this.nextLabel();
            this.asmOut.append(string);
            this.asmOut.newLine();
            if (this.isEndOfInstr(characterIterator)) {
                this.asmOut.append("\tCALL\tPS_NL\n");
                this.addLibItem(BasicLibrary.LibItem.PS_NL);
            } else {
                BasicUtil.parseToken(characterIterator, ',');
                this.parsePrint(characterIterator, false);
            }
            this.asmOut.append(string);
            this.asmOut.append(":\n");
        } else {
            this.parsePrint(characterIterator, true);
        }
    }

    private void parsePSET(CharacterIterator characterIterator) throws PrgException {
        this.checkGraphicsSupported();
        this.parsePointTo_DE_HL(characterIterator);
        this.asmOut.append("\tCALL\tXPSET\n");
        this.addLibItem(BasicLibrary.LibItem.XPSET);
    }

    private void parseREM(CharacterIterator characterIterator) {
        characterIterator.setIndex(characterIterator.getEndIndex());
    }

    private void parseREAD(CharacterIterator characterIterator) throws PrgException {
        characterIterator.previous();
        do {
            characterIterator.next();
            SimpleVarInfo simpleVarInfo = this.checkVariable(characterIterator);
            if (simpleVarInfo != null) {
                switch (simpleVarInfo.getDataType()) {
                    case INTEGER: {
                        simpleVarInfo.ensureAddrInHL(this.asmOut);
                        this.asmOut.append("\tCALL\tDREADI\n");
                        this.addLibItem(BasicLibrary.LibItem.DREADI);
                        break;
                    }
                    case STRING: {
                        simpleVarInfo.ensureAddrInHL(this.asmOut);
                        this.asmOut.append("\tCALL\tDREADS\n");
                        this.addLibItem(BasicLibrary.LibItem.DREADS);
                    }
                }
                continue;
            }
            BasicCompiler.throwVarExpected();
        } while (BasicUtil.skipSpaces(characterIterator) == ',');
    }

    private void parseRESTORE(CharacterIterator characterIterator) throws PrgException {
        BasicLineExpr basicLineExpr = BasicLineExpr.checkBasicLineExpr(characterIterator, this.curSource, this.curBasicLineNum);
        if (basicLineExpr != null) {
            if (this.restoreBasicLines == null) {
                this.restoreBasicLines = new ArrayList<BasicLineExpr>(128);
            }
            this.restoreBasicLines.add(basicLineExpr);
            this.asmOut.append_LD_HL_xx(BasicCompiler.createDataLineLabel(basicLineExpr.getExprText()));
            this.asmOut.append("\tLD\t(M_READ),HL\n");
        } else {
            if (!this.isEndOfInstr(characterIterator)) {
                BasicCompiler.throwBasicLineExprExpected();
            }
            this.asmOut.append("\tCALL\tDINIT\n");
        }
        this.addLibItem(BasicLibrary.LibItem.DATA);
    }

    private void parseRETURN() {
        if (this.options.getCheckStack()) {
            this.asmOut.append("\tPOP\tAF\n\tCP\t");
            this.asmOut.appendHex2(71);
            this.asmOut.append("\n\tJP\tNZ,E_REWG\n");
            this.addLibItem(BasicLibrary.LibItem.E_REWG);
        }
        this.asmOut.append("\tRET\n");
    }

    private void parseSCREEN(CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseExpr(this, characterIterator);
        this.asmOut.append("\tCALL\tSCREEN\n");
        this.addLibItem(BasicLibrary.LibItem.SCREEN);
    }

    private void parseWAIT(CharacterIterator characterIterator) throws PrgException {
        Object object;
        int n = this.asmOut.length();
        BasicExprParser.parseExpr(this, characterIterator);
        String string = this.asmOut.cut(n);
        String string2 = BasicUtil.convertCodeToValueInBC(string);
        BasicUtil.parseToken(characterIterator, ',');
        BasicExprParser.parseExpr(this, characterIterator);
        String string3 = this.asmOut.substring(n);
        String string4 = null;
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(this, n);
        this.asmOut.setLength(n);
        if (n2 != null) {
            int n3 = n2 & 0xFF;
            string4 = String.format("\tLD\tE,%s%02XH\n", n3 >= 160 ? "0" : "", n3);
        } else if (BasicUtil.isOnly_LD_HL_xx(string3)) {
            string4 = string3 + "\tLD\tE,L\n";
        }
        String string5 = null;
        String string6 = null;
        if (BasicUtil.checkToken(characterIterator, ',')) {
            BasicExprParser.parseExpr(this, characterIterator);
            string5 = this.asmOut.substring(n);
            object = BasicUtil.removeLastCodeIfConstExpr(this, n);
            this.asmOut.setLength(n);
            if (object != null) {
                int n4 = (Integer)object & 0xFF;
                string6 = String.format("\tLD\tL,%s%02XH\n", n4 >= 160 ? "0" : "", n4);
            } else if (BasicUtil.isOnly_LD_HL_xx(string5)) {
                string6 = string5;
            }
        }
        if (string2 != null && string4 != null && (string5 == null || string6 != null)) {
            this.asmOut.append(string2);
            this.asmOut.append(string4);
            if (string6 != null) {
                this.asmOut.append(string6);
            }
        } else {
            this.asmOut.append(string);
            this.asmOut.append("\tPUSH\tHL\n");
            if (string5 != null) {
                if (string6 != null) {
                    if (string4 != null) {
                        this.asmOut.append(string4);
                    } else {
                        this.asmOut.append(string3);
                        this.asmOut.append("\tLD\tE,L\n");
                    }
                    this.asmOut.append(string6);
                } else {
                    this.asmOut.append(string3);
                    this.asmOut.append("\tPUSH\tHL\n");
                    this.asmOut.append(string5);
                    this.asmOut.append("\tPOP\tDE\n");
                }
            } else if (string4 != null) {
                this.asmOut.append(string4);
            } else {
                this.asmOut.append(string3);
                this.asmOut.append("\tLD\tE,L\n");
            }
            this.asmOut.append("\tPOP\tBC\n");
        }
        object = this.nextLabel();
        this.asmOut.append((CharSequence)object);
        this.asmOut.append(":\tIN\tA,(C)\n");
        if (string5 != null) {
            this.asmOut.append("\tXOR\tL\n");
        }
        this.asmOut.append("\tAND\tE\n");
        if (this.options.canBreakAlways()) {
            String string7 = this.nextLabel();
            this.asmOut.append("\tJR\tNZ,");
            this.asmOut.append(string7);
            this.asmOut.append("\n\tCALL\tXCKBRK\n\tJR\t");
            this.asmOut.append((CharSequence)object);
            this.asmOut.newLine();
            this.asmOut.append(string7);
            this.asmOut.append(":\n");
            this.addLibItem(BasicLibrary.LibItem.XCKBRK);
        } else {
            this.asmOut.append("\tJR\tZ,");
            this.asmOut.append((CharSequence)object);
            this.asmOut.newLine();
        }
    }

    private void parseWEND(CharacterIterator characterIterator) throws PrgException {
        BasicSourcePos basicSourcePos;
        LoopEntry loopEntry = null;
        if (!this.structureStack.isEmpty() && (basicSourcePos = this.structureStack.peek()) instanceof WhileEntry) {
            loopEntry = (WhileEntry)basicSourcePos;
            this.structureStack.pop();
        }
        if (loopEntry == null) {
            throw new PrgException("WEND ohne WHILE");
        }
        this.asmOut.append("\tJP\t");
        this.asmOut.append(loopEntry.getLoopLabel());
        this.asmOut.newLine();
        this.asmOut.append(loopEntry.getExitLabel());
        this.asmOut.append(":\n");
    }

    private void parseWHILE(CharacterIterator characterIterator) throws PrgException {
        String string = this.nextLabel();
        String string2 = this.nextLabel();
        this.asmOut.append(string);
        this.asmOut.append(":\n");
        BasicExprParser.parseExpr(this, characterIterator);
        BasicUtil.checkKeyword(characterIterator, "DO");
        this.asmOut.append("\tLD\tA,H\n\tOR\tL\n\tJP\tZ," + string2 + "\n");
        this.checkAppendBreakCheck();
        this.structureStack.push(new WhileEntry(this.curSource, this.curBasicLineNum, string, string2));
    }

    private void parseExpr(CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseExpr(this, characterIterator);
    }

    private void parseLineExprList(CharacterIterator characterIterator) throws PrgException {
        ArrayList<String> arrayList = new ArrayList<String>(32);
        arrayList.add(this.parseDestLineExpr(characterIterator));
        while (BasicUtil.checkToken(characterIterator, ',')) {
            arrayList.add(this.parseDestLineExpr(characterIterator));
        }
        int n = arrayList.size();
        if (n >= 255) {
            throw new PrgException("Liste der Zeilennummern zu lang");
        }
        this.asmOut.append("\tDB\t");
        this.asmOut.appendHex2(n);
        this.asmOut.newLine();
        for (String string : arrayList) {
            this.asmOut.append("\tDW\t");
            this.asmOut.append(string);
            this.asmOut.newLine();
        }
    }

    private static Long readLineNum(CharacterIterator characterIterator) throws PrgException {
        Long l = null;
        char c = BasicUtil.skipSpaces(characterIterator);
        if (c >= '0' && c <= '9') {
            long l2 = c - 48;
            c = characterIterator.next();
            while (c >= '0' && c <= '9') {
                if ((l2 = l2 * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                    throw new PrgException("BASIC-Zeilennummer zu gro\u00df");
                }
                c = characterIterator.next();
            }
            l = l2;
        }
        return l;
    }

    private void parseAssignment(CharacterIterator characterIterator, SimpleVarInfo simpleVarInfo) throws PrgException {
        BasicUtil.parseToken(characterIterator, '=');
        if (simpleVarInfo.getDataType() == DataType.INTEGER) {
            if (simpleVarInfo.hasStaticAddr()) {
                BasicExprParser.parseExpr(this, characterIterator);
                simpleVarInfo.writeCode_LD_Var_HL(this.asmOut);
            } else {
                int n = this.asmOut.length();
                BasicExprParser.parseExpr(this, characterIterator);
                Integer n2 = BasicUtil.removeLastCodeIfConstExpr(this, n);
                if (n2 != null) {
                    this.asmOut.append("\tLD\t(HL),");
                    this.asmOut.appendHex2(n2);
                    this.asmOut.append("\n\tINC\tHL\n\tLD\t(HL),");
                    this.asmOut.appendHex2(n2 >> 8);
                    this.asmOut.newLine();
                } else {
                    String string = this.asmOut.cut(n);
                    String string2 = BasicUtil.convertCodeToValueInDE(string);
                    if (string2 != null) {
                        this.asmOut.append(string2);
                    } else {
                        this.asmOut.append("\tPUSH\tHL\n");
                        this.asmOut.append(string);
                        this.asmOut.append("\tEX\tDE,HL\n\tPOP\tHL\n");
                    }
                    this.asmOut.append("\tLD\t(HL),E\n\tINC\tHL\n\tLD\t(HL),D\n");
                }
            }
        } else if (simpleVarInfo.getDataType() == DataType.STRING) {
            int n;
            boolean bl = false;
            int n3 = characterIterator.getIndex();
            int n4 = this.asmOut.length();
            String string = BasicUtil.checkStringLiteral(this, characterIterator);
            if (string != null) {
                n = BasicUtil.skipSpaces(characterIterator);
                if (this.isEndOfInstr(characterIterator)) {
                    if (simpleVarInfo.hasStaticAddr()) {
                        simpleVarInfo.ensureStaticAddrInDE(this.asmOut, false);
                    } else if (!BasicUtil.replaceLastCodeFrom_LD_HL_To_DE(this)) {
                        this.asmOut.append("\tEX\tDE,HL\n");
                    }
                    this.asmOut.append("\tLD\tHL,");
                    this.asmOut.append(this.getStringLiteralLabel(string));
                    this.asmOut.append("\n\tCALL\tASSIGN_STR_TO_VS\n");
                    this.addLibItem(BasicLibrary.LibItem.ASSIGN_STR_TO_VS);
                    bl = true;
                }
            }
            if (!bl) {
                characterIterator.setIndex(n3);
                this.asmOut.setLength(n4);
                SimpleVarInfo simpleVarInfo2 = this.checkVariable(characterIterator);
                if (simpleVarInfo2 != null) {
                    char c = BasicUtil.skipSpaces(characterIterator);
                    if (this.isEndOfInstr(characterIterator)) {
                        if (simpleVarInfo2.hasStaticAddr()) {
                            simpleVarInfo2.ensureAddrInHL(this.asmOut);
                            simpleVarInfo.ensureStaticAddrInDE(this.asmOut, true);
                        } else {
                            this.asmOut.insert(n4, "\tPUSH\tHL\n");
                            simpleVarInfo2.ensureAddrInHL(this.asmOut);
                            this.asmOut.append("\tPOP\tDE\n");
                        }
                        this.asmOut.append("\tCALL\tASSIGN_VS_TO_VS\n");
                        this.addLibItem(BasicLibrary.LibItem.ASSIGN_VS_TO_VS);
                        bl = true;
                    }
                }
            }
            if (!bl) {
                characterIterator.setIndex(n3);
                this.asmOut.setLength(n4);
                if (!simpleVarInfo.hasStaticAddr()) {
                    this.asmOut.append("\tPUSH\tHL\n");
                }
                if (BasicExprParser.checkParseStringPrimExpr(this, characterIterator) && this.isEndOfInstr(characterIterator)) {
                    if (simpleVarInfo.hasStaticAddr()) {
                        simpleVarInfo.ensureStaticAddrInDE(this.asmOut, true);
                    } else {
                        this.asmOut.append("\tPOP\tDE\n");
                    }
                    this.asmOut.append("\tCALL\tASSIGN_STR_TO_NEW_MEM_VS\n");
                    this.addLibItem(BasicLibrary.LibItem.ASSIGN_STR_TO_NEW_MEM_VS);
                    bl = true;
                }
            }
            if (!bl) {
                characterIterator.setIndex(n3);
                this.asmOut.setLength(n4);
                if (!simpleVarInfo.hasStaticAddr()) {
                    this.asmOut.append("\tPUSH\tHL\n");
                }
                this.asmOut.append("\tCALL\tMFIND\n\tPUSH\tDE\n");
                this.asmOut.append_LD_BC_nn(255);
                this.addLibItem(BasicLibrary.LibItem.MFIND);
                while (true) {
                    if ((string = BasicUtil.checkStringLiteral(this, characterIterator)) != null) {
                        this.asmOut.append("\tLD\tHL,");
                        this.asmOut.append(this.getStringLiteralLabel(string));
                        this.asmOut.newLine();
                    } else {
                        String string3;
                        n = this.asmOut.length();
                        if (!BasicExprParser.checkParseStringPrimVarExpr(this, characterIterator)) {
                            BasicUtil.throwStringExprExpected();
                        }
                        if (BasicUtil.isOnly_LD_HL_xx(string3 = this.asmOut.cut(n))) {
                            this.asmOut.append(string3);
                        } else {
                            this.asmOut.append("\tPUSH\tBC\n\tPUSH\tDE\n");
                            this.asmOut.append(string3);
                            this.asmOut.append("\tPOP\tDE\n\tPOP\tBC\n");
                        }
                    }
                    this.asmOut.append("\tCALL\tSTNCP\n");
                    this.addLibItem(BasicLibrary.LibItem.STNCP);
                    if (BasicUtil.skipSpaces(characterIterator) != '+') break;
                    characterIterator.next();
                }
                this.asmOut.append("\tPOP\tHL\n\tCALL\tMALLOC\n");
                this.addLibItem(BasicLibrary.LibItem.MALLOC);
                if (simpleVarInfo.hasStaticAddr()) {
                    simpleVarInfo.ensureStaticAddrInDE(this.asmOut, true);
                } else {
                    this.asmOut.append("\tPOP\tDE\n");
                }
                this.asmOut.append("\tCALL\tASSIGN_STR_TO_VS\n");
                this.addLibItem(BasicLibrary.LibItem.ASSIGN_STR_TO_VS);
            }
        }
    }

    private void checkAppendBreakCheck() {
        if (this.options.canBreakAlways()) {
            this.asmOut.append("\tCALL\tXCKBRK\n");
            this.addLibItem(BasicLibrary.LibItem.XCKBRK);
        }
    }

    private void checkCreateStackFrame() {
        CallableEntry callableEntry = this.getEnclosingCallableEntry();
        if (callableEntry != null) {
            int n = callableEntry.getVarCount();
            if (!(callableEntry.hasStackFrame() || callableEntry.getArgCount() <= 0 && n <= 0)) {
                this.asmOut.append("\tPUSH\tIY\n\tLD\tIY,0000H\n\tADD\tIY,SP\n");
                int n2 = callableEntry.getTotalVarSize();
                if (n2 > 0) {
                    this.asmOut.append_LD_HL_nn(-n2);
                    this.asmOut.append("\tADD\tHL,SP\n\tLD\tSP,HL\n");
                }
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    if (callableEntry.getVarType(i) != DataType.STRING) continue;
                    if (!bl) {
                        this.asmOut.append_LD_HL_xx("D_EMPT");
                        this.addLibItem(BasicLibrary.LibItem.EMPTY_STRING);
                        bl = true;
                    }
                    this.asmOut.append_LD_IndirectIY_HL(callableEntry.getVarIYOffs(i));
                }
                callableEntry.setStackFrameCreated();
            }
        }
    }

    private void checkGraphicsSupported() throws PrgException {
        if (!this.target.supportsGraphics()) {
            throw new PrgException("Grafikanweisungen und -funktionen f\u00fcr das Zielsystem nicht unterst\u00fctzt");
        }
    }

    private void checkMainPrgScope() throws PrgException {
        CallableEntry callableEntry;
        if (!this.mainPrg && (callableEntry = this.getEnclosingCallableEntry()) == null) {
            throw new PrgException("Anweisung nur im Hauptprogramm oder in einer Funktion/Prozedur zul\u00e4ssig");
        }
    }

    private boolean checkReturnValueAssignment(CharacterIterator characterIterator, String string) throws PrgException {
        boolean bl = false;
        CallableEntry callableEntry = this.getEnclosingCallableEntry();
        if (callableEntry != null && callableEntry.getName().equals(string) && callableEntry instanceof FunctionEntry) {
            Integer n = ((FunctionEntry)callableEntry).getIYOffs(string);
            if (n == null) {
                new PrgException("R\u00fcckgabewert f\u00fcr eine Prozedur nicht m\u00f6glich");
            }
            this.parseAssignment(characterIterator, ((FunctionEntry)callableEntry).getReturnVarInfo());
            bl = true;
        }
        return bl;
    }

    private void checkVarName(String string) throws PrgException {
        if (this.isReservedWord(string)) {
            throw new PrgException("Reserviertes Schl\u00fcsselwort als Variablenname nicht erlaubt");
        }
    }

    private boolean isEndOfInstr(CharacterIterator characterIterator) {
        char c = BasicUtil.skipSpaces(characterIterator);
        return c == '\uffff' || c == ':';
    }

    private boolean isReservedWord(String string) {
        return Arrays.binarySearch(sortedReservedWords, string) >= 0 || this.target.isReservedWord(string);
    }

    private CallableEntry parseCallableDecl(CharacterIterator characterIterator, boolean bl, boolean bl2) throws PrgException {
        if (!this.structureStack.isEmpty()) {
            throw new PrgException("Anweisung nur in der obersten Ebene erlaubt");
        }
        String string = BasicUtil.checkIdentifier(characterIterator);
        if (string == null) {
            throw new PrgException("Name der Funktion/Prozedur erwartet");
        }
        if (this.isReservedWord(string)) {
            throw new PrgException("Reserviertes Schl\u00fcsselwort als Name einer Funktion/Prozedur nicht erlaubt");
        }
        if (!bl && string.indexOf(36) >= 0) {
            throw new PrgException("'$' im Namen einer Prozedur nicht erlaubt");
        }
        boolean bl3 = false;
        CallableEntry callableEntry = this.name2Callable.get(string);
        if (callableEntry != null && (bl && !(callableEntry instanceof FunctionEntry) || !bl && !(callableEntry instanceof SubEntry))) {
            bl3 = true;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (BasicUtil.checkToken(characterIterator, '(') && !BasicUtil.checkToken(characterIterator, ')')) {
            do {
                String string2;
                if ((string2 = BasicUtil.checkIdentifier(characterIterator)) == null) {
                    BasicCompiler.throwVarExpected();
                }
                this.checkVarName(string2);
                if (string2.equals(string)) {
                    throw new PrgException("Name der Funktion/Prozedur als Variablenname nicht erlaubt");
                }
                if (callableEntry != null) {
                    int n = arrayList.size();
                    if (callableEntry.equalsArgType(n, string2)) {
                        if (bl2) {
                            callableEntry.setArg(n, string2);
                        }
                    } else {
                        bl3 = true;
                    }
                }
                if (!treeSet.add(string2)) {
                    throw new PrgException("Lokale Variable bereits vorhanden");
                }
                arrayList.add(string2);
                if (arrayList.size() <= 60) continue;
                throw new PrgException("Anzahl der maximal m\u00f6glichen Argumente \u00fcberschritten");
            } while (BasicUtil.checkToken(characterIterator, ','));
            BasicUtil.parseToken(characterIterator, ')');
        }
        if (callableEntry != null) {
            int n = 0;
            if (arrayList != null) {
                n = arrayList.size();
            }
            if (callableEntry.getArgCount() != n) {
                bl3 = true;
            }
        }
        if (bl3) {
            throw new PrgException("Funktion/Prozedur stimmt nicht mit vorheriger Deklaration \u00fcberein.");
        }
        if (callableEntry == null) {
            callableEntry = bl ? new FunctionEntry(this.curSource, this.curBasicLineNum, string) : new SubEntry(this.curSource, this.curBasicLineNum, string);
            if (arrayList != null) {
                callableEntry.setArgs(arrayList);
            }
            this.name2Callable.put(string, callableEntry);
        }
        return callableEntry;
    }

    private void parseCallableImpl(CharacterIterator characterIterator, boolean bl) throws PrgException {
        CallableEntry callableEntry = this.parseCallableDecl(characterIterator, bl, true);
        if (callableEntry.isImplemented()) {
            throw new PrgException("Funktion/Prozedur bereits vorhanden");
        }
        callableEntry.setImplemented();
        this.structureStack.push(callableEntry);
        if (this.mainPrg) {
            this.asmOut.append("\tJP\tXEXIT\n");
            this.mainPrg = false;
        }
        this.asmOut.append(callableEntry.getLabel());
        this.asmOut.append(":\n");
    }

    private void parseIOChannelNumToWriteRoutineInHL(CharacterIterator characterIterator) throws PrgException {
        Integer n = BasicUtil.readNumber(characterIterator);
        if (n != null) {
            switch (n) {
                case 1: {
                    this.asmOut.append("\tLD\tHL,IOCTB1\n\tLD\t(IO_M_CADDR),HL\n\tLD\tHL,(IOCTB1+");
                    this.asmOut.appendHex2(6);
                    this.asmOut.append(")\n");
                    this.addLibItem(BasicLibrary.LibItem.IOCTB1);
                    break;
                }
                case 2: {
                    this.asmOut.append("\tLD\tHL,IOCTB2\n\tLD\t(IO_M_CADDR),HL\n\tLD\tHL,(IOCTB2+");
                    this.asmOut.appendHex2(6);
                    this.asmOut.append(")\n");
                    this.addLibItem(BasicLibrary.LibItem.IOCTB2);
                    break;
                }
                default: {
                    BasicCompiler.throwIOChannelNumOutOfRange();
                    break;
                }
            }
        } else {
            BasicExprParser.parseExpr(this, characterIterator);
            this.asmOut.append("\tCALL\tIOCADR\n\tLD\t(IO_M_CADDR),HL\n");
            this.asmOut.append_LD_DE_nn(6);
            this.asmOut.append("\tADD\tHL,DE\n\tLD\tA,(HL)\n\tINC\tHL\n\tLD\tH,(HL)\n\tLD\tL,A\n");
            this.addLibItem(BasicLibrary.LibItem.IOCADR);
            this.addLibItem(BasicLibrary.LibItem.IOCTB1);
            this.addLibItem(BasicLibrary.LibItem.IOCTB2);
        }
    }

    private String parseDestLineExpr(CharacterIterator characterIterator) throws PrgException {
        BasicLineExpr basicLineExpr = BasicLineExpr.checkBasicLineExpr(characterIterator, this.curSource, this.curBasicLineNum);
        if (basicLineExpr == null) {
            BasicCompiler.throwBasicLineExprExpected();
        }
        this.destBasicLines.add(basicLineExpr);
        return BasicCompiler.createBasicLineLabel(basicLineExpr.getExprText());
    }

    private void parseInputLine(CharacterIterator characterIterator, boolean bl) throws PrgException {
        Object object;
        String string = BasicUtil.checkStringLiteral(this, characterIterator);
        if (string != null) {
            object = this.str2Label.get(string);
            if (object != null) {
                this.asmOut.append("\tLD\tHL,");
                this.asmOut.append((CharSequence)object);
                this.asmOut.append("\n\tCALL\tXOUTS\n");
                this.addLibItem(BasicLibrary.LibItem.XOUTS);
            } else {
                this.asmOut.append("\tCALL\tXOUTST\n");
                this.asmOut.appendStringLiteral(string);
                this.addLibItem(BasicLibrary.LibItem.XOUTST);
            }
            BasicUtil.parseToken(characterIterator, ';');
        }
        if ((object = this.checkVariable(characterIterator)) != null && ((SimpleVarInfo)object).getDataType() != DataType.STRING) {
            object = null;
        }
        if (object == null) {
            if (string != null) {
                BasicCompiler.throwStringVarExpected();
            }
            BasicCompiler.throwStringLitOrVarExpected();
        }
        ((SimpleVarInfo)object).ensureAddrInHL(this.asmOut);
        if (bl) {
            this.asmOut.append("\tCALL\tINPWV\n");
            this.addLibItem(BasicLibrary.LibItem.INPWV);
        } else {
            this.asmOut.append("\tCALL\tINRSV\n");
            this.addLibItem(BasicLibrary.LibItem.INRSV);
        }
    }

    private void parseInputLineIO(CharacterIterator characterIterator) throws PrgException {
        this.parseIOChannelNumToPtrFldAddrInHL(characterIterator, null);
        BasicUtil.parseToken(characterIterator, ',');
        this.asmOut.append("\tLD\tC,00H\n\tCALL\tIOINL\n");
        int n = this.asmOut.length();
        SimpleVarInfo simpleVarInfo = this.checkVariable(characterIterator);
        if (simpleVarInfo == null) {
            BasicCompiler.throwStringVarExpected();
        }
        if (simpleVarInfo.getDataType() != DataType.STRING) {
            BasicCompiler.throwStringVarExpected();
        }
        simpleVarInfo.ensureAddrInHL(this.asmOut);
        String string = this.asmOut.cut(n);
        String string2 = BasicUtil.convertCodeToValueInDE(string);
        if (string2 != null) {
            this.asmOut.append(string2);
        } else {
            this.asmOut.append("\tPUSH\tHL\n");
            this.asmOut.append(string);
            this.asmOut.append("\tEX\tDE,HL\n\tPOP\tHL\n");
        }
        this.asmOut.append("\tCALL\tASSIGN_STR_TO_NEW_MEM_VS\n");
        this.addLibItem(BasicLibrary.LibItem.IOINL);
        this.addLibItem(BasicLibrary.LibItem.ASSIGN_STR_TO_NEW_MEM_VS);
    }

    private void parseKeywordAS(CharacterIterator characterIterator) throws PrgException {
        if (!BasicUtil.checkKeyword(characterIterator, "AS")) {
            throw new PrgException("AS erwartet");
        }
    }

    private void parsePointTo_DE_HL(CharacterIterator characterIterator) throws PrgException {
        boolean bl = BasicUtil.checkToken(characterIterator, '(');
        BasicExprParser.parse2ArgsTo_DE_HL(this, characterIterator);
        if (bl) {
            BasicUtil.parseToken(characterIterator, ')');
        }
    }

    private void parsePointToMem(CharacterIterator characterIterator, String string, String string2) throws PrgException {
        boolean bl = BasicUtil.checkToken(characterIterator, '(');
        BasicExprParser.parseExpr(this, characterIterator);
        this.asmOut.append("\tLD\t(");
        this.asmOut.append(string);
        this.asmOut.append("),HL\n");
        BasicUtil.parseToken(characterIterator, ',');
        BasicExprParser.parseExpr(this, characterIterator);
        this.asmOut.append("\tLD\t(");
        this.asmOut.append(string2);
        this.asmOut.append("),HL\n");
        if (bl) {
            BasicUtil.parseToken(characterIterator, ')');
        }
    }

    private void parsePrint(CharacterIterator characterIterator, boolean bl) throws PrgException {
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        char c = BasicUtil.skipSpaces(characterIterator);
        while (!this.isEndOfInstr(characterIterator)) {
            this.tmpStrBufUsed = false;
            bl2 = true;
            bl3 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            while (true) {
                Object object;
                boolean bl7 = false;
                int n = characterIterator.getIndex();
                if (BasicUtil.checkKeyword(characterIterator, "CHR$")) {
                    if (BasicUtil.checkToken(characterIterator, '(')) {
                        int n2 = this.asmOut.length();
                        BasicExprParser.parseExpr(this, characterIterator);
                        object = BasicUtil.removeLastCodeIfConstExpr(this, n2);
                        if (object != null) {
                            this.asmOut.append_LD_A_n((Integer)object);
                        } else {
                            this.asmOut.append("\tLD\tA,L\n");
                        }
                        if (bl) {
                            this.asmOut.append("\tCALL\tXOUTCH\n");
                            this.addLibItem(BasicLibrary.LibItem.XOUTCH);
                        } else {
                            this.asmOut.append("\tCALL\tIO_COUT\n");
                            this.addLibItem(BasicLibrary.LibItem.IO_COUT);
                        }
                        BasicUtil.parseToken(characterIterator, ')');
                        bl5 = true;
                        bl7 = true;
                    }
                } else if (BasicUtil.checkKeyword(characterIterator, "SPC")) {
                    BasicExprParser.parseEnclosedExpr(this, characterIterator);
                    if (bl) {
                        this.asmOut.append("\tCALL\tPRINT_SPC\n");
                        this.addLibItem(BasicLibrary.LibItem.PRINT_SPC);
                    } else {
                        this.asmOut.append("\tCALL\tIO_PRINT_SPC\n");
                        this.addLibItem(BasicLibrary.LibItem.IO_PRINT_SPC);
                    }
                    bl5 = true;
                    bl7 = true;
                }
                if (!bl7) {
                    characterIterator.setIndex(n);
                    String string = BasicUtil.checkStringLiteral(this, characterIterator);
                    if (string != null) {
                        object = this.str2Label.get(string);
                        if (object != null) {
                            this.asmOut.append("\tLD\tHL,");
                            this.asmOut.append((CharSequence)object);
                            this.asmOut.newLine();
                            if (bl) {
                                this.asmOut.append("\tCALL\tXOUTS\n");
                                this.addLibItem(BasicLibrary.LibItem.XOUTS);
                            } else {
                                this.asmOut.append("\tCALL\tPS_S\n");
                                this.addLibItem(BasicLibrary.LibItem.PS_S);
                            }
                        } else {
                            if (bl) {
                                this.asmOut.append("\tCALL\tXOUTST\n");
                                this.addLibItem(BasicLibrary.LibItem.XOUTST);
                            } else {
                                this.asmOut.append("\tCALL\tPS_ST\n");
                                this.addLibItem(BasicLibrary.LibItem.PS_ST);
                            }
                            this.asmOut.appendStringLiteral(string);
                        }
                        bl5 = true;
                    } else if (BasicExprParser.checkParseStringPrimVarExpr(this, characterIterator)) {
                        if (bl) {
                            this.asmOut.append("\tCALL\tXOUTS\n");
                            this.addLibItem(BasicLibrary.LibItem.XOUTS);
                        } else {
                            this.asmOut.append("\tCALL\tPS_S\n");
                            this.addLibItem(BasicLibrary.LibItem.PS_S);
                        }
                        bl5 = true;
                    } else if (bl6) {
                        BasicUtil.throwStringExprExpected();
                    }
                }
                if (BasicUtil.skipSpaces(characterIterator) != '+') break;
                characterIterator.next();
                bl6 = true;
            }
            if (!bl5) {
                BasicExprParser.parseExpr(this, characterIterator);
                if (bl4) {
                    if (bl) {
                        this.asmOut.append("\tCALL\tP_IF\n");
                        this.addLibItem(BasicLibrary.LibItem.P_IF);
                    } else {
                        this.asmOut.append("\tCALL\tPS_IF\n");
                        this.addLibItem(BasicLibrary.LibItem.PS_IF);
                    }
                } else if (bl) {
                    this.asmOut.append("\tCALL\tP_I\n");
                    this.addLibItem(BasicLibrary.LibItem.P_I);
                } else {
                    this.asmOut.append("\tCALL\tPS_I\n");
                    this.addLibItem(BasicLibrary.LibItem.PS_I);
                }
                bl3 = true;
            }
            boolean bl8 = bl4 = (c = BasicUtil.skipSpaces(characterIterator)) == ',';
            if (c != ';' && c != ',') break;
            if (bl3) {
                if (bl) {
                    this.asmOut.append("\tCALL\tOUTSP\n");
                    this.addLibItem(BasicLibrary.LibItem.OUTSP);
                } else {
                    this.asmOut.append("\tCALL\tPS_SP\n");
                    this.addLibItem(BasicLibrary.LibItem.PS_SP);
                }
            }
            bl2 = false;
            characterIterator.next();
            c = BasicUtil.skipSpaces(characterIterator);
        }
        if (bl2) {
            if (bl) {
                this.asmOut.append("\tCALL\tXOUTNL\n");
                this.addLibItem(BasicLibrary.LibItem.XOUTNL);
            } else {
                this.asmOut.append("\tCALL\tPS_NL\n");
                this.addLibItem(BasicLibrary.LibItem.PS_NL);
            }
        }
    }

    private String parseStringLiteral(CharacterIterator characterIterator) throws PrgException {
        String string = BasicUtil.checkStringLiteral(this, characterIterator);
        if (string == null) {
            throw new PrgException("String-Literal erwartet");
        }
        return string;
    }

    private void popCodeCreationDisabled() {
        this.setCodeCreationDisabledLevel(this.codeCreationDisabledLevel - 1);
    }

    private void pushCodeCreationDisabled() {
        this.setCodeCreationDisabledLevel(this.codeCreationDisabledLevel + 1);
    }

    public void putWarning(String string) {
        this.appendLineNumMsgToErrLog(string, "Warnung");
    }

    public void putWarning(BasicSourcePos basicSourcePos, String string) {
        this.appendLineNumMsgToErrLog(basicSourcePos, string, "Warnung");
    }

    private void setCodeCreationDisabledLevel(int n) {
        this.codeCreationDisabledLevel = n > 0 ? n : 0;
        this.asmOut.setEnabled(this.codeCreationDisabledLevel == 0);
    }

    private static void throwBasicLineExprExpected() throws PrgException {
        throw new PrgException("BASIC-Zeilennummer oder Marke erwartet");
    }

    private static void throwDimTooSmall() throws PrgException {
        throw new PrgException("Dimension zu klein");
    }

    private static void throwDivisionByZero() throws PrgException {
        throw new PrgException("Division durch 0");
    }

    private static void throwIOChannelNumOutOfRange() throws PrgException {
        throw new PrgException("Kanalnummer au\u00dferhalb des g\u00fcltigen Bereichs");
    }

    private static void throwStringLitOrVarExpected() throws PrgException {
        throw new PrgException("String-Literal oder String-Variable erwartet");
    }

    private static void throwStringVarExpected() throws PrgException {
        throw new PrgException("String-Variable erwartet");
    }

    private static void throwVarExpected() throws PrgException {
        throw new PrgException("Variable erwartet");
    }

    private static void throwVarNameExpected() throws PrgException {
        throw new PrgException("Name einer Variable erwartet");
    }

    public static enum IODriver {
        CRT,
        LPT,
        FILE,
        VDIP,
        ALL;

    }

    public static enum DataType {
        INTEGER,
        STRING;

    }
}

