/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.text.CharacterIterator;
import jkcemu.programming.PrgException;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicFuncParser;
import jkcemu.programming.basic.BasicLibrary;
import jkcemu.programming.basic.BasicUtil;
import jkcemu.programming.basic.CallableEntry;
import jkcemu.programming.basic.FunctionEntry;
import jkcemu.programming.basic.SimpleVarInfo;

public class BasicExprParser {
    public static Integer checkIntConstant(BasicCompiler basicCompiler, String string) {
        Integer n = null;
        if (string != null) {
            boolean bl = true;
            int n2 = 0;
            if (string.equals("E_CHANNEL_ALREADY_OPEN")) {
                n2 = -11;
            } else if (string.equals("E_CHANNEL_CLOSED")) {
                n2 = -12;
            } else if (string.equals("E_DEVICE_LOCKED")) {
                n2 = -22;
            } else if (string.equals("E_DEVICE_NOT_FOUND")) {
                n2 = -21;
            } else if (string.equals("E_DISK_FULL")) {
                n2 = -32;
            } else if (string.equals("E_EOF")) {
                n2 = -29;
            } else if (string.equals("E_ERROR")) {
                n2 = -1;
            } else if (string.equals("E_FILE_NOT_FOUND")) {
                n2 = -25;
            } else if (string.equals("E_INVALID")) {
                n2 = -2;
            } else if (string.equals("E_IO_ERROR")) {
                n2 = -28;
            } else if (string.equals("E_IO_MODE")) {
                n2 = -27;
            } else if (string.equals("E_NO_DISK")) {
                n2 = -24;
            } else if (string.equals("E_OK")) {
                n2 = 0;
            } else if (string.equals("E_OVERFLOW")) {
                n2 = -3;
            } else if (string.equals("E_PATH_NOT_FOUND")) {
                n2 = -26;
            } else if (string.equals("E_READ_ONLY")) {
                n2 = -30;
            } else if (string.equals("FALSE")) {
                n2 = 0;
            } else if (string.equals("JOYST_BUTTONS")) {
                n2 = basicCompiler.getTarget().getNamedValue("JOYST_BUTTON1") | basicCompiler.getTarget().getNamedValue("JOYST_BUTTON2");
            } else if (string.equals("PEN_NONE")) {
                n2 = 0;
            } else if (string.equals("PEN_NORMAL")) {
                n2 = 1;
            } else if (string.equals("PEN_RUBBER")) {
                n2 = 2;
            } else if (string.equals("PEN_XOR")) {
                n2 = 3;
            } else if (string.equals("TRUE")) {
                n2 = 65535;
            } else if (basicCompiler.getTarget().isReservedWord(string)) {
                n2 = basicCompiler.getTarget().getNamedValue(string);
            } else {
                bl = false;
            }
            if (bl) {
                n = n2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer checkParseConstExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) {
        Integer n = null;
        int n2 = characterIterator.getIndex();
        try {
            int n3 = BasicExprParser.parseConstNotExpr(basicCompiler, characterIterator);
            while (true) {
                if (BasicUtil.checkKeyword(characterIterator, "AND")) {
                    n = n & BasicExprParser.parseConstNotExpr(basicCompiler, characterIterator);
                } else if (BasicUtil.checkKeyword(characterIterator, "OR")) {
                    n = n | BasicExprParser.parseConstNotExpr(basicCompiler, characterIterator);
                } else {
                    if (!BasicUtil.checkKeyword(characterIterator, "XOR")) break;
                    n = n ^ BasicExprParser.parseConstNotExpr(basicCompiler, characterIterator);
                }
                n3 &= 0xFFFF;
            }
            n = n3;
        }
        catch (PrgException prgException) {
            n = null;
        }
        finally {
            if (n == null) {
                characterIterator.setIndex(n2);
            }
        }
        return n;
    }

    public static boolean checkParseStringPrimExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        boolean bl = false;
        String string = BasicUtil.checkStringLiteral(basicCompiler, characterIterator);
        if (string != null) {
            AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
            asmCodeBuf.append("\tLD\tHL,");
            asmCodeBuf.append(basicCompiler.getStringLiteralLabel(string));
            asmCodeBuf.newLine();
            bl = true;
        } else {
            bl = BasicExprParser.checkParseStringPrimVarExpr(basicCompiler, characterIterator);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkParseStringPrimVarExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        boolean bl = false;
        int n = characterIterator.getIndex();
        String string = BasicUtil.checkIdentifier(characterIterator);
        if (string != null && !(bl = BasicFuncParser.checkParseStringFunction(basicCompiler, characterIterator, string)) && string.endsWith("$")) {
            CallableEntry callableEntry = basicCompiler.getCallableEntry(string);
            if (callableEntry != null) {
                if (!(callableEntry instanceof FunctionEntry)) throw new PrgException("Aufruf einer Prozedur an der Stelle nicht erlaubt");
                if (((FunctionEntry)callableEntry).getReturnType() != BasicCompiler.DataType.STRING) {
                    BasicUtil.throwStringExprExpected();
                }
                basicCompiler.parseCallableCall(characterIterator, callableEntry);
                return true;
            } else {
                BasicExprParser.parseVariableExpr(basicCompiler, characterIterator, string, BasicCompiler.DataType.STRING);
            }
            return true;
        }
        if (bl) return bl;
        characterIterator.setIndex(n);
        return bl;
    }

    public static void parse2ArgsTo_DE_HL(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        int n = asmCodeBuf.length();
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ',');
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(basicCompiler, n);
        if (n2 != null) {
            BasicExprParser.parseExpr(basicCompiler, characterIterator);
            asmCodeBuf.append_LD_DE_nn(n2);
        } else {
            String string = asmCodeBuf.cut(n);
            String string2 = BasicUtil.convertCodeToValueInDE(string);
            BasicExprParser.parseExpr(basicCompiler, characterIterator);
            String string3 = asmCodeBuf.cut(n);
            if (BasicUtil.isOnly_LD_HL_xx(string3)) {
                if (string2 != null) {
                    asmCodeBuf.append(string2);
                } else {
                    asmCodeBuf.append(string);
                    asmCodeBuf.append("\tEX\tDE,HL\n");
                }
                asmCodeBuf.append(string3);
            } else {
                asmCodeBuf.append(string);
                asmCodeBuf.append("\tPUSH\tHL\n");
                asmCodeBuf.append(string3);
                asmCodeBuf.append("\tPOP\tDE\n");
            }
        }
    }

    public static void parseEnclosedExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ')');
    }

    public static void parseExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        BasicExprParser.parseNotExpr(basicCompiler, characterIterator);
        while (true) {
            String string;
            String string2;
            int n;
            if (BasicUtil.checkKeyword(characterIterator, "AND")) {
                n = asmCodeBuf.length();
                BasicExprParser.parseNotExpr(basicCompiler, characterIterator);
                string2 = asmCodeBuf.cut(n);
                string = BasicUtil.convertCodeToValueInDE(string2);
                if (string != null) {
                    asmCodeBuf.append(string);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string2);
                    asmCodeBuf.append("\tPOP\tDE\n");
                }
                asmCodeBuf.append("\tCALL\tO_AND\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.O_AND);
                continue;
            }
            if (BasicUtil.checkKeyword(characterIterator, "OR")) {
                n = asmCodeBuf.length();
                BasicExprParser.parseNotExpr(basicCompiler, characterIterator);
                string2 = asmCodeBuf.cut(n);
                if (string2.equals("\tLD\tHL,0000H\n")) continue;
                string = BasicUtil.convertCodeToValueInDE(string2);
                if (string != null) {
                    asmCodeBuf.append(string);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string2);
                    asmCodeBuf.append("\tPOP\tDE\n");
                }
                asmCodeBuf.append("\tCALL\tO_OR\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.O_OR);
                continue;
            }
            if (!BasicUtil.checkKeyword(characterIterator, "XOR")) break;
            n = asmCodeBuf.length();
            BasicExprParser.parseNotExpr(basicCompiler, characterIterator);
            string2 = asmCodeBuf.cut(n);
            string = BasicUtil.convertCodeToValueInDE(string2);
            if (string != null) {
                asmCodeBuf.append(string);
            } else {
                asmCodeBuf.append("\tPUSH\tHL\n");
                asmCodeBuf.append(string2);
                asmCodeBuf.append("\tPOP\tDE\n");
            }
            asmCodeBuf.append("\tCALL\tO_XOR\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.O_XOR);
        }
    }

    public static void parseStringPrimExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        String string = BasicUtil.checkStringLiteral(basicCompiler, characterIterator);
        if (string != null) {
            AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
            String string2 = basicCompiler.getStringLiteralLabel(string);
            asmCodeBuf.append("\tLD\tHL,");
            asmCodeBuf.append(string2);
            asmCodeBuf.newLine();
        } else if (!BasicExprParser.checkParseStringPrimVarExpr(basicCompiler, characterIterator)) {
            BasicUtil.throwStringExprExpected();
        }
    }

    public static void parseVariableExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator, String string, BasicCompiler.DataType dataType) throws PrgException {
        SimpleVarInfo simpleVarInfo = basicCompiler.checkVariable(characterIterator, string);
        if (simpleVarInfo != null && simpleVarInfo.getDataType() != dataType) {
            simpleVarInfo = null;
        }
        if (simpleVarInfo == null) {
            if (dataType == BasicCompiler.DataType.STRING) {
                throw new PrgException("String-Variable oder String-Funktion erwartet");
            }
            throw new PrgException("Numerische Variable oder Funktion erwartet");
        }
        simpleVarInfo.ensureValueInHL(basicCompiler.getCodeBuf());
    }

    private static void check8BitChar(char c) throws PrgException {
        if (c == '\u0000' || c > '\u00ff') {
            throw new PrgException("Zeichen '" + c + "' au\u00dferhalb des 8-Bit-Wertebereiches");
        }
    }

    private static boolean checkAppend_LD_HL_Constant(BasicCompiler basicCompiler, String string) {
        boolean bl = false;
        if (string != null) {
            AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
            if (string.equals("TOP")) {
                bl = true;
                asmCodeBuf.append("\tLD\tHL,MTOP\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.MTOP);
            } else {
                Integer n = BasicExprParser.checkIntConstant(basicCompiler, string);
                if (n != null) {
                    asmCodeBuf.append_LD_HL_nn(n);
                    bl = true;
                }
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Integer checkIntLiteral(BasicCompiler basicCompiler, CharacterIterator characterIterator, boolean bl) throws PrgException {
        Integer n = null;
        char c = BasicUtil.skipSpaces(characterIterator);
        if (c >= '0' && c <= '9') {
            n = BasicUtil.readNumber(characterIterator);
            if (n != null) return n;
            BasicUtil.throwNumberExpected();
            return n;
        } else if (c == '&') {
            c = characterIterator.next();
            if (c == 'B' || c == 'b') {
                c = characterIterator.next();
                if (c != '0') {
                    if (c != '1') throw new PrgException("0 oder 1 erwartet");
                }
                int n2 = 0;
                while (true) {
                    if (c != '0') {
                        if (c != '1') return n2;
                    }
                    n2 <<= 1;
                    if (c == '1') {
                        n2 |= 1;
                    }
                    c = characterIterator.next();
                }
            }
            if (c != 'H') {
                if (c != 'h') throw new PrgException("B oder H erwartet");
            }
            characterIterator.next();
            n = BasicUtil.readHex(characterIterator);
            if (n != null) return n;
            BasicUtil.throwHexDigitExpected();
            return n;
        } else {
            if (c != '\'') return n;
            c = characterIterator.next();
            characterIterator.next();
            if (bl && basicCompiler.getBasicOptions().getWarnNonAsciiChars() && (c < ' ' || c > '\u007f')) {
                basicCompiler.putWarningNonAsciiChar(c);
            }
            BasicUtil.parseToken(characterIterator, '\'');
            BasicExprParser.check8BitChar(c);
            return c;
        }
    }

    private static int parseConstNotExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        int n = 0;
        n = BasicUtil.checkKeyword(characterIterator, "NOT") ? ~BasicExprParser.parseConstCondExpr(basicCompiler, characterIterator) & 0xFFFF : BasicExprParser.parseConstCondExpr(basicCompiler, characterIterator);
        return n;
    }

    private static int parseConstCondExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        int n = BasicExprParser.parseConstShiftExpr(basicCompiler, characterIterator);
        char c = BasicUtil.skipSpaces(characterIterator);
        if (c == '<') {
            c = characterIterator.next();
            if (c == '=') {
                characterIterator.next();
                n = n <= BasicExprParser.parseConstShiftExpr(basicCompiler, characterIterator) ? -1 : 0;
            } else if (c == '>') {
                characterIterator.next();
                n = n != BasicExprParser.parseConstShiftExpr(basicCompiler, characterIterator) ? -1 : 0;
            } else {
                n = n < BasicExprParser.parseConstShiftExpr(basicCompiler, characterIterator) ? -1 : 0;
            }
        } else if (c == '=') {
            characterIterator.next();
            n = n == BasicExprParser.parseConstShiftExpr(basicCompiler, characterIterator) ? -1 : 0;
        } else if (c == '>') {
            c = characterIterator.next();
            if (c == '=') {
                characterIterator.next();
                n = n >= BasicExprParser.parseConstShiftExpr(basicCompiler, characterIterator) ? -1 : 0;
            } else {
                n = n > BasicExprParser.parseConstShiftExpr(basicCompiler, characterIterator) ? -1 : 0;
            }
        }
        return n & 0xFFFF;
    }

    private static int parseConstShiftExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        String string;
        Integer n = BasicExprParser.checkIntLiteral(basicCompiler, characterIterator, false);
        if (n == null && (string = BasicUtil.checkIdentifier(characterIterator)) != null) {
            n = BasicExprParser.checkIntConstant(basicCompiler, string);
        }
        if (n == null) {
            BasicExprParser.throwNoConstExpr();
        }
        return n;
    }

    private static void parseNotExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        if (BasicUtil.checkKeyword(characterIterator, "NOT")) {
            BasicExprParser.parseCondExpr(basicCompiler, characterIterator);
            basicCompiler.getCodeBuf().append("\tCALL\tO_NOT\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.O_NOT);
        } else {
            BasicExprParser.parseCondExpr(basicCompiler, characterIterator);
        }
    }

    private static void parseCondExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        if (BasicExprParser.checkParseStringPrimExpr(basicCompiler, characterIterator)) {
            char c = BasicUtil.skipSpaces(characterIterator);
            if (c == '<') {
                c = characterIterator.next();
                if (c == '=') {
                    characterIterator.next();
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
                    asmCodeBuf.append("\tPOP\tDE\n\tCALL\tO_STLE\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.O_STLE);
                } else if (c == '>') {
                    characterIterator.next();
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
                    asmCodeBuf.append("\tPOP\tDE\n\tCALL\tO_STNE\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.O_STNE);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
                    asmCodeBuf.append("\tPOP\tDE\n\tCALL\tO_STLT\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.O_STLT);
                }
            } else if (c == '=') {
                characterIterator.next();
                asmCodeBuf.append("\tPUSH\tHL\n");
                BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
                asmCodeBuf.append("\tPOP\tDE\n\tCALL\tO_STEQ\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.O_STEQ);
            } else if (c == '>') {
                c = characterIterator.next();
                if (c == '=') {
                    characterIterator.next();
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
                    asmCodeBuf.append("\tPOP\tDE\n\tCALL\tO_STGE\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.O_STGE);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
                    asmCodeBuf.append("\tPOP\tDE\n\tCALL\tO_STGT\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.O_STGT);
                }
            } else {
                BasicExprParser.throwCondOpExpected();
            }
        } else {
            BasicExprParser.parseShiftExpr(basicCompiler, characterIterator);
            char c = BasicUtil.skipSpaces(characterIterator);
            if (c == '<') {
                c = characterIterator.next();
                if (c == '=') {
                    characterIterator.next();
                    int n = asmCodeBuf.length();
                    BasicExprParser.parseShiftExpr(basicCompiler, characterIterator);
                    String string = asmCodeBuf.cut(n);
                    String string2 = BasicUtil.convertCodeToValueInDE(string);
                    if (string2 != null) {
                        asmCodeBuf.append(string2);
                        asmCodeBuf.append("\tCALL\tO_LE\n");
                        basicCompiler.addLibItem(BasicLibrary.LibItem.O_LE);
                    } else {
                        asmCodeBuf.append("\tPUSH\tHL\n");
                        asmCodeBuf.append(string);
                        asmCodeBuf.append("\tPOP\tDE\n\tCALL\tO_GE\n");
                        basicCompiler.addLibItem(BasicLibrary.LibItem.O_GE);
                    }
                } else if (c == '>') {
                    characterIterator.next();
                    int n = asmCodeBuf.length();
                    BasicExprParser.parseShiftExpr(basicCompiler, characterIterator);
                    String string = asmCodeBuf.cut(n);
                    String string3 = BasicUtil.convertCodeToValueInDE(string);
                    if (string3 != null) {
                        asmCodeBuf.append(string3);
                    } else {
                        asmCodeBuf.append("\tPUSH\tHL\n");
                        asmCodeBuf.append(string);
                        asmCodeBuf.append("\tPOP\tDE\n");
                    }
                    asmCodeBuf.append("\tCALL\tO_NE\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.O_NE);
                } else {
                    int n = asmCodeBuf.length();
                    BasicExprParser.parseShiftExpr(basicCompiler, characterIterator);
                    String string = asmCodeBuf.cut(n);
                    String string4 = BasicUtil.convertCodeToValueInDE(string);
                    if (string4 != null) {
                        asmCodeBuf.append(string4);
                        asmCodeBuf.append("\tCALL\tO_LT\n");
                        basicCompiler.addLibItem(BasicLibrary.LibItem.O_LT);
                    } else {
                        asmCodeBuf.append("\tPUSH\tHL\n");
                        asmCodeBuf.append(string);
                        asmCodeBuf.append("\tPOP\tDE\n\tCALL\tO_GT\n");
                        basicCompiler.addLibItem(BasicLibrary.LibItem.O_GT);
                    }
                }
            } else if (c == '=') {
                characterIterator.next();
                int n = asmCodeBuf.length();
                BasicExprParser.parseShiftExpr(basicCompiler, characterIterator);
                String string = asmCodeBuf.cut(n);
                String string5 = BasicUtil.convertCodeToValueInDE(string);
                if (string5 != null) {
                    asmCodeBuf.append(string5);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string);
                    asmCodeBuf.append("\tPOP\tDE\n");
                }
                asmCodeBuf.append("\tCALL\tO_EQ\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.O_EQ);
            } else if (c == '>') {
                c = characterIterator.next();
                if (c == '=') {
                    characterIterator.next();
                    int n = asmCodeBuf.length();
                    BasicExprParser.parseShiftExpr(basicCompiler, characterIterator);
                    String string = asmCodeBuf.cut(n);
                    String string6 = BasicUtil.convertCodeToValueInDE(string);
                    if (string6 != null) {
                        asmCodeBuf.append(string6);
                        asmCodeBuf.append("\tCALL\tO_GE\n");
                        basicCompiler.addLibItem(BasicLibrary.LibItem.O_GE);
                    } else {
                        asmCodeBuf.append("\tPUSH\tHL\n");
                        asmCodeBuf.append(string);
                        asmCodeBuf.append("\tPOP\tDE\n\tCALL\tO_LE\n");
                        basicCompiler.addLibItem(BasicLibrary.LibItem.O_LE);
                    }
                } else {
                    int n = asmCodeBuf.length();
                    BasicExprParser.parseShiftExpr(basicCompiler, characterIterator);
                    String string = asmCodeBuf.cut(n);
                    String string7 = BasicUtil.convertCodeToValueInDE(string);
                    if (string7 != null) {
                        asmCodeBuf.append(string7);
                        asmCodeBuf.append("\tCALL\tO_GT\n");
                        basicCompiler.addLibItem(BasicLibrary.LibItem.O_GT);
                    } else {
                        asmCodeBuf.append("\tPUSH\tHL\n");
                        asmCodeBuf.append(string);
                        asmCodeBuf.append("\tPOP\tDE\n\tCALL\tO_LT\n");
                        basicCompiler.addLibItem(BasicLibrary.LibItem.O_LT);
                    }
                }
            }
        }
    }

    private static void parseShiftExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        BasicExprParser.parseAddExpr(basicCompiler, characterIterator);
        while (true) {
            String string;
            String string2;
            int n;
            if (BasicUtil.checkKeyword(characterIterator, "SHL")) {
                n = asmCodeBuf.length();
                BasicExprParser.parseAddExpr(basicCompiler, characterIterator);
                string2 = asmCodeBuf.cut(n);
                if (string2.equals("\tLD\tHL,0001H\n")) {
                    asmCodeBuf.append("\tSLA\tL\n\tRL\tH\n");
                    continue;
                }
                string = BasicUtil.convertCodeToValueInDE(string2);
                if (string != null) {
                    asmCodeBuf.append(string);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string2);
                    asmCodeBuf.append("\tEX\tDE,HL\n\tPOP\tHL\n");
                }
                asmCodeBuf.append("\tCALL\tO_SHL\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.O_SHL);
                continue;
            }
            if (!BasicUtil.checkKeyword(characterIterator, "SHR")) break;
            n = asmCodeBuf.length();
            BasicExprParser.parseAddExpr(basicCompiler, characterIterator);
            string2 = asmCodeBuf.cut(n);
            if (string2.equals("\tLD\tHL,0001H\n")) {
                asmCodeBuf.append("\tSRL\tH\n\tRR\tL\n");
                continue;
            }
            string = BasicUtil.convertCodeToValueInDE(string2);
            if (string != null) {
                asmCodeBuf.append(string);
            } else {
                asmCodeBuf.append("\tPUSH\tHL\n");
                asmCodeBuf.append(string2);
                asmCodeBuf.append("\tEX\tDE,HL\n\tPOP\tHL\n");
            }
            asmCodeBuf.append("\tCALL\tO_SHR\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.O_SHR);
        }
    }

    private static void parseAddExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        BasicExprParser.parseMulExpr(basicCompiler, characterIterator);
        while (true) {
            String string;
            String string2;
            int n;
            char c;
            if ((c = BasicUtil.skipSpaces(characterIterator)) == '+') {
                characterIterator.next();
                n = asmCodeBuf.length();
                BasicExprParser.parseMulExpr(basicCompiler, characterIterator);
                string2 = asmCodeBuf.cut(n);
                if (string2.equals("\tLD\tHL,0000H\n")) continue;
                if (string2.equals("\tLD\tHL,0001H\n")) {
                    asmCodeBuf.append("\tCALL\tO_INC\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.O_INC);
                    continue;
                }
                if (string2.equals("\tLD\tHL,0FFFFH\n")) {
                    asmCodeBuf.append("\tCALL\tO_DEC\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.O_DEC);
                    continue;
                }
                string = BasicUtil.convertCodeToValueInDE(string2);
                if (string != null) {
                    asmCodeBuf.append(string);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string2);
                    asmCodeBuf.append("\tPOP\tDE\n");
                }
                asmCodeBuf.append("\tCALL\tO_ADD\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.O_ADD);
                continue;
            }
            if (c == '-') {
                characterIterator.next();
                n = asmCodeBuf.length();
                BasicExprParser.parseMulExpr(basicCompiler, characterIterator);
                string2 = asmCodeBuf.cut(n);
                if (string2.equals("\tLD\tHL,0000H\n")) continue;
                if (string2.equals("\tLD\tHL,0001H\n")) {
                    asmCodeBuf.append("\tCALL\tO_DEC\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.O_DEC);
                    continue;
                }
                if (string2.equals("\tLD\tHL,0FFFFH\n")) {
                    asmCodeBuf.append("\tCALL\tO_INC\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.O_INC);
                    continue;
                }
                string = BasicUtil.convertCodeToValueInDE(string2);
                if (string != null) {
                    asmCodeBuf.append(string);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string2);
                    asmCodeBuf.append("\tPOP\tDE\n\tEX\tDE,HL\n");
                }
                asmCodeBuf.append("\tCALL\tO_SUB\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.O_SUB);
                continue;
            }
            if (BasicUtil.checkKeyword(characterIterator, "ADD")) {
                n = asmCodeBuf.length();
                BasicExprParser.parseMulExpr(basicCompiler, characterIterator);
                string2 = asmCodeBuf.cut(n);
                if (string2.equals("\tLD\tHL,0000H\n")) continue;
                if (string2.equals("\tLD\tHL,0001H\n")) {
                    asmCodeBuf.append("\tINC\tHL\n");
                    continue;
                }
                if (string2.equals("\tLD\tHL,0FFFFH\n")) {
                    asmCodeBuf.append("\tDEC\tHL\n");
                    continue;
                }
                string = BasicUtil.convertCodeToValueInDE(string2);
                if (string != null) {
                    asmCodeBuf.append(string);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string2);
                    asmCodeBuf.append("\tPOP\tDE\n");
                }
                asmCodeBuf.append("\tADD\tHL,DE\n");
                continue;
            }
            if (!BasicUtil.checkKeyword(characterIterator, "SUB")) break;
            n = asmCodeBuf.length();
            BasicExprParser.parseMulExpr(basicCompiler, characterIterator);
            string2 = asmCodeBuf.cut(n);
            if (string2.equals("\tLD\tHL,0000H\n")) continue;
            if (string2.equals("\tLD\tHL,0001H\n")) {
                asmCodeBuf.append("\tDEC\tHL\n");
                continue;
            }
            if (string2.equals("\tLD\tHL,0FFFFH\n")) {
                asmCodeBuf.append("\tINC\tHL\n");
                continue;
            }
            string = BasicUtil.convertCodeToValueInDE(string2);
            if (string != null) {
                asmCodeBuf.append(string);
            } else {
                asmCodeBuf.append("\tPUSH\tHL\n");
                asmCodeBuf.append(string2);
                asmCodeBuf.append("\tPOP\tDE\n\tEX\tDE,HL\n");
            }
            asmCodeBuf.append("\tOR\tA\n\tSBC\tHL,DE\n");
        }
    }

    private static void parseMulExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        BasicExprParser.parseUnaryExpr(basicCompiler, characterIterator);
        while (true) {
            String string;
            String string2;
            int n;
            char c;
            if ((c = BasicUtil.skipSpaces(characterIterator)) == '*') {
                characterIterator.next();
                n = asmCodeBuf.length();
                BasicExprParser.parseUnaryExpr(basicCompiler, characterIterator);
                string2 = asmCodeBuf.cut(n);
                string = BasicUtil.convertCodeToValueInDE(string2);
                if (string != null) {
                    asmCodeBuf.append(string);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string2);
                    asmCodeBuf.append("\tPOP\tDE\n");
                }
                asmCodeBuf.append("\tCALL\tO_MUL\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.O_MUL);
                continue;
            }
            if (c == '/') {
                characterIterator.next();
                n = asmCodeBuf.length();
                BasicExprParser.parseUnaryExpr(basicCompiler, characterIterator);
                string2 = asmCodeBuf.cut(n);
                string = BasicUtil.convertCodeToValueInDE(string2);
                if (string != null) {
                    asmCodeBuf.append(string);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string2);
                    asmCodeBuf.append("\tPOP\tDE\n\tEX\tDE,HL\n");
                }
                asmCodeBuf.append("\tCALL\tO_DIV\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.O_DIV);
                continue;
            }
            if (!BasicUtil.checkKeyword(characterIterator, "MOD")) break;
            n = asmCodeBuf.length();
            BasicExprParser.parseUnaryExpr(basicCompiler, characterIterator);
            string2 = asmCodeBuf.cut(n);
            string = BasicUtil.convertCodeToValueInDE(string2);
            if (string != null) {
                asmCodeBuf.append(string);
            } else {
                asmCodeBuf.append("\tPUSH\tHL\n");
                asmCodeBuf.append(string2);
                asmCodeBuf.append("\tPOP\tDE\n\tEX\tDE,HL\n");
            }
            asmCodeBuf.append("\tCALL\tO_MOD\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.O_MOD);
        }
    }

    private static void parseUnaryExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        char c = BasicUtil.skipSpaces(characterIterator);
        if (c == '-') {
            characterIterator.next();
            AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
            Integer n = BasicUtil.readNumber(characterIterator);
            if (n != null) {
                asmCodeBuf.append_LD_HL_nn(-n.intValue());
            } else {
                BasicExprParser.parsePrimExpr(basicCompiler, characterIterator);
                asmCodeBuf.append("\tCALL\tNEGHL\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.ABS_NEG_HL);
            }
        } else {
            if (c == '+') {
                characterIterator.next();
            }
            BasicExprParser.parsePrimExpr(basicCompiler, characterIterator);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parsePrimExpr(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        char c = BasicUtil.skipSpaces(characterIterator);
        if (c == '(') {
            characterIterator.next();
            BasicExprParser.parseExpr(basicCompiler, characterIterator);
            BasicUtil.parseToken(characterIterator, ')');
            return;
        } else {
            Integer n = BasicExprParser.checkIntLiteral(basicCompiler, characterIterator, true);
            if (n != null) {
                asmCodeBuf.append_LD_HL_nn(n);
                return;
            } else {
                String string = BasicUtil.checkIdentifier(characterIterator);
                if (string != null) {
                    if (BasicExprParser.checkAppend_LD_HL_Constant(basicCompiler, string)) return;
                    AbstractTarget abstractTarget = basicCompiler.getTarget();
                    if (string.equals("ERR")) {
                        asmCodeBuf.append("\tLD\tHL,(M_ERN)\n");
                        basicCompiler.addLibItem(BasicLibrary.LibItem.M_ERN);
                        return;
                    } else if (string.equals("H_CHAR")) {
                        abstractTarget.appendHCharTo(asmCodeBuf);
                        return;
                    } else if (string.equals("H_PIXEL")) {
                        abstractTarget.appendHPixelTo(asmCodeBuf);
                        return;
                    } else if (string.equals("W_CHAR")) {
                        abstractTarget.appendWCharTo(asmCodeBuf);
                        return;
                    } else if (string.equals("W_PIXEL")) {
                        abstractTarget.appendWPixelTo(asmCodeBuf);
                        return;
                    } else if (string.equals("XPOS")) {
                        asmCodeBuf.append("\tLD\tHL,(M_XPOS)\n");
                        basicCompiler.addLibItem(BasicLibrary.LibItem.M_XYPO);
                        return;
                    } else if (string.equals("YPOS")) {
                        asmCodeBuf.append("\tLD\tHL,(M_YPOS)\n");
                        basicCompiler.addLibItem(BasicLibrary.LibItem.M_XYPO);
                        return;
                    } else {
                        if (BasicFuncParser.checkParseIntFunction(basicCompiler, characterIterator, string)) return;
                        CallableEntry callableEntry = basicCompiler.getCallableEntry(string);
                        if (callableEntry != null) {
                            if (!(callableEntry instanceof FunctionEntry)) throw new PrgException("Aufruf einer Prozedur an der Stelle nicht erlaubt");
                            if (((FunctionEntry)callableEntry).getReturnType() != BasicCompiler.DataType.INTEGER) {
                                BasicExprParser.throwIntExprExpected();
                            }
                            basicCompiler.parseCallableCall(characterIterator, callableEntry);
                            return;
                        } else {
                            if (string.endsWith("$")) {
                                BasicExprParser.throwIntExprExpected();
                            }
                            BasicExprParser.parseVariableExpr(basicCompiler, characterIterator, string, BasicCompiler.DataType.INTEGER);
                        }
                    }
                    return;
                } else {
                    BasicUtil.throwUnexpectedChar(BasicUtil.skipSpaces(characterIterator));
                }
            }
        }
    }

    private static void throwCondOpExpected() throws PrgException {
        throw new PrgException("Vergleichsoperator erwartet");
    }

    private static void throwIntExprExpected() throws PrgException {
        throw new PrgException("Integer-Ausdruck erwartet");
    }

    private static void throwNoConstExpr() throws PrgException {
        throw new PrgException("Kein konstanter Ausdruck");
    }
}

