/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.text.CharacterIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import jkcemu.programming.PrgException;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicExprParser;
import jkcemu.programming.basic.BasicLibrary;
import jkcemu.programming.basic.BasicUtil;

public class BasicFuncParser {
    public static boolean checkParseIntFunction(BasicCompiler basicCompiler, CharacterIterator characterIterator, String string) throws PrgException {
        boolean bl = false;
        if (string != null) {
            bl = true;
            if (string.equals("ABS")) {
                BasicFuncParser.parseABS(basicCompiler, characterIterator);
            } else if (string.equals("ASC")) {
                BasicFuncParser.parseASC(basicCompiler, characterIterator);
            } else if (string.equals("ASM")) {
                basicCompiler.parseASM(characterIterator, true);
            } else if (string.equals("DEEK")) {
                BasicFuncParser.parseDEEK(basicCompiler, characterIterator);
            } else if (string.equals("EOF")) {
                BasicFuncParser.parseEOF(basicCompiler, characterIterator);
            } else if (string.equals("HIBYTE")) {
                BasicFuncParser.parseHIBYTE(basicCompiler, characterIterator);
            } else if (string.equals("IN") || string.equals("INP")) {
                BasicFuncParser.parseIN(basicCompiler, characterIterator);
            } else if (string.equals("INSTR")) {
                BasicFuncParser.parseINSTR(basicCompiler, characterIterator);
            } else if (string.equals("IS_TARGET")) {
                BasicFuncParser.parseIS_TARGET(basicCompiler, characterIterator);
            } else if (string.equals("JOYST")) {
                BasicFuncParser.parseJOYST(basicCompiler, characterIterator);
            } else if (string.equals("LEN")) {
                BasicFuncParser.parseLEN(basicCompiler, characterIterator);
            } else if (string.equals("LOBYTE")) {
                BasicFuncParser.parseLOBYTE(basicCompiler, characterIterator);
            } else if (string.equals("MAX")) {
                BasicFuncParser.parseMAX(basicCompiler, characterIterator);
            } else if (string.equals("MIN")) {
                BasicFuncParser.parseMIN(basicCompiler, characterIterator);
            } else if (string.equals("PEEK")) {
                BasicFuncParser.parsePEEK(basicCompiler, characterIterator);
            } else if (string.equals("POINT")) {
                BasicFuncParser.parsePOINT(basicCompiler, characterIterator);
            } else if (string.equals("PTEST")) {
                BasicFuncParser.parsePTEST(basicCompiler, characterIterator);
            } else if (string.equals("RND")) {
                BasicFuncParser.parseRND(basicCompiler, characterIterator);
            } else if (string.equals("SGN")) {
                BasicFuncParser.parseSGN(basicCompiler, characterIterator);
            } else if (string.equals("SQR")) {
                BasicFuncParser.parseSQR(basicCompiler, characterIterator);
            } else if (string.equals("USR")) {
                BasicFuncParser.parseUSR(basicCompiler, characterIterator);
            } else if (string.equals("USR0")) {
                BasicFuncParser.parseUSR(basicCompiler, characterIterator, 0);
            } else if (string.equals("USR1")) {
                BasicFuncParser.parseUSR(basicCompiler, characterIterator, 1);
            } else if (string.equals("USR2")) {
                BasicFuncParser.parseUSR(basicCompiler, characterIterator, 2);
            } else if (string.equals("USR3")) {
                BasicFuncParser.parseUSR(basicCompiler, characterIterator, 3);
            } else if (string.equals("USR4")) {
                BasicFuncParser.parseUSR(basicCompiler, characterIterator, 4);
            } else if (string.equals("USR5")) {
                BasicFuncParser.parseUSR(basicCompiler, characterIterator, 5);
            } else if (string.equals("USR6")) {
                BasicFuncParser.parseUSR(basicCompiler, characterIterator, 6);
            } else if (string.equals("USR7")) {
                BasicFuncParser.parseUSR(basicCompiler, characterIterator, 7);
            } else if (string.equals("USR8")) {
                BasicFuncParser.parseUSR(basicCompiler, characterIterator, 8);
            } else if (string.equals("USR9")) {
                BasicFuncParser.parseUSR(basicCompiler, characterIterator, 9);
            } else if (string.equals("VAL")) {
                BasicFuncParser.parseVAL(basicCompiler, characterIterator);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean checkParseStringFunction(BasicCompiler basicCompiler, CharacterIterator characterIterator, String string) throws PrgException {
        boolean bl = false;
        if (string != null) {
            bl = true;
            if (string.equals("BIN$")) {
                BasicFuncParser.parseStrBIN(basicCompiler, characterIterator);
            } else if (string.equals("CHR$")) {
                BasicFuncParser.parseStrCHR(basicCompiler, characterIterator);
            } else if (string.equals("ERR$")) {
                BasicFuncParser.parseStrERR(basicCompiler, characterIterator);
            } else if (string.equals("HEX$")) {
                BasicFuncParser.parseStrHEX(basicCompiler, characterIterator);
            } else if (string.equals("INKEY$")) {
                BasicFuncParser.parseStrINKEY(basicCompiler, characterIterator);
            } else if (string.equals("INPUT$")) {
                BasicFuncParser.parseStrINPUT(basicCompiler, characterIterator);
            } else if (string.equals("LEFT$")) {
                BasicFuncParser.parseStrLEFT(basicCompiler, characterIterator);
            } else if (string.equals("LOWER$") || string.equals("LCASE$")) {
                BasicFuncParser.parseStrLOWER(basicCompiler, characterIterator);
            } else if (string.equals("LTRIM$")) {
                BasicFuncParser.parseStrLTRIM(basicCompiler, characterIterator);
            } else if (string.equals("MEMSTR$")) {
                BasicFuncParser.parseStrMEMSTR(basicCompiler, characterIterator);
            } else if (string.equals("MID$")) {
                BasicFuncParser.parseStrMID(basicCompiler, characterIterator);
            } else if (string.equals("MIRROR$")) {
                BasicFuncParser.parseStrMIRROR(basicCompiler, characterIterator);
            } else if (string.equals("RIGHT$")) {
                BasicFuncParser.parseStrRIGHT(basicCompiler, characterIterator);
            } else if (string.equals("RTRIM$")) {
                BasicFuncParser.parseStrRTRIM(basicCompiler, characterIterator);
            } else if (string.equals("SPACE$")) {
                BasicFuncParser.parseStrSPACE(basicCompiler, characterIterator);
            } else if (string.equals("STR$")) {
                BasicFuncParser.parseStrSTR(basicCompiler, characterIterator);
            } else if (string.equals("STRING$")) {
                BasicFuncParser.parseStrSTRING(basicCompiler, characterIterator);
            } else if (string.equals("TRIM$")) {
                BasicFuncParser.parseStrTRIM(basicCompiler, characterIterator);
            } else if (string.equals("UPPER$") || string.equals("UCASE$")) {
                BasicFuncParser.parseStrUPPER(basicCompiler, characterIterator);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private static void parseABS(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        basicCompiler.getCodeBuf().append("\tCALL\tABSHL\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.ABS_NEG_HL);
    }

    private static void parseASC(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.getCodeBuf().append("\tLD\tL,(HL)\n\tLD\tH,00H\n");
    }

    private static void parseDEEK(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        int n = asmCodeBuf.length();
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(basicCompiler, n);
        if (n2 != null) {
            asmCodeBuf.append("\tLD\tHL,(");
            asmCodeBuf.appendHex4(n2);
            asmCodeBuf.append(")\n");
        } else {
            asmCodeBuf.append("\tLD\tA,(HL)\n\tINC\tHL\n\tLD\tH,(HL)\n\tLD\tL,A\n");
        }
    }

    private static void parseEOF(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicUtil.parseToken(characterIterator, '(');
        BasicUtil.checkToken(characterIterator, '#');
        basicCompiler.parseIOChannelNumToPtrFldAddrInHL(characterIterator, null);
        basicCompiler.getCodeBuf().append("\tCALL\tIOEOF\n");
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.addLibItem(BasicLibrary.LibItem.IOEOF);
    }

    private static void parseHIBYTE(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        basicCompiler.getCodeBuf().append("\tLD\tL,H\n\tLD\tH,00H\n");
    }

    private static void parseIN(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ')');
        if (!BasicUtil.replaceLastCodeFrom_LD_HL_To_BC(basicCompiler)) {
            asmCodeBuf.append("\tLD\tB,H\n\tLD\tC,L\n");
        }
        asmCodeBuf.append("\tIN\tL,(C)\n\tLD\tH,0\n");
    }

    private static void parseINSTR(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        boolean bl = false;
        Integer n = null;
        String string = null;
        BasicUtil.parseToken(characterIterator, '(');
        String string2 = BasicUtil.checkStringLiteral(basicCompiler, characterIterator);
        if (string2 == null) {
            boolean bl2 = bl = !BasicExprParser.checkParseStringPrimExpr(basicCompiler, characterIterator);
        }
        if (bl) {
            int n2 = asmCodeBuf.length();
            BasicExprParser.parseExpr(basicCompiler, characterIterator);
            n = BasicUtil.removeLastCodeIfConstExpr(basicCompiler, n2);
            if (n != null) {
                if (n <= 0) {
                    BasicUtil.throwIndexOutOfRange();
                }
            } else {
                String string3 = asmCodeBuf.cut(n2);
                string = BasicUtil.convertCodeToValueInBC(string3);
                if (string == null) {
                    asmCodeBuf.append(string3);
                    asmCodeBuf.append("\tPUSH\tHL\n");
                }
            }
            BasicUtil.parseToken(characterIterator, ',');
            string2 = BasicUtil.checkStringLiteral(basicCompiler, characterIterator);
            if (string2 == null) {
                BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
            }
        }
        BasicUtil.parseToken(characterIterator, ',');
        String string4 = BasicUtil.checkStringLiteral(basicCompiler, characterIterator);
        if (string4 != null) {
            if (string2 != null) {
                asmCodeBuf.append("\tLD\tHL,");
                asmCodeBuf.append(basicCompiler.getStringLiteralLabel(string2));
                asmCodeBuf.newLine();
            }
            asmCodeBuf.append("\tLD\tDE,");
            asmCodeBuf.append(basicCompiler.getStringLiteralLabel(string4));
            asmCodeBuf.newLine();
        } else {
            if (string2 == null) {
                asmCodeBuf.append("\tPUSH\tHL\n");
            }
            BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
            asmCodeBuf.append("\tEX\tDE,HL\n");
            if (string2 != null) {
                asmCodeBuf.append("\tLD\tHL,");
                asmCodeBuf.append(basicCompiler.getStringLiteralLabel(string2));
                asmCodeBuf.newLine();
            } else {
                asmCodeBuf.append("\tPOP\tHL\n");
            }
        }
        if (bl) {
            if (n != null) {
                asmCodeBuf.append_LD_BC_nn(n);
            } else if (string != null) {
                asmCodeBuf.append(string);
            } else {
                asmCodeBuf.append("\tPOP\tBC\n");
            }
            asmCodeBuf.append("\tCALL\tF_INSTRN\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.F_INSTRN);
        } else {
            asmCodeBuf.append("\tCALL\tF_INSTR\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.F_INSTR);
        }
        BasicUtil.parseToken(characterIterator, ')');
    }

    private static void parseIS_TARGET(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        int[] nArray = basicCompiler.getTarget().getTargetIDs();
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        int n = asmCodeBuf.length();
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(basicCompiler, n);
        if (n2 != null) {
            int n3 = 0;
            if (nArray != null) {
                for (int n4 : nArray) {
                    if (n4 != n2) continue;
                    n3 = -1;
                    break;
                }
            }
            asmCodeBuf.append_LD_HL_nn(n3);
        } else if (nArray.length == 1) {
            asmCodeBuf.append_LD_DE_nn(nArray[0]);
            asmCodeBuf.append("\tCALL\tO_EQ \n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.O_EQ);
        } else if (nArray.length > 1) {
            asmCodeBuf.append("\tCALL\tF_IS_TARGET\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.F_IS_TARGET);
        }
    }

    private static void parseJOYST(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        basicCompiler.getCodeBuf().append("\tCALL\tF_JOY\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.F_JOY);
    }

    private static void parseLEN(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        BasicUtil.parseToken(characterIterator, '(');
        String string = BasicUtil.checkStringLiteral(basicCompiler, characterIterator);
        if (string != null) {
            asmCodeBuf.append_LD_HL_nn(string.length());
        } else {
            BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
            asmCodeBuf.append("\tCALL\tF_LEN\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.F_LEN);
        }
        BasicUtil.parseToken(characterIterator, ')');
    }

    private static void parseLOBYTE(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        basicCompiler.getCodeBuf().append("\tLD\tH,00H\n");
    }

    private static void parseMAX(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        while (BasicUtil.checkToken(characterIterator, ',')) {
            asmCodeBuf.append("\tPUSH\tHL\n");
            BasicExprParser.parseExpr(basicCompiler, characterIterator);
            String string = basicCompiler.nextLabel();
            asmCodeBuf.append("\tPOP\tDE\n\tCALL\tCPHLDE\n\tJR\tNC,");
            asmCodeBuf.append(string);
            asmCodeBuf.append("\n\tEX\tDE,HL\n");
            asmCodeBuf.append(string);
            asmCodeBuf.append(":\n");
        }
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.addLibItem(BasicLibrary.LibItem.CPHLDE);
    }

    private static void parseMIN(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        while (BasicUtil.checkToken(characterIterator, ',')) {
            asmCodeBuf.append("\tPUSH\tHL\n");
            BasicExprParser.parseExpr(basicCompiler, characterIterator);
            String string = basicCompiler.nextLabel();
            asmCodeBuf.append("\tPOP\tDE\n\tCALL\tCPHLDE\n\tJR\tC,");
            asmCodeBuf.append(string);
            asmCodeBuf.append("\n\tEX\tDE,HL\n");
            asmCodeBuf.append(string);
            asmCodeBuf.append(":\n");
        }
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.addLibItem(BasicLibrary.LibItem.CPHLDE);
    }

    private static void parsePEEK(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        basicCompiler.getCodeBuf().append("\tLD\tL,(HL)\n\tLD\tH,0\n");
    }

    private static void parseRND(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        basicCompiler.getCodeBuf().append("\tCALL\tF_RND\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.F_RND);
    }

    private static void parsePOINT(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parse2ArgsTo_DE_HL(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.getCodeBuf().append("\tCALL\tXPOINT\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.XPOINT);
    }

    private static void parsePTEST(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parse2ArgsTo_DE_HL(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.getCodeBuf().append("\tCALL\tXPTEST\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.XPTEST);
    }

    private static void parseSGN(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        basicCompiler.getCodeBuf().append("\tCALL\tF_SGN\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.F_SGN);
    }

    private static void parseSQR(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        int n = asmCodeBuf.length();
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(basicCompiler, n);
        if (n2 != null) {
            if (n2 < 0) {
                throw new PrgException("Wurzel aus negativer Zahl nicht m\u00f6glich");
            }
            asmCodeBuf.append_LD_HL_nn((int)Math.floor(Math.sqrt(n2.doubleValue())));
        } else {
            asmCodeBuf.append("\tCALL\tF_SQR\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.F_SQR);
        }
    }

    private static void parseUSR(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        int n = BasicUtil.parseUsrNum(characterIterator);
        BasicFuncParser.parseUSR(basicCompiler, characterIterator, n);
    }

    private static void parseUSR(BasicCompiler basicCompiler, CharacterIterator characterIterator, int n) throws PrgException {
        boolean bl;
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        if (!BasicUtil.replaceLastCodeFrom_LD_HL_To_DE(basicCompiler)) {
            asmCodeBuf.append("\tEX\tDE,HL\n");
        }
        boolean bl2 = bl = basicCompiler.getEnclosingCallableEntry() != null;
        if (bl) {
            asmCodeBuf.append("\tPUSH\tIY\n");
        }
        asmCodeBuf.append("\tLD\tHL,(");
        asmCodeBuf.append(basicCompiler.getUsrLabel(n));
        asmCodeBuf.append(")\n\tCALL\tJP_HL\n");
        if (bl) {
            asmCodeBuf.append("\tPOP\tIY\n");
        }
        basicCompiler.addLibItem(BasicLibrary.LibItem.JP_HL);
        basicCompiler.addLibItem(BasicLibrary.LibItem.E_USR);
    }

    private static void parseVAL(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        block9: {
            AsmCodeBuf asmCodeBuf;
            block7: {
                int n;
                block8: {
                    asmCodeBuf = basicCompiler.getCodeBuf();
                    BasicUtil.parseToken(characterIterator, '(');
                    BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
                    if (!BasicUtil.checkToken(characterIterator, ',')) break block7;
                    n = asmCodeBuf.length();
                    BasicExprParser.parseExpr(basicCompiler, characterIterator);
                    Integer n2 = BasicUtil.removeLastCodeIfConstExpr(basicCompiler, n);
                    if (n2 == null) break block8;
                    switch (n2) {
                        case 2: {
                            asmCodeBuf.append("\tCALL\tF_VLB\n");
                            basicCompiler.addLibItem(BasicLibrary.LibItem.F_VLB);
                            break block9;
                        }
                        case 10: {
                            asmCodeBuf.append("\tCALL\tF_VLI\n");
                            basicCompiler.addLibItem(BasicLibrary.LibItem.F_VLI);
                            break block9;
                        }
                        case 16: {
                            asmCodeBuf.append("\tCALL\tF_VLH\n");
                            basicCompiler.addLibItem(BasicLibrary.LibItem.F_VLH);
                            break block9;
                        }
                        default: {
                            throw new PrgException("Zahlenbasis in VAL-Funktion nicht unterst\u00fctzt");
                        }
                    }
                }
                String string = asmCodeBuf.cut(n);
                String string2 = BasicUtil.convertCodeToValueInDE(string);
                if (string2 != null) {
                    asmCodeBuf.append(string2);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string);
                    asmCodeBuf.append("\tEX\tDE,HL\n\tPOP\tHL\n");
                }
                asmCodeBuf.append("\tCALL\tF_VAL\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.F_VAL);
                break block9;
            }
            asmCodeBuf.append("\tCALL\tF_VLI\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.F_VLI);
        }
        BasicUtil.parseToken(characterIterator, ')');
    }

    private static void parseStrBIN(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        basicCompiler.lockTmpStrBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        if (BasicUtil.checkToken(characterIterator, ',')) {
            int n = asmCodeBuf.length();
            BasicExprParser.parseExpr(basicCompiler, characterIterator);
            Integer n2 = BasicUtil.removeLastCodeIfConstExpr(basicCompiler, n);
            if (n2 != null) {
                if (n2 < 0) {
                    basicCompiler.putWarningOutOfRange();
                }
                asmCodeBuf.append_LD_BC_nn(n2);
            } else {
                String string = asmCodeBuf.cut(n);
                String string2 = BasicUtil.convertCodeToValueInBC(string);
                if (string2 != null) {
                    asmCodeBuf.append(string2);
                } else {
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string);
                    asmCodeBuf.append("\tLD\tB,H\n\tLD\tC,L\n\tPOP\tHL\n");
                }
            }
            asmCodeBuf.append("\tCALL\tS_BINN\n");
        } else {
            asmCodeBuf.append("\tCALL\tS_BIN\n");
        }
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_BIN);
    }

    private static void parseStrCHR(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        basicCompiler.lockTmpStrBuf();
        int n = asmCodeBuf.length();
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(basicCompiler, n);
        if (n2 != null) {
            asmCodeBuf.append_LD_A_n(n2);
            asmCodeBuf.append("\tCALL\tS_CHRA\n");
        } else {
            asmCodeBuf.append("\tCALL\tS_CHRL\n");
        }
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_CHR);
    }

    private static void parseStrERR(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        basicCompiler.getCodeBuf().append("\tLD\tHL,(M_ERT)\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.M_ERT);
    }

    private static void parseStrHEX(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        basicCompiler.lockTmpStrBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        if (BasicUtil.checkToken(characterIterator, ',')) {
            int n = asmCodeBuf.length();
            BasicExprParser.parseExpr(basicCompiler, characterIterator);
            String string = asmCodeBuf.cut(n);
            String string2 = BasicUtil.convertCodeToValueInBC(string);
            if (string2 != null) {
                asmCodeBuf.append(string2);
            } else {
                asmCodeBuf.append("\tPUSH\tHL\n");
                asmCodeBuf.append(string);
                asmCodeBuf.append("\tLD\tB,H\n\tLD\tC,L\n\tPOP\tHL\n");
            }
            asmCodeBuf.append("\tCALL\tS_HEXN\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.S_HEXN);
        } else {
            asmCodeBuf.append("\tCALL\tS_HEX\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.S_HEX);
        }
        BasicUtil.parseToken(characterIterator, ')');
    }

    private static void parseStrINKEY(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        basicCompiler.getCodeBuf().append("\tCALL\tS_INKY\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_INKY);
    }

    private static void parseStrINPUT(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        basicCompiler.lockTmpStrBuf();
        BasicUtil.parseToken(characterIterator, '(');
        int n = asmCodeBuf.length();
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        if (BasicUtil.checkToken(characterIterator, ',')) {
            String string = asmCodeBuf.cut(n);
            String string2 = BasicUtil.convertCodeToValueInBC(string);
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            BasicUtil.checkToken(characterIterator, '#');
            basicCompiler.parseIOChannelNumToPtrFldAddrInHL(characterIterator, atomicBoolean);
            if (string2 != null) {
                asmCodeBuf.append(string2);
            } else {
                String string3 = asmCodeBuf.cut(n);
                if (atomicBoolean.get()) {
                    asmCodeBuf.append(string);
                    asmCodeBuf.append("\tLD\tB,H\n\tLD\tC,L\n");
                    asmCodeBuf.append(string3);
                } else {
                    asmCodeBuf.append(string);
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string3);
                    asmCodeBuf.append("\tPOP\tBC\n");
                }
            }
            asmCodeBuf.append("\tCALL\tIOINX\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.IOINX);
        } else {
            Integer n2 = BasicUtil.removeLastCodeIfConstExpr(basicCompiler, n);
            if (n2 != null) {
                if (n2 == 1) {
                    asmCodeBuf.append("\tCALL\tS_INCH\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.S_INCH);
                } else {
                    asmCodeBuf.append("\tCALL\tS_INP\n");
                    basicCompiler.addLibItem(BasicLibrary.LibItem.S_INP);
                }
            } else {
                asmCodeBuf.append("\tCALL\tS_INP\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.S_INP);
            }
        }
        BasicUtil.parseToken(characterIterator, ')');
    }

    private static void parseStrLEFT(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        basicCompiler.lockTmpStrBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ',');
        int n = asmCodeBuf.length();
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        String string = asmCodeBuf.cut(n);
        String string2 = BasicUtil.convertCodeToValueInBC(string);
        if (string2 != null) {
            asmCodeBuf.append(string2);
        } else {
            asmCodeBuf.append("\tPUSH\tHL\n");
            asmCodeBuf.append(string);
            asmCodeBuf.append("\tLD\tB,H\n\tLD\tC,L\n\tPOP\tHL\n");
        }
        asmCodeBuf.append("\tCALL\tS_LEFT\n");
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_LEFT);
    }

    private static void parseStrLOWER(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        basicCompiler.lockTmpStrBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.getCodeBuf().append("\tCALL\tS_LWR\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_LWR);
    }

    private static void parseStrLTRIM(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
        basicCompiler.getCodeBuf().append("\tCALL\tS_LTRIM\n");
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_LTRIM);
    }

    private static void parseStrMEMSTR(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
    }

    private static void parseStrMIRROR(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        BasicUtil.parseToken(characterIterator, '(');
        String string = BasicUtil.checkStringLiteral(basicCompiler, characterIterator);
        if (string != null) {
            if (string.isEmpty()) {
                asmCodeBuf.append_LD_HL_xx("D_EMPT");
                basicCompiler.addLibItem(BasicLibrary.LibItem.EMPTY_STRING);
            } else {
                asmCodeBuf.appendStringLiteral(new StringBuilder(string).reverse().toString(), "00H");
            }
        } else {
            basicCompiler.lockTmpStrBuf();
            BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
            asmCodeBuf.append("\tCALL\tS_MIRR\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.S_MIRR);
        }
        BasicUtil.parseToken(characterIterator, ')');
    }

    private static void parseStrMID(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        basicCompiler.lockTmpStrBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ',');
        int n = asmCodeBuf.length();
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        String string = asmCodeBuf.cut(n);
        String string2 = BasicUtil.convertCodeToValueInDE(string);
        if (BasicUtil.checkToken(characterIterator, ',')) {
            BasicExprParser.parseExpr(basicCompiler, characterIterator);
            String string3 = asmCodeBuf.cut(n);
            String string4 = BasicUtil.convertCodeToValueInBC(string3);
            if (string2 != null && string4 != null) {
                asmCodeBuf.append(string2);
                asmCodeBuf.append(string4);
            } else {
                asmCodeBuf.append("\tPUSH\tHL\n");
                if (string2 != null) {
                    asmCodeBuf.append(string3);
                    asmCodeBuf.append("\tLD\tB,H\n\tLD\tC,L\n");
                    asmCodeBuf.append(string2);
                } else if (string4 != null) {
                    asmCodeBuf.append(string);
                    asmCodeBuf.append("\tEX\tDE,HL\n");
                    asmCodeBuf.append(string4);
                } else {
                    asmCodeBuf.append(string);
                    asmCodeBuf.append("\tPUSH\tHL\n");
                    asmCodeBuf.append(string3);
                    asmCodeBuf.append("\tLD\tB,H\n\tLD\tC,L\n\tPOP\tDE\n");
                }
                asmCodeBuf.append("\tPOP\tHL\n");
            }
            asmCodeBuf.append("\tCALL\tS_MIDN\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.S_MIDN);
        } else {
            if (string2 != null) {
                asmCodeBuf.append(string2);
            } else {
                asmCodeBuf.append("\tPUSH\tHL\n");
                asmCodeBuf.append(string);
                asmCodeBuf.append("\tEX\tDE,HL\n\tPOP\tHL\n");
            }
            asmCodeBuf.append("\tCALL\tS_MID\n");
            basicCompiler.addLibItem(BasicLibrary.LibItem.S_MID);
        }
        BasicUtil.parseToken(characterIterator, ')');
    }

    private static void parseStrRIGHT(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ',');
        int n = asmCodeBuf.length();
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        String string = asmCodeBuf.cut(n);
        String string2 = BasicUtil.convertCodeToValueInBC(string);
        if (string2 != null) {
            asmCodeBuf.append(string2);
        } else {
            asmCodeBuf.append("\tPUSH\tHL\n");
            asmCodeBuf.append(string);
            asmCodeBuf.append("\tLD\tB,H\n\tLD\tC,L\n\tPOP\tHL\n");
        }
        asmCodeBuf.append("\tCALL\tS_RIGHT\n");
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_RIGHT);
    }

    private static void parseStrRTRIM(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        basicCompiler.lockTmpStrBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
        basicCompiler.getCodeBuf().append("\tCALL\tS_RTRIM\n");
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_RTRIM);
    }

    private static void parseStrSPACE(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        basicCompiler.lockTmpStrBuf();
        int n = asmCodeBuf.length();
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        String string = asmCodeBuf.cut(n);
        String string2 = BasicUtil.convertCodeToValueInBC(string);
        if (string2 != null) {
            asmCodeBuf.append(string2);
        } else {
            asmCodeBuf.append(string);
            asmCodeBuf.append("\tLD\tB,H\n\tLD\tC,L\n");
        }
        asmCodeBuf.append("\tLD\tL,20H\n\tCALL\tS_STC\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_STC);
    }

    private static void parseStrSTR(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        BasicExprParser.parseEnclosedExpr(basicCompiler, characterIterator);
        basicCompiler.getCodeBuf().append("\tCALL\tS_STR\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_STR);
    }

    private static void parseStrSTRING(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        AsmCodeBuf asmCodeBuf = basicCompiler.getCodeBuf();
        basicCompiler.lockTmpStrBuf();
        BasicUtil.parseToken(characterIterator, '(');
        int n = asmCodeBuf.length();
        BasicExprParser.parseExpr(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ',');
        Integer n2 = BasicUtil.removeLastCodeIfConstExpr(basicCompiler, n);
        if (n2 != null) {
            if (BasicExprParser.checkParseStringPrimExpr(basicCompiler, characterIterator)) {
                asmCodeBuf.append_LD_BC_nn(n2);
                asmCodeBuf.append("\tCALL\tS_STS\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.S_STS);
            } else {
                BasicExprParser.parseExpr(basicCompiler, characterIterator);
                asmCodeBuf.append_LD_BC_nn(n2);
                asmCodeBuf.append("\tCALL\tS_STC\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.S_STC);
            }
        } else {
            String string = asmCodeBuf.cut(n);
            String string2 = BasicUtil.convertCodeToValueInBC(string);
            boolean bl = false;
            if (BasicExprParser.checkParseStringPrimExpr(basicCompiler, characterIterator)) {
                bl = true;
            } else {
                BasicExprParser.parseExpr(basicCompiler, characterIterator);
            }
            String string3 = asmCodeBuf.cut(n);
            if (BasicUtil.isOnly_LD_HL_xx(string3)) {
                if (string2 != null) {
                    asmCodeBuf.append(string2);
                } else {
                    asmCodeBuf.append(string);
                    asmCodeBuf.append("\tLD\tB,H\n\tLD\tC,L\n");
                }
                asmCodeBuf.append(string3);
            } else if (string2 != null) {
                asmCodeBuf.append(string3);
                asmCodeBuf.append(string2);
            } else {
                asmCodeBuf.append(string);
                asmCodeBuf.append("\tPUSH\tHL\n");
                asmCodeBuf.append(string3);
                asmCodeBuf.append("\tPOP\tBC\n");
            }
            if (bl) {
                asmCodeBuf.append("\tCALL\tS_STS\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.S_STS);
            } else {
                asmCodeBuf.append("\tCALL\tS_STC\n");
                basicCompiler.addLibItem(BasicLibrary.LibItem.S_STC);
            }
        }
        BasicUtil.parseToken(characterIterator, ')');
    }

    private static void parseStrTRIM(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        basicCompiler.lockTmpStrBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
        basicCompiler.getCodeBuf().append("\tCALL\tS_TRIM\n");
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_TRIM);
    }

    private static void parseStrUPPER(BasicCompiler basicCompiler, CharacterIterator characterIterator) throws PrgException {
        basicCompiler.lockTmpStrBuf();
        BasicUtil.parseToken(characterIterator, '(');
        BasicExprParser.parseStringPrimExpr(basicCompiler, characterIterator);
        BasicUtil.parseToken(characterIterator, ')');
        basicCompiler.getCodeBuf().append("\tCALL\tS_UPR\n");
        basicCompiler.addLibItem(BasicLibrary.LibItem.S_UPR);
    }
}

