/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.HexDocument;
import jkcemu.base.IntegerDocument;
import jkcemu.base.LimitedDocument;
import jkcemu.base.UserInputException;
import jkcemu.programming.AbstractOptionsDlg;
import jkcemu.programming.PrgOptions;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.BasicOptions;
import jkcemu.programming.basic.target.AC1Target;
import jkcemu.programming.basic.target.CPMTarget;
import jkcemu.programming.basic.target.HueblerGraphicsMCTarget;
import jkcemu.programming.basic.target.KC854Target;
import jkcemu.programming.basic.target.KC85Target;
import jkcemu.programming.basic.target.KramerMCTarget;
import jkcemu.programming.basic.target.LLC2HIRESTarget;
import jkcemu.programming.basic.target.SCCHTarget;
import jkcemu.programming.basic.target.Z1013PetersTarget;
import jkcemu.programming.basic.target.Z1013Target;
import jkcemu.programming.basic.target.Z9001KRTTarget;
import jkcemu.programming.basic.target.Z9001Target;

public class BasicOptionsDlg
extends AbstractOptionsDlg {
    private static final String textCodeBegAddr = "Anfangsadresse Programmcode:";
    private static final String textHeapSize = "Gr\u00f6\u00dfe Zeichenkettenspeicher:";
    private static final AbstractTarget[] targets = new AbstractTarget[]{new CPMTarget(), new SCCHTarget(), new AC1Target(), new LLC2HIRESTarget(), new HueblerGraphicsMCTarget(), new Z9001Target(), new Z9001KRTTarget(), new KC85Target(), new KC854Target(), new KramerMCTarget(), new Z1013Target(), new Z1013PetersTarget()};
    private EmuSys emuSys;
    private JTabbedPane tabbedPane;
    private JRadioButton btnStackSystem;
    private JRadioButton btnStackSeparate;
    private JRadioButton btnBssTrailed;
    private JRadioButton btnBssBegAddr;
    private JRadioButton btnLangDE;
    private JRadioButton btnLangEN;
    private JRadioButton btnCheckAll;
    private JRadioButton btnCheckNone;
    private JRadioButton btnCheckCustom;
    private JRadioButton btnBreakAlways;
    private JRadioButton btnBreakInput;
    private JRadioButton btnBreakNever;
    private JComboBox<Object> comboTarget;
    private JCheckBox btnCheckBounds;
    private JCheckBox btnCheckStack;
    private JCheckBox btnOpenCrtEnabled;
    private JCheckBox btnOpenLptEnabled;
    private JCheckBox btnOpenFileEnabled;
    private JCheckBox btnOpenVdipEnabled;
    private JCheckBox btnInclBasicLines;
    private JCheckBox btnPreferRelJumps;
    private JCheckBox btnPrintLineNumOnAbort;
    private JCheckBox btnShowAsm;
    private JCheckBox btnWarnNonAsciiChars;
    private JCheckBox btnWarnUnusedItems;
    private JTextField fldAppName;
    private JTextField fldCodeBegAddr;
    private JTextField fldBssBegAddr;
    private JTextField fldHeapSize;
    private JTextField fldStackSize;
    private JLabel labelAppName;
    private JLabel labelBssBegAddrUnit;
    private JLabel labelStackUnit;
    private LimitedDocument docAppName;
    private HexDocument docCodeBegAddr;
    private HexDocument docBssBegAddr;
    private IntegerDocument docHeapSize;
    private IntegerDocument docStackSize;

    public BasicOptionsDlg(Frame frame, EmuThread emuThread, PrgOptions prgOptions) {
        super(frame, emuThread, "BASIC-Compiler-Optionen");
        int n;
        Object object2;
        this.emuThread = emuThread;
        this.emuSys = emuThread != null ? emuThread.getEmuSys() : null;
        BasicOptions basicOptions = null;
        if (prgOptions != null && prgOptions instanceof BasicOptions) {
            basicOptions = (BasicOptions)prgOptions;
        }
        String string = null;
        boolean bl = false;
        if (basicOptions != null && (string = basicOptions.getTargetText()) != null) {
            object2 = basicOptions.getEmuSys();
            if (this.emuSys != null && object2 != null && this.emuSys != object2) {
                string = null;
                bl = true;
            }
        }
        this.setLayout(new GridBagLayout());
        object2 = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.tabbedPane = new JTabbedPane(1);
        this.add((Component)this.tabbedPane, object2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Allgemein", jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0);
        jPanel.add((Component)new JLabel("Zielsystem:"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.labelAppName = new JLabel("Name des Programms:");
        jPanel.add((Component)this.labelAppName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(textCodeBegAddr), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("Variablen/Speicherzellen:"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(textHeapSize), gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("Stack:"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("Sprache der Laufzeitausschriften:"), gridBagConstraints);
        boolean bl2 = false;
        int n2 = -1;
        if (string != null) {
            for (n = 0; n < targets.length; ++n) {
                if (!string.equals(targets[n].toString())) continue;
                n2 = n;
                break;
            }
        } else if (this.emuSys != null) {
            n = 0;
            for (int i = 0; i < targets.length; ++i) {
                int n3 = targets[i].getCompatibilityLevel(this.emuSys);
                if (n3 <= n) continue;
                n2 = i;
                bl2 = true;
                n = n3;
            }
        }
        if (n2 >= 0) {
            this.comboTarget = new JComboBox<Object>((Object[])targets);
            this.comboTarget.setEditable(false);
        } else {
            this.comboTarget = new JComboBox();
            this.comboTarget.setEditable(false);
            this.comboTarget.addItem("Bitte ausw\u00e4hlen");
            for (AbstractTarget object3 : targets) {
                this.comboTarget.addItem(object3);
            }
            n2 = 0;
        }
        try {
            this.comboTarget.setSelectedIndex(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
        jPanel.add(this.comboTarget, gridBagConstraints);
        this.docAppName = new LimitedDocument(8);
        this.docAppName.setAsciiOnly(true);
        this.fldAppName = new JTextField(this.docAppName, "", 9);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.fldAppName, gridBagConstraints);
        this.docCodeBegAddr = new HexDocument(4);
        this.fldCodeBegAddr = new JTextField(this.docCodeBegAddr, "", 5);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.fldCodeBegAddr, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JLabel("hex"), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnBssTrailed = new JRadioButton("direkt hinter Programmcode", true);
        buttonGroup.add(this.btnBssTrailed);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.btnBssTrailed, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.btnBssBegAddr = new JRadioButton("Ab Adresse:");
        buttonGroup.add(this.btnBssBegAddr);
        jPanel2.add(this.btnBssBegAddr);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.docBssBegAddr = new HexDocument(4);
        this.fldBssBegAddr = new JTextField(this.docBssBegAddr, "", 5);
        jPanel2.add(this.fldBssBegAddr);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.labelBssBegAddrUnit = new JLabel("hex");
        jPanel2.add(this.labelBssBegAddrUnit);
        this.fldHeapSize = new JTextField(5);
        this.docHeapSize = new IntegerDocument((JTextComponent)this.fldHeapSize, 512, 32768);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.fldHeapSize, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JLabel("Bytes"), gridBagConstraints);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.btnStackSystem = new JRadioButton("System-Stack verwenden", true);
        buttonGroup2.add(this.btnStackSystem);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.btnStackSystem, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.btnStackSeparate = new JRadioButton("Eigener Stack-Bereich:", false);
        buttonGroup2.add(this.btnStackSeparate);
        jPanel3.add(this.btnStackSeparate);
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        this.fldStackSize = new JTextField(5);
        this.docStackSize = new IntegerDocument((JTextComponent)this.fldStackSize, (Integer)64, null);
        jPanel3.add(this.fldStackSize);
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        this.labelStackUnit = new JLabel("Bytes");
        jPanel3.add(this.labelStackUnit);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.btnLangDE = new JRadioButton("Deutsch");
        buttonGroup3.add(this.btnLangDE);
        jPanel4.add(this.btnLangDE);
        this.btnLangEN = new JRadioButton("Englisch");
        buttonGroup3.add(this.btnLangEN);
        jPanel4.add(this.btnLangEN);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Laufzeiteigenschaften", jPanel5);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        ButtonGroup buttonGroup4 = new ButtonGroup();
        this.btnCheckAll = new JRadioButton("Compilieren f\u00fcr Test und Debugging", true);
        buttonGroup4.add(this.btnCheckAll);
        jPanel5.add((Component)this.btnCheckAll, gridBagConstraints2);
        this.btnCheckNone = new JRadioButton("Compilieren f\u00fcr Produktiveinsatz", false);
        buttonGroup4.add(this.btnCheckNone);
        gridBagConstraints2.insets.top = 0;
        ++gridBagConstraints2.gridy;
        jPanel5.add((Component)this.btnCheckNone, gridBagConstraints2);
        this.btnCheckCustom = new JRadioButton("Benutzerdefiniert", false);
        buttonGroup4.add(this.btnCheckCustom);
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel5.add((Component)this.btnCheckCustom, gridBagConstraints2);
        ButtonGroup buttonGroup5 = new ButtonGroup();
        this.btnBreakAlways = new JRadioButton("CTRL-C bricht Programm ab", true);
        buttonGroup5.add(this.btnBreakAlways);
        gridBagConstraints2.insets.top = 5;
        gridBagConstraints2.insets.bottom = 0;
        gridBagConstraints2.insets.left = 20;
        gridBagConstraints2.gridy = 0;
        ++gridBagConstraints2.gridx;
        jPanel5.add((Component)this.btnBreakAlways, gridBagConstraints2);
        this.btnBreakInput = new JRadioButton("CTRL-C bricht Programm nur bei Eingaben ab", false);
        buttonGroup5.add(this.btnBreakInput);
        gridBagConstraints2.insets.top = 0;
        ++gridBagConstraints2.gridy;
        jPanel5.add((Component)this.btnBreakInput, gridBagConstraints2);
        this.btnBreakNever = new JRadioButton("CTRL-C bricht Programm nicht ab", false);
        buttonGroup5.add(this.btnBreakNever);
        ++gridBagConstraints2.gridy;
        jPanel5.add((Component)this.btnBreakNever, gridBagConstraints2);
        this.btnCheckBounds = new JCheckBox("Feldgrenzen pr\u00fcfen", true);
        gridBagConstraints2.insets.top = 5;
        ++gridBagConstraints2.gridy;
        jPanel5.add((Component)this.btnCheckBounds, gridBagConstraints2);
        this.btnCheckStack = new JCheckBox("Stack pr\u00fcfen", true);
        gridBagConstraints2.insets.top = 0;
        ++gridBagConstraints2.gridy;
        jPanel5.add((Component)this.btnCheckStack, gridBagConstraints2);
        this.btnPrintLineNumOnAbort = new JCheckBox("Bei Abbruch aufgrund eines Fehlers Zeilennummer ausgeben", true);
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel5.add((Component)this.btnPrintLineNumOnAbort, gridBagConstraints2);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Treiber", jPanel6);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        jPanel6.add((Component)new JLabel("Bei Verwendung der OPEN-Anweisung folgende Treiber einbinden:"), gridBagConstraints3);
        this.btnOpenCrtEnabled = new JCheckBox("CRT-Treiber (Ausgabekanal auf Bildschirm)");
        gridBagConstraints3.insets.top = 0;
        gridBagConstraints3.insets.left = 50;
        ++gridBagConstraints3.gridy;
        jPanel6.add((Component)this.btnOpenCrtEnabled, gridBagConstraints3);
        this.btnOpenLptEnabled = new JCheckBox("LPT-Treiber (Ausgabekanal auf Drucker, nur relevant wenn vom Zielsystem unterst\u00fctzt)");
        gridBagConstraints3.insets.bottom = 0;
        ++gridBagConstraints3.gridy;
        jPanel6.add((Component)this.btnOpenLptEnabled, gridBagConstraints3);
        this.btnOpenFileEnabled = new JCheckBox("FILE-Treiber (Zugriff auf Dateisystem, nur relevant bei Zielsystem 'CP/M-kompatibel')");
        ++gridBagConstraints3.gridy;
        jPanel6.add((Component)this.btnOpenFileEnabled, gridBagConstraints3);
        this.btnOpenVdipEnabled = new JCheckBox("VDIP-Treiber (Zugriff auf USB-Speicher, nur relevant wenn vom Zielsystem unterst\u00fctzt)");
        gridBagConstraints3.insets.bottom = 5;
        ++gridBagConstraints3.gridy;
        jPanel6.add((Component)this.btnOpenVdipEnabled, gridBagConstraints3);
        this.tabbedPane.addTab("Erzeugter Programmcode", this.createCodeDestOptions());
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        this.tabbedPane.addTab("Sonstiges", jPanel7);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0);
        jPanel7.add((Component)new JLabel("Fehlervermeidung:"), gridBagConstraints4);
        this.btnWarnNonAsciiChars = new JCheckBox("Bei Nicht-ASCII-Zeichen warnen");
        gridBagConstraints4.insets.top = 0;
        gridBagConstraints4.insets.left = 50;
        ++gridBagConstraints4.gridy;
        jPanel7.add((Component)this.btnWarnNonAsciiChars, gridBagConstraints4);
        this.btnWarnUnusedItems = new JCheckBox("Bei nicht verwendeten Funktionen, Prozeduren und Variablen warnen");
        ++gridBagConstraints4.gridy;
        jPanel7.add((Component)this.btnWarnUnusedItems, gridBagConstraints4);
        gridBagConstraints4.insets.top = 15;
        gridBagConstraints4.insets.left = 5;
        ++gridBagConstraints4.gridy;
        jPanel7.add((Component)new JLabel("Optimierung:"), gridBagConstraints4);
        this.btnPreferRelJumps = new JCheckBox("Relative Spr\u00fcnge bevorzugen");
        gridBagConstraints4.insets.top = 0;
        gridBagConstraints4.insets.left = 50;
        ++gridBagConstraints4.gridy;
        jPanel7.add((Component)this.btnPreferRelJumps, gridBagConstraints4);
        gridBagConstraints4.insets.top = 15;
        gridBagConstraints4.insets.left = 5;
        ++gridBagConstraints4.gridy;
        jPanel7.add((Component)new JLabel("Assembler-Code:"), gridBagConstraints4);
        this.btnShowAsm = new JCheckBox("Erzeugten Assembler-Code anzeigen");
        gridBagConstraints4.insets.top = 0;
        gridBagConstraints4.insets.left = 50;
        ++gridBagConstraints4.gridy;
        jPanel7.add((Component)this.btnShowAsm, gridBagConstraints4);
        this.btnInclBasicLines = new JCheckBox("BASIC-Zeilen als Kommentare einf\u00fcgen");
        gridBagConstraints4.insets.bottom = 5;
        ++gridBagConstraints4.gridy;
        jPanel7.add((Component)this.btnInclBasicLines, gridBagConstraints4);
        ((GridBagConstraints)object2).fill = 0;
        ((GridBagConstraints)object2).weightx = 0.0;
        ((GridBagConstraints)object2).weighty = 0.0;
        ((GridBagConstraints)object2).insets.bottom = 10;
        ++((GridBagConstraints)object2).gridy;
        this.add((Component)this.createButtons("Compilieren"), object2);
        String string2 = null;
        int n3 = 128;
        if (basicOptions != null) {
            string2 = basicOptions.getLangCode();
            n3 = basicOptions.getStackSize();
            this.fldAppName.setText(basicOptions.getAppName());
            if (!this.updBegAddrs(basicOptions.getCodeBegAddr(), basicOptions.getBssBegAddr())) {
                bl = true;
            }
            this.docHeapSize.setValue(basicOptions.getHeapSize());
            switch (basicOptions.getBreakOption()) {
                case INPUT: {
                    this.btnBreakInput.setSelected(true);
                    break;
                }
                case NEVER: {
                    this.btnBreakNever.setSelected(true);
                    break;
                }
                default: {
                    this.btnBreakAlways.setSelected(true);
                }
            }
            this.btnCheckBounds.setSelected(basicOptions.getCheckBounds());
            this.btnCheckStack.setSelected(basicOptions.getCheckStack());
            this.btnOpenCrtEnabled.setSelected(basicOptions.isOpenCrtEnabled());
            this.btnOpenLptEnabled.setSelected(basicOptions.isOpenLptEnabled());
            this.btnOpenFileEnabled.setSelected(basicOptions.isOpenFileEnabled());
            this.btnOpenVdipEnabled.setSelected(basicOptions.isOpenVdipEnabled());
            this.btnPreferRelJumps.setSelected(basicOptions.getPreferRelativeJumps());
            this.btnPrintLineNumOnAbort.setSelected(basicOptions.getPrintLineNumOnAbort());
            this.btnShowAsm.setSelected(basicOptions.getShowAssemblerText());
            this.btnInclBasicLines.setSelected(basicOptions.getIncludeBasicLines());
            this.btnWarnNonAsciiChars.setSelected(basicOptions.getWarnNonAsciiChars());
            this.btnWarnUnusedItems.setSelected(basicOptions.getWarnUnusedItems());
        } else {
            this.fldAppName.setText("MYAPP");
            this.docHeapSize.setValue(1024);
            this.btnBreakAlways.setSelected(true);
            this.btnCheckBounds.setSelected(true);
            this.btnCheckStack.setSelected(true);
            this.btnOpenCrtEnabled.setSelected(true);
            this.btnOpenLptEnabled.setSelected(true);
            this.btnOpenFileEnabled.setSelected(true);
            this.btnOpenVdipEnabled.setSelected(true);
            this.btnPreferRelJumps.setSelected(true);
            this.btnPrintLineNumOnAbort.setSelected(true);
            this.btnShowAsm.setSelected(false);
            this.btnInclBasicLines.setSelected(true);
            this.btnWarnNonAsciiChars.setSelected(true);
            this.btnWarnUnusedItems.setSelected(true);
            bl = true;
        }
        if (string2 != null) {
            if (string2.equalsIgnoreCase("DE")) {
                this.btnLangDE.setSelected(true);
            } else {
                this.btnLangEN.setSelected(true);
            }
        } else {
            this.btnLangDE.setSelected(true);
        }
        if (this.btnBreakAlways.isSelected() && this.btnCheckBounds.isSelected() && this.btnCheckStack.isSelected() && this.btnPrintLineNumOnAbort.isSelected()) {
            this.btnCheckAll.setSelected(true);
        } else if (this.btnBreakNever.isSelected() && !this.btnCheckBounds.isSelected() && !this.btnCheckStack.isSelected() && !this.btnPrintLineNumOnAbort.isSelected()) {
            this.btnCheckNone.setSelected(true);
        } else {
            this.btnCheckCustom.setSelected(true);
        }
        if (n3 > 0) {
            this.btnStackSeparate.setSelected(true);
            this.docStackSize.setValue(n3);
        } else {
            this.btnStackSystem.setSelected(true);
        }
        this.docAppName.setSwapCase(true);
        if (bl) {
            this.updBegAddrsFromSelectedTarget();
        }
        this.updCodeToEmuFields();
        this.updCodeDestFields(prgOptions, bl2);
        this.updAppNameFieldsEnabled();
        this.updCheckFieldsEnabled();
        this.updStackFieldsEnabled();
        this.updInclBasicLinesEnabled();
        this.comboTarget.addActionListener(this);
        this.fldCodeBegAddr.addActionListener(this);
        this.btnBssTrailed.addActionListener(this);
        this.btnBssBegAddr.addActionListener(this);
        this.fldBssBegAddr.addActionListener(this);
        this.fldHeapSize.addActionListener(this);
        this.btnStackSystem.addActionListener(this);
        this.btnStackSeparate.addActionListener(this);
        this.fldStackSize.addActionListener(this);
        this.btnLangDE.addActionListener(this);
        this.btnLangEN.addActionListener(this);
        this.btnCheckAll.addActionListener(this);
        this.btnCheckNone.addActionListener(this);
        this.btnCheckCustom.addActionListener(this);
        this.btnShowAsm.addActionListener(this);
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
    }

    @Override
    protected void doApply() {
        String string = null;
        try {
            int n;
            AbstractTarget abstractTarget = null;
            Object object = this.comboTarget.getSelectedItem();
            if (object != null && object instanceof AbstractTarget) {
                abstractTarget = (AbstractTarget)object;
            }
            if (abstractTarget == null) {
                throw new UserInputException("Sie m\u00fcssen ein Zielsystem ausw\u00e4hlen!");
            }
            string = textCodeBegAddr;
            int n2 = n = this.docCodeBegAddr.intValue();
            string = "Anfangsadresse Variablen/Speicherzellen:";
            int n3 = -1;
            if (this.btnBssBegAddr.isSelected()) {
                n3 = this.docBssBegAddr.intValue();
            }
            string = textHeapSize;
            int n4 = this.docHeapSize.intValue();
            string = "Stack-Gr\u00f6\u00dfe:";
            int n5 = 0;
            if (this.btnStackSeparate.isSelected()) {
                n5 = this.docStackSize.intValue();
            }
            string = null;
            BasicOptions.BreakOption breakOption = BasicOptions.BreakOption.ALWAYS;
            if (this.btnBreakInput.isSelected()) {
                breakOption = BasicOptions.BreakOption.INPUT;
            } else if (this.btnBreakNever.isSelected()) {
                breakOption = BasicOptions.BreakOption.NEVER;
            }
            String string2 = this.fldAppName.getText();
            BasicOptions basicOptions = new BasicOptions();
            basicOptions.setTarget(abstractTarget);
            basicOptions.setAppName(string2 != null ? string2.trim() : null);
            basicOptions.setCodeBegAddr(n);
            basicOptions.setBssBegAddr(n3);
            basicOptions.setHeapSize(n4);
            basicOptions.setStackSize(n5);
            basicOptions.setLangCode(this.btnLangDE.isSelected() ? "DE" : "EN");
            basicOptions.setBreakOption(breakOption);
            basicOptions.setCheckBounds(this.btnCheckBounds.isSelected());
            basicOptions.setCheckStack(this.btnCheckStack.isSelected());
            basicOptions.setOpenCrtEnabled(this.btnOpenCrtEnabled.isSelected());
            basicOptions.setOpenLptEnabled(this.btnOpenLptEnabled.isSelected());
            basicOptions.setOpenFileEnabled(this.btnOpenFileEnabled.isSelected());
            basicOptions.setOpenVdipEnabled(this.btnOpenVdipEnabled.isSelected());
            basicOptions.setPreferRelativeJumps(this.btnPreferRelJumps.isSelected());
            basicOptions.setPrintLineNumOnAbort(this.btnPrintLineNumOnAbort.isSelected());
            basicOptions.setShowAssemblerText(this.btnShowAsm.isSelected());
            basicOptions.setIncludeBasicLines(this.btnInclBasicLines.isSelected());
            basicOptions.setWarnNonAsciiChars(this.btnWarnNonAsciiChars.isSelected());
            basicOptions.setWarnUnusedItems(this.btnWarnUnusedItems.isSelected());
            try {
                this.applyCodeDestOptionsTo(basicOptions);
                this.appliedOptions = basicOptions;
                this.doClose();
            }
            catch (UserInputException userInputException) {
                BasicOptionsDlg.showErrorDlg((Component)this, "Erzeugter Programmcode:\n" + userInputException.getMessage());
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = numberFormatException.getMessage();
            if (string != null) {
                string3 = string + " " + string3;
            }
            BasicOptionsDlg.showErrorDlg((Component)this, string3);
        }
        catch (UserInputException userInputException) {
            BasicOptionsDlg.showErrorDlg((Component)this, userInputException);
        }
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = super.doAction(eventObject);
        if (!bl && eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.comboTarget) {
                bl = true;
                this.updAppNameFieldsEnabled();
                this.updBegAddrsFromSelectedTarget();
                this.updCodeToEmuFields();
            } else if (object == this.btnBssTrailed || object == this.btnBssBegAddr) {
                bl = true;
                this.updBssFieldsEnabled();
            } else if (object == this.btnStackSystem || object == this.btnStackSeparate) {
                bl = true;
                this.updStackFieldsEnabled();
            } else if (object == this.btnCheckAll) {
                bl = true;
                this.btnBreakAlways.setSelected(true);
                this.btnCheckBounds.setSelected(true);
                this.btnCheckStack.setSelected(true);
                this.btnPrintLineNumOnAbort.setSelected(true);
                this.updCheckFieldsEnabled();
            } else if (object == this.btnCheckNone) {
                bl = true;
                this.btnBreakNever.setSelected(true);
                this.btnCheckBounds.setSelected(false);
                this.btnCheckStack.setSelected(false);
                this.btnPrintLineNumOnAbort.setSelected(false);
                this.updCheckFieldsEnabled();
            } else if (object == this.btnCheckCustom) {
                bl = true;
                this.updCheckFieldsEnabled();
            } else if (object == this.btnShowAsm) {
                bl = true;
                this.updInclBasicLinesEnabled();
            } else {
                bl = true;
                if (object instanceof JTextField) {
                    ((JTextField)object).transferFocus();
                }
            }
        }
        return bl;
    }

    @Override
    public void settingsChanged() {
        EmuSys emuSys;
        super.settingsChanged();
        if (this.emuThread != null && (emuSys = this.emuThread.getEmuSys()) != null) {
            boolean bl = true;
            if (this.emuSys != null && this.emuSys.equals(emuSys)) {
                bl = false;
            }
            int n = 0;
            this.emuSys = emuSys;
            if (this.emuSys != null) {
                int n2 = this.comboTarget.getItemCount();
                for (int i = 0; i < n2; ++i) {
                    Object object = this.comboTarget.getItemAt(i);
                    if (object == null || !(object instanceof AbstractTarget) || ((AbstractTarget)object).getCompatibilityLevel(this.emuSys) <= 0) continue;
                    n = i;
                    break;
                }
            }
            try {
                this.comboTarget.setSelectedIndex(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void updAppNameFieldsEnabled() {
        boolean bl = false;
        Object object = this.comboTarget.getSelectedItem();
        if (object != null && object instanceof AbstractTarget && ((AbstractTarget)object).getMaxAppNameLen() > 0) {
            bl = true;
        }
        this.labelAppName.setEnabled(bl);
        this.fldAppName.setEnabled(bl);
    }

    private boolean updBegAddrs(int n, int n2) {
        boolean bl = false;
        if (n >= 0) {
            this.docCodeBegAddr.setValue(n, 4);
            bl = true;
        } else {
            this.fldCodeBegAddr.setText("");
        }
        if (n2 >= 0) {
            this.docBssBegAddr.setValue(n2, 4);
            this.btnBssBegAddr.setSelected(true);
        } else {
            this.fldBssBegAddr.setText("");
            this.btnBssTrailed.setSelected(true);
        }
        this.updBssFieldsEnabled();
        return bl;
    }

    private void updBegAddrsFromSelectedTarget() {
        int n = -1;
        Object object = this.comboTarget.getSelectedItem();
        if (object != null && object instanceof AbstractTarget) {
            n = ((AbstractTarget)object).getDefaultBegAddr();
        }
        this.updBegAddrs(n, -1);
    }

    private void updBssFieldsEnabled() {
        boolean bl = this.btnBssBegAddr.isSelected();
        this.fldBssBegAddr.setEnabled(bl);
        this.labelBssBegAddrUnit.setEnabled(bl);
    }

    private void updCheckFieldsEnabled() {
        boolean bl = this.btnCheckCustom.isSelected();
        this.btnBreakAlways.setEnabled(bl);
        this.btnBreakInput.setEnabled(bl);
        this.btnBreakNever.setEnabled(bl);
        this.btnCheckBounds.setEnabled(bl);
        this.btnCheckStack.setEnabled(bl);
        this.btnPrintLineNumOnAbort.setEnabled(bl);
    }

    private void updCodeToEmuFields() {
        Object object;
        boolean bl = false;
        if (this.emuSys != null && (object = this.comboTarget.getSelectedItem()) != null && object instanceof AbstractTarget && ((AbstractTarget)object).getCompatibilityLevel(this.emuSys) > 0) {
            bl = true;
        }
        if (!bl) {
            this.setCodeToEmu(false);
        }
    }

    private void updInclBasicLinesEnabled() {
        this.btnInclBasicLines.setEnabled(this.btnShowAsm.isSelected());
    }

    private void updStackFieldsEnabled() {
        boolean bl = this.btnStackSeparate.isSelected();
        this.fldStackSize.setEnabled(bl);
        this.labelStackUnit.setEnabled(bl);
    }
}

