/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import jkcemu.base.EmuUtil;
import jkcemu.programming.CmdLineArgIterator;
import jkcemu.programming.PrgLogger;
import jkcemu.programming.assembler.Z80Assembler;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicOptions;
import jkcemu.programming.basic.target.AC1Target;
import jkcemu.programming.basic.target.CPMTarget;
import jkcemu.programming.basic.target.HueblerGraphicsMCTarget;
import jkcemu.programming.basic.target.KC854Target;
import jkcemu.programming.basic.target.KC85Target;
import jkcemu.programming.basic.target.KramerMCTarget;
import jkcemu.programming.basic.target.LLC2HIRESTarget;
import jkcemu.programming.basic.target.SCCHTarget;
import jkcemu.programming.basic.target.Z1013PetersTarget;
import jkcemu.programming.basic.target.Z1013Target;
import jkcemu.programming.basic.target.Z9001KRTTarget;
import jkcemu.programming.basic.target.Z9001Target;

public class CmdLineBasicCompiler {
    private static final String[] usageLines = new String[]{"", "Aufruf:", "  java -jar jkcemu.jar --bc [Optionen] <Datei>", "  java -jar jkcemu.jar --basiccompiler [Optionen] <Datei>", "", "Optionen:", "  -h              diese Hilfe anzeigen", "  -f <Datei>      Kommandozeile aus Datei lesen", "  -g              bei Abbruch aufgrund eines Fehlers Zeilennummer ausgeben", "  -o <Datei>      Ausgabedatei festlegen", "  -t <System>     Zielsystem festlegen (ac1, cpm, huebler, kc85, kc85_4,", "                  kramer, llc2_hires, scch, z1013, z1013_64x16,", "                  z9001, z9001_krt)", "  -A <AAdr>       Anfangsadresse festlegen (hexadezimal)", "  -A <AAdr:BAdr>  Anfangsadressen f\u00fcr Programmcode (AAdr) und", "                  BSS-Bereich (BAdr) festlegen (hexadezimal)", "  -D <Treiber>    einzubindende Treiber festlegen (z.B.: -D \"CRT,LPT\")", "                  vorhandene Treiber: CRT, LPT, FILE, VDIP", "  -L <Sprache>    Sprache der Laufzeitausschriften festlegen (de, en)", "  -M <Zahl>       Stack-Gr\u00f6\u00dfe festlegen (0: System-Stack verwenden)", "  -N <Name>       Programmname festlegen", "  -B...           Abbruchm\u00f6glichkeit festlegen", "  -O...           Programmcode optimieren", "  -S              nur Assembler-Quelltext erzeugen", "  -T <Zahl>       Gr\u00f6\u00dfe Zeichenkettenspeicher festlegen", "  -W <...>        Warnungen ein-/ausschalten", "", "Option zum Festlegen der Abbruchm\u00f6glichkeit:", "  -B0             CTRL-C bricht Programm nicht ab", "  -B1             CTRL-C bricht Programm nur bei Eingaben ab", "  -B2             CTRL-C bricht Programm immer ab (Standard, langsam!)", "", "Option zur Programmcodeoptimierung (-O entspricht -O2):", "  -O1             Stack-Pr\u00fcfungen ausschalten", "  -O2             zus\u00e4tzlich Feldpr\u00fcfungen ausschalten", "  -O3             zus\u00e4tzlich relative Spr\u00fcnge bevorzugen", "", "Option fuer Warnungen:", "  -W all          alle Warnungen einschalten (Standard)", "  -W none         alle Warnungen ausschalten", "  -W nonascii     Bei Nicht-ASCII-Zeichen warnen", "  -W unused       Bei nicht verwendeten Funktionen, Prozeduren und", "                  Variablen warnen", ""};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(String[] stringArray, int n) {
        boolean bl;
        block108: {
            bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n2 = 0;
            String string = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            BasicOptions.BreakOption breakOption = BasicOptions.BreakOption.ALWAYS;
            CmdLineArgIterator cmdLineArgIterator = null;
            CmdLineArgIterator cmdLineArgIterator2 = CmdLineArgIterator.createFromStringArray(stringArray, n);
            try {
                String string2;
                int n3;
                int n4;
                int n5;
                String string3;
                String string4 = cmdLineArgIterator2.next();
                while (string4 != null) {
                    int n6 = string4.length();
                    if (n6 > 0) {
                        if (string4.charAt(0) == '-') {
                            if (n6 < 2) {
                                CmdLineBasicCompiler.throwWrongCmdLine();
                            }
                            int n7 = 1;
                            while (n7 < n6) {
                                int n8 = string4.charAt(n7++);
                                block4 : switch (n8) {
                                    case 102: {
                                        if (cmdLineArgIterator != null) {
                                            throw new IOException("Option -f in der Datei nicht erlaubt");
                                        }
                                        String string5 = null;
                                        if (n7 < n6) {
                                            string5 = string4.substring(n7);
                                            n7 = n6;
                                        } else {
                                            string5 = cmdLineArgIterator2.next();
                                        }
                                        if (string5 == null) {
                                            CmdLineBasicCompiler.throwWrongCmdLine();
                                        }
                                        try {
                                            cmdLineArgIterator = cmdLineArgIterator2;
                                            cmdLineArgIterator2 = CmdLineArgIterator.createFromReader(new FileReader(string5));
                                        }
                                        catch (IOException iOException) {
                                            cmdLineArgIterator2 = cmdLineArgIterator;
                                            cmdLineArgIterator = null;
                                        }
                                        break;
                                    }
                                    case 72: 
                                    case 104: {
                                        bl3 = true;
                                        break;
                                    }
                                    case 103: {
                                        bl4 = true;
                                        break;
                                    }
                                    case 83: {
                                        bl2 = true;
                                        break;
                                    }
                                    case 66: {
                                        if (n7 < n6) {
                                            switch (string4.charAt(n7++)) {
                                                case '0': {
                                                    breakOption = BasicOptions.BreakOption.NEVER;
                                                    break block4;
                                                }
                                                case '1': {
                                                    breakOption = BasicOptions.BreakOption.INPUT;
                                                    break block4;
                                                }
                                                case '2': {
                                                    breakOption = BasicOptions.BreakOption.ALWAYS;
                                                    break block4;
                                                }
                                            }
                                            throw new IOException(String.format("Option 'B%c' nicht unterst\u00fctzt", Character.valueOf((char)n8)));
                                        }
                                        throw new IOException("Option 'B' hat falsches Format");
                                    }
                                    case 79: {
                                        if (n7 < n6) {
                                            char c;
                                            if ((c = string4.charAt(n7++)) < '0' || c > '4') {
                                                throw new IOException(String.format("Option O%c nicht unterst\u00fctzt", Character.valueOf(c)));
                                            }
                                            n2 = c - 48;
                                            break;
                                        }
                                        n2 = 2;
                                        break;
                                    }
                                    case 65: 
                                    case 68: 
                                    case 76: 
                                    case 77: 
                                    case 78: 
                                    case 84: 
                                    case 87: 
                                    case 111: 
                                    case 116: {
                                        String string6;
                                        String string7 = null;
                                        if (n7 < n6) {
                                            string7 = string4.substring(n7);
                                            n7 = n6;
                                        } else {
                                            string7 = cmdLineArgIterator2.next();
                                        }
                                        if (string7 == null) {
                                            CmdLineBasicCompiler.throwWrongCmdLine();
                                        }
                                        if (hashMap.containsKey(string6 = Character.toString((char)n8))) {
                                            CmdLineBasicCompiler.throwWrongCmdLine();
                                        }
                                        hashMap.put(string6, string7);
                                        break;
                                    }
                                    default: {
                                        throw new IOException(String.format("Unbekannte Option '%c'", Character.valueOf((char)n8)));
                                    }
                                }
                            }
                        } else {
                            if (string != null) {
                                CmdLineBasicCompiler.throwWrongCmdLine();
                            }
                            string = string4;
                        }
                    }
                    if ((string4 = cmdLineArgIterator2.next()) != null || cmdLineArgIterator == null) continue;
                    EmuUtil.closeSilent(cmdLineArgIterator2);
                    cmdLineArgIterator2 = cmdLineArgIterator;
                    cmdLineArgIterator = null;
                    string4 = cmdLineArgIterator2.next();
                }
                if (bl3) {
                    EmuUtil.printlnOut();
                    EmuUtil.printlnOut("JKCEMU Version 0.9.7 BASIC-Compiler");
                    for (String string8 : usageLines) {
                        EmuUtil.printlnOut(string8);
                    }
                    break block108;
                }
                if (string == null) {
                    throw new IOException("Quelltextdatei nicht angegeben");
                }
                File file = new File(string);
                BasicOptions basicOptions = new BasicOptions();
                String string9 = (String)hashMap.get("t");
                if (string9 == null) {
                    throw new IOException("Option 't' nicht angegeben");
                }
                AbstractTarget abstractTarget = null;
                boolean bl5 = false;
                if (string9 != null) {
                    if (string9.equalsIgnoreCase("AC1")) {
                        abstractTarget = new AC1Target();
                    } else if (string9.equalsIgnoreCase("SCCH")) {
                        abstractTarget = new SCCHTarget();
                    } else if (string9.equalsIgnoreCase("CPM")) {
                        abstractTarget = new CPMTarget();
                    } else if (string9.equalsIgnoreCase("KC85")) {
                        abstractTarget = new KC85Target();
                    } else if (string9.equalsIgnoreCase("KC85_4")) {
                        abstractTarget = new KC854Target();
                    } else if (string9.equalsIgnoreCase("HUEBLER")) {
                        abstractTarget = new HueblerGraphicsMCTarget();
                    } else if (string9.equalsIgnoreCase("KRAMER")) {
                        abstractTarget = new KramerMCTarget();
                    } else if (string9.equalsIgnoreCase("Z9001")) {
                        abstractTarget = new Z9001Target();
                        bl5 = true;
                    } else if (string9.equalsIgnoreCase("Z9001_KRT")) {
                        abstractTarget = new Z9001KRTTarget();
                        bl5 = true;
                    } else if (string9.equalsIgnoreCase("LLC2_HIRES")) {
                        abstractTarget = new LLC2HIRESTarget();
                    } else if (string9.equalsIgnoreCase("Z1013")) {
                        abstractTarget = new Z1013Target();
                    } else if (string9.equalsIgnoreCase("Z1013_64X16")) {
                        abstractTarget = new Z1013PetersTarget();
                    }
                }
                if (abstractTarget == null) {
                    throw new IOException(String.format("'%s': unbekanntes Zielsystem", string9));
                }
                basicOptions.setTarget(abstractTarget);
                String string10 = (String)hashMap.get("o");
                String string11 = (String)hashMap.get("L");
                if (string11 != null) {
                    if (!string11.equalsIgnoreCase("DE") && !string11.equalsIgnoreCase("EN")) {
                        throw new IOException(String.format("'%s': Sprache nicht unterst\u00fctzt", string11));
                    }
                    basicOptions.setLangCode(string11.toUpperCase());
                } else {
                    basicOptions.setLangCode("DE");
                }
                int n9 = -1;
                int n10 = -1;
                String string12 = "A";
                String string13 = (String)hashMap.get(string12);
                if (string13 != null) {
                    int n11 = string13.indexOf(58);
                    if (n11 >= 0) {
                        n9 = CmdLineBasicCompiler.getHex4(string13.substring(0, n11), string12);
                        n10 = CmdLineBasicCompiler.getHex4(string13.substring(n11 + 1), string12);
                    } else {
                        n9 = CmdLineBasicCompiler.getHex4(string13, string12);
                    }
                }
                if (n9 >= 0) {
                    basicOptions.setCodeBegAddr(n9);
                } else {
                    basicOptions.setCodeBegAddr(abstractTarget.getDefaultBegAddr());
                }
                if (n10 >= 0) {
                    basicOptions.setBssBegAddr(n10);
                }
                if ((string3 = (String)hashMap.get("D")) != null) {
                    n5 = 0;
                    n4 = 0;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    n3 = string3.length();
                    if (n3 > 1 && string3.startsWith("\"") && string3.endsWith("\"")) {
                        string3 = string3.substring(1, n3 - 1);
                    }
                    try {
                        String[] stringArray2 = string3.split(",");
                        if (stringArray2 != null) {
                            for (String string14 : stringArray2) {
                                if (string14.equalsIgnoreCase("CRT")) {
                                    n5 = 1;
                                    continue;
                                }
                                if (string14.equalsIgnoreCase("LPT")) {
                                    n4 = 1;
                                    continue;
                                }
                                if (string14.equalsIgnoreCase("FILE")) {
                                    bl6 = true;
                                    continue;
                                }
                                if (string14.equalsIgnoreCase("VDIP")) {
                                    bl7 = true;
                                    continue;
                                }
                                throw new IOException(string14 + ": Unbekannter Treiber");
                            }
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                    basicOptions.setOpenCrtEnabled(n5 != 0);
                    basicOptions.setOpenLptEnabled(n4 != 0);
                    basicOptions.setOpenFileEnabled(bl6);
                    basicOptions.setOpenVdipEnabled(bl7);
                }
                if ((n5 = CmdLineBasicCompiler.getIntArg(hashMap, "T")) >= 0) {
                    if (n5 < 512) {
                        throw new IOException("Option 'T': Wert zu klein");
                    }
                    if (n5 > Short.MAX_VALUE) {
                        throw new IOException("Option 'T': Wert zu gro\u00df");
                    }
                    basicOptions.setHeapSize(n5);
                } else {
                    basicOptions.setHeapSize(1024);
                }
                n4 = CmdLineBasicCompiler.getIntArg(hashMap, "M");
                if (n4 >= 0) {
                    if (n4 > 0 && n4 < 64) {
                        throw new IOException("Option 'T': Wert entweder 0 oder >= " + Integer.toString(64));
                    }
                    if (n5 > Short.MAX_VALUE) {
                        throw new IOException("Option 'T': Wert zu gro\u00df");
                    }
                    basicOptions.setStackSize(n4);
                } else {
                    basicOptions.setStackSize(128);
                }
                String string15 = (String)hashMap.get("N");
                if (string15 == null && abstractTarget.getMaxAppNameLen() >= 6 && (string2 = file.getName()) != null && (n3 = string2.indexOf(46)) > 0) {
                    string15 = string2.substring(0, n3).toUpperCase();
                }
                if (string15 != null) {
                    basicOptions.setAppName(string15);
                }
                basicOptions.setBreakOption(breakOption);
                basicOptions.setCheckStack(n2 == 0);
                basicOptions.setCheckBounds(n2 <= 1);
                basicOptions.setPreferRelativeJumps(n2 >= 3);
                String string16 = (String)hashMap.get("W");
                if (string16 != null) {
                    basicOptions.setWarnNonAsciiChars(false);
                    basicOptions.setWarnUnusedItems(false);
                    if (string16.equalsIgnoreCase("ALL")) {
                        basicOptions.setWarnNonAsciiChars(true);
                        basicOptions.setWarnUnusedItems(true);
                    } else if (string16.equalsIgnoreCase("NONASCII")) {
                        basicOptions.setWarnNonAsciiChars(true);
                    } else if (string16.equalsIgnoreCase("UNUSED")) {
                        basicOptions.setWarnUnusedItems(true);
                    } else if (!string16.equalsIgnoreCase("NONE")) {
                        throw new IOException("Option 'W': Schl\u00fcsselwort " + string16 + " nicht unterst\u00fctzt");
                    }
                } else {
                    basicOptions.setWarnNonAsciiChars(true);
                    basicOptions.setWarnUnusedItems(true);
                }
                basicOptions.setPrintLineNumOnAbort(bl4);
                basicOptions.setShowAssemblerText(bl2);
                bl = CmdLineBasicCompiler.compile(file, string10, string15, bl5, basicOptions, bl2);
            }
            catch (IOException iOException) {
                EmuUtil.printlnErr();
                EmuUtil.printlnErr("JKCEMU Version 0.9.7 BASIC-Compiler:");
                String string17 = iOException.getMessage();
                if (string17 != null && !string17.isEmpty()) {
                    EmuUtil.printlnErr(string17);
                }
                for (String string18 : usageLines) {
                    EmuUtil.printlnErr(string18);
                }
                bl = false;
            }
            finally {
                EmuUtil.closeSilent(cmdLineArgIterator2);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compile(File file, String string, String string2, boolean bl, BasicOptions basicOptions, boolean bl2) {
        boolean bl3;
        block17: {
            bl3 = false;
            try {
                Object object;
                Object object2;
                File file2 = null;
                if (string != null) {
                    file2 = new File(string);
                } else {
                    object2 = file.getName();
                    if (object2 != null) {
                        int n = ((String)object2).lastIndexOf(46);
                        if (n >= 0 && n < ((String)object2).length()) {
                            object2 = ((String)object2).substring(0, n);
                        }
                    } else {
                        object2 = "out";
                    }
                    object2 = bl2 ? (String)object2 + ".s" : (basicOptions.getTarget() instanceof CPMTarget && basicOptions.getCodeBegAddr() == 256 ? (String)object2 + ".com" : (String)object2 + ".bin");
                    object = file.getParentFile();
                    file2 = object != null ? new File((File)object, (String)object2) : new File((String)object2);
                }
                if (file2.equals(file)) {
                    throw new IOException("Quelltext- und Ausgabedatei sind identisch");
                }
                if (bl2) {
                    basicOptions.setCodeToFile(false, null);
                } else {
                    basicOptions.setCodeToFile(true, file2);
                }
                object2 = PrgLogger.createStandardLogger();
                object = new BasicCompiler(null, file, basicOptions, (PrgLogger)object2);
                String string3 = ((BasicCompiler)object).compile();
                if (string3 == null) break block17;
                if (bl2) {
                    BufferedWriter bufferedWriter = null;
                    int n = string3.length();
                    try {
                        bufferedWriter = new BufferedWriter(new FileWriter(file2));
                        for (int i = 0; i < n; ++i) {
                            char c = string3.charAt(i);
                            if (c == '\n') {
                                bufferedWriter.newLine();
                                continue;
                            }
                            bufferedWriter.write(c);
                        }
                        bufferedWriter.close();
                        bufferedWriter = null;
                        bl3 = true;
                    }
                    catch (Throwable throwable) {
                        EmuUtil.closeSilent(bufferedWriter);
                        throw throwable;
                    }
                    EmuUtil.closeSilent(bufferedWriter);
                    break block17;
                }
                Z80Assembler z80Assembler = new Z80Assembler(string3, "Assembler-Quelltext", null, basicOptions, (PrgLogger)object2, false);
                bl3 = z80Assembler.assemble(string2, bl);
                if (z80Assembler.getRelJumpsTooLong()) {
                    EmuUtil.printlnErr("Compilieren Sie bitte mit einer niedrigeren Optimierungsstufe (max. '-O3').");
                }
            }
            catch (IOException iOException) {
                String string4 = iOException.getMessage();
                if (string4 != null && !string4.isEmpty()) {
                    EmuUtil.printlnErr(string4);
                }
                bl3 = false;
            }
        }
        return bl3;
    }

    private static int getHex4(String string, String string2) throws IOException {
        int n = -1;
        if (string != null) {
            try {
                int n2 = string.length();
                if (n2 > 1 && (string.endsWith("H") || string.endsWith("h"))) {
                    string = string.substring(0, n2 - 1);
                }
                if (((n = Integer.parseInt(string, 16)) & 0xFFFF0000) != 0) {
                    throw new IOException(String.format("Option '%c': %s Hexadezimalzahl zu gro\u00df", string2, string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(String.format("Option '%c': %s Ung\u00fcltige Hexadezimalzahl", string2, string));
            }
        }
        return n;
    }

    private static int getHex4Arg(Map<String, String> map, String string) throws IOException {
        return CmdLineBasicCompiler.getHex4(map.get(string), string);
    }

    private static int getIntArg(Map<String, String> map, String string) throws IOException {
        int n = -1;
        String string2 = map.get(string);
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(String.format("Option '%c': %s: Ung\u00fcltige Zahl", string, string2));
            }
        }
        return n;
    }

    private static void throwWrongCmdLine() throws IOException {
        throw new IOException("Kommandozeile fehlerhaft");
    }
}

